/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.OverrideUtils;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class InterfaceTranslator {
    private final InterfaceDef interfaceDef;
    private final ImTranslator translator;
    private final ImClass imClass;

    public InterfaceTranslator(InterfaceDef interfaceDef, ImTranslator translator) {
        this.interfaceDef = interfaceDef;
        this.translator = translator;
        this.imClass = translator.getClassFor(interfaceDef);
    }

    public void translate() {
        this.translator.getImProg().getClasses().add(this.imClass);
        for (TypeExpr ext : this.interfaceDef.getExtendsList()) {
            this.imClass.getSuperClasses().add((ImClassType)ext.attrTyp().imTranslateType(this.translator));
        }
        for (FuncDef f : this.interfaceDef.getMethods()) {
            this.translateInterfaceFuncDef(f);
        }
        this.addDestroyMethod();
    }

    public void addDestroyMethod() {
        ImMethod m = this.translator.destroyMethod.getFor(this.interfaceDef);
        this.imClass.getMethods().add(m);
        ArrayList subClasses = Lists.newArrayList(this.translator.getInterfaceInstances(this.interfaceDef));
        for (ClassDef sc : subClasses) {
            ImMethod dm = this.translator.destroyMethod.getFor(sc);
            m.getSubMethods().add(dm);
        }
        ImFunction f = this.translator.destroyFunc.getFor(this.interfaceDef);
        ImVar thisVar = (ImVar)f.getParameters().get(0);
        f.getBody().add(JassIm.ImDealloc(this.interfaceDef, this.imClassType(), JassIm.ImVarAccess(thisVar)));
    }

    private ImClassType imClassType() {
        ImTypeArguments typeArgs = this.imClass.getTypeVariables().stream().map(tv -> JassIm.ImTypeArgument(JassIm.ImTypeVarRef(tv), Collections.emptyMap())).collect(Collectors.toCollection(() -> JassIm.ImTypeArguments(new ImTypeArgument[0])));
        return JassIm.ImClassType(this.imClass, typeArgs);
    }

    private void translateInterfaceFuncDef(FuncDef f) {
        ImMethod imMeth = this.translator.getMethodFor(f);
        ImFunction imFunc = this.translator.getFuncFor(f);
        this.imClass.getMethods().add(imMeth);
        if (f.attrHasEmptyBody()) {
            imMeth.setIsAbstract(true);
        } else {
            imFunc.getBody().addAll(this.translator.translateStatements(imFunc, f.getBody()));
        }
        ArrayList subClasses = Lists.newArrayList(this.translator.getInterfaceInstances(this.interfaceDef));
        Map<ClassDef, FuncDef> subClasses2 = this.translator.getClassesWithImplementation(subClasses, f);
        for (Map.Entry<ClassDef, FuncDef> subE : subClasses2.entrySet()) {
            ClassDef subC = subE.getKey();
            WurstTypeClass subCT = subC.attrTypC();
            ImmutableList<WurstTypeInterface> interfaces = subCT.implementedInterfaces();
            VariableBinding typeBinding = interfaces.stream().filter(t -> t.getDef() == this.interfaceDef).map(WurstTypeNamedScope::getTypeArgBinding).findFirst().orElse(VariableBinding.emptyMapping());
            FuncDef subM = subE.getValue();
            ImMethod m = this.translator.getMethodFor(subM);
            ImClass mClass = this.translator.getClassFor(subC);
            OverrideUtils.addOverride(this.translator, f, mClass, m, subM, typeBinding);
        }
    }
}

