/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.HoverInfo;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.WurstKeywords;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMember;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprRealVal;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.AttrExprType;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.names.TypeDefLink;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeClassOrInterface;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.InsertTextFormat;

public class GetCompletions
extends UserRequest<CompletionList> {
    private static final int MAX_COMPLETIONS = 100;
    private final WFile filename;
    private final String buffer;
    private final String[] lines;
    private final int line;
    private final int column;
    private String alreadyEntered;
    private String alreadyEnteredLower;
    private SearchMode searchMode;
    private Element elem;
    private WurstType expectedType;
    private ModelManager modelManager;
    private boolean isIncomplete = false;
    private CompilationUnit cu;
    private static final Pattern realPattern = Pattern.compile("[0-9]\\.");

    public GetCompletions(CompletionParams position, BufferManager bufferManager) {
        this.filename = WFile.create(position.getTextDocument().getUri());
        this.buffer = bufferManager.getBuffer(position.getTextDocument());
        this.line = position.getPosition().getLine() + 1;
        this.column = position.getPosition().getCharacter();
        this.lines = this.buffer.split("\\n|\\r\\n");
        if (this.line <= this.lines.length) {
            WLogger.info("Get completions in line " + this.line + ": \n" + this.currentLine().replace('\t', ' ') + "\n" + Utils.repeat(' ', this.column > 0 ? this.column : 0) + "^\n at column " + this.column);
        }
    }

    private String currentLine() {
        return this.lines[this.line - 1];
    }

    @Override
    public CompletionList execute(ModelManager modelManager) {
        this.modelManager = modelManager;
        this.cu = modelManager.replaceCompilationUnitContent(this.filename, this.buffer, false);
        if (this.cu == null) {
            return new CompletionList(Collections.emptyList());
        }
        List<CompletionItem> result = this.computeCompletionProposals(this.cu);
        if (result != null) {
            result.sort(this.completionItemComparator());
            return new CompletionList(this.isIncomplete, result);
        }
        return new CompletionList(this.isIncomplete, Collections.emptyList());
    }

    private Comparator<CompletionItem> completionItemComparator() {
        return Comparator.comparing(CompletionItem::getSortText).reversed().thenComparing(CompletionItem::getLabel);
    }

    public List<CompletionItem> computeCompletionProposals(CompilationUnit cu) {
        if (this.isEnteringRealNumber()) {
            return null;
        }
        this.alreadyEntered = this.getAlreadyEnteredText();
        this.alreadyEnteredLower = this.alreadyEntered.toLowerCase();
        WLogger.info("already entered = " + this.alreadyEntered);
        SearchMode[] searchModeArray = SearchMode.values();
        int n = searchModeArray.length;
        for (int i = 0; i < n; ++i) {
            SearchMode mode;
            this.searchMode = mode = searchModeArray[i];
            ArrayList completions = Lists.newArrayList();
            this.elem = Utils.getAstElementAtPos(cu, this.line, this.column + 1, false).get();
            WLogger.info("get completions at " + Utils.printElement(this.elem));
            this.expectedType = null;
            if (this.elem instanceof Expr) {
                Expr expr = (Expr)this.elem;
                this.expectedType = expr.attrExpectedTyp();
                WLogger.info("....expected type = " + this.expectedType);
            }
            this.calculateCompletions(completions);
            this.dropBadCompletions(completions);
            this.removeDuplicates(completions);
            if (completions.size() <= 0) continue;
            return completions;
        }
        return null;
    }

    private void calculateCompletions(List<CompletionItem> completions) {
        boolean isMemberAccess = false;
        if (this.elem instanceof ExprMember) {
            ExprMemberMethod c;
            ExprMember e = (ExprMember)this.elem;
            if (this.elem instanceof ExprMemberMethod && this.isInParenthesis((c = (ExprMemberMethod)this.elem).getLeft().getSource().getEndColumn())) {
                this.getCompletionsForExistingMemberCall(completions, c);
                return;
            }
            WurstType leftType = e.getLeft().attrTyp();
            if (leftType instanceof WurstTypeNamedScope) {
                WurstTypeNamedScope ct = (WurstTypeNamedScope)leftType;
                for (DefLink nameLink : ct.nameLinks().values()) {
                    if (!this.isSuitableCompletion(nameLink.getName()) || nameLink.getReceiverType() == null && !(nameLink instanceof TypeDefLink) || nameLink.getVisibility() != Visibility.PUBLIC) continue;
                    CompletionItem completion = this.makeNameDefCompletion(nameLink);
                    completions.add(completion);
                }
            }
            isMemberAccess = true;
            for (WScope scope = this.elem.attrNearestScope(); scope != null; scope = scope.attrNextScope()) {
                ImmutableMultimap<String, DefLink> visibleNames = scope.attrNameLinks();
                this.completionsAddVisibleNames(this.alreadyEntered, completions, (Multimap<String, DefLink>)visibleNames, leftType, isMemberAccess, this.elem);
                this.completionsAddVisibleExtensionFunctions(completions, (Multimap<String, DefLink>)visibleNames, leftType);
            }
        } else if (!(this.elem instanceof ExprRealVal) && !(this.elem instanceof WPackage)) {
            if (this.elem instanceof WImport) {
                this.completeImport(completions);
            } else if (this.elem instanceof ExprNewObject) {
                ExprNewObject en = (ExprNewObject)this.elem;
                if (this.isInParenthesis(en.getSource().getStartColumn())) {
                    this.getCompletionsForExistingConstructorCall(completions, en);
                    return;
                }
                for (WScope scope = this.elem.attrNearestScope(); scope != null; scope = scope.attrNextScope()) {
                    ImmutableMultimap<String, DefLink> visibleNames = scope.attrNameLinks();
                    for (NameLink n : visibleNames.values()) {
                        if (!(n.getDef() instanceof ClassDef) || !this.isSuitableCompletion(n.getName())) continue;
                        ClassDef c = (ClassDef)n.getDef();
                        for (ConstructorDef constr : c.getConstructors()) {
                            completions.add(this.makeConstructorCompletion(c, constr));
                        }
                    }
                }
            } else if (this.elem instanceof ExprFunctionCall) {
                ExprFunctionCall c = (ExprFunctionCall)this.elem;
                if (this.isInParenthesis(c.getSource().getStartColumn())) {
                    this.getCompletionsForExistingCall(completions, c);
                } else {
                    this.addDefaultCompletions(completions, this.elem, isMemberAccess);
                }
            } else {
                if (this.elem instanceof ExprEmpty && this.elem.getParent() instanceof Arguments) {
                    Element grandParent = this.getGrandParent();
                    if (grandParent instanceof ExprFunctionCall) {
                        ExprFunctionCall c = (ExprFunctionCall)grandParent;
                        this.getCompletionsForExistingCall(completions, c);
                    } else if (grandParent instanceof ExprMemberMethod) {
                        ExprMemberMethod c = (ExprMemberMethod)grandParent;
                        this.getCompletionsForExistingMemberCall(completions, c);
                    } else if (grandParent instanceof ExprNewObject) {
                        ExprNewObject c = (ExprNewObject)grandParent;
                        this.getCompletionsForExistingConstructorCall(completions, c);
                    }
                }
                if (completions.isEmpty()) {
                    this.addDefaultCompletions(completions, this.elem, isMemberAccess);
                }
            }
        }
        if (!isMemberAccess) {
            this.addKeywordCompletions(completions);
        }
    }

    private void addKeywordCompletions(List<CompletionItem> completions) {
        for (String keyword : WurstKeywords.KEYWORDS) {
            if (!keyword.startsWith(this.alreadyEntered)) continue;
            completions.add(this.makeSimpleNameCompletion(keyword));
        }
        for (String keyword : WurstKeywords.JASS_PRIMITIVE_TYPES) {
            if (!keyword.startsWith(this.alreadyEntered)) continue;
            completions.add(this.makeSimpleNameCompletion(keyword));
        }
    }

    private void completeImport(List<CompletionItem> completions) {
        ModelManager mm = this.modelManager;
        WurstModel model = this.elem.getModel();
        HashSet usedPackages = Sets.newHashSet();
        for (WPackage p : model.attrPackages().values()) {
            if (usedPackages.contains(p.getName()) || !this.isSuitableCompletion(p.getName())) continue;
            completions.add(this.makeNameDefCompletion(PackageLink.create(p, p.attrNearestScope())));
            usedPackages.add(p.getName());
        }
        for (File dep : mm.getDependencyWurstFiles()) {
            String libName = Utils.getLibName(dep);
            if (usedPackages.contains(libName) || !this.isSuitableCompletion(libName)) continue;
            usedPackages.add(libName);
            completions.add(this.makeSimpleNameCompletion(libName));
        }
        if (this.isSuitableCompletion("NoWurst")) {
            completions.add(this.makeSimpleNameCompletion("NoWurst"));
        }
    }

    private @Nullable Element getGrandParent() {
        Element parent = this.elem.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getParent();
    }

    private boolean isInParenthesis(int start) {
        try {
            String s = this.currentLine().substring(start, this.column - start);
            return s.contains("(");
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private void addDefaultCompletions(List<CompletionItem> completions, Element elem, boolean isMemberAccess) {
        WurstType leftType = AttrExprType.caclulateThistype(elem, true, null);
        if (leftType instanceof WurstTypeUnknown) {
            leftType = null;
        }
        for (WScope scope = elem.attrNearestScope(); scope != null; scope = scope.attrNextScope()) {
            ImmutableMultimap<String, DefLink> visibleNames = scope.attrNameLinks();
            this.completionsAddVisibleNames(this.alreadyEntered, completions, (Multimap<String, DefLink>)visibleNames, leftType, isMemberAccess, elem);
        }
    }

    private void getCompletionsForExistingConstructorCall(List<CompletionItem> completions, ExprNewObject c) {
        ConstructorDef constructorDef = c.attrConstructorDef();
        if (constructorDef != null) {
            ClassDef classDef = constructorDef.attrNearestClassDef();
            assert (classDef != null);
            CompletionItem ci = this.makeConstructorCompletion(classDef, constructorDef);
            ci.setTextEdit(null);
            completions.add(ci);
        }
    }

    private void getCompletionsForExistingMemberCall(List<CompletionItem> completions, ExprMemberMethod c) {
        FuncLink funcDef = c.attrFuncLink();
        if (funcDef != null) {
            CompletionItem ci = this.makeFunctionCompletion(funcDef);
            ci.setTextEdit(null);
            completions.add(ci);
        }
    }

    private void getCompletionsForExistingCall(List<CompletionItem> completions, ExprFunctionCall c) {
        FuncLink funcDef = c.attrFuncLink();
        if (funcDef != null) {
            this.alreadyEntered = c.getFuncName();
            CompletionItem ci = this.makeFunctionCompletion(funcDef);
            ci.setTextEdit(null);
            completions.add(ci);
        }
    }

    private boolean isSuitableCompletion(String name) {
        if (name.endsWith("Tests")) {
            return false;
        }
        switch (this.searchMode) {
            case PREFIX: {
                return name.toLowerCase().startsWith(this.alreadyEnteredLower);
            }
            case INFIX: {
                return name.toLowerCase().contains(this.alreadyEnteredLower);
            }
        }
        return Utils.isSubsequenceIgnoreCase(this.alreadyEntered, name);
    }

    private boolean isEnteringRealNumber() {
        try {
            String currentLine = this.currentLine();
            String before = currentLine.substring(this.column - 2, 2);
            return realPattern.matcher(before).matches();
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private boolean isBeforeParenthesis() {
        try {
            return this.currentLine().charAt(this.column) == '(';
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private boolean isAtEndOfLine() {
        String line = this.currentLine();
        for (int i = this.column + 1; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void removeDuplicates(List<CompletionItem> completions) {
        for (int i = 0; i < completions.size() - 1; ++i) {
            for (int j = completions.size() - 1; j > i; --j) {
                if (!completions.get(i).equals((Object)completions.get(j))) continue;
                completions.remove(j);
            }
        }
    }

    private String getAlreadyEnteredText() {
        try {
            char c;
            int start;
            String currentLine = this.currentLine();
            for (start = this.column - 1; start >= 0 && Character.isJavaIdentifierPart(c = currentLine.charAt(start)); --start) {
            }
            return currentLine.substring(++start, this.column);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    private void completionsAddVisibleNames(String alreadyEntered, List<CompletionItem> completions, Multimap<String, DefLink> visibleNames, @Nullable WurstType leftType, boolean isMemberAccess, Element pos) {
        Collection entries = visibleNames.entries();
        for (Map.Entry e : entries) {
            DefLink defLink;
            if (!this.isSuitableCompletion((String)e.getKey()) || (defLink = (DefLink)e.getValue()).getVisibility() == Visibility.PRIVATE_OTHER || defLink.getVisibility() == Visibility.PROTECTED_OTHER) continue;
            WurstType receiverType = defLink.getReceiverType();
            if (leftType != null ? (receiverType != null ? !leftType.isSubtypeOf(receiverType, pos) : isMemberAccess) : receiverType != null && !receiverType.isStaticRef()) continue;
            if (defLink instanceof FuncLink) {
                FuncLink funcLink = (FuncLink)defLink;
                CompletionItem completion = this.makeFunctionCompletion(funcLink);
                completions.add(completion);
            } else {
                completions.add(this.makeNameDefCompletion(defLink));
            }
            if (alreadyEntered.length() > 3 || completions.size() < 100) continue;
            this.isIncomplete = true;
            return;
        }
    }

    private void dropBadCompletions(List<CompletionItem> completions) {
        completions.sort(this.completionItemComparator());
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        for (int i = completions.size() - 1; i >= 100; --i) {
            try {
                if (numberFormat.parse(completions.get(i).getSortText()).doubleValue() > 0.4) {
                    return;
                }
            }
            catch (NumberFormatException | ParseException e) {
                WLogger.severe(e);
            }
            completions.remove(i);
        }
    }

    private CompletionItem makeNameDefCompletion(NameLink n) {
        if (n instanceof FuncLink) {
            return this.makeFunctionCompletion((FuncLink)n);
        }
        CompletionItem completion = new CompletionItem(n.getName());
        completion.setDetail(HoverInfo.descriptionString(n.getDef()));
        completion.setDocumentation(n.getDef().attrComment());
        double rating = this.calculateRating(n.getName(), n.getTyp());
        completion.setSortText(this.ratingToString(rating));
        String newText = n.getName();
        completion.setInsertText(newText);
        return completion;
    }

    private String ratingToString(double rating) {
        rating = Math.min(10.0, rating);
        DecimalFormat format = new DecimalFormat("####.000");
        return format.format(10.0 - rating);
    }

    private CompletionItem makeSimpleNameCompletion(String name) {
        CompletionItem completion = new CompletionItem(name);
        completion.setDetail("");
        double rating = this.calculateRating(name, WurstTypeUnknown.instance());
        completion.setSortText(this.ratingToString(rating));
        completion.setInsertText(name);
        return completion;
    }

    private double calculateRating(String name, WurstType wurstType) {
        double r = this.calculateNameBasedRating(name);
        if (this.expectedType != null && wurstType.isSubtypeOf(this.expectedType, this.elem)) {
            r += 0.1;
        }
        if (name.contains("BJ") || name.contains("Swapped")) {
            r -= 0.05;
        }
        return r;
    }

    private double calculateNameBasedRating(String name) {
        if (this.alreadyEntered.isEmpty()) {
            return 0.5;
        }
        if (name.startsWith(this.alreadyEntered)) {
            return 1.23;
        }
        String nameLower = name.toLowerCase();
        if (nameLower.startsWith(this.alreadyEnteredLower)) {
            return 0.999;
        }
        int ssLen = Utils.isSubsequence(this.alreadyEntered, name) ? Math.min(Utils.subsequenceLengthes(this.alreadyEntered, name).size(), Utils.subsequenceLengthes(this.alreadyEnteredLower, nameLower).size()) : Utils.subsequenceLengthes(this.alreadyEnteredLower, nameLower).size();
        return 1.0 - (double)ssLen * 1.0 / (double)this.alreadyEntered.length();
    }

    private static String nearestScopeName(NameDef n) {
        if (n.attrNearestNamedScope() != null) {
            return Utils.printElement(n.attrNearestNamedScope());
        }
        return "Global";
    }

    private CompletionItem makeFunctionCompletion(FuncLink f) {
        String replacementString = f.getName();
        List<WurstType> params = f.getParameterTypes();
        CompletionItem completion = new CompletionItem(f.getName());
        completion.setKind(CompletionItemKind.Function);
        completion.setDetail(this.getFunctionDescriptionShort(f.getDef()));
        completion.setDocumentation(HoverInfo.descriptionString(f.getDef()));
        completion.setInsertText(replacementString);
        double rating = this.calculateRating(f.getName(), f.getReturnType());
        if (f.getDef().attrHasAnnotation("deprecated")) {
            rating -= 0.05;
        }
        completion.setSortText(this.ratingToString(rating));
        if (!this.isBeforeParenthesis()) {
            this.addParamSnippet(replacementString, f, completion);
        }
        return completion;
    }

    private void addParamSnippet(String replacementString, FuncLink f, CompletionItem completion) {
        WurstTypeClassOrInterface it;
        FuncLink singleAbstractMethod;
        WurstType lastParamType;
        List<String> paramNames = f.getParameterNames();
        StringBuilder lambdaReplacement = null;
        List<WurstType> parameterTypes = f.getParameterTypes();
        if (this.isAtEndOfLine() && !parameterTypes.isEmpty() && (lastParamType = Utils.getLast(parameterTypes)) instanceof WurstTypeClassOrInterface && (singleAbstractMethod = (it = (WurstTypeClassOrInterface)lastParamType).findSingleAbstractMethod(this.elem)) != null) {
            paramNames = Utils.init(paramNames);
            if (singleAbstractMethod.getParameterTypes().size() == 0) {
                lambdaReplacement = new StringBuilder(" -> \n");
                this.cu.getCuInfo().getIndentationMode().appendIndent(lambdaReplacement, 1);
            } else {
                lambdaReplacement = new StringBuilder(" (");
                for (int i = 0; i < singleAbstractMethod.getParameterTypes().size(); ++i) {
                    if (i > 0) {
                        lambdaReplacement.append(", ");
                    }
                    lambdaReplacement.append(singleAbstractMethod.getParameterType(i));
                    lambdaReplacement.append(" ");
                    lambdaReplacement.append(singleAbstractMethod.getParameterName(i));
                }
                lambdaReplacement.append(") ->\n");
                this.cu.getCuInfo().getIndentationMode().appendIndent(lambdaReplacement, 1);
            }
        }
        this.addParamSnippet(replacementString, paramNames, completion, lambdaReplacement);
    }

    private void addParamSnippet(String replacementString, List<String> paramNames, CompletionItem completion, StringBuilder lambdaReplacement) {
        if (paramNames.isEmpty()) {
            replacementString = (String)replacementString + "()";
        } else {
            ArrayList<CallSite> paramSnippets = new ArrayList<CallSite>();
            for (int i = 0; i < paramNames.size(); ++i) {
                String paramName = paramNames.get(i);
                paramSnippets.add((CallSite)((Object)("${" + (i + 1) + ":" + paramName + "}")));
            }
            replacementString = (String)replacementString + "(" + String.join((CharSequence)", ", paramSnippets) + ")";
            completion.setInsertTextFormat(InsertTextFormat.Snippet);
        }
        if (lambdaReplacement != null) {
            replacementString = (String)replacementString + lambdaReplacement;
            completion.setInsertTextFormat(InsertTextFormat.Snippet);
        }
        completion.setInsertText((String)replacementString);
    }

    private String getFunctionDescriptionShort(FunctionDefinition f) {
        String displayString = "(" + Utils.getParameterListText(f) + ")";
        WurstType returnType = f.attrReturnTyp();
        if (!(returnType instanceof WurstTypeVoid)) {
            displayString = displayString + " returns " + returnType;
        }
        displayString = displayString + " [" + GetCompletions.nearestScopeName(f) + "]";
        return displayString;
    }

    private CompletionItem makeConstructorCompletion(ClassDef c, ConstructorDef constr) {
        String replacementString = c.getName();
        CompletionItem completion = new CompletionItem(c.getName());
        completion.setKind(CompletionItemKind.Constructor);
        String params = Utils.getParameterListText(constr);
        completion.setDetail("(" + params + ")");
        completion.setDocumentation(HoverInfo.descriptionString(constr));
        completion.setInsertTextFormat(InsertTextFormat.Snippet);
        completion.setInsertText(replacementString);
        completion.setSortText(this.ratingToString(this.calculateRating(c.getName(), c.attrTyp().dynamic())));
        List<String> parameterNames = constr.getParameters().stream().map(WParameter::getName).collect(Collectors.toList());
        this.addParamSnippet(replacementString, parameterNames, completion, null);
        return completion;
    }

    private void completionsAddVisibleExtensionFunctions(List<CompletionItem> completions, Multimap<String, DefLink> visibleNames, WurstType leftType) {
        for (Map.Entry e : visibleNames.entries()) {
            FuncLink ef;
            FuncLink ef2;
            if (!this.isSuitableCompletion((String)e.getKey()) || !(e.getValue() instanceof FuncLink) || !((DefLink)e.getValue()).getVisibility().isPublic() || (ef2 = (ef = (FuncLink)e.getValue()).adaptToReceiverType(leftType)) == null) continue;
            completions.add(this.makeFunctionCompletion(ef2));
        }
    }

    private static enum SearchMode {
        PREFIX,
        INFIX,
        SUBSEQENCE;

    }
}

