/*
 * Decompiled with CFR 0.152.
 */
package ui;

import config.WurstProjectBuildMapData;
import config.WurstProjectConfig;
import config.WurstProjectConfigData;
import de.ralleytn.simple.registry.Key;
import de.ralleytn.simple.registry.Registry;
import de.ralleytn.simple.registry.Reloadable;
import de.ralleytn.simple.registry.Value;
import file.CompileTimeInfo;
import file.SetupApp;
import global.InstallationManager;
import global.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import net.ConnectionManager;
import net.NetStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tablelayout.Table;
import ui.AddRepoDialog;
import ui.JSystemFileChooser;
import ui.MainWindow;
import ui.UiManager;
import ui.UiStyle;
import workers.CompilerUpdateWorker;
import workers.OnlineCheckWorker;
import workers.ProjectCreateWorker;
import workers.ProjectUpdateWorker;
import workers.WurstBuildCheckWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002./B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020*H\u0002J\u0006\u0010,\u001a\u00020*J\b\u0010-\u001a\u00020*H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u001b\u0010\f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0016\u0010\u0006R\u001b\u0010\u0018\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\b\u001a\u0004\b\u0019\u0010\u0006R\u001b\u0010\u001b\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\b\u001a\u0004\b\u001c\u0010\u0006R\u001b\u0010\u001e\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\b\u001a\u0004\b \u0010!R\u000e\u0010#\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020%8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\b\u001a\u0004\b&\u0010'\u00a8\u00060"}, d2={"Lui/MainWindow;", "Ljavax/swing/JFrame;", "()V", "exitIcon", "Ljavax/swing/ImageIcon;", "getExitIcon", "()Ljavax/swing/ImageIcon;", "exitIcon$delegate", "Lkotlin/Lazy;", "exitIconDown", "getExitIconDown", "exitIconDown$delegate", "exitIconHover", "getExitIconHover", "exitIconHover$delegate", "hasExecuted", "", "importChooser", "Lui/JSystemFileChooser;", "log", "Lmu/KLogger;", "minIcon", "getMinIcon", "minIcon$delegate", "minIconDown", "getMinIconDown", "minIconDown$delegate", "minIconHover", "getMinIconHover", "minIconHover$delegate", "point", "Ljava/awt/Point;", "getPoint", "()Ljava/awt/Point;", "point$delegate", "saveChooser", "ui", "Lui/MainWindow$UI;", "getUi", "()Lui/MainWindow$UI;", "ui$delegate", "centerWindow", "", "executeListener", "init", "initFilechooser", "SetupButton", "UI", "WurstSetup"})
public final class MainWindow
extends JFrame {
    @NotNull
    public static final MainWindow INSTANCE = new MainWindow();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(log.1.INSTANCE);
    @NotNull
    private static final Lazy exitIcon$delegate = LazyKt.lazy(exitIcon.2.INSTANCE);
    @NotNull
    private static final Lazy minIcon$delegate = LazyKt.lazy(minIcon.2.INSTANCE);
    @NotNull
    private static final Lazy exitIconDown$delegate = LazyKt.lazy(exitIconDown.2.INSTANCE);
    @NotNull
    private static final Lazy minIconDown$delegate = LazyKt.lazy(minIconDown.2.INSTANCE);
    @NotNull
    private static final Lazy exitIconHover$delegate = LazyKt.lazy(exitIconHover.2.INSTANCE);
    @NotNull
    private static final Lazy minIconHover$delegate = LazyKt.lazy(minIconHover.2.INSTANCE);
    @NotNull
    private static final Lazy ui$delegate = LazyKt.lazy(ui.2.INSTANCE);
    private static JSystemFileChooser saveChooser;
    private static JSystemFileChooser importChooser;
    @NotNull
    private static final Lazy point$delegate;
    private static boolean hasExecuted;

    private MainWindow() {
    }

    private final ImageIcon getExitIcon() {
        Lazy lazy = exitIcon$delegate;
        return (ImageIcon)lazy.getValue();
    }

    private final ImageIcon getMinIcon() {
        Lazy lazy = minIcon$delegate;
        return (ImageIcon)lazy.getValue();
    }

    private final ImageIcon getExitIconDown() {
        Lazy lazy = exitIconDown$delegate;
        return (ImageIcon)lazy.getValue();
    }

    private final ImageIcon getMinIconDown() {
        Lazy lazy = minIconDown$delegate;
        return (ImageIcon)lazy.getValue();
    }

    private final ImageIcon getExitIconHover() {
        Lazy lazy = exitIconHover$delegate;
        return (ImageIcon)lazy.getValue();
    }

    private final ImageIcon getMinIconHover() {
        Lazy lazy = minIconHover$delegate;
        return (ImageIcon)lazy.getValue();
    }

    @NotNull
    public final UI getUi() {
        Lazy lazy = ui$delegate;
        return (UI)lazy.getValue();
    }

    @NotNull
    public final Point getPoint() {
        Lazy lazy = point$delegate;
        return (Point)lazy.getValue();
    }

    public final void init() {
        this.initFilechooser();
        log.debug("init UI");
        this.setLayout(new BorderLayout());
        this.setSize(570, 355);
        this.setBackground(new Color(36, 36, 36));
        this.centerWindow();
        if (!this.isDisplayable()) {
            this.setUndecorated(true);
        }
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.getUi().initComponents();
        this.add((Component)this.getUi(), "Center");
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                MainWindow.INSTANCE.getPoint().x = e.getX();
                MainWindow.INSTANCE.getPoint().y = e.getY();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                Point p = MainWindow.INSTANCE.getLocation();
                MainWindow.INSTANCE.setLocation(p.x + e.getX() - MainWindow.INSTANCE.getPoint().x, p.y + e.getY() - MainWindow.INSTANCE.getPoint().y);
            }
        });
        this.setVisible(true);
        new OnlineCheckWorker("http://google.com", init.3.INSTANCE).execute();
        new OnlineCheckWorker("http://bing.com", init.4.INSTANCE).execute();
        new OnlineCheckWorker("http://baidu.com", init.5.INSTANCE).execute();
    }

    private final void executeListener() {
        if (!hasExecuted) {
            hasExecuted = true;
            new WurstBuildCheckWorker().execute();
        }
    }

    private final void initFilechooser() {
        saveChooser = new JSystemFileChooser();
        JSystemFileChooser jSystemFileChooser = saveChooser;
        if (jSystemFileChooser == null) {
            Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
            jSystemFileChooser = null;
        }
        jSystemFileChooser.setFileSelectionMode(1);
        JSystemFileChooser jSystemFileChooser2 = saveChooser;
        if (jSystemFileChooser2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
            jSystemFileChooser2 = null;
        }
        jSystemFileChooser2.setCurrentDirectory(new File("."));
        JSystemFileChooser jSystemFileChooser3 = saveChooser;
        if (jSystemFileChooser3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
            jSystemFileChooser3 = null;
        }
        jSystemFileChooser3.setDialogTitle("Select project root");
        JSystemFileChooser jSystemFileChooser4 = saveChooser;
        if (jSystemFileChooser4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
            jSystemFileChooser4 = null;
        }
        jSystemFileChooser4.setAcceptAllFileFilterUsed(false);
        importChooser = new JSystemFileChooser();
        JSystemFileChooser jSystemFileChooser5 = importChooser;
        if (jSystemFileChooser5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("importChooser");
            jSystemFileChooser5 = null;
        }
        jSystemFileChooser5.setCurrentDirectory(new File("."));
        JSystemFileChooser jSystemFileChooser6 = importChooser;
        if (jSystemFileChooser6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("importChooser");
            jSystemFileChooser6 = null;
        }
        jSystemFileChooser6.setDialogTitle("Select wurst.build file");
        JSystemFileChooser jSystemFileChooser7 = importChooser;
        if (jSystemFileChooser7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("importChooser");
            jSystemFileChooser7 = null;
        }
        jSystemFileChooser7.setAcceptAllFileFilterUsed(false);
        JSystemFileChooser jSystemFileChooser8 = importChooser;
        if (jSystemFileChooser8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("importChooser");
            jSystemFileChooser8 = null;
        }
        String[] stringArray = new String[]{"build"};
        jSystemFileChooser8.setFileFilter(new FileNameExtensionFilter("wurst.build files", stringArray));
    }

    private final void centerWindow() {
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        int centerX = screenBounds.x + screenBounds.width / 2;
        int centerY = screenBounds.y + screenBounds.height / 2;
        this.setLocation(centerX - this.getWidth() / 2, centerY - this.getHeight() / 2);
    }

    public static final /* synthetic */ void access$executeListener(MainWindow $this) {
        $this.executeListener();
    }

    public static final /* synthetic */ ImageIcon access$getExitIcon(MainWindow $this) {
        return $this.getExitIcon();
    }

    public static final /* synthetic */ ImageIcon access$getMinIcon(MainWindow $this) {
        return $this.getMinIcon();
    }

    public static final /* synthetic */ JSystemFileChooser access$getSaveChooser$p() {
        return saveChooser;
    }

    static {
        point$delegate = LazyKt.lazy(point.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lui/MainWindow$SetupButton;", "Ljavax/swing/JButton;", "buttonTag", "", "(Ljava/lang/String;)V", "backgroundColor", "Ljava/awt/Color;", "overColor", "pressedColor", "textColor", "kotlin.jvm.PlatformType", "paintComponent", "", "g", "Ljava/awt/Graphics;", "WurstSetup"})
    public static final class SetupButton
    extends JButton {
        private final Color textColor;
        @NotNull
        private final Color backgroundColor;
        @NotNull
        private final Color overColor;
        @NotNull
        private final Color pressedColor;

        public SetupButton(@NotNull String buttonTag) {
            Intrinsics.checkNotNullParameter(buttonTag, "buttonTag");
            super(buttonTag);
            this.textColor = Color.WHITE;
            this.backgroundColor = new Color(18, 18, 18);
            this.overColor = new Color(120, 20, 20);
            this.pressedColor = new Color(240, 40, 40);
            this.setBackground(this.backgroundColor);
            this.setForeground(this.textColor);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            Border line = BorderFactory.createLineBorder(new Color(80, 80, 80));
            EmptyBorder empty2 = new EmptyBorder(4, 4, 4, 4);
            CompoundBorder border = new CompoundBorder(line, empty2);
            this.setBorder(border);
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter(g, "g");
            if (this.getModel().isPressed()) {
                g.setColor(this.pressedColor);
            } else if (this.getModel().isRollover()) {
                g.setColor(this.overColor);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010Z\u001a\u00020[H\u0002J\b\u0010\\\u001a\u00020[H\u0002J\b\u0010]\u001a\u00020[H\u0002J\u0006\u0010^\u001a\u00020[J\u0006\u0010_\u001a\u00020[J\b\u0010`\u001a\u00020\u0013H\u0002J\b\u0010a\u001a\u00020[H\u0002J\b\u0010b\u001a\u00020[H\u0002J\b\u0010c\u001a\u00020[H\u0002J\b\u0010d\u001a\u00020[H\u0002J\u0006\u0010e\u001a\u00020[J\u0006\u0010f\u001a\u00020[J\b\u0010g\u001a\u00020[H\u0002J\u0018\u0010h\u001a\u00020[2\u0006\u0010C\u001a\u00020!2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010i\u001a\u00020\u001fH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u001a\u0010&\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00104\"\u0004\b9\u00106R\u001a\u0010:\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00104\"\u0004\b<\u00106R\u001a\u0010=\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00104\"\u0004\b?\u00106R\u001a\u0010@\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u00104\"\u0004\bB\u00106R\u000e\u0010C\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010D\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u0016\u0010J\u001a\n L*\u0004\u0018\u00010K0KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010M\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u001b\"\u0004\bO\u0010\u001dR\u000e\u0010P\u001a\u00020QX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010R\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u001b\"\u0004\bT\u0010\u001dR\u0010\u0010U\u001a\u0004\u0018\u00010VX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lui/MainWindow$UI;", "Ljavax/swing/JPanel;", "()V", "btnAdvanced", "Lui/MainWindow$SetupButton;", "getBtnAdvanced", "()Lui/MainWindow$SetupButton;", "setBtnAdvanced", "(Lui/MainWindow$SetupButton;)V", "btnCreate", "getBtnCreate", "setBtnCreate", "btnUpdate", "getBtnUpdate", "setBtnUpdate", "contentTable", "Ltablelayout/Table;", "dependencies", "", "", "getDependencies", "()Ljava/util/List;", "setDependencies", "(Ljava/util/List;)V", "dependencyTF", "Ljavax/swing/JTextField;", "getDependencyTF", "()Ljavax/swing/JTextField;", "setDependencyTF", "(Ljavax/swing/JTextField;)V", "disabled", "", "exit", "Ljavax/swing/JButton;", "gamePathTF", "importButton", "getImportButton", "setImportButton", "inited", "getInited", "()Z", "setInited", "(Z)V", "jTextArea", "Ljavax/swing/JTextArea;", "getJTextArea", "()Ljavax/swing/JTextArea;", "setJTextArea", "(Ljavax/swing/JTextArea;)V", "lblCurVerNumber", "Ljavax/swing/JLabel;", "getLblCurVerNumber", "()Ljavax/swing/JLabel;", "setLblCurVerNumber", "(Ljavax/swing/JLabel;)V", "lblCurrentVersion", "getLblCurrentVersion", "setLblCurrentVersion", "lblLatestVer", "getLblLatestVer", "setLblLatestVer", "lblLatestVerNumber", "getLblLatestVerNumber", "setLblLatestVerNumber", "lblWelcome", "getLblWelcome", "setLblWelcome", "minimize", "progressBar", "Ljavax/swing/JProgressBar;", "getProgressBar", "()Ljavax/swing/JProgressBar;", "setProgressBar", "(Ljavax/swing/JProgressBar;)V", "projNamePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "projectNameTF", "getProjectNameTF", "setProjectNameTF", "projectRootFile", "Ljava/io/File;", "projectRootTF", "getProjectRootTF", "setProjectRootTF", "selectedConfig", "Lconfig/WurstProjectConfigData;", "title", "topBar", "windowLabel", "checkDefaultWinLocation", "", "createButtonTable", "createConfigTable", "disableButtons", "enableButtons", "getVersionString", "handleCreateProject", "handleImport", "handleUpdateProject", "handleWurstUpdate", "initComponents", "refreshComponents", "setupTopBar", "titleEvents", "warnProjectName", "WurstSetup"})
    @SourceDebugExtension(value={"SMAP\nMainWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainWindow.kt\nui/MainWindow$UI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,627:1\n1855#2,2:628\n1855#2,2:630\n*S KotlinDebug\n*F\n+ 1 MainWindow.kt\nui/MainWindow$UI\n*L\n541#1:628,2\n559#1:630,2\n*E\n"})
    public static final class UI
    extends JPanel {
        private final Pattern projNamePattern = Pattern.compile("(\\w|\\s)+");
        @NotNull
        private Table contentTable = new Table();
        @NotNull
        private final JPanel topBar = new JPanel();
        @NotNull
        private final JPanel title = new JPanel();
        @NotNull
        private final JLabel windowLabel = new JLabel("    Wurst Setup");
        @NotNull
        private JLabel lblWelcome = new JLabel("Welcome to the Wurst Setup");
        @NotNull
        private JLabel lblCurrentVersion = new JLabel("Installed Compiler Build: ");
        @NotNull
        private JLabel lblCurVerNumber = new JLabel("(not installed)");
        @NotNull
        private JLabel lblLatestVer = new JLabel("Latest Build: ");
        @NotNull
        private JLabel lblLatestVerNumber = new JLabel("(unknown)");
        @NotNull
        private JProgressBar progressBar = new JProgressBar();
        @NotNull
        private SetupButton btnCreate = new SetupButton("Create Project");
        @NotNull
        private SetupButton btnUpdate = new SetupButton("Install WurstScript");
        @NotNull
        private SetupButton importButton = new SetupButton("Open Project");
        @NotNull
        private SetupButton btnAdvanced = new SetupButton("Add");
        @NotNull
        private JTextArea jTextArea = new JTextArea("Ready version: " + CompileTimeInfo.INSTANCE.getVersion() + "\n");
        @NotNull
        private JTextField projectNameTF = new JTextField("MyWurstProject");
        @NotNull
        private JTextField projectRootTF = new JTextField("projectRoot");
        @NotNull
        private JTextField dependencyTF = new JTextField("wurstStdlib2");
        @NotNull
        private final JButton exit = new JButton(MainWindow.access$getExitIcon(INSTANCE));
        @NotNull
        private final JButton minimize = new JButton(MainWindow.access$getMinIcon(INSTANCE));
        @NotNull
        private final JTextField gamePathTF = new JTextField("Select your wc3 installation folder (optional)");
        @Nullable
        private WurstProjectConfigData selectedConfig;
        @NotNull
        private List<String> dependencies;
        private boolean inited;
        @NotNull
        private File projectRootFile;
        private boolean disabled;

        public UI() {
            String[] stringArray = new String[]{"https://github.com/wurstscript/wurstStdlib2"};
            this.dependencies = new ArrayList(Arrays.asList(stringArray));
            this.projectRootFile = new File(".");
        }

        @NotNull
        public final JLabel getLblWelcome() {
            return this.lblWelcome;
        }

        public final void setLblWelcome(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter(jLabel, "<set-?>");
            this.lblWelcome = jLabel;
        }

        @NotNull
        public final JLabel getLblCurrentVersion() {
            return this.lblCurrentVersion;
        }

        public final void setLblCurrentVersion(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter(jLabel, "<set-?>");
            this.lblCurrentVersion = jLabel;
        }

        @NotNull
        public final JLabel getLblCurVerNumber() {
            return this.lblCurVerNumber;
        }

        public final void setLblCurVerNumber(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter(jLabel, "<set-?>");
            this.lblCurVerNumber = jLabel;
        }

        @NotNull
        public final JLabel getLblLatestVer() {
            return this.lblLatestVer;
        }

        public final void setLblLatestVer(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter(jLabel, "<set-?>");
            this.lblLatestVer = jLabel;
        }

        @NotNull
        public final JLabel getLblLatestVerNumber() {
            return this.lblLatestVerNumber;
        }

        public final void setLblLatestVerNumber(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter(jLabel, "<set-?>");
            this.lblLatestVerNumber = jLabel;
        }

        @NotNull
        public final JProgressBar getProgressBar() {
            return this.progressBar;
        }

        public final void setProgressBar(@NotNull JProgressBar jProgressBar) {
            Intrinsics.checkNotNullParameter(jProgressBar, "<set-?>");
            this.progressBar = jProgressBar;
        }

        @NotNull
        public final SetupButton getBtnCreate() {
            return this.btnCreate;
        }

        public final void setBtnCreate(@NotNull SetupButton setupButton) {
            Intrinsics.checkNotNullParameter(setupButton, "<set-?>");
            this.btnCreate = setupButton;
        }

        @NotNull
        public final SetupButton getBtnUpdate() {
            return this.btnUpdate;
        }

        public final void setBtnUpdate(@NotNull SetupButton setupButton) {
            Intrinsics.checkNotNullParameter(setupButton, "<set-?>");
            this.btnUpdate = setupButton;
        }

        @NotNull
        public final SetupButton getImportButton() {
            return this.importButton;
        }

        public final void setImportButton(@NotNull SetupButton setupButton) {
            Intrinsics.checkNotNullParameter(setupButton, "<set-?>");
            this.importButton = setupButton;
        }

        @NotNull
        public final SetupButton getBtnAdvanced() {
            return this.btnAdvanced;
        }

        public final void setBtnAdvanced(@NotNull SetupButton setupButton) {
            Intrinsics.checkNotNullParameter(setupButton, "<set-?>");
            this.btnAdvanced = setupButton;
        }

        @NotNull
        public final JTextArea getJTextArea() {
            return this.jTextArea;
        }

        public final void setJTextArea(@NotNull JTextArea jTextArea) {
            Intrinsics.checkNotNullParameter(jTextArea, "<set-?>");
            this.jTextArea = jTextArea;
        }

        @NotNull
        public final JTextField getProjectNameTF() {
            return this.projectNameTF;
        }

        public final void setProjectNameTF(@NotNull JTextField jTextField) {
            Intrinsics.checkNotNullParameter(jTextField, "<set-?>");
            this.projectNameTF = jTextField;
        }

        @NotNull
        public final JTextField getProjectRootTF() {
            return this.projectRootTF;
        }

        public final void setProjectRootTF(@NotNull JTextField jTextField) {
            Intrinsics.checkNotNullParameter(jTextField, "<set-?>");
            this.projectRootTF = jTextField;
        }

        @NotNull
        public final JTextField getDependencyTF() {
            return this.dependencyTF;
        }

        public final void setDependencyTF(@NotNull JTextField jTextField) {
            Intrinsics.checkNotNullParameter(jTextField, "<set-?>");
            this.dependencyTF = jTextField;
        }

        @NotNull
        public final List<String> getDependencies() {
            return this.dependencies;
        }

        public final void setDependencies(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, "<set-?>");
            this.dependencies = list;
        }

        public final boolean getInited() {
            return this.inited;
        }

        public final void setInited(boolean bl) {
            this.inited = bl;
        }

        public final void initComponents() {
            INSTANCE.setTitle("Wurst Setup");
            this.setBackground(new Color(36, 36, 36));
            this.setupTopBar();
            this.topBar.setBackground(new Color(64, 67, 69));
            this.title.setBackground(new Color(94, 97, 99));
            this.windowLabel.setForeground(new Color(255, 255, 255));
            this.contentTable.setSize(570, 350);
            INSTANCE.getContentPane().add(this.contentTable);
            this.contentTable.top();
            this.contentTable.row().height(26.0f);
            Table titleTable = new Table();
            titleTable.addCell(this.topBar).growX().height(26.0f);
            titleTable.addCell(this.title).size(100.0f, 26.0f);
            this.contentTable.addCell(titleTable).growX();
            this.contentTable.row();
            this.lblWelcome.setHorizontalAlignment(0);
            this.lblWelcome.setFont(new Font("SansSerif", 1, 18));
            this.contentTable.addCell(this.lblWelcome).center().pad(2.0f);
            this.contentTable.row();
            Table noteTable = new Table();
            noteTable.addCell(this.lblCurrentVersion).center();
            noteTable.addCell(this.lblCurVerNumber).center();
            noteTable.addCell(this.lblLatestVer).center().padLeft(12.0f);
            noteTable.addCell(this.lblLatestVerNumber).center();
            this.contentTable.addCell(noteTable).pad(2.0f).growX();
            this.contentTable.row();
            this.createConfigTable();
            this.contentTable.row();
            this.jTextArea.setBackground(new Color(46, 46, 46));
            this.jTextArea.setForeground(new Color(255, 255, 255));
            this.jTextArea.setFont(new Font("Monospaced", 0, 12));
            if (this.jTextArea.getCaret() instanceof DefaultCaret) {
                Caret caret = this.jTextArea.getCaret();
                Intrinsics.checkNotNull(caret, "null cannot be cast to non-null type javax.swing.text.DefaultCaret");
                DefaultCaret caret2 = (DefaultCaret)caret;
                caret2.setUpdatePolicy(2);
                caret2.setSelectionVisible(true);
            }
            this.jTextArea.setEditable(false);
            this.jTextArea.setMargin(new Insets(2, 2, 2, 2));
            JScrollPane scrollPane = new JScrollPane(this.jTextArea);
            this.contentTable.addCell(scrollPane).height(120.0f).growX().pad(2.0f);
            Border line = BorderFactory.createLineBorder(Color.DARK_GRAY);
            scrollPane.setBorder(line);
            scrollPane.setVerticalScrollBarPolicy(21);
            scrollPane.setHorizontalScrollBarPolicy(31);
            this.contentTable.row();
            this.contentTable.addCell(this.progressBar).growX().pad(2.0f);
            this.contentTable.row();
            this.createButtonTable();
            UiStyle.INSTANCE.setStyle(this.contentTable);
            this.inited = true;
            this.refreshComponents();
        }

        private final void setupTopBar() {
            try {
                this.exit.setOpaque(false);
                this.exit.setContentAreaFilled(false);
                this.exit.setFocusPainted(false);
                this.exit.setBorderPainted(false);
                this.exit.setPressedIcon(INSTANCE.getExitIconDown());
                this.exit.setRolloverIcon(INSTANCE.getExitIconHover());
                this.minimize.setOpaque(false);
                this.minimize.setContentAreaFilled(false);
                this.minimize.setFocusPainted(false);
                this.minimize.setBorderPainted(false);
                this.minimize.setPressedIcon(INSTANCE.getMinIconDown());
                this.minimize.setRolloverIcon(INSTANCE.getMinIconHover());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.title.setLayout(new GridLayout(1, 2));
            this.minimize.setSize(new Dimension(50, 26));
            this.exit.setSize(new Dimension(50, 26));
            this.title.add(this.minimize);
            this.title.add(this.exit);
            this.topBar.setLayout(new GridLayout(1, 1));
            this.topBar.add((Component)this.windowLabel, new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.titleEvents(this.minimize, this.exit);
        }

        private final void titleEvents(JButton minimize, JButton exit) {
            minimize.addActionListener(UI::titleEvents$lambda$0);
            exit.addActionListener(UI::titleEvents$lambda$1);
        }

        private final boolean warnProjectName() {
            String string = this.projectNameTF.getText();
            Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
            if (((CharSequence)string).length() > 0 && !this.projNamePattern.matcher(this.projectNameTF.getText()).matches()) {
                JOptionPane.showMessageDialog(null, "Error: Please enter valid project name", "Error Massage", 0);
                return true;
            }
            return false;
        }

        private final void createConfigTable() {
            UI that = this;
            Table configTable = new Table();
            configTable.row().height(24.0f);
            configTable.addCell(new JLabel("Project name:")).left();
            Table projectInputTable = new Table();
            projectInputTable.row().height(24.0f);
            this.projectNameTF.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ UI this$0;
                {
                    this.this$0 = $receiver;
                }

                public void changedUpdate(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter(e, "e");
                    this.warn();
                }

                public void removeUpdate(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter(e, "e");
                    this.warn();
                }

                public void insertUpdate(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter(e, "e");
                    this.warn();
                }

                public final void warn() {
                    String string = this.this$0.getProjectNameTF().getText();
                    Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                    if (((CharSequence)string).length() == 0) {
                        this.this$0.getBtnCreate().setEnabled(false);
                    } else {
                        this.this$0.getProjectRootTF().setText(UI.access$getProjectRootFile$p(this.this$0).getAbsolutePath() + File.separator + this.this$0.getProjectNameTF().getText());
                        if (!UI.access$getDisabled$p(this.this$0)) {
                            this.this$0.getBtnCreate().setEnabled(true);
                        }
                    }
                }
            });
            configTable.addCell(projectInputTable).growX();
            configTable.row().height(24.0f).padTop(2.0f);
            configTable.addCell(new JLabel("Project root:")).left();
            Table projectTF = new Table();
            this.projectRootTF.setEditable(false);
            projectTF.row().height(24.0f);
            projectTF.addCell(this.projectRootTF).growX();
            SetupButton selectProjectRoot = new SetupButton("...");
            this.projectRootTF.setText(this.projectRootFile.getAbsolutePath() + File.separator + this.projectNameTF.getText());
            projectInputTable.addCell(this.projectNameTF).growX();
            selectProjectRoot.addMouseListener(new MouseAdapter(that, this){
                final /* synthetic */ UI $that;
                final /* synthetic */ UI this$0;
                {
                    this.$that = $that;
                    this.this$0 = $receiver;
                }

                public void mouseClicked(@NotNull MouseEvent arg0) {
                    Intrinsics.checkNotNullParameter(arg0, "arg0");
                    JSystemFileChooser jSystemFileChooser = MainWindow.access$getSaveChooser$p();
                    if (jSystemFileChooser == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
                        jSystemFileChooser = null;
                    }
                    if (jSystemFileChooser.showSaveDialog(this.$that) == 0) {
                        JSystemFileChooser jSystemFileChooser2 = MainWindow.access$getSaveChooser$p();
                        if (jSystemFileChooser2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
                            jSystemFileChooser2 = null;
                        }
                        File file = jSystemFileChooser2.getSelectedFile();
                        Intrinsics.checkNotNullExpressionValue(file, "getSelectedFile(...)");
                        UI.access$setProjectRootFile$p(this.this$0, file);
                        JTextField jTextField = this.this$0.getProjectRootTF();
                        JSystemFileChooser jSystemFileChooser3 = MainWindow.access$getSaveChooser$p();
                        if (jSystemFileChooser3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
                            jSystemFileChooser3 = null;
                        }
                        jTextField.setText(jSystemFileChooser3.getSelectedFile().getAbsolutePath() + File.separator + this.this$0.getProjectNameTF().getText());
                    }
                }
            });
            projectTF.addCell(selectProjectRoot).pad(0.0f, 2.0f, 0.0f, 2.0f);
            configTable.addCell(projectTF).growX();
            configTable.row().height(24.0f).padTop(2.0f);
            configTable.addCell(new JLabel("Game path:")).left();
            Table gameTF = new Table();
            this.gamePathTF.setEditable(false);
            gameTF.addCell(this.gamePathTF).height(24.0f).growX();
            SetupButton selectGamePath = new SetupButton("...");
            selectGamePath.addMouseListener(new MouseAdapter(that, this){
                final /* synthetic */ UI $that;
                final /* synthetic */ UI this$0;
                {
                    this.$that = $that;
                    this.this$0 = $receiver;
                }

                public void mouseClicked(@NotNull MouseEvent arg0) {
                    Intrinsics.checkNotNullParameter(arg0, "arg0");
                    JSystemFileChooser jSystemFileChooser = MainWindow.access$getSaveChooser$p();
                    if (jSystemFileChooser == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
                        jSystemFileChooser = null;
                    }
                    if (jSystemFileChooser.showSaveDialog(this.$that) == 0) {
                        JTextField jTextField = UI.access$getGamePathTF$p(this.this$0);
                        JSystemFileChooser jSystemFileChooser2 = MainWindow.access$getSaveChooser$p();
                        if (jSystemFileChooser2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("saveChooser");
                            jSystemFileChooser2 = null;
                        }
                        jTextField.setText(jSystemFileChooser2.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
            if (StringsKt.startsWith$default(string, "Windows", false, 2, null)) {
                try {
                    Object wc3Path;
                    Key key = Registry.getKey("HKEY_CURRENT_USER\\SOFTWARE\\Blizzard Entertainment\\Warcraft III");
                    Reloadable reloadable = key;
                    Object object = reloadable != null && (reloadable = ((Key)reloadable).getValueByName("InstallPath")) != null ? ((Value)reloadable).getRawValue() : (wc3Path = null);
                    if (wc3Path != null) {
                        Path gameFolder;
                        String string2 = File.separator;
                        Intrinsics.checkNotNullExpressionValue(string2, "separator");
                        if (!StringsKt.endsWith$default((String)wc3Path, string2, false, 2, null)) {
                            wc3Path = (String)wc3Path + File.separator;
                        }
                        if (Files.exists(gameFolder = Paths.get((String)wc3Path, new String[0]), new LinkOption[0])) {
                            this.gamePathTF.setText((String)wc3Path);
                        }
                    } else {
                        this.checkDefaultWinLocation();
                    }
                }
                catch (Exception e) {
                    this.checkDefaultWinLocation();
                }
            }
            gameTF.addCell(selectGamePath).height(24.0f).pad(0.0f, 2.0f, 0.0f, 2.0f);
            configTable.addCell(gameTF).growX();
            configTable.row().height(24.0f).padTop(2.0f);
            configTable.addCell(new JLabel("Dependencies:")).left();
            Table dependencyTable = new Table();
            this.dependencyTF.setEditable(false);
            dependencyTable.addCell(this.dependencyTF).height(24.0f).growX();
            this.btnAdvanced.addMouseListener(new MouseAdapter(){

                public void mouseClicked(@NotNull MouseEvent arg0) {
                    Intrinsics.checkNotNullParameter(arg0, "arg0");
                    MainWindow.access$getLog$p().debug("Adding dependency");
                    new AddRepoDialog();
                }
            });
            dependencyTable.addCell(this.btnAdvanced).height(24.0f).pad(0.0f, 2.0f, 0.0f, 2.0f);
            configTable.addCell(dependencyTable).growX();
            this.contentTable.addCell(configTable).growX().pad(2.0f);
        }

        private final void checkDefaultWinLocation() {
            Path gameFolder;
            Path path = Paths.get(System.getenv("ProgramFiles"), new String[0]);
            Path path2 = gameFolder = path != null ? path.resolve("Warcraft III") : null;
            if (gameFolder != null && Files.exists(gameFolder, new LinkOption[0])) {
                this.gamePathTF.setText(((Object)gameFolder.toAbsolutePath()).toString());
            } else {
                Path path3 = Paths.get(System.getenv("ProgramFiles") + " (x86)", new String[0]);
                Path path4 = gameFolder = path3 != null ? path3.resolve("Warcraft III") : null;
                if (gameFolder != null && Files.exists(gameFolder, new LinkOption[0])) {
                    this.gamePathTF.setText(((Object)gameFolder.toAbsolutePath()).toString());
                } else {
                    log.warn("Didn't find warcraft installation.");
                }
            }
        }

        private final void handleImport() {
            try {
                JSystemFileChooser jSystemFileChooser = importChooser;
                if (jSystemFileChooser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("importChooser");
                    jSystemFileChooser = null;
                }
                Path buildFile = jSystemFileChooser.getSelectedFile().toPath();
                Intrinsics.checkNotNull(buildFile);
                WurstProjectConfigData config = WurstProjectConfig.INSTANCE.loadProject(buildFile);
                if (config != null) {
                    this.projectNameTF.setText(config.getProjectName());
                    this.projectRootTF.setText(((Object)buildFile.getParent()).toString());
                    this.dependencyTF.setText(config.getDependencies().stream().map(arg_0 -> UI.handleImport$lambda$2(handleImport.1.INSTANCE, arg_0)).collect(Collectors.joining(", ")));
                    this.dependencies = new ArrayList(config.getDependencies());
                    this.btnCreate.setText("Update Project");
                    this.selectedConfig = config;
                    Log.INSTANCE.print("Use the \"Update Project\" button to update config and dependencies.\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public final void refreshComponents() {
            if (!this.inited) {
                return;
            }
            SwingUtilities.invokeLater(() -> UI.refreshComponents$lambda$3(this));
        }

        private final String getVersionString() {
            return InstallationManager.INSTANCE.getCurrentCompilerVersion() > 0 ? String.valueOf(InstallationManager.INSTANCE.getCurrentCompilerVersion()) : "(unofficial build)";
        }

        public final void enableButtons() {
            this.disabled = false;
        }

        public final void disableButtons() {
            this.disabled = true;
            if (SwingUtilities.isEventDispatchThread()) {
                this.btnCreate.setEnabled(false);
                this.btnUpdate.setEnabled(false);
                this.importButton.setEnabled(false);
                this.btnAdvanced.setEnabled(false);
            } else {
                SwingUtilities.invokeLater(() -> UI.disableButtons$lambda$4(this));
            }
        }

        private final void createButtonTable() {
            Table buttonTable = new Table();
            buttonTable.setSize(420, 90);
            this.btnUpdate.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ UI this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseClicked(@NotNull MouseEvent arg0) {
                    Intrinsics.checkNotNullParameter(arg0, "arg0");
                    if (this.this$0.getBtnUpdate().isEnabled() && !this.this$0.getProgressBar().isIndeterminate()) {
                        UI.access$handleWurstUpdate(this.this$0);
                    }
                }
            });
            buttonTable.addCell(this.btnUpdate);
            buttonTable.addCell().growX();
            this.btnCreate.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ UI this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseClicked(@NotNull MouseEvent arg0) {
                    Intrinsics.checkNotNullParameter(arg0, "arg0");
                    if (this.this$0.getBtnCreate().isEnabled() && !this.this$0.getProgressBar().isIndeterminate()) {
                        SwingUtilities.invokeLater(() -> createButtonTable.2.mouseClicked$lambda$0(this.this$0));
                        this.this$0.disableButtons();
                        if (UI.access$getSelectedConfig$p(this.this$0) == null) {
                            try {
                                String[] stringArray = new String[]{"wurst.build"};
                                Path path = Paths.get(this.this$0.getProjectRootTF().getText(), stringArray);
                                Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                                UI.access$setSelectedConfig$p(this.this$0, WurstProjectConfig.INSTANCE.loadProject(path));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (UI.access$getSelectedConfig$p(this.this$0) != null) {
                            UI.access$handleUpdateProject(this.this$0);
                        } else if (UI.access$warnProjectName(this.this$0)) {
                            UiManager.INSTANCE.refreshComponents();
                        } else {
                            UI.access$handleCreateProject(this.this$0);
                        }
                    }
                }

                private static final void mouseClicked$lambda$0(UI this$0) {
                    Intrinsics.checkNotNullParameter(this$0, "this$0");
                    this$0.getProgressBar().setIndeterminate(true);
                }
            });
            UI that = this;
            this.importButton.addMouseListener(new MouseAdapter(this, that){
                final /* synthetic */ UI this$0;
                final /* synthetic */ UI $that;
                {
                    this.this$0 = $receiver;
                    this.$that = $that;
                }

                public void mouseClicked(@NotNull MouseEvent arg0) {
                    Intrinsics.checkNotNullParameter(arg0, "arg0");
                    if (this.this$0.getImportButton().isEnabled() && !this.this$0.getProgressBar().isIndeterminate()) {
                        JSystemFileChooser jSystemFileChooser = MainWindow.access$getImportChooser$p();
                        if (jSystemFileChooser == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("importChooser");
                            jSystemFileChooser = null;
                        }
                        if (jSystemFileChooser.showOpenDialog(this.$that) == 0) {
                            UI.access$handleImport(this.this$0);
                        }
                    }
                }
            });
            buttonTable.addCell(this.importButton).padRight(6.0f);
            buttonTable.addCell(this.btnCreate);
            this.contentTable.addCell(buttonTable).growX().pad(2.0f);
        }

        private final void handleCreateProject() {
            SwingUtilities.invokeLater(() -> UI.handleCreateProject$lambda$5(this));
            this.disableButtons();
            String gamePath = this.gamePathTF.getText();
            Path projectRoot = Paths.get(this.projectRootTF.getText(), new String[0]);
            Intrinsics.checkNotNull(gamePath);
            Path gameRoot = ((CharSequence)gamePath).length() > 0 ? Paths.get(gamePath, new String[0]) : null;
            Object[] objectArray = new String[]{"https://github.com/wurstscript/wurstStdlib2"};
            ArrayList<String> arrayList = new ArrayList<String>((Collection)CollectionsKt.mutableListOf(objectArray));
            String string = System.getProperty("user.name");
            Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
            WurstProjectConfigData config = new WurstProjectConfigData("MyProjectName", arrayList, new WurstProjectBuildMapData("MyMapName", "MyMapFile", string, null, null, null, null, 120, null));
            String string2 = this.projectNameTF.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            config.setProjectName(string2);
            Iterable $this$forEach$iv = this.dependencies;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String elem = (String)element$iv;
                boolean bl = false;
                if (config.getDependencies().contains(elem)) continue;
                config.getDependencies().add(elem);
            }
            objectArray = new Object[]{gameRoot, projectRoot, config};
            log.info("Generating new project.\n\t-> gamepath <{}>, root <{}>, config <{}>", objectArray);
            if (SetupApp.INSTANCE.getSetup().isGUILaunch()) {
                Intrinsics.checkNotNull(projectRoot);
                new ProjectCreateWorker(projectRoot, gameRoot, config).execute();
            } else {
                Intrinsics.checkNotNull(projectRoot);
                WurstProjectConfig.INSTANCE.handleCreate(projectRoot, gameRoot, config);
            }
        }

        private final void handleUpdateProject() {
            Path gameRoot = Paths.get(this.gamePathTF.getText(), new String[0]);
            Path projectRoot = Paths.get(this.projectRootTF.getText(), new String[0]);
            if (this.selectedConfig != null) {
                Iterable $this$forEach$iv = this.dependencies;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String e = (String)element$iv;
                    boolean bl = false;
                    Object object = this.selectedConfig;
                    boolean bl2 = object != null && (object = ((WurstProjectConfigData)object).getDependencies()) != null ? !((ArrayList)object).contains(e) : false;
                    if (!bl2) continue;
                    Object object2 = this.selectedConfig;
                    if (object2 == null || (object2 = ((WurstProjectConfigData)object2).getDependencies()) == null) continue;
                    ((ArrayList)object2).add(e);
                }
                log.info("Installing project. gamepath <{}>, root <{}>", (Object)gameRoot, (Object)projectRoot);
                Intrinsics.checkNotNull(projectRoot);
                Intrinsics.checkNotNull(gameRoot);
                WurstProjectConfigData wurstProjectConfigData = this.selectedConfig;
                Intrinsics.checkNotNull(wurstProjectConfigData);
                new ProjectUpdateWorker(projectRoot, gameRoot, wurstProjectConfigData).execute();
            }
        }

        private final void handleWurstUpdate() {
            log.debug("handle wurst update");
            SwingUtilities.invokeLater(() -> UI.handleWurstUpdate$lambda$8(this));
            this.disableButtons();
            new CompilerUpdateWorker().execute();
        }

        private static final void titleEvents$lambda$0(ActionEvent actionEvent) {
            INSTANCE.setState(1);
        }

        private static final void titleEvents$lambda$1(ActionEvent actionEvent) {
            INSTANCE.dispose();
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        private static final String handleImport$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final void refreshComponents$lambda$3(UI this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.progressBar.setIndeterminate(false);
            if (!this$0.disabled) {
                this$0.importButton.setEnabled(true);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[ConnectionManager.INSTANCE.getNetStatus().ordinal()]) {
                case 1: 
                case 2: {
                    this$0.lblLatestVerNumber.setText("(loading..)");
                    this$0.lblLatestVerNumber.setForeground(Color.DARK_GRAY);
                    this$0.btnCreate.setEnabled(false);
                    this$0.btnUpdate.setEnabled(false);
                    break;
                }
                case 3: {
                    this$0.lblLatestVerNumber.setText(String.valueOf(InstallationManager.INSTANCE.getLatestCompilerVersion()));
                    this$0.lblLatestVerNumber.setForeground(Color.decode("#005719"));
                    if (this$0.disabled) break;
                    this$0.btnUpdate.setEnabled(true);
                    break;
                }
                case 4: {
                    this$0.lblLatestVerNumber.setText("Loading..");
                    this$0.btnUpdate.setEnabled(false);
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$1[InstallationManager.INSTANCE.getStatus().ordinal()]) {
                case 1: {
                    this$0.btnUpdate.setText("Install WurstScript");
                    this$0.btnCreate.setEnabled(false);
                    this$0.lblCurVerNumber.setForeground(Color.DARK_GRAY);
                    break;
                }
                case 2: {
                    this$0.lblCurVerNumber.setText(this$0.getVersionString());
                    this$0.lblCurVerNumber.setForeground(Color.decode("#005719"));
                    if (!this$0.disabled) {
                        this$0.btnCreate.setEnabled(true);
                    }
                    this$0.btnUpdate.setText("Compiler up to date");
                    this$0.btnUpdate.setEnabled(false);
                    break;
                }
                case 3: 
                case 4: {
                    this$0.lblCurVerNumber.setText(this$0.getVersionString());
                    this$0.lblCurVerNumber.setForeground(Color.decode("#702D2D"));
                    if (!this$0.disabled) {
                        this$0.btnCreate.setEnabled(true);
                    }
                    this$0.btnUpdate.setText("Update WurstScript");
                }
            }
        }

        private static final void disableButtons$lambda$4(UI this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.btnCreate.setEnabled(false);
            this$0.btnUpdate.setEnabled(false);
            this$0.importButton.setEnabled(false);
            this$0.btnAdvanced.setEnabled(false);
        }

        private static final void handleCreateProject$lambda$5(UI this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.progressBar.setIndeterminate(true);
        }

        private static final void handleWurstUpdate$lambda$8(UI this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.progressBar.setIndeterminate(true);
        }

        public static final /* synthetic */ File access$getProjectRootFile$p(UI $this) {
            return $this.projectRootFile;
        }

        public static final /* synthetic */ boolean access$getDisabled$p(UI $this) {
            return $this.disabled;
        }

        public static final /* synthetic */ void access$setProjectRootFile$p(UI $this, File file) {
            $this.projectRootFile = file;
        }

        public static final /* synthetic */ JTextField access$getGamePathTF$p(UI $this) {
            return $this.gamePathTF;
        }

        public static final /* synthetic */ void access$handleWurstUpdate(UI $this) {
            $this.handleWurstUpdate();
        }

        public static final /* synthetic */ WurstProjectConfigData access$getSelectedConfig$p(UI $this) {
            return $this.selectedConfig;
        }

        public static final /* synthetic */ void access$setSelectedConfig$p(UI $this, WurstProjectConfigData wurstProjectConfigData) {
            $this.selectedConfig = wurstProjectConfigData;
        }

        public static final /* synthetic */ void access$handleUpdateProject(UI $this) {
            $this.handleUpdateProject();
        }

        public static final /* synthetic */ boolean access$warnProjectName(UI $this) {
            return $this.warnProjectName();
        }

        public static final /* synthetic */ void access$handleCreateProject(UI $this) {
            $this.handleCreateProject();
        }

        public static final /* synthetic */ void access$handleImport(UI $this) {
            $this.handleImport();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[NetStatus.values().length];
                try {
                    nArray[NetStatus.CLIENT_OFFLINE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NetStatus.SERVER_OFFLINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NetStatus.ONLINE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NetStatus.SERVER_CONTACT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[InstallationManager.InstallationStatus.values().length];
                try {
                    nArray[InstallationManager.InstallationStatus.NOT_INSTALLED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InstallationManager.InstallationStatus.INSTALLED_UPTODATE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InstallationManager.InstallationStatus.INSTALLED_UNKNOWN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InstallationManager.InstallationStatus.INSTALLED_OUTDATED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

