/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CancelledException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphWriter;
import org.eclipse.jgit.internal.storage.commitgraph.GraphCommits;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GcLog;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.util.ShutdownHook;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.internal.WorkQueue;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GC {
    private static final Logger LOG = LoggerFactory.getLogger(GC.class);
    private static final String PRUNE_EXPIRE_DEFAULT = "2.weeks.ago";
    private static final String PRUNE_PACK_EXPIRE_DEFAULT = "1.hour.ago";
    private static final Pattern PATTERN_LOOSE_OBJECT = Pattern.compile("[0-9a-fA-F]{38}");
    private static final Set<PackExt> PARENT_EXTS = Set.of(PackExt.PACK, PackExt.KEEP);
    private static final Set<PackExt> CHILD_EXTS = Set.of(PackExt.BITMAP_INDEX, PackExt.INDEX, PackExt.REVERSE_INDEX);
    private static final int DEFAULT_AUTOPACKLIMIT = 50;
    private static final int DEFAULT_AUTOLIMIT = 6700;
    private static final boolean DEFAULT_WRITE_BLOOM_FILTER = false;
    private static final boolean DEFAULT_WRITE_COMMIT_GRAPH = false;
    private static volatile ExecutorService executor;
    private final FileRepository repo;
    private ProgressMonitor pm;
    private long expireAgeMillis = -1L;
    private Date expire;
    private long packExpireAgeMillis = -1L;
    private Date packExpire;
    private Boolean packKeptObjects;
    private PackConfig pconfig;
    private Collection<Ref> lastPackedRefs;
    private long lastRepackTime;
    private boolean automatic;
    private boolean background;

    public static void setExecutor(ExecutorService e) {
        executor = e;
    }

    public GC(FileRepository repo) {
        this.repo = repo;
        this.pconfig = new PackConfig(repo);
        this.pm = NullProgressMonitor.INSTANCE;
    }

    public CompletableFuture<Collection<Pack>> gc() throws IOException, ParseException {
        if (!this.background) {
            return CompletableFuture.completedFuture(this.doGc());
        }
        GcLog gcLog = new GcLog(this.repo);
        if (!gcLog.lock()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        Supplier<Collection> gcTask = () -> {
            try {
                Collection<Pack> newPacks = this.doGc();
                if (this.automatic && this.tooManyLooseObjects()) {
                    String message = JGitText.get().gcTooManyUnpruned;
                    gcLog.write(message);
                    gcLog.commit();
                }
                Collection<Pack> collection = newPacks;
                return collection;
            }
            catch (IOException | ParseException e) {
                try {
                    gcLog.write(e.getMessage());
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    gcLog.write(sw.toString());
                    gcLog.commit();
                }
                catch (IOException e2) {
                    e2.addSuppressed(e);
                    LOG.error(e2.getMessage(), e2);
                }
            }
            finally {
                gcLog.unlock();
            }
            return Collections.emptyList();
        };
        return CompletableFuture.supplyAsync(gcTask, this.executor());
    }

    private ExecutorService executor() {
        return executor != null ? executor : WorkQueue.getExecutor();
    }

    private Collection<Pack> doGc() throws IOException, ParseException {
        if (this.automatic && !this.needGc()) {
            return Collections.emptyList();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (PidLock lock = new PidLock();){
            if (!lock.lock()) {
                return Collections.emptyList();
            }
            this.pm.start(6);
            this.packRefs();
            Collection<Pack> newPacks = this.repack();
            this.prune(Collections.emptySet());
            if (this.shouldWriteCommitGraphWhenGc()) {
                this.writeCommitGraph(this.refsToObjectIds(this.getAllRefs()));
            }
            return newPacks;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void loosen(ObjectDirectoryInserter inserter, ObjectReader reader, Pack pack, HashSet<ObjectId> existing) throws IOException {
        for (PackIndex.MutableEntry entry : pack) {
            ObjectId oid = entry.toObjectId();
            if (existing.contains(oid)) continue;
            existing.add(oid);
            ObjectLoader loader = reader.open(oid);
            inserter.insert(loader.getType(), loader.getSize(), loader.openStream(), true);
        }
    }

    private void deleteOldPacks(Collection<Pack> oldPacks, Collection<Pack> newPacks) throws ParseException, IOException {
        HashSet<ObjectId> ids = new HashSet<ObjectId>();
        for (Pack pack : newPacks) {
            for (PackIndex.MutableEntry entry : pack) {
                ids.add(entry.toObjectId());
            }
        }
        ObjectReader reader = this.repo.newObjectReader();
        ObjectDirectory dir = this.repo.getObjectDatabase();
        ObjectDirectoryInserter inserter = dir.newInserter();
        boolean shouldLoosen = !"now".equals(this.getPruneExpireStr()) && this.getExpireDate() < Long.MAX_VALUE;
        this.prunePreserved();
        long packExpireDate = this.getPackExpireDate();
        ArrayList<PackFile> packFilesToPrune = new ArrayList<PackFile>();
        block2: for (Pack oldPack : oldPacks) {
            this.checkCancelled();
            String oldName = oldPack.getPackName();
            for (Pack newPack : newPacks) {
                if (oldName.equals(newPack.getPackName())) continue block2;
            }
            if (oldPack.shouldBeKept() || this.repo.getFS().lastModifiedInstant(oldPack.getPackFile()).toEpochMilli() >= packExpireDate) continue;
            if (shouldLoosen) {
                this.loosen(inserter, reader, oldPack, ids);
            }
            oldPack.close();
            packFilesToPrune.add(oldPack.getPackFile());
        }
        packFilesToPrune.forEach(this::prunePack);
        this.repo.getObjectDatabase().close();
    }

    private void removeOldPack(PackFile packFile, int deleteOptions) throws IOException {
        if (this.pconfig.isPreserveOldPacks()) {
            File oldPackDir = this.repo.getObjectDatabase().getPreservedDirectory();
            FileUtils.mkdir(oldPackDir, true);
            PackFile oldPackFile = packFile.createPreservedForDirectory(oldPackDir);
            FileUtils.rename(packFile, oldPackFile);
        } else {
            FileUtils.delete(packFile, deleteOptions);
        }
    }

    private void prunePreserved() {
        if (this.pconfig.isPrunePreserved()) {
            try {
                FileUtils.delete(this.repo.getObjectDatabase().getPreservedDirectory(), 7);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void prunePack(PackFile packFile) {
        try {
            int deleteOptions = 6;
            this.removeOldPack(packFile.create(PackExt.PACK), deleteOptions);
            deleteOptions |= 8;
            PackExt[] packExtArray = PackExt.values();
            int n = packExtArray.length;
            int n2 = 0;
            while (n2 < n) {
                PackExt ext = packExtArray[n2];
                if (!PackExt.PACK.equals((Object)ext)) {
                    this.removeOldPack(packFile.create(ext), deleteOptions);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void prunePacked() throws IOException {
        ObjectDirectory objdb = this.repo.getObjectDatabase();
        Collection<Pack> packs = objdb.getPacks();
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout != null && fanout.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLoosePackedObjects, fanout.length);
            try {
                String[] stringArray = fanout;
                int n = fanout.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] entries;
                    String d = stringArray[n2];
                    this.checkCancelled();
                    this.pm.update(1);
                    if (d.length() == 2 && (entries = new File(objects, d).list()) != null) {
                        String[] stringArray2 = entries;
                        int n3 = entries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            block12: {
                                String e = stringArray2[n4];
                                this.checkCancelled();
                                if (e.length() == 38) {
                                    ObjectId id;
                                    try {
                                        id = ObjectId.fromString(d + e);
                                    }
                                    catch (IllegalArgumentException notAnObject) {
                                        break block12;
                                    }
                                    boolean found = false;
                                    for (Pack p : packs) {
                                        this.checkCancelled();
                                        if (!p.hasObject(id)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) {
                                        FileUtils.delete(objdb.fileFor(id), 14);
                                    }
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            finally {
                this.pm.endTask();
            }
        }
    }

    public void prune(Set<ObjectId> objectsToKeep) throws IOException, ParseException {
        Collection<Ref> newRefs;
        long expireDate = this.getExpireDate();
        HashMap<ObjectId, File> deletionCandidates = new HashMap<ObjectId, File>();
        Set<ObjectId> indexObjects = null;
        File objects = this.repo.getObjectsDirectory();
        String[] fanout = objects.list();
        if (fanout == null || fanout.length == 0) {
            return;
        }
        this.pm.beginTask(JGitText.get().pruneLooseUnreferencedObjects, fanout.length);
        try {
            String[] stringArray = fanout;
            int n = fanout.length;
            int n2 = 0;
            while (n2 < n) {
                String d = stringArray[n2];
                this.checkCancelled();
                this.pm.update(1);
                if (d.length() == 2) {
                    File dir = new File(objects, d);
                    File[] entries = dir.listFiles();
                    if (entries == null || entries.length == 0) {
                        FileUtils.delete(dir, 8);
                    } else {
                        File[] fileArray = entries;
                        int n3 = entries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File f = fileArray[n4];
                            this.checkCancelled();
                            String fName = f.getName();
                            if (fName.length() == 38 && this.repo.getFS().lastModifiedInstant(f).toEpochMilli() < expireDate) {
                                try {
                                    ObjectId id = ObjectId.fromString(d + fName);
                                    if (!objectsToKeep.contains(id)) {
                                        if (indexObjects == null) {
                                            indexObjects = this.listNonHEADIndexObjects();
                                        }
                                        if (!indexObjects.contains(id)) {
                                            deletionCandidates.put(id, f);
                                        }
                                    }
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            this.pm.endTask();
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        this.checkCancelled();
        if (this.lastPackedRefs == null || this.lastPackedRefs.isEmpty()) {
            newRefs = this.getAllRefs();
        } else {
            HashMap<String, Ref> last = new HashMap<String, Ref>();
            for (Ref r : this.lastPackedRefs) {
                last.put(r.getName(), r);
            }
            newRefs = new ArrayList<Ref>();
            for (Ref r : this.getAllRefs()) {
                Ref old;
                if (GC.equals(r, old = (Ref)last.get(r.getName()))) continue;
                newRefs.add(r);
            }
        }
        if (!newRefs.isEmpty()) {
            ObjectWalk w = new ObjectWalk(this.repo);
            try {
                for (Ref cr : newRefs) {
                    this.checkCancelled();
                    w.markStart(w.parseAny(cr.getObjectId()));
                }
                if (this.lastPackedRefs != null) {
                    for (Ref lpr : this.lastPackedRefs) {
                        w.markUninteresting(w.parseAny(lpr.getObjectId()));
                    }
                }
                this.removeReferenced(deletionCandidates, w);
            }
            finally {
                w.dispose();
            }
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        ObjectWalk w = new ObjectWalk(this.repo);
        try {
            for (Ref ar : this.getAllRefs()) {
                for (ObjectId id : this.listRefLogObjects(ar, this.lastRepackTime)) {
                    this.checkCancelled();
                    w.markStart(w.parseAny(id));
                }
            }
            if (this.lastPackedRefs != null) {
                for (Ref lpr : this.lastPackedRefs) {
                    this.checkCancelled();
                    w.markUninteresting(w.parseAny(lpr.getObjectId()));
                }
            }
            this.removeReferenced(deletionCandidates, w);
        }
        finally {
            w.dispose();
        }
        if (deletionCandidates.isEmpty()) {
            return;
        }
        this.checkCancelled();
        HashSet<File> touchedFanout = new HashSet<File>();
        for (File f : deletionCandidates.values()) {
            if (f.lastModified() >= expireDate) continue;
            f.delete();
            touchedFanout.add(f.getParentFile());
        }
        for (File f : touchedFanout) {
            FileUtils.delete(f, 24);
        }
        this.repo.getObjectDatabase().close();
    }

    private long getExpireDate() throws ParseException {
        long expireDate = Long.MAX_VALUE;
        if (this.expire == null && this.expireAgeMillis == -1L) {
            String pruneExpireStr = this.getPruneExpireStr();
            if (pruneExpireStr == null) {
                pruneExpireStr = PRUNE_EXPIRE_DEFAULT;
            }
            this.expire = GitDateParser.parse(pruneExpireStr, null, SystemReader.getInstance().getLocale());
            this.expireAgeMillis = -1L;
        }
        if (this.expire != null) {
            expireDate = this.expire.getTime();
        }
        if (this.expireAgeMillis != -1L) {
            expireDate = System.currentTimeMillis() - this.expireAgeMillis;
        }
        return expireDate;
    }

    private String getPruneExpireStr() {
        return this.repo.getConfig().getString("gc", null, "pruneexpire");
    }

    private long getPackExpireDate() throws ParseException {
        long packExpireDate = Long.MAX_VALUE;
        if (this.packExpire == null && this.packExpireAgeMillis == -1L) {
            String prunePackExpireStr = this.repo.getConfig().getString("gc", null, "prunepackexpire");
            if (prunePackExpireStr == null) {
                prunePackExpireStr = PRUNE_PACK_EXPIRE_DEFAULT;
            }
            this.packExpire = GitDateParser.parse(prunePackExpireStr, null, SystemReader.getInstance().getLocale());
            this.packExpireAgeMillis = -1L;
        }
        if (this.packExpire != null) {
            packExpireDate = this.packExpire.getTime();
        }
        if (this.packExpireAgeMillis != -1L) {
            packExpireDate = System.currentTimeMillis() - this.packExpireAgeMillis;
        }
        return packExpireDate;
    }

    private void removeReferenced(Map<ObjectId, File> id2File, ObjectWalk w) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject ro = w.next();
        while (ro != null) {
            this.checkCancelled();
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.next();
        }
        ro = w.nextObject();
        while (ro != null) {
            this.checkCancelled();
            if (id2File.remove(ro.getId()) != null && id2File.isEmpty()) {
                return;
            }
            ro = w.nextObject();
        }
    }

    private static boolean equals(Ref r1, Ref r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.isSymbolic()) {
            return r2.isSymbolic() && r1.getTarget().getName().equals(r2.getTarget().getName());
        }
        return !r2.isSymbolic() && Objects.equals(r1.getObjectId(), r2.getObjectId());
    }

    public void packRefs() throws IOException {
        RefDatabase refDb = this.repo.getRefDatabase();
        if (refDb instanceof FileReftableDatabase) {
            this.pm.beginTask(JGitText.get().packRefs, 1);
            try {
                ((FileReftableDatabase)refDb).compactFully();
            }
            finally {
                this.pm.endTask();
            }
            return;
        }
        List<Ref> refs = refDb.getRefsByPrefix("refs/");
        ArrayList<String> refsToBePacked = new ArrayList<String>(refs.size());
        this.pm.beginTask(JGitText.get().packRefs, refs.size());
        try {
            for (Ref ref : refs) {
                this.checkCancelled();
                if (!ref.isSymbolic() && ref.getStorage().isLoose()) {
                    refsToBePacked.add(ref.getName());
                }
                this.pm.update(1);
            }
            ((RefDirectory)this.repo.getRefDatabase()).pack(refsToBePacked);
        }
        finally {
            this.pm.endTask();
        }
    }

    public Collection<Pack> repack() throws IOException {
        Pack rest;
        Collection<Pack> toBeDeleted = this.repo.getObjectDatabase().getPacks();
        long time = System.currentTimeMillis();
        Collection<Ref> refsBefore = this.getAllRefs();
        HashSet allHeadsAndTags = new HashSet();
        HashSet<ObjectId> allHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> allTags = new HashSet<ObjectId>();
        HashSet<ObjectId> nonHeads = new HashSet<ObjectId>();
        HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
        Set<ObjectId> indexObjects = this.listNonHEADIndexObjects();
        Set<ObjectId> refsToExcludeFromBitmap = this.repo.getRefDatabase().getRefsByPrefix(this.pconfig.getBitmapExcludedRefsPrefixes()).stream().map(Ref::getObjectId).collect(Collectors.toSet());
        for (Ref ref : refsBefore) {
            this.checkCancelled();
            nonHeads.addAll(this.listRefLogObjects(ref, 0L));
            if (ref.isSymbolic() || ref.getObjectId() == null) continue;
            if (GC.isHead(ref)) {
                allHeads.add(ref.getObjectId());
            } else if (GC.isTag(ref)) {
                allTags.add(ref.getObjectId());
            } else {
                nonHeads.add(ref.getObjectId());
            }
            if (ref.getPeeledObjectId() == null) continue;
            tagTargets.add(ref.getPeeledObjectId());
        }
        LinkedList<ObjectIdSet> excluded = new LinkedList<ObjectIdSet>();
        for (Pack p : this.repo.getObjectDatabase().getPacks()) {
            this.checkCancelled();
            if (this.shouldPackKeptObjects() || !p.shouldBeKept()) continue;
            excluded.add(p.getIndex());
        }
        allTags.removeAll(allHeads);
        allHeadsAndTags.addAll(allHeads);
        allHeadsAndTags.addAll(allTags);
        tagTargets.addAll(allHeadsAndTags);
        nonHeads.addAll(indexObjects);
        if (this.pconfig.getSinglePack()) {
            allHeadsAndTags.addAll(nonHeads);
            nonHeads.clear();
        }
        ArrayList<Pack> ret = new ArrayList<Pack>(2);
        Pack heads = null;
        if (!allHeadsAndTags.isEmpty() && (heads = this.writePack(allHeadsAndTags, PackWriter.NONE, allTags, refsToExcludeFromBitmap, tagTargets, excluded, true)) != null) {
            ret.add(heads);
            excluded.add(0, heads.getIndex());
        }
        if (!nonHeads.isEmpty() && (rest = this.writePack(nonHeads, allHeadsAndTags, PackWriter.NONE, PackWriter.NONE, tagTargets, excluded, false)) != null) {
            ret.add(rest);
        }
        try {
            this.deleteOldPacks(toBeDeleted, ret);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        this.prunePacked();
        if (this.repo.getRefDatabase() instanceof RefDirectory) {
            this.deleteEmptyRefsFolders();
        }
        this.deleteOrphans();
        this.deleteTempPacksIdx();
        this.lastPackedRefs = refsBefore;
        this.lastRepackTime = time;
        return ret;
    }

    private Set<ObjectId> refsToObjectIds(Collection<Ref> refs) throws IOException {
        HashSet<ObjectId> objectIds = new HashSet<ObjectId>();
        for (Ref ref : refs) {
            this.checkCancelled();
            if (ref.getPeeledObjectId() != null) {
                objectIds.add(ref.getPeeledObjectId());
                continue;
            }
            if (ref.getObjectId() == null) continue;
            objectIds.add(ref.getObjectId());
        }
        return objectIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeCommitGraph(@NonNull Set<? extends ObjectId> wants) throws IOException {
        if (!this.repo.getConfig().get(CoreConfig.KEY).enableCommitGraph()) {
            return;
        }
        if (this.repo.getObjectDatabase().getShallowCommits().size() > 0) {
            return;
        }
        this.checkCancelled();
        if (wants.isEmpty()) {
            return;
        }
        File tmpFile = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (RevWalk walk = new RevWalk(this.repo);){
                block33: {
                    CommitGraphWriter writer = new CommitGraphWriter(GraphCommits.fromWalk(this.pm, wants, walk), this.shouldWriteBloomFilter());
                    tmpFile = File.createTempFile("commit_", PackExt.COMMIT_GRAPH.getTmpExtension(), this.repo.getObjectDatabase().getInfoDirectory());
                    Throwable throwable2 = null;
                    Object var8_11 = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(tmpFile);
                        try {
                            block32: {
                                FileChannel channel = fos.getChannel();
                                try {
                                    try (OutputStream channelStream = Channels.newOutputStream(channel);){
                                        writer.write(this.pm, channelStream);
                                        channel.force(true);
                                    }
                                    if (channel == null) break block32;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    if (channel == null) throw throwable2;
                                    channel.close();
                                    throw throwable2;
                                }
                                channel.close();
                            }
                            if (fos == null) break block33;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            if (fos == null) throw throwable2;
                            fos.close();
                            throw throwable2;
                        }
                        fos.close();
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                            throw throwable2;
                        }
                        if (throwable2 == throwable5) throw throwable2;
                        throwable2.addSuppressed(throwable5);
                        throw throwable2;
                    }
                }
                File realFile = new File(this.repo.getObjectsDirectory(), "info/commit-graph");
                FileUtils.rename(tmpFile, realFile, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        this.deleteTempCommitGraph();
    }

    private void deleteTempCommitGraph() {
        Path objectsDir = this.repo.getObjectDatabase().getInfoDirectory().toPath();
        Instant threshold = Instant.now().minus(1L, ChronoUnit.DAYS);
        if (!Files.exists(objectsDir, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(objectsDir, "commit_*_tmp");){
                stream.forEach(t -> {
                    try {
                        Instant lastModified = Files.getLastModifiedTime(t, new LinkOption[0]).toInstant();
                        if (lastModified.isBefore(threshold)) {
                            Files.deleteIfExists(t);
                        }
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    boolean shouldWriteCommitGraphWhenGc() {
        return this.repo.getConfig().getBoolean("gc", "writeCommitGraph", false);
    }

    boolean shouldWriteBloomFilter() {
        return this.repo.getConfig().getBoolean("gc", "writeChangedPaths", false);
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private static boolean isTag(Ref ref) {
        return ref.getName().startsWith("refs/tags/");
    }

    private void deleteEmptyRefsFolders() throws IOException {
        Path refs = this.repo.getDirectory().toPath().resolve("refs/");
        Instant threshold = Instant.now().minus(30L, ChronoUnit.SECONDS);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> entries = Files.list(refs).filter(path -> Files.isDirectory(path, new LinkOption[0]));){
            Iterator iterator2 = entries.iterator();
            while (iterator2.hasNext()) {
                Throwable throwable2 = null;
                Object var8_11 = null;
                try (Stream<Path> s = Files.list((Path)iterator2.next());){
                    s.filter(path -> this.canBeSafelyDeleted((Path)path, threshold)).forEach(this::deleteDir);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private boolean canBeSafelyDeleted(Path path, Instant threshold) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().isBefore(threshold);
        }
        catch (IOException e) {
            LOG.warn(MessageFormat.format(JGitText.get().cannotAccessLastModifiedForSafeDeletion, path), e);
            return false;
        }
    }

    private void deleteDir(Path dir) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> dirs = Files.walk(dir, new FileVisitOption[0]);){
                dirs.filter(this::isDirectory).sorted(Comparator.reverseOrder()).forEach(this::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    private boolean isDirectory(Path p) {
        return p.toFile().isDirectory();
    }

    private void delete(Path d) {
        try {
            Files.delete(d);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
        }
        catch (IOException e) {
            LOG.error(MessageFormat.format(JGitText.get().cannotDeleteFile, d), e);
        }
    }

    private static Optional<PackFile> toPackFileWithValidExt(Path packFilePath) {
        try {
            PackFile packFile = new PackFile(packFilePath.toFile());
            if (packFile.getPackExt() == null) {
                return Optional.empty();
            }
            return Optional.of(packFile);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private void deleteOrphans() {
        List childFiles;
        Path packDir = this.repo.getObjectDatabase().getPackDirectory().toPath();
        HashSet seenParentIds = new HashSet();
        try {
            Throwable throwable = null;
            Iterator iterator2 = null;
            try (Stream<Path> files = Files.list(packDir);){
                childFiles = files.map(GC::toPackFileWithValidExt).filter(Optional::isPresent).map(Optional::get).filter(packFile -> {
                    PackExt ext = packFile.getPackExt();
                    if (PARENT_EXTS.contains((Object)ext)) {
                        seenParentIds.add(packFile.getId());
                        return false;
                    }
                    return CHILD_EXTS.contains((Object)ext);
                }).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
            return;
        }
        for (PackFile child : childFiles) {
            if (seenParentIds.contains(child.getId())) continue;
            try {
                FileUtils.delete(child, 6);
                LOG.warn(JGitText.get().deletedOrphanInPackDir, (Object)child);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    private void deleteTempPacksIdx() {
        Path packDir = this.repo.getObjectDatabase().getPackDirectory().toPath();
        Instant threshold = Instant.now().minus(1L, ChronoUnit.DAYS);
        if (!Files.exists(packDir, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(packDir, "gc_*_tmp");){
                stream.forEach(t -> {
                    try {
                        Instant lastModified = Files.getLastModifiedTime(t, new LinkOption[0]).toInstant();
                        if (lastModified.isBefore(threshold)) {
                            Files.deleteIfExists(t);
                        }
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    private Set<ObjectId> listRefLogObjects(Ref ref, long minTime) throws IOException {
        ReflogReader reflogReader = this.repo.getReflogReader(ref);
        List<ReflogEntry> rlEntries = reflogReader.getReverseEntries();
        if (rlEntries == null || rlEntries.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectId> ret = new HashSet<ObjectId>();
        for (ReflogEntry e : rlEntries) {
            ObjectId oldId;
            if (e.getWho().getWhen().getTime() < minTime) break;
            ObjectId newId = e.getNewId();
            if (newId != null && !ObjectId.zeroId().equals(newId)) {
                ret.add(newId);
            }
            if ((oldId = e.getOldId()) == null || ObjectId.zeroId().equals(oldId)) continue;
            ret.add(oldId);
        }
        return ret;
    }

    private Collection<Ref> getAllRefs() throws IOException {
        RefDatabase refdb = this.repo.getRefDatabase();
        List<Ref> refs = refdb.getRefs();
        List<Ref> addl = refdb.getAdditionalRefs();
        if (!addl.isEmpty()) {
            ArrayList<Ref> all = new ArrayList<Ref>(refs.size() + addl.size());
            all.addAll(refs);
            for (Ref r : addl) {
                this.checkCancelled();
                if (!r.getName().startsWith("refs/")) continue;
                all.add(r);
            }
            return all;
        }
        return refs;
    }

    private Set<ObjectId> listNonHEADIndexObjects() throws CorruptObjectException, IOException {
        if (this.repo.isBare()) {
            return Collections.emptySet();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            treeWalk.addTree(new DirCacheIterator(this.repo.readDirCache()));
            ObjectId headID = this.repo.resolve("HEAD");
            if (headID != null) {
                Throwable throwable2 = null;
                Object var6_9 = null;
                try (RevWalk revWalk = new RevWalk(this.repo);){
                    treeWalk.addTree(revWalk.parseTree(headID));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            treeWalk.setRecursive(true);
            HashSet<ObjectId> ret = new HashSet<ObjectId>();
            while (treeWalk.next()) {
                this.checkCancelled();
                ObjectId objectId = treeWalk.getObjectId(0);
                switch (treeWalk.getRawMode(0) & 0xF000) {
                    case 0: 
                    case 57344: {
                        break;
                    }
                    case 16384: 
                    case 32768: 
                    case 40960: {
                        ret.add(objectId);
                        break;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", treeWalk.getRawMode(0)), objectId == null ? "null" : objectId.name(), treeWalk.getPathString(), this.repo.getIndexFile()));
                    }
                }
            }
            return ret;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private Pack writePack(@NonNull Set<? extends ObjectId> want, @NonNull Set<? extends ObjectId> have, @NonNull Set<ObjectId> tags, @NonNull Set<ObjectId> excludedRefsTips, Set<ObjectId> tagTargets, List<ObjectIdSet> excludeObjects, boolean createBitmap) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<? extends ObjectId> union(Set<ObjectId> tags, Set<ObjectId> excludedRefsHeadsTips) {
        HashSet<ObjectId> unionSet = new HashSet<ObjectId>(tags.size() + excludedRefsHeadsTips.size());
        unionSet.addAll(tags);
        unionSet.addAll(excludedRefsHeadsTips);
        return unionSet;
    }

    private void checkCancelled() throws CancelledException {
        if (this.pm.isCancelled() || Thread.currentThread().isInterrupted()) {
            throw new CancelledException(JGitText.get().operationCanceled);
        }
    }

    public void setPackKeptObjects(boolean packKeptObjects) {
        this.packKeptObjects = packKeptObjects;
    }

    private boolean shouldPackKeptObjects() {
        return Optional.ofNullable(this.packKeptObjects).orElse(this.pconfig.isPackKeptObjects());
    }

    public RepoStatistics getStatistics() throws IOException {
        RepoStatistics ret = new RepoStatistics();
        Collection<Pack> packs = this.repo.getObjectDatabase().getPacks();
        for (Pack p : packs) {
            ret.numberOfPackedObjects += p.getIndex().getObjectCount();
            ++ret.numberOfPackFiles;
            ret.sizeOfPackedObjects += p.getPackFile().length();
            if (p.getBitmapIndex() == null) continue;
            ret.numberOfBitmaps += (long)p.getBitmapIndex().getBitmapCount();
        }
        File objDir = this.repo.getObjectsDirectory();
        String[] fanout = objDir.list();
        if (fanout != null && fanout.length > 0) {
            String[] stringArray = fanout;
            int n = fanout.length;
            int n2 = 0;
            while (n2 < n) {
                File[] entries;
                String d = stringArray[n2];
                if (d.length() == 2 && (entries = new File(objDir, d).listFiles()) != null) {
                    File[] fileArray = entries;
                    int n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray[n4];
                        if (f.getName().length() == 38) {
                            ++ret.numberOfLooseObjects;
                            ret.sizeOfLooseObjects += f.length();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        RefDatabase refDb = this.repo.getRefDatabase();
        for (Ref r : refDb.getRefs()) {
            Ref.Storage storage2 = r.getStorage();
            if (storage2 == Ref.Storage.LOOSE || storage2 == Ref.Storage.LOOSE_PACKED) {
                ++ret.numberOfLooseRefs;
            }
            if (storage2 != Ref.Storage.PACKED && storage2 != Ref.Storage.LOOSE_PACKED) continue;
            ++ret.numberOfPackedRefs;
        }
        return ret;
    }

    public GC setProgressMonitor(ProgressMonitor pm) {
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
        return this;
    }

    public void setExpireAgeMillis(long expireAgeMillis) {
        this.expireAgeMillis = expireAgeMillis;
        this.expire = null;
    }

    public void setPackExpireAgeMillis(long packExpireAgeMillis) {
        this.packExpireAgeMillis = packExpireAgeMillis;
        this.expire = null;
    }

    public void setPackConfig(@NonNull PackConfig pconfig) {
        this.pconfig = pconfig;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
        this.expireAgeMillis = -1L;
    }

    public void setPackExpire(Date packExpire) {
        this.packExpire = packExpire;
        this.packExpireAgeMillis = -1L;
    }

    public void setAuto(boolean auto) {
        this.automatic = auto;
    }

    void setBackground(boolean background) {
        this.background = background;
    }

    private boolean needGc() {
        if (!this.tooManyPacks()) {
            return this.tooManyLooseObjects();
        }
        this.addRepackAllOption();
        return true;
    }

    private void addRepackAllOption() {
    }

    boolean tooManyPacks() {
        int autopacklimit = this.repo.getConfig().getInt("gc", "autopacklimit", 50);
        if (autopacklimit <= 0) {
            return false;
        }
        return this.repo.getObjectDatabase().getPacks().size() > autopacklimit + 1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean tooManyLooseObjects() {
        auto = this.getLooseObjectLimit();
        if (auto <= 0) {
            return false;
        }
        n = 0;
        threshold = (auto + 255) / 256;
        dir = this.repo.getObjectsDirectory().toPath().resolve("17");
        if (!dir.toFile().exists()) {
            return false;
        }
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                stream = Files.newDirectoryStream(dir, (DirectoryStream.Filter<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$15(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)());
                try {
                    iter = stream.iterator();
                    while (true) {
                        if (++n > threshold) {
                            return true;
                        }
                        iter.next();
                        break;
                    }
                }
                finally {
                    if (iter.hasNext()) ** continue;
                    return false;
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                    throw var5_5;
                }
                if (var5_5 == var6_9) throw var5_5;
                var5_5.addSuppressed(var6_9);
                throw var5_5;
            }
        }
        catch (IOException e) {
            GC.LOG.error(e.getMessage(), e);
        }
        return false;
    }

    private int getLooseObjectLimit() {
        return this.repo.getConfig().getInt("gc", "auto", 6700);
    }

    private static /* synthetic */ int lambda$14(PackExt o1, PackExt o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == PackExt.INDEX) {
            return 1;
        }
        if (o2 == PackExt.INDEX) {
            return -1;
        }
        return Integer.signum(o1.hashCode() - o2.hashCode());
    }

    private static /* synthetic */ boolean lambda$15(Path file) throws IOException {
        Path fileName = file.getFileName();
        return file.toFile().isFile() && fileName != null && PATTERN_LOOSE_OBJECT.matcher(fileName.toString()).matches();
    }

    private class PidLock
    implements AutoCloseable {
        private static final String GC_PID = "gc.pid";
        private final Path pidFile;
        private FS.LockToken token;
        private FileLock lock;
        private RandomAccessFile f;
        private FileChannel channel;
        private ShutdownHook.Listener shutdownListener = this::close;

        PidLock() {
            this.pidFile = GC.this.repo.getDirectory().toPath().resolve(GC_PID);
        }

        boolean lock() throws IOException {
            block7: {
                if (Files.exists(this.pidFile, new LinkOption[0])) {
                    Instant twelveHoursAgo;
                    Instant mtime = FS.DETECTED.lastModifiedInstant(this.pidFile.toFile());
                    if (mtime.compareTo(twelveHoursAgo = Instant.now().minus(12L, ChronoUnit.HOURS)) > 0) {
                        this.gcAlreadyRunning();
                        return false;
                    }
                    LOG.warn(MessageFormat.format(JGitText.get().stalePidLock, this.pidFile, mtime));
                }
                this.token = FS.DETECTED.createNewFileAtomic(this.pidFile.toFile());
                this.f = new RandomAccessFile(this.pidFile.toFile(), "rw");
                this.channel = this.f.getChannel();
                this.lock = this.channel.tryLock();
                if (this.lock != null && this.lock.isValid()) break block7;
                this.gcAlreadyRunning();
                return false;
            }
            try {
                this.channel.write(ByteBuffer.wrap(this.getProcDesc().getBytes(StandardCharsets.UTF_8)));
                ShutdownHook.INSTANCE.register(this.shutdownListener);
            }
            catch (IOException | OverlappingFileLockException e) {
                try {
                    this.failedToLock();
                }
                catch (Exception e1) {
                    LOG.error(MessageFormat.format(JGitText.get().closePidLockFailed, this.pidFile), e1);
                }
                throw e;
            }
            return true;
        }

        private void failedToLock() {
            this.close();
            LOG.error(MessageFormat.format(JGitText.get().failedPidLock, this.pidFile));
        }

        private void gcAlreadyRunning() {
            this.close();
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (Stream<String> lines = Files.lines(this.pidFile);){
                    Optional<String> s = lines.findFirst();
                    String machine = null;
                    String pid = null;
                    if (s.isPresent()) {
                        String[] c = s.get().split("\\s+");
                        pid = c[0];
                        machine = c[1];
                    }
                    if (!StringUtils.isEmptyOrNull(machine) && !StringUtils.isEmptyOrNull(pid)) {
                        LOG.error(MessageFormat.format(JGitText.get().gcAlreadyRunning, machine, pid));
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.error(MessageFormat.format(JGitText.get().failedPidLock, this.pidFile));
        }

        private String getProcDesc() {
            StringBuffer s = new StringBuffer(Long.toString(this.getPID()));
            s.append(' ');
            s.append(this.getHostName());
            return s.toString();
        }

        private long getPID() {
            return ProcessHandle.current().pid();
        }

        private String getHostName() {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                return "";
            }
        }

        @Override
        public void close() {
            boolean wasLocked = false;
            try {
                ShutdownHook.INSTANCE.unregister(this.shutdownListener);
                if (this.lock != null && this.lock.isValid()) {
                    this.lock.release();
                    wasLocked = true;
                }
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.f != null) {
                    this.f.close();
                }
                if (this.token != null) {
                    this.token.close();
                }
                if (wasLocked) {
                    FileUtils.delete(this.pidFile.toFile(), 6);
                }
            }
            catch (IOException e) {
                LOG.error(MessageFormat.format(JGitText.get().closePidLockFailed, this.pidFile), e);
            }
        }
    }

    public static class RepoStatistics {
        public long numberOfPackedObjects;
        public long numberOfPackFiles;
        public long numberOfLooseObjects;
        public long sizeOfLooseObjects;
        public long sizeOfPackedObjects;
        public long numberOfLooseRefs;
        public long numberOfPackedRefs;
        public long numberOfBitmaps;

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("numberOfPackedObjects=").append(this.numberOfPackedObjects);
            b.append(", numberOfPackFiles=").append(this.numberOfPackFiles);
            b.append(", numberOfLooseObjects=").append(this.numberOfLooseObjects);
            b.append(", numberOfLooseRefs=").append(this.numberOfLooseRefs);
            b.append(", numberOfPackedRefs=").append(this.numberOfPackedRefs);
            b.append(", sizeOfLooseObjects=").append(this.sizeOfLooseObjects);
            b.append(", sizeOfPackedObjects=").append(this.sizeOfPackedObjects);
            b.append(", numberOfBitmaps=").append(this.numberOfBitmaps);
            return b.toString();
        }
    }
}

