/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class FileElement {
    private final String path;
    private final Type type;
    private final File workDir;
    private InputStream stream;
    private File tempFile;

    public FileElement(String path, Type type2) {
        this(path, type2, null);
    }

    public FileElement(String path, Type type2, File workDir) {
        this(path, type2, workDir, null);
    }

    public FileElement(String path, Type type2, File workDir, InputStream stream) {
        this.path = path;
        this.type = type2;
        this.workDir = workDir;
        this.stream = stream;
    }

    public String getPath() {
        return this.path;
    }

    public Type getType() {
        return this.type;
    }

    public File getFile() throws IOException {
        if (this.tempFile != null && this.stream == null) {
            return this.tempFile;
        }
        File file = new File(this.workDir, this.path);
        if (this.stream != null || this.isNullPath()) {
            if (this.tempFile == null) {
                this.tempFile = FileElement.getTempFile(file, this.type.name(), null);
            }
            if (this.stream != null) {
                FileElement.copyFromStream(this.tempFile, this.stream);
            }
            this.stream = null;
            return this.tempFile;
        }
        return file;
    }

    public boolean isNullPath() {
        return this.path.equals("/dev/null");
    }

    public File createTempFile(File directory) throws IOException {
        if (this.tempFile == null) {
            this.tempFile = FileElement.getTempFile(new File(this.path), this.type.name(), directory);
        }
        return this.tempFile;
    }

    public void cleanTemporaries() {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
        this.tempFile = null;
    }

    public String replaceVariable(String input) throws IOException {
        return input.replace("$" + this.type.name(), this.getFile().getPath());
    }

    public void addToEnv(Map<String, String> env) throws IOException {
        env.put(this.type.name(), this.getFile().getPath());
    }

    private static File getTempFile(File file, String midName, File workingDir) throws IOException {
        String[] fileNameAndExtension = FileElement.splitBaseFileNameAndExtension(file);
        return File.createTempFile(fileNameAndExtension[0] + "_" + midName + "_", fileNameAndExtension[1], workingDir);
    }

    private static void copyFromStream(File file, InputStream stream) throws IOException, FileNotFoundException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream outStream = new FileOutputStream(file);){
                int read = 0;
                byte[] bytes = new byte[8192];
                while ((read = stream.read(bytes)) != -1) {
                    ((OutputStream)outStream).write(bytes, 0, read);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            stream.close();
        }
    }

    private static String[] splitBaseFileNameAndExtension(File file) {
        String[] result2 = new String[]{file.getName(), ""};
        int idx = result2[0].lastIndexOf(".");
        if (idx > 0) {
            result2[1] = result2[0].substring(idx, result2[0].length());
            result2[0] = result2[0].substring(0, idx);
        }
        return result2;
    }

    public static enum Type {
        LOCAL,
        REMOTE,
        MERGED,
        BASE,
        BACKUP;

    }
}

