/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class CachingPublicKeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository.AttributeKey<Map<PublicKey, Boolean>> CACHE_ATTRIBUTE = new AttributeRepository.AttributeKey();
    protected final PublickeyAuthenticator authenticator;

    public CachingPublicKeyAuthenticator(PublickeyAuthenticator authenticator) {
        this.authenticator = Objects.requireNonNull(authenticator, "No delegate authenticator");
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        Map<PublicKey, Boolean> map = this.resolveCachedResults(username, key, session);
        Boolean result2 = map.get(key);
        if (result2 == null) {
            try {
                result2 = this.authenticator.authenticate(username, key, session);
            }
            catch (Error e) {
                this.warn("authenticate({}@{}) failed ({}) to consult delegate for {} key={}: {}", username, session, e.getClass().getSimpleName(), KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key), e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({}@{}) cache result={} for {} key={}", username, session, result2, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
            }
            map.put(key, result2);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}@{}) use cached result={} for {} key={}", username, session, result2, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
        }
        return result2;
    }

    protected Map<PublicKey, Boolean> resolveCachedResults(String username, PublicKey key, ServerSession session) {
        return session.computeAttributeIfAbsent(CACHE_ATTRIBUTE, attr -> new ConcurrentHashMap());
    }
}

