/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.sshd.common.util.io.IoUtils;

@FunctionalInterface
public interface FileInfoExtractor<T> {
    public static final FileInfoExtractor<Boolean> EXISTS = Files::exists;
    public static final FileInfoExtractor<Boolean> ISDIR = Files::isDirectory;
    public static final FileInfoExtractor<Boolean> ISREG = Files::isRegularFile;
    public static final FileInfoExtractor<Boolean> ISSYMLINK = (file, options2) -> Files.isSymbolicLink(file);
    public static final FileInfoExtractor<Long> SIZE = (file, options2) -> Files.size(file);
    public static final FileInfoExtractor<Set<PosixFilePermission>> PERMISSIONS = IoUtils::getPermissions;
    public static final FileInfoExtractor<FileTime> LASTMODIFIED = Files::getLastModifiedTime;

    public T infoOf(Path var1, LinkOption ... var2) throws IOException;
}

