/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class DefaultAgentForwardSupport
extends AbstractCloseable
implements AgentForwardSupport {
    private final ConnectionService serviceInstance;
    private final AtomicReference<SshAgentServer> agentServerHolder = new AtomicReference();

    public DefaultAgentForwardSupport(ConnectionService service) {
        this.serviceInstance = Objects.requireNonNull(service, "No connection service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String initialize() throws IOException {
        Object session = this.serviceInstance.getSession();
        try {
            SshAgentServer agentServer;
            AtomicReference<SshAgentServer> atomicReference = this.agentServerHolder;
            synchronized (atomicReference) {
                agentServer = this.agentServerHolder.get();
                if (agentServer != null) {
                    return agentServer.getId();
                }
                agentServer = Objects.requireNonNull(this.createSshAgentServer(this.serviceInstance, (Session)session), "No agent server created");
                this.agentServerHolder.set(agentServer);
            }
            String agentId = agentServer.getId();
            if (this.log.isDebugEnabled()) {
                this.log.debug("initialize({}) id={}, server={}", session, agentId, agentServer);
            }
            return agentId;
        }
        catch (Throwable t) {
            this.error("initialize({}) failed ({}) to create server: {}", session, t.getClass().getSimpleName(), t.getMessage(), t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new SshException(t);
        }
    }

    protected SshAgentServer createSshAgentServer(ConnectionService service, Session session) throws Throwable {
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory = Objects.requireNonNull(manager.getAgentFactory(), "No agent factory");
        return factory.createServer(service);
    }

    @Override
    public void close() throws IOException {
        SshAgentServer agentServer = this.agentServerHolder.getAndSet(null);
        if (agentServer != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("close({}) closing server={}", this.serviceInstance.getSession(), (Object)agentServer);
            }
            agentServer.close();
        }
    }

    @Override
    protected void doCloseImmediately() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed (" + e.getClass().getSimpleName() + ") to close agent: " + e.getMessage(), e);
        }
        super.doCloseImmediately();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serviceInstance.getSession() + "]";
    }
}

