/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.common.extensions.openssh;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.sftp.common.extensions.AbstractParser;

public abstract class AbstractOpenSSHExtensionParser
extends AbstractParser<OpenSSHExtension> {
    protected AbstractOpenSSHExtensionParser(String name) {
        super(name);
    }

    @Override
    public OpenSSHExtension parse(byte[] input, int offset, int len) {
        return this.parse(new String(input, offset, len, StandardCharsets.UTF_8));
    }

    public OpenSSHExtension parse(String version) {
        return new OpenSSHExtension(this.getName(), version);
    }

    public static class OpenSSHExtension
    implements NamedResource,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 5902797870154506909L;
        private final String name;
        private String version;

        public OpenSSHExtension(String name) {
            this(name, null);
        }

        public OpenSSHExtension(String name, String version) {
            this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No extension name");
            this.version = version;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getVersion());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OpenSSHExtension other = (OpenSSHExtension)obj;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getVersion(), other.getVersion());
        }

        public OpenSSHExtension clone() {
            try {
                return (OpenSSHExtension)this.getClass().cast(super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Unexpected clone exception " + this.toString() + ": " + e.getMessage());
            }
        }

        public String toString() {
            return this.getName() + " " + this.getVersion();
        }
    }
}

