/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class DigestUtils {
    private DigestUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean checkSupported(String algorithm) {
        ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm");
        try {
            MessageDigest digest = SecurityUtils.getMessageDigest(algorithm);
            return digest != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <D extends Digest> D findDigestByAlgorithm(String algo, Comparator<? super String> comp, Collection<? extends D> digests) {
        if (GenericUtils.isEmpty(algo) || GenericUtils.isEmpty(digests)) {
            return null;
        }
        for (Digest d : digests) {
            if (comp.compare(algo, d.getAlgorithm()) != 0) continue;
            return (D)d;
        }
        return null;
    }

    public static <F extends DigestFactory> F findFactoryByAlgorithm(String algo, Comparator<? super String> comp, Collection<? extends F> factories) {
        if (GenericUtils.isEmpty(algo) || GenericUtils.isEmpty(factories)) {
            return null;
        }
        for (DigestFactory f : factories) {
            if (comp.compare(algo, f.getAlgorithm()) != 0) continue;
            return (F)f;
        }
        return null;
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s) throws Exception {
        return DigestUtils.getFingerPrint(f, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Factory<? extends Digest> f, String s, Charset charset) throws Exception {
        return DigestUtils.getFingerPrint(Objects.requireNonNull(f, "No factory").create(), s, charset);
    }

    public static String getFingerPrint(Digest d, String s) throws Exception {
        return DigestUtils.getFingerPrint(d, s, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Digest d, String s, Charset charset) throws Exception {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        return DigestUtils.getFingerPrint(d, s.getBytes(charset));
    }

    public static String getFingerPrint(Factory<? extends Digest> f, byte ... buf) throws Exception {
        return DigestUtils.getFingerPrint(f, buf, 0, NumberUtils.length(buf));
    }

    public static String getFingerPrint(Factory<? extends Digest> f, byte[] buf, int offset, int len) throws Exception {
        return DigestUtils.getFingerPrint(Objects.requireNonNull(f, "No factory").create(), buf, offset, len);
    }

    public static String getFingerPrint(Digest d, byte ... buf) throws Exception {
        return DigestUtils.getFingerPrint(d, buf, 0, NumberUtils.length(buf));
    }

    public static String getFingerPrint(Digest d, byte[] buf, int offset, int len) throws Exception {
        if (len <= 0) {
            return null;
        }
        byte[] data2 = DigestUtils.getRawFingerprint(d, buf, offset, len);
        String algo = d.getAlgorithm();
        if (BuiltinDigests.md5.getAlgorithm().equals(algo)) {
            return algo + ":" + BufferUtils.toHex(':', data2).toLowerCase();
        }
        Base64.Encoder encoder = Base64.getEncoder();
        return algo.replace("-", "").toUpperCase() + ":" + encoder.encodeToString(data2).replaceAll("=", "");
    }

    public static byte[] getRawFingerprint(Digest d, byte ... buf) throws Exception {
        return DigestUtils.getRawFingerprint(d, buf, 0, NumberUtils.length(buf));
    }

    public static byte[] getRawFingerprint(Digest d, byte[] buf, int offset, int len) throws Exception {
        if (len <= 0) {
            return null;
        }
        Objects.requireNonNull(d, "No digest").init();
        d.update(buf, offset, len);
        return d.digest();
    }
}

