/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultCancellableSshFuture;

public class DefaultAuthFuture
extends DefaultCancellableSshFuture<AuthFuture>
implements AuthFuture {
    private final CancelFuture cancellation;
    private AtomicBoolean cancellable = new AtomicBoolean(true);

    public DefaultAuthFuture(Object id, Object lock) {
        super(id, lock);
        this.cancellation = this.createCancellation();
        this.addListener(self -> {
            Object value;
            if (this.isDone() && !((value = this.getValue()) instanceof CancelFuture)) {
                this.cancellation.setNotCanceled();
            }
        });
    }

    @Override
    public AuthFuture verify(long timeoutMillis, CancelOption ... options2) throws IOException {
        Boolean result2 = this.verifyResult(Boolean.class, timeoutMillis, options2);
        if (!result2.booleanValue()) {
            throw this.formatExceptionMessage(SshException::new, "Authentication failed while waiting %d msec.", timeoutMillis);
        }
        return this;
    }

    @Override
    public boolean isSuccess() {
        Object v = this.getValue();
        return v instanceof Boolean && (Boolean)v != false;
    }

    @Override
    public boolean isFailure() {
        Object v = this.getValue();
        if (v instanceof Boolean) {
            return (Boolean)v == false;
        }
        return true;
    }

    @Override
    public void setAuthed(boolean authed) {
        this.setValue(authed);
    }

    @Override
    public CancelFuture cancel() {
        this.cancellation.setBackTrace(new CancellationException("Programmatically canceled"));
        if (this.cancellable.get()) {
            this.setValue(this.cancellation);
        }
        return this.cancellation;
    }

    @Override
    public CancelFuture getCancellation() {
        return this.wasCanceled() ? this.cancellation : null;
    }

    @Override
    public boolean wasCanceled() {
        return this.cancellation.getBackTrace() != null;
    }

    @Override
    public void setCancellable(boolean cancellable) {
        this.cancellable.set(cancellable);
        if (this.wasCanceled() && this.cancellable.get()) {
            this.setValue(this.cancellation);
        }
    }
}

