/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.PathMap;
import net.moonlightflower.wc3libs.misc.Raster;
import net.moonlightflower.wc3libs.misc.Size;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;

public class WPM
extends Raster<FlagsInt> {
    public static final File GAME_PATH = new File("war3map.wpm");
    public static final int CELL_SIZE = 32;
    private PathMap _pathMap = new PathMap(new Bounds(new Size(0, 0)));

    @Override
    public int getCellSize() {
        return 32;
    }

    @Override
    public void setSize(int cellsCount) {
        this._cells = new FlagsInt[cellsCount];
    }

    @Override
    public FlagsInt mergeCellVal(@Nonnull FlagsInt oldVal, @Nonnull FlagsInt other) {
        return Flags.valueOf(oldVal.toInt() | other.toInt());
    }

    public PathMap getPathMap() {
        return this._pathMap;
    }

    @Override
    public WPM clone() {
        PathMap pathMap = this._pathMap;
        WPM other = pathMap.getBounds() != null ? new WPM(pathMap.getBounds()) : new WPM();
        other.getPathMap().mergeCells(pathMap);
        return other;
    }

    public void write_0x0(@Nonnull Wc3BinOutputStream stream) {
        stream.writeId(Id.valueOf("MP3W"));
        stream.writeInt32(EncodingFormat.WPM_0x0.getVersion());
        PathMap pathMap = this.getPathMap();
        int width = pathMap.getWidth();
        int height = pathMap.getHeight();
        stream.writeInt32(width);
        stream.writeInt32(height);
        int cellsCount = width * height;
        for (int i = 0; i < cellsCount; ++i) {
            stream.writeUByte(pathMap.get(i));
        }
    }

    public void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.WPM_0x0.getVersion(), version);
        int width = stream.readInt32("width");
        int height = stream.readInt32("height");
        PathMap pathMap = this.getPathMap();
        pathMap.setBounds(new Bounds(new Size(width, height)), false, false);
        int cellsCount = width * height;
        for (int i = 0; i < cellsCount; ++i) {
            Coords2DI coords = pathMap.indexToCoords(i);
            pathMap.set(i, (int)stream.readUByte());
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case WPM_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: 
            case WPM_0x0: {
                this.write_0x0(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream inStream = new Wc3BinOutputStream(file);
        this.write(inStream);
        inStream.close();
    }

    public WPM(@Nonnull PathMap pathMap) {
        this();
        this._pathMap = pathMap.clone();
    }

    public WPM(@Nonnull Bounds bounds) {
        this(new PathMap(bounds));
    }

    public WPM(@Nonnull Wc3BinInputStream stream) throws IOException {
        this();
        this.read(stream);
    }

    public WPM() {
        super(new Bounds(0, 0, 0, 0));
    }

    @Nonnull
    public static WPM ofMap(@Nonnull File mapFile) throws IOException {
        MpqPort.Out.Result portResult;
        JMpqPort.Out portOut = new JMpqPort.Out();
        portOut.add(GAME_PATH);
        try {
            portResult = portOut.commit(mapFile);
        }
        catch (Exception e) {
            throw new IOException(String.format("could not extract %s", GAME_PATH.toString()));
        }
        return new WPM(new Wc3BinInputStream(portResult.getInputStream(GAME_PATH)));
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat WPM_0x0 = new EncodingFormat(Enum.WPM_0x0, 0);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            WPM_0x0;

        }
    }

    private static class Flags
    extends FlagsInt {
        private Flags(int val) {
            super(val);
        }

        public static Flags valueOf(int val) {
            return new Flags(val);
        }

        @Override
        public DataType decode(Object val) {
            return null;
        }

        @Override
        public Object toSLKVal() {
            return null;
        }

        @Override
        public Object toTXTVal() {
            return null;
        }
    }
}

