/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableArrayList;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.TexCoordSet;

public class TexCoordSetChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("UVAS");
    private final ArrayList<TexCoordSet> _texCoordSets = new ObservableArrayList<TexCoordSet>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public ArrayList<TexCoordSet> getTexCoordSets() {
        return this._texCoordSets;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        stream.writeUInt32(this._texCoordSets.size());
        for (TexCoordSet texCoordSet : this._texCoordSets) {
            texCoordSet.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public TexCoordSetChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        for (long matrixGroupsCount = stream.readUInt32("texCoordSetCount").longValue(); matrixGroupsCount > 0L; --matrixGroupsCount) {
            this._texCoordSets.add(new TexCoordSet(stream));
        }
    }

    public TexCoordSetChunk() {
    }
}

