/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio;

import de.peeeq.wurstscript.utils.Utils;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public interface TimeTaker {
    default public void measure(String name, Runnable f) {
        this.measure(name, () -> {
            f.run();
            return null;
        });
    }

    public <T> T measure(String var1, Supplier<T> var2);

    public void beginPhase(String var1);

    public void endPhase();

    public void printReport();

    public static class Recording
    implements TimeTaker {
        private int nesting = 0;
        private String currentPhaseDescription;
        private long currentPhaseStart;
        private final Map<String, Long> accumulatedTimes = new LinkedHashMap<String, Long>();
        private Long startTime = 0L;

        @Override
        public <T> T measure(String name, Supplier<T> f) {
            name = this.withNesting(name);
            ++this.nesting;
            this.accumulatedTimes.putIfAbsent(name, 0L);
            long time = System.currentTimeMillis();
            T result = f.get();
            long duration = System.currentTimeMillis() - time;
            this.reportDuration(name, duration);
            --this.nesting;
            return result;
        }

        private String withNesting(String name) {
            return Utils.repeat(' ', this.nesting) + name;
        }

        private void reportDuration(String name, long duration) {
            this.accumulatedTimes.put(name, this.accumulatedTimes.getOrDefault(name, 0L) + duration);
        }

        @Override
        public void beginPhase(String description) {
            if (this.accumulatedTimes.isEmpty()) {
                this.startTime = System.currentTimeMillis();
            }
            if (this.currentPhaseDescription != null) {
                this.endPhase();
            }
            description = this.withNesting(description);
            ++this.nesting;
            this.accumulatedTimes.putIfAbsent(description, 0L);
            this.currentPhaseDescription = description;
            this.currentPhaseStart = System.currentTimeMillis();
        }

        @Override
        public void endPhase() {
            if (this.currentPhaseDescription == null) {
                return;
            }
            long duration = System.currentTimeMillis() - this.currentPhaseStart;
            this.reportDuration(this.currentPhaseDescription, duration);
            --this.nesting;
            this.currentPhaseDescription = null;
        }

        @Override
        public void printReport() {
            System.out.println("#############################");
            System.out.println("Run times:");
            for (Map.Entry<String, Long> e : this.accumulatedTimes.entrySet()) {
                System.out.println(e.getKey() + ": " + e.getValue() + "ms");
            }
            System.out.println("Total runtime: " + (System.currentTimeMillis() - this.startTime) + "ms");
            System.out.println("GC time: " + Recording.getGarbageCollectionTime() + "ms");
        }

        private static long getGarbageCollectionTime() {
            long collectionTime = 0L;
            for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                collectionTime += garbageCollectorMXBean.getCollectionTime();
            }
            return collectionTime;
        }
    }

    public static class Default
    implements TimeTaker {
        @Override
        public <T> T measure(String name, Supplier<T> f) {
            return f.get();
        }

        @Override
        public void beginPhase(String description) {
        }

        @Override
        public void endPhase() {
        }

        @Override
        public void printReport() {
        }
    }
}

