/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.AlreadyTriedException;
import net.moonlightflower.wc3libs.port.NotFoundException;

public abstract class Finder<T> {
    static ThreadLocal<Set<Class<? extends Finder>>> _finders = new ThreadLocal();

    @Nonnull
    public abstract T find() throws NotFoundException;

    public T get() throws NotFoundException {
        if (_finders.get() == null) {
            _finders.set(new LinkedHashSet());
        }
        if (_finders.get().contains(this.getClass())) {
            throw new NotFoundException(new AlreadyTriedException());
        }
        _finders.get().add(this.getClass());
        try {
            T t = this.find();
            return t;
        }
        finally {
            _finders.get().remove(this.getClass());
        }
    }
}

