/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.Convert;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprVarArrayAccess;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class GetUsages
extends UserRequest<List<UsagesData>> {
    private final WFile wFile;
    private final String buffer;
    private final int line;
    private final int column;
    private final boolean global;

    public GetUsages(TextDocumentPositionParams position, BufferManager bufferManager, boolean global) {
        this.wFile = WFile.create(position.getTextDocument().getUri());
        this.buffer = bufferManager.getBuffer(position.getTextDocument());
        this.line = position.getPosition().getLine() + 1;
        this.column = position.getPosition().getCharacter() + 1;
        this.global = global;
    }

    @Override
    public List<UsagesData> execute(ModelManager modelManager) {
        CompilationUnit cu = modelManager.replaceCompilationUnitContent(this.wFile, this.buffer, false);
        if (cu == null) {
            return Collections.emptyList();
        }
        Optional<Element> astElem = Utils.getAstElementAtPos(cu, this.line, this.column, false);
        Optional nameDef = astElem.flatMap(elem -> Optional.ofNullable(elem.tryGetNameDef()));
        ArrayList<UsagesData> usages = new ArrayList<UsagesData>();
        if (nameDef.isPresent()) {
            if (this.global || ((NameDef)nameDef.get()).getSource().getFile().equals(this.wFile.toString())) {
                usages.add(new UsagesData(Convert.posToLocation(((NameDef)nameDef.get()).attrErrorPos()), DocumentHighlightKind.Write));
            }
            ArrayDeque<Element> todo = new ArrayDeque<Element>();
            if (this.global) {
                todo.push(modelManager.getModel());
            } else {
                todo.push(cu);
            }
            while (!todo.isEmpty()) {
                Element e = (Element)todo.pop();
                for (int i = 0; i < e.size(); ++i) {
                    todo.push(e.get(i));
                }
                NameDef e_def = e.tryGetNameDef();
                if (e_def != nameDef.get()) continue;
                if (e instanceof ExprVarArrayAccess) {
                    e = ((ExprVarArrayAccess)e).getVarNameId();
                }
                Location location = Convert.posToLocation(e.attrErrorPos());
                UsagesData usagesData = new UsagesData(location, DocumentHighlightKind.Read);
                usages.add(usagesData);
            }
        }
        return usages;
    }

    public static class UsagesData {
        private final Location location;
        private DocumentHighlightKind kind;

        public UsagesData(Location location, DocumentHighlightKind kind) {
            this.location = location;
            this.kind = kind;
        }

        public String getFilename() {
            return this.location.getUri();
        }

        public void setFilename(String filename) {
            this.location.setUri(filename);
        }

        public Range getRange() {
            return this.location.getRange();
        }

        public void setRange(Range range) {
            this.location.setRange(range);
        }

        public DocumentHighlightKind getKind() {
            return this.kind;
        }

        public void setKind(DocumentHighlightKind kind) {
            this.kind = kind;
        }

        public Location getLocation() {
            return this.location;
        }

        public DocumentHighlight toDocumentHighlight() {
            return new DocumentHighlight(this.location.getRange(), this.kind);
        }
    }
}

