/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript;

import com.google.common.collect.Maps;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.AstElementWithBody;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprIntVal;
import de.peeeq.wurstscript.ast.ExprMemberVarDot;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.ExprUnary;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.parser.WPos;
import java.util.LinkedHashMap;
import java.util.Map;

public class SyntacticSugar {
    public void removeSyntacticSugar(CompilationUnit root, boolean hasCommonJ) {
        if (hasCommonJ) {
            this.addDefaultImports(root);
        }
        this.rewriteNegatedInts(root);
        this.addDefaultConstructors(root);
        this.addEndFunctionStatements(root);
        this.replaceTypeIdUse(root);
    }

    private void replaceTypeIdUse(CompilationUnit root) {
        final LinkedHashMap replacements = Maps.newLinkedHashMap();
        root.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ExprMemberVarDot e) {
                super.visit(e);
                if (e.getVarName().equals("typeId")) {
                    replacements.put(e, Ast.ExprTypeId(e.getSource(), e.getLeft().copy()));
                }
            }
        });
        this.doReplacements(replacements, "Cannot use typeId here");
    }

    private void rewriteNegatedInts(CompilationUnit root) {
        final LinkedHashMap replacements = Maps.newLinkedHashMap();
        root.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ExprUnary e) {
                super.visit(e);
                if (e.getOpU() == WurstOperator.UNARY_MINUS && e.getRight() instanceof ExprIntVal) {
                    ExprIntVal iv = (ExprIntVal)e.getRight();
                    ExprIntVal newExpr = Ast.ExprIntVal(e.getSource(), "-" + iv.getValIraw());
                    replacements.put(e, newExpr);
                }
            }
        });
        this.doReplacements(replacements, "Cannot use typeId here");
    }

    private void doReplacements(Map<Expr, Expr> replacements, String msg) {
        for (Map.Entry<Expr, Expr> e : replacements.entrySet()) {
            Expr oldE = e.getKey();
            Expr newE = e.getValue();
            try {
                this.doSingleReplacement(oldE, newE);
            }
            catch (ClassCastException ex) {
                oldE.addError(msg);
            }
        }
    }

    public void doSingleReplacement(Expr oldE, Expr newE) throws Error {
        Element parent = oldE.getParent();
        for (int i = 0; i < parent.size(); ++i) {
            if (parent.get(i) != oldE) continue;
            parent.set(i, newE);
            return;
        }
        throw new Error("could not replace " + oldE + " with " + newE);
    }

    private void addEndFunctionStatements(CompilationUnit root) {
        root.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ExtensionFuncDef f) {
                super.visit(f);
                this.addEnd(f);
            }

            @Override
            public void visit(FuncDef f) {
                super.visit(f);
                this.addEnd(f);
            }

            @Override
            public void visit(ConstructorDef f) {
                super.visit(f);
                this.addEnd(f);
            }

            @Override
            public void visit(InitBlock f) {
                super.visit(f);
                this.addEnd(f);
            }

            @Override
            public void visit(OnDestroyDef f) {
                super.visit(f);
                this.addEnd(f);
            }

            @Override
            public void visit(ExprStatementsBlock f) {
                super.visit(f);
                this.addEnd(f);
            }

            private void addEnd(AstElementWithBody f) {
                WPos pos = f.attrSource();
                pos = pos.withRightPos(pos.getLeftPos() - 1);
                f.getBody().add(Ast.EndFunctionStatement(pos));
                f.getBody().add(0, Ast.StartFunctionStatement(pos));
            }
        });
    }

    private void addDefaultImports(CompilationUnit root) {
        block0: for (WPackage p : root.attrGetByType().packageDefs) {
            for (WImport imp : p.getImports()) {
                if (!imp.getPackagename().equals("Wurst") && !imp.getPackagename().equals("NoWurst")) continue;
                continue block0;
            }
            WPos source = p.getSource().artificial();
            p.getImports().add(Ast.WImport(source, false, false, Ast.Identifier(source, "Wurst")));
        }
    }

    private void addDefaultConstructors(CompilationUnit root) {
        for (ClassDef c : root.attrGetByType().classes) {
            if (c.getConstructors().size() != 0) continue;
            WPos source = c.getSource().withRightPos(c.getSource().getLeftPos() - 1);
            c.getConstructors().add(Ast.ConstructorDef(source, Ast.Modifiers(new Modifier[0]), Ast.WParameters(new WParameter[0]), Ast.NoSuperConstructorCall(), Ast.WStatements(new WStatement[0])));
        }
    }
}

