/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import config.WurstProjectConfigData;
import de.peeeq.wurstio.CompiletimeFunctionRunner;
import de.peeeq.wurstio.jassinterpreter.InterpreterException;
import de.peeeq.wurstio.jassinterpreter.ReflectionNativeProvider;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.RequestFailedException;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.intermediatelang.interpreter.ILInterpreter;
import de.peeeq.wurstscript.intermediatelang.interpreter.ProgramState;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassinterpreter.TestFailException;
import de.peeeq.wurstscript.jassinterpreter.TestSuccessException;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.utils.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.MessageType;

public class RunTests
extends UserRequest<Object> {
    private final Optional<WFile> filename;
    private final int line;
    private final int column;
    private final Optional<String> testName;
    private final int timeoutSeconds;
    private final List<ImFunction> successTests = Lists.newArrayList();
    private final List<TestFailure> failTests = Lists.newArrayList();
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    public RunTests(Optional<String> filename, int line, int column, Optional<String> testName) {
        this(filename, line, column, testName, 20);
    }

    public RunTests(Optional<String> filename, int line, int column, Optional<String> testName, int timeoutSeconds) {
        this.filename = filename.map(WFile::create);
        this.line = line;
        this.column = column;
        this.testName = testName;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public Object execute(ModelManager modelManager) {
        if (modelManager.hasErrors()) {
            throw new RequestFailedException(MessageType.Error, "Fix errors in your code before running tests.\n" + modelManager.getFirstErrorDescription());
        }
        WLogger.info("Starting tests " + this.filename + ", " + this.line + ", " + this.column);
        this.println("Running unit tests..\n");
        Optional<CompilationUnit> cu = this.filename.map(modelManager::getCompilationUnit);
        WLogger.info("test.cu = " + Utils.printElement(cu));
        Optional<FuncDef> funcToTest = this.getFunctionToTest(cu);
        WLogger.info("test.funcToTest = " + Utils.printElement(funcToTest));
        ImTranslator translator = this.translateProg(modelManager);
        ImProg imProg = translator.getImProg();
        if (imProg == null) {
            this.println("Could not run tests, because program did not compile.\n");
            return "Could not translate program";
        }
        this.runTests(translator, imProg, funcToTest, cu);
        return "ok";
    }

    public TestResult runTests(ImTranslator translator, ImProg imProg, Optional<FuncDef> funcToTest, Optional<CompilationUnit> cu) {
        TestGui gui = new TestGui();
        CompiletimeFunctionRunner cfr = new CompiletimeFunctionRunner(translator, imProg, Optional.empty(), null, gui, CompiletimeFunctionRunner.FunctionFlagToRun.CompiletimeFunctions, new WurstProjectConfigData(), false, false);
        ILInterpreter interpreter = cfr.getInterpreter();
        ProgramState globalState = cfr.getGlobalState();
        if (globalState == null) {
            globalState = new ProgramState(gui, imProg, true);
        }
        if (interpreter == null) {
            interpreter = new ILInterpreter(imProg, (WurstGui)gui, Optional.empty(), globalState, false);
            interpreter.addNativeProvider(new ReflectionNativeProvider(interpreter));
        }
        this.redirectInterpreterOutput(globalState);
        cfr.run();
        if (gui.getErrorCount() > 0) {
            for (CompileError compileError : gui.getErrorList()) {
                this.println(compileError.toString());
            }
            this.println("There were some problem while running compiletime expressions and functions.");
            return new TestResult(0, 1);
        }
        WLogger.info("Ran compiletime functions");
        for (ImFunction f : imProg.getFunctions()) {
            TestFailure failure;
            if (!f.hasFlag(FunctionFlagEnum.IS_TEST)) continue;
            Element trace = f.attrTrace();
            if (cu.isPresent() && !Utils.elementContained(Optional.of(trace), cu.get()) || funcToTest.isPresent() && trace != funcToTest.get()) continue;
            String message = "Running <" + f.attrTrace().attrNearestPackage().tryGetNameDef().getName() + ":" + f.attrTrace().attrErrorPos().getLine() + " - " + f.getName() + ">..";
            this.println(message);
            WLogger.info(message);
            try {
                @Nullable ILInterpreter finalInterpreter = interpreter;
                Callable<Void> run = () -> {
                    finalInterpreter.runVoidFunc(f, null);
                    finalInterpreter.completeTimers();
                    return null;
                };
                FutureTask<Void> future = new FutureTask<Void>(run);
                if (service != null && !service.isShutdown()) {
                    service.shutdownNow();
                }
                service = Executors.newSingleThreadScheduledExecutor();
                service.execute(future);
                try {
                    future.get(this.timeoutSeconds, TimeUnit.SECONDS);
                }
                catch (TimeoutException ex) {
                    future.cancel(true);
                    throw new TestTimeOutException();
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
                service.shutdown();
                service.awaitTermination(10L, TimeUnit.SECONDS);
                service = Executors.newSingleThreadScheduledExecutor();
                if (gui.getErrorCount() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (CompileError error : gui.getErrorList()) {
                        sb.append(error).append("\n");
                        this.println(error.getMessage());
                    }
                    gui.clearErrors();
                    TestFailure failure2 = new TestFailure(f, interpreter.getStackFrames(), sb.toString());
                    this.failTests.add(failure2);
                    continue;
                }
                this.successTests.add(f);
                this.println("\tOK!");
            }
            catch (TestSuccessException e) {
                this.successTests.add(f);
                this.println("\tOK!");
            }
            catch (TestFailException e) {
                failure = new TestFailure(f, interpreter.getStackFrames(), e.getMessage());
                this.failTests.add(failure);
                this.println("\tFAILED assertion:");
                this.println("\t" + failure.getMessageWithStackFrame());
            }
            catch (TestTimeOutException e) {
                this.failTests.add(new TestFailure(f, interpreter.getStackFrames(), e.getMessage()));
                this.println("\tFAILED - TIMEOUT (This test did not complete in " + this.timeoutSeconds + " seconds, it might contain an endless loop)");
                this.println(interpreter.getStackFrames().toString());
            }
            catch (InterpreterException e) {
                failure = new TestFailure(f, interpreter.getStackFrames(), e.getMessage());
                this.failTests.add(failure);
                this.println("\t" + failure.getMessageWithStackFrame());
            }
            catch (Throwable e) {
                this.failTests.add(new TestFailure(f, interpreter.getStackFrames(), e.toString()));
                this.println("\tFAILED with exception: " + e.getClass() + " " + e.getLocalizedMessage());
                this.println(interpreter.getStackFrames().toString());
                this.println("Here are some compiler internals, that might help Wurst developers to debug this issue:");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String sStackTrace = sw.toString();
                this.println("\t" + e.getLocalizedMessage());
                this.println("\t" + sStackTrace);
            }
        }
        this.println("Tests succeeded: " + this.successTests.size() + "/" + (this.successTests.size() + this.failTests.size()));
        if (this.failTests.size() == 0) {
            this.println(">> All tests have passed successfully!");
        } else {
            this.println(">> " + this.failTests.size() + " Tests have failed!");
        }
        if (gui.getErrorCount() > 0) {
            this.println("There were some errors reported while running the tests.");
            for (CompileError error : gui.getErrorList()) {
                this.println(error.toString());
            }
        }
        WLogger.info("finished tests");
        return new TestResult(this.successTests.size(), this.successTests.size() + this.failTests.size());
    }

    private void redirectInterpreterOutput(ProgramState globalState) {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                if (b > 0) {
                    RunTests.this.println("" + (char)b);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                RunTests.this.println(new String(b, off, len));
            }
        };
        globalState.setOutStream(new PrintStream(os));
    }

    protected void println(String message) {
        this.print(message);
        this.print(System.lineSeparator());
    }

    protected void print(String message) {
        System.err.print(message);
    }

    private ImTranslator translateProg(ModelManager modelManager) {
        RunArgs runArgs = new RunArgs("-runcompiletimefunctions");
        ImTranslator imTranslator = new ImTranslator(modelManager.getModel(), false, runArgs);
        imTranslator.setEclipseMode(true);
        imTranslator.translateProg();
        return imTranslator;
    }

    private Optional<FuncDef> getFunctionToTest(Optional<CompilationUnit> maybeCu) {
        if (this.testName.isPresent()) {
            String funcName;
            int dotPos = this.testName.get().indexOf(".");
            String packageName = this.testName.get().substring(0, dotPos);
            Optional<FuncDef> testFunc = maybeCu.flatMap(arg_0 -> RunTests.lambda$getFunctionToTest$7(packageName, funcName = this.testName.get().substring(dotPos + 1), arg_0));
            if (testFunc.isPresent()) {
                return testFunc;
            }
        }
        if (!this.filename.isPresent() || !maybeCu.isPresent() || this.line < 0) {
            return Optional.empty();
        }
        Optional<Element> e = Utils.getAstElementAtPos(maybeCu.get(), this.line, this.column, false);
        while (e.isPresent()) {
            if (e.get() instanceof FuncDef) {
                return e.map(el -> (FuncDef)el);
            }
            e = e.flatMap(el -> Optional.ofNullable(el.getParent()));
        }
        return null;
    }

    public List<TestFailure> getFailTests() {
        return this.failTests;
    }

    public static ScheduledExecutorService getService() {
        return service;
    }

    private static /* synthetic */ Optional lambda$getFunctionToTest$7(String packageName, String funcName, CompilationUnit cu) {
        return cu.getPackages().stream().filter(p -> p.getName().equals(packageName)).flatMap(p -> p.getElements().stream()).filter(e -> e instanceof FuncDef).map(e -> (FuncDef)e).filter(f -> f.hasAnnotation("@test")).filter(f -> f.getName().equals(funcName)).findFirst();
    }

    private static class TestTimeOutException
    extends Throwable {
        private TestTimeOutException() {
        }

        @Override
        public String getMessage() {
            return "test failed with timeout (This test did not complete in 20 seconds, it might contain an endless loop)";
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public class TestGui
    extends WurstGui {
        @Override
        public void sendProgress(String whatsRunningNow) {
        }

        @Override
        public void sendFinished() {
        }

        @Override
        public void showInfoMessage(String message) {
            RunTests.this.println(message + "\n");
        }
    }

    public static class TestResult {
        private final int passedTests;
        private final int totalTests;

        public TestResult(int passedTests, int totalTests) {
            this.passedTests = passedTests;
            this.totalTests = totalTests;
        }

        public int getPassedTests() {
            return this.passedTests;
        }

        public int getTotalTests() {
            return this.totalTests;
        }
    }

    public static class TestFailure {
        private final ImFunction function;
        private final ProgramState.StackTrace stackTrace;
        private final String message;

        public TestFailure(ImFunction function, ProgramState.StackTrace stackTrace, String message) {
            Preconditions.checkNotNull((Object)function);
            Preconditions.checkNotNull((Object)stackTrace);
            Preconditions.checkNotNull((Object)message);
            this.function = function;
            this.stackTrace = stackTrace;
            this.message = message;
        }

        public ProgramState.StackTrace getStackTrace() {
            return this.stackTrace;
        }

        public String getMessage() {
            return this.message;
        }

        public ImFunction getFunction() {
            return this.function;
        }

        public String getMessageWithStackFrame() {
            StringBuilder s = new StringBuilder(this.message);
            s.append("\n");
            this.stackTrace.appendTo(s);
            return s.toString();
        }
    }
}

