/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class MapWithIndexes<K, V> {
    private final Map<K, V> base = new LinkedHashMap();
    private final List<BiConsumer<K, V>> onInserts = new ArrayList<BiConsumer<K, V>>();
    private final List<BiConsumer<K, V>> onDelete = new ArrayList<BiConsumer<K, V>>();

    public <I> Index<I, K> createIndex(Function<V, I> indexedValue) {
        LinkedHashMultimap index = LinkedHashMultimap.create();
        this.onInserts.add((arg_0, arg_1) -> MapWithIndexes.lambda$createIndex$0((Multimap)index, indexedValue, arg_0, arg_1));
        this.onDelete.add((arg_0, arg_1) -> MapWithIndexes.lambda$createIndex$1((Multimap)index, indexedValue, arg_0, arg_1));
        return arg_0 -> MapWithIndexes.lambda$createIndex$2((Multimap)index, arg_0);
    }

    public PredIndex<K> createPredicateIndex(Predicate<V> indexedValue) {
        LinkedHashSet index = new LinkedHashSet();
        this.onInserts.add((k, v) -> {
            if (indexedValue.test(v)) {
                index.add(k);
            }
        });
        this.onDelete.add((k, v) -> index.remove(k));
        return () -> ImmutableList.copyOf((Collection)index);
    }

    public <I> Index<I, K> createMultiIndex(Function<V, ? extends Collection<I>> indexedValue) {
        LinkedHashMultimap index = LinkedHashMultimap.create();
        this.onInserts.add((arg_0, arg_1) -> MapWithIndexes.lambda$createMultiIndex$6(indexedValue, (Multimap)index, arg_0, arg_1));
        this.onDelete.add((arg_0, arg_1) -> MapWithIndexes.lambda$createMultiIndex$7(indexedValue, (Multimap)index, arg_0, arg_1));
        return arg_0 -> MapWithIndexes.lambda$createMultiIndex$8((Multimap)index, arg_0);
    }

    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.base.containsKey(key);
    }

    public V get(K key) {
        return this.base.get(key);
    }

    public V put(K key, V value) {
        Preconditions.checkNotNull(key, (Object)"key must not be null");
        Preconditions.checkNotNull(value, (Object)"value must not be null");
        V oldV = this.base.put(key, value);
        if (oldV != null) {
            for (BiConsumer<K, V> f : this.onDelete) {
                f.accept(key, value);
            }
        }
        for (BiConsumer<K, V> f : this.onInserts) {
            f.accept(key, value);
        }
        return oldV;
    }

    public V remove(K key) {
        V value = this.base.remove(key);
        if (value != null) {
            for (BiConsumer<K, V> f : this.onDelete) {
                f.accept(key, value);
            }
        }
        return value;
    }

    public void clear() {
        for (Map.Entry<K, V> e : this.base.entrySet()) {
            for (BiConsumer<K, V> f : this.onDelete) {
                f.accept(e.getKey(), e.getValue());
            }
        }
        this.base.clear();
    }

    public Set<K> keySet() {
        return this.base.keySet();
    }

    public Collection<V> values() {
        return this.base.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.base.entrySet();
    }

    public void removeAll(Collection<K> ks) {
        for (K k : ks) {
            this.remove(k);
        }
    }

    private static /* synthetic */ Collection lambda$createMultiIndex$8(Multimap index, Object key) {
        return ImmutableList.copyOf((Collection)index.get(key));
    }

    private static /* synthetic */ void lambda$createMultiIndex$7(Function indexedValue, Multimap index, Object k, Object v) {
        Collection is = (Collection)indexedValue.apply(v);
        for (Object i : is) {
            index.remove(i, k);
        }
    }

    private static /* synthetic */ void lambda$createMultiIndex$6(Function indexedValue, Multimap index, Object k, Object v) {
        Collection is = (Collection)indexedValue.apply(v);
        for (Object i : is) {
            index.put(i, k);
        }
    }

    private static /* synthetic */ Collection lambda$createIndex$2(Multimap index, Object key) {
        return ImmutableList.copyOf((Collection)index.get(key));
    }

    private static /* synthetic */ void lambda$createIndex$1(Multimap index, Function indexedValue, Object k, Object v) {
        index.remove(indexedValue.apply(v), k);
    }

    private static /* synthetic */ void lambda$createIndex$0(Multimap index, Function indexedValue, Object k, Object v) {
        index.put(indexedValue.apply(v), k);
    }

    public static interface PredIndex<K> {
        public Collection<K> lookup();
    }

    public static interface Index<I, K> {
        public Collection<K> lookup(I var1);
    }
}

