/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import java.io.File;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.GameExeFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.port.UnsupportedPlatformException;
import net.moonlightflower.wc3libs.port.mac.MacGameExeFinder;
import net.moonlightflower.wc3libs.port.win.WinGameExeFinder;

public class StdGameExeFinder
extends GameExeFinder {
    protected GameExeFinder getMacGameExeFinder() {
        return Context.getService(MacGameExeFinder.class);
    }

    protected GameExeFinder getWinGameExeFinder() {
        return Context.getService(WinGameExeFinder.class);
    }

    @Override
    @Nonnull
    public File find() throws NotFoundException {
        if (Orient.isMacSystem()) {
            GameExeFinder macGameExeFinder = this.getMacGameExeFinder();
            return (File)macGameExeFinder.get();
        }
        if (Orient.isWindowsSystem()) {
            GameExeFinder winGameExeFinder = this.getWinGameExeFinder();
            return (File)winGameExeFinder.get();
        }
        throw new UnsupportedPlatformException("system not supported: " + Orient.getSystem());
    }
}

