/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imoptimizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class NullSetter {
    private final ImProg prog;
    private final ImTranslator translator;
    private final Set<String> primitiveTypes = Sets.newHashSet((Object[])new String[]{"boolean", "integer", "string", "code", "real"});

    public NullSetter(ImTranslator translator) {
        this.translator = translator;
        this.prog = translator.getImProg();
    }

    public void optimize() {
        this.prog.flatten(this.translator);
        for (ImFunction f : ImHelper.calculateFunctionsOfProg(this.prog)) {
            this.optimizeFunc(f);
        }
    }

    private void optimizeFunc(ImFunction f) {
        if (f.isBj() || f.isNative() || f.isCompiletime() || f.isExtern()) {
            return;
        }
        ArrayList handleVars = Lists.newArrayList();
        for (ImVar local : f.getLocals()) {
            if (!this.isHandleType(local.getType())) continue;
            handleVars.add(local);
        }
        if (handleVars.isEmpty()) {
            return;
        }
        ArrayList nullSetStmts = Lists.newArrayList();
        de.peeeq.wurstscript.ast.Element trace = f.getTrace();
        for (ImVar local : handleVars) {
            nullSetStmts.add(JassIm.ImSet(trace, JassIm.ImVarAccess(local), JassIm.ImNull(local.getType())));
        }
        boolean returns = this.optimizeChildren(f, handleVars, nullSetStmts, trace, f.getBody());
        if (!returns) {
            this.addNullSetStmts(f.getBody(), f.getBody().size(), nullSetStmts);
        }
    }

    private boolean optimizeChildren(ImFunction f, List<ImVar> handleVars, List<ImStmt> nullSetStmts, de.peeeq.wurstscript.ast.Element trace, Element parent) {
        for (int i = 0; i < parent.size(); ++i) {
            Element elem = parent.get(i);
            if (elem instanceof ImReturn) {
                this.handleReturnStmt(f, handleVars, nullSetStmts, trace, (ImReturn)elem);
                return true;
            }
            if (elem instanceof ImIf) {
                ImIf imIf = (ImIf)elem;
                boolean returnsThen = this.optimizeChildren(f, handleVars, nullSetStmts, trace, imIf.getThenBlock());
                boolean returnsElse = this.optimizeChildren(f, handleVars, nullSetStmts, trace, imIf.getElseBlock());
                if (!returnsThen || !returnsElse) continue;
                return true;
            }
            if (elem instanceof ImLoop) {
                this.optimizeChildren(f, handleVars, nullSetStmts, trace, elem);
                continue;
            }
            boolean returns = this.optimizeChildren(f, handleVars, nullSetStmts, trace, elem);
            if (!returns) continue;
            return true;
        }
        return false;
    }

    private void handleReturnStmt(ImFunction f, List<ImVar> handleVars, List<ImStmt> nullSetStmts, de.peeeq.wurstscript.ast.Element trace, ImReturn imReturn) {
        ImStmts parent2 = (ImStmts)imReturn.getParent();
        int parentIndex = parent2.indexOf(imReturn);
        if (imReturn.getReturnValue() instanceof ImExpr) {
            ImExpr returnExpr = (ImExpr)imReturn.getReturnValue();
            this.addNullSetStmts(parent2, parentIndex, nullSetStmts);
            if (this.exprContainsVar(returnExpr, handleVars)) {
                ImVar tempReturn = JassIm.ImVar(imReturn.attrTrace(), returnExpr.attrTyp(), f.getName() + "tempReturn", false);
                if (this.isHandleType(returnExpr.attrTyp())) {
                    this.prog.getGlobals().add(tempReturn);
                } else {
                    f.getLocals().add(tempReturn);
                }
                imReturn.setReturnValue(JassIm.ImVarAccess(tempReturn));
                parent2.add(parentIndex, JassIm.ImSet(trace, JassIm.ImVarAccess(tempReturn), returnExpr));
            }
        } else {
            this.addNullSetStmts(parent2, parentIndex, nullSetStmts);
        }
    }

    private boolean exprContainsVar(ImExpr returnExpr, final List<ImVar> handleVars) {
        final boolean[] result = new boolean[]{false};
        returnExpr.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess e) {
                super.visit(e);
                if (handleVars.contains(e.getVar())) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    private void addNullSetStmts(ImStmts parent, int parentIndex, List<ImStmt> nullSetStmts) {
        ArrayList nullSetStmtsCopy = Lists.newArrayListWithCapacity((int)nullSetStmts.size());
        for (ImStmt s : nullSetStmts) {
            nullSetStmtsCopy.add(s.copy());
        }
        parent.addAll(parentIndex, (Collection)nullSetStmtsCopy);
    }

    private boolean isHandleType(ImType type) {
        if (type instanceof ImSimpleType) {
            ImSimpleType imSimpleType = (ImSimpleType)type;
            return !this.primitiveTypes.contains(imSimpleType.getTypename());
        }
        return false;
    }
}

