/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import com.google.gson.JsonObject;
import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.PerformCodeActionRequest;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMember;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprMemberMethodDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDotDot;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.FuncDefs;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.FunctionLike;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeExprSimple;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.TypeLink;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeClassOrInterface;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionRequest
extends UserRequest<List<Either<Command, CodeAction>>> {
    private final CodeActionParams params;
    private final WFile filename;
    private final String buffer;
    private final int line;
    private final int column;

    public CodeActionRequest(CodeActionParams params, BufferManager bufferManager) {
        this.params = params;
        TextDocumentIdentifier textDocument = params.getTextDocument();
        this.filename = WFile.create(textDocument.getUri());
        this.buffer = bufferManager.getBuffer(textDocument);
        this.line = params.getRange().getStart().getLine() + 1;
        this.column = params.getRange().getStart().getCharacter() + 1;
    }

    @Override
    public List<Either<Command, CodeAction>> execute(ModelManager modelManager) {
        ModuleUse mu;
        ModuleDef def;
        if (this.params.getContext().getDiagnostics().isEmpty()) {
            return Collections.emptyList();
        }
        CompilationUnit cu = modelManager.replaceCompilationUnitContent(this.filename, this.buffer, false);
        if (cu == null) {
            return Collections.emptyList();
        }
        Optional<Element> e = Utils.getAstElementAtPos(cu, this.line, this.column, false);
        WLogger.info("Code action on element " + Utils.printElementWithSource(e));
        if (!e.isPresent()) {
            return Collections.emptyList();
        }
        if (e.get() instanceof ExprNewObject) {
            ExprNewObject enew = (ExprNewObject)e.get();
            ConstructorDef constructorDef = enew.attrConstructorDef();
            if (constructorDef == null) {
                return this.handleMissingClass(modelManager, enew.getTypeName());
            }
        } else if (e.get() instanceof FuncRef) {
            FuncRef fr = (FuncRef)e.get();
            FuncLink fd = fr.attrFuncLink();
            if (fd == null) {
                return this.handleMissingFunction(modelManager, fr);
            }
        } else if (e.get() instanceof NameRef) {
            NameRef nr = (NameRef)e.get();
            NameLink nd = nr.attrNameLink();
            if (nd == null) {
                return this.handleMissingName(modelManager, nr);
            }
        } else if (e.get() instanceof TypeExprSimple) {
            TypeExprSimple nr = (TypeExprSimple)e.get();
            TypeDef nd = nr.attrTypeDef();
            if (nd == null) {
                return this.handleMissingType(modelManager, nr.getTypeName());
            }
        } else if (e.get() instanceof ModuleUse && (def = (mu = (ModuleUse)e.get()).attrModuleDef()) == null) {
            return this.handleMissingModule(modelManager, mu.getModuleNameId().getName());
        }
        return Collections.emptyList();
    }

    private List<Either<Command, CodeAction>> handleMissingName(ModelManager modelManager, NameRef nr) {
        String funcName = nr.getVarName();
        WurstModel model = modelManager.getModel();
        ArrayList<String> possibleImports = new ArrayList<String>();
        WurstType receiverType = null;
        if (nr instanceof ExprMember) {
            ExprMember m = (ExprMember)((Object)nr);
            receiverType = m.getLeft().attrTyp();
        }
        for (CompilationUnit cu : model) {
            block1: for (WPackage wPackage : cu.getPackages()) {
                for (NameLink nameLink : wPackage.attrExportedNameLinks().get((Object)funcName)) {
                    if (!this.definedInPackage(wPackage, nameLink) || !((DefLink)nameLink).receiverCompatibleWith(receiverType, nr)) continue;
                    possibleImports.add(wPackage.getName());
                    continue block1;
                }
                for (NameLink nameLink : wPackage.attrExportedTypeNameLinks().get((Object)funcName)) {
                    if (!this.definedInPackage(wPackage, nameLink) || !((TypeLink)nameLink).receiverCompatibleWith(receiverType, nr)) continue;
                    possibleImports.add(wPackage.getName());
                    continue block1;
                }
            }
        }
        return this.makeImportCommands(possibleImports);
    }

    private boolean definedInPackage(WPackage wPackage, NameLink nameLink) {
        NameDef def = nameLink.getDef();
        if (def != null) {
            return def.attrNearestPackage() == wPackage;
        }
        return false;
    }

    private List<Either<Command, CodeAction>> handleMissingFunction(ModelManager modelManager, FuncRef fr) {
        String funcName = fr.getFuncName();
        WurstType receiverType = null;
        if (fr instanceof ExprMember) {
            ExprMember m = (ExprMember)((Object)fr);
            receiverType = m.getLeft().attrTyp();
        }
        WurstModel model = modelManager.getModel();
        ArrayList<String> possibleImports = new ArrayList<String>();
        for (CompilationUnit cu : model) {
            block1: for (WPackage wPackage : cu.getPackages()) {
                for (NameLink nameLink : wPackage.attrExportedNameLinks().get((Object)funcName)) {
                    if (!(nameLink.getDef() instanceof FunctionDefinition) || !this.definedInPackage(wPackage, nameLink) || !nameLink.receiverCompatibleWith(receiverType, fr)) continue;
                    possibleImports.add(wPackage.getName());
                    continue block1;
                }
            }
        }
        return Utils.concatLists(this.makeImportCommands(possibleImports), this.makeCreateFunctionQuickfix(fr));
    }

    private List<Either<Command, CodeAction>> makeCreateFunctionQuickfix(final FuncRef fr) {
        class M
        implements FuncRef.MatcherVoid {
            private List<String> parameterTypes = Collections.emptyList();
            private List<String> parameterNames = Collections.emptyList();
            private int line;
            private int indent;
            private final WFile targetFile;
            private String receiverType;
            private WurstType returnType;
            private boolean isAnnotation;

            M() {
                this.targetFile = CodeActionRequest.this.filename;
                this.receiverType = "";
                this.returnType = WurstTypeVoid.instance();
                this.isAnnotation = false;
            }

            @Override
            public void case_ExprFuncRef(ExprFuncRef e) {
                this.getInsertPos(fr);
            }

            @Override
            public void case_Annotation(Annotation annotation) {
                this.isAnnotation = true;
                this.getInsertPos(fr);
            }

            private void getInsertPos(Element fr2) {
                for (Element elem = fr2; elem != null; elem = elem.getParent()) {
                    WPos source;
                    if (elem instanceof FunctionLike) {
                        source = elem.attrSource();
                        this.line = source.getEndLine();
                        this.indent = source.getStartColumn() - 1;
                        break;
                    }
                    if (elem instanceof WPackage) {
                        source = elem.attrSource();
                        this.line = source.getEndLine();
                        this.indent = 0;
                        break;
                    }
                    if (elem instanceof FuncDefs) {
                        FuncDefs funcDefs = (FuncDefs)elem;
                        if (funcDefs.isEmpty()) continue;
                        WPos source2 = Utils.getLast(funcDefs).attrSource();
                        this.line = source2.getEndLine();
                        this.indent = source2.getStartColumn() - 1;
                        break;
                    }
                    if (!(elem instanceof NamedScope)) continue;
                    source = elem.attrSource();
                    this.line = source.getEndLine();
                    this.indent = source.getStartColumn() - 1 + 4;
                    break;
                }
            }

            @Override
            public void case_ExprMemberMethodDotDot(ExprMemberMethodDotDot e) {
                this.case_Member(e);
                this.returnType = e.attrExpectedTyp();
            }

            @Override
            public void case_ExprMemberMethodDot(ExprMemberMethodDot e) {
                this.case_Member(e);
            }

            private void case_Member(ExprMemberMethod e) {
                WurstType leftType = e.getLeft().attrTyp();
                if (leftType instanceof WurstTypeClassOrInterface) {
                    this.getInsertPos(((WurstTypeClassOrInterface)leftType).getDef().getMethods());
                } else {
                    this.getInsertPos(e);
                    this.receiverType = leftType + ".";
                }
                this.addParametertypes(e.getArgs());
                this.returnType = e.attrExpectedTyp();
            }

            private void addParametertypes(Arguments args) {
                this.parameterTypes = args.stream().map(Expr::attrTyp).map(WurstType::toPrettyString).collect(Collectors.toList());
                this.parameterNames = args.stream().map(this::deriveParameterName).collect(Collectors.toCollection(ArrayList::new));
                this.makeUnique(this.parameterNames);
            }

            private void makeUnique(List<String> names) {
                for (int i = 0; i < names.size(); ++i) {
                    for (int j = i + 1; j < names.size(); ++j) {
                        if (!names.get(i).equals(names.get(j))) continue;
                        names.set(i, names.get(i) + i);
                    }
                }
            }

            private String deriveParameterName(Expr expr) {
                if (expr instanceof NameRef) {
                    return ((NameRef)expr).getVarName();
                }
                if (expr instanceof FuncRef) {
                    return ((FuncRef)((Object)expr)).getFuncName();
                }
                String res = Utils.prettyPrint(expr).replaceAll("[^a-zA-Z]+", "");
                if (res.length() > 10) {
                    res = res.substring(0, 10);
                } else if (res.isEmpty()) {
                    res = "arg";
                }
                return res;
            }

            @Override
            public void case_ExprFunctionCall(ExprFunctionCall e) {
                this.getInsertPos(fr);
                this.addParametertypes(e.getArgs());
            }

            public void indent(StringBuilder sb) {
                CompilationUnitInfo.IndentationMode indentationMode = fr.attrCompilationUnit().getCuInfo().getIndentationMode();
                indentationMode.appendIndent(sb, indentationMode.countIndents(this.indent) + 1);
            }
        }
        M m = new M();
        fr.match(m);
        String title = "Create function " + fr.getFuncName();
        StringBuilder code = new StringBuilder("\n");
        m.indent(code);
        if (m.isAnnotation) {
            code.append("@annotation ");
        }
        code.append("function ");
        code.append(m.receiverType);
        code.append(fr.getFuncName());
        code.append("(");
        for (int i = 0; i < m.parameterTypes.size(); ++i) {
            if (i > 0) {
                code.append(", ");
            }
            code.append(m.parameterTypes.get(i));
            code.append(" ");
            code.append(m.parameterNames.get(i));
        }
        code.append(")");
        if (!(m.returnType instanceof WurstTypeVoid) && !(m.returnType instanceof WurstTypeUnknown)) {
            code.append(" returns ");
            code.append(m.returnType);
        }
        code.append("\n");
        List<JsonObject> arguments = Collections.singletonList(PerformCodeActionRequest.insertCodeAction(m.targetFile.getUriString(), m.line, code.toString()));
        return Collections.singletonList(Either.forLeft((Object)new Command(title, "wurst.perform_code_action", arguments)));
    }

    private List<Either<Command, CodeAction>> handleMissingType(ModelManager modelManager, String typeName) {
        WurstModel model = modelManager.getModel();
        ArrayList<String> possibleImports = new ArrayList<String>();
        for (CompilationUnit cu : model) {
            for (WPackage wPackage : cu.getPackages()) {
                if (wPackage.attrExportedTypeNameLinks().get((Object)typeName).isEmpty()) continue;
                possibleImports.add(wPackage.getName());
            }
        }
        return this.makeImportCommands(possibleImports);
    }

    private List<Either<Command, CodeAction>> handleMissingClass(ModelManager modelManager, String typeName) {
        WurstModel model = modelManager.getModel();
        ArrayList<String> possibleImports = new ArrayList<String>();
        for (CompilationUnit cu : model) {
            block1: for (WPackage wPackage : cu.getPackages()) {
                for (NameLink nameLink : wPackage.attrExportedTypeNameLinks().get((Object)typeName)) {
                    if (!(nameLink.getDef() instanceof ClassDef)) continue;
                    possibleImports.add(wPackage.getName());
                    continue block1;
                }
            }
        }
        return this.makeImportCommands(possibleImports);
    }

    private List<Either<Command, CodeAction>> handleMissingModule(ModelManager modelManager, String moduleName) {
        WurstModel model = modelManager.getModel();
        ArrayList<String> possibleImports = new ArrayList<String>();
        for (CompilationUnit cu : model) {
            block1: for (WPackage wPackage : cu.getPackages()) {
                for (NameLink nameLink : wPackage.attrExportedTypeNameLinks().get((Object)moduleName)) {
                    if (!(nameLink.getDef() instanceof ModuleDef)) continue;
                    possibleImports.add(wPackage.getName());
                    continue block1;
                }
            }
        }
        return this.makeImportCommands(possibleImports);
    }

    private List<Either<Command, CodeAction>> makeImportCommands(List<String> possibleImports) {
        return possibleImports.stream().map(this::makeImportCommand).collect(Collectors.toList());
    }

    private Either<Command, CodeAction> makeImportCommand(String imp) {
        String title = "Import package " + imp;
        List<JsonObject> arguments = Collections.singletonList(PerformCodeActionRequest.importPackageAction(this.filename.getUriString(), imp));
        return Either.forLeft((Object)new Command(title, "wurst.perform_code_action", arguments));
    }
}

