/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.splats;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.BlendMode;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.UberSplatId;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;

public class UberSplatSLK
extends ObjSLK<UberSplatSLK, UberSplatId, Obj> {
    public static final File GAME_PATH = new File("Units\\UberSplatData.slk");

    @Override
    @Nonnull
    public Map<UberSplatId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((UberSplatId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull UberSplatId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    private RawSLK toRawSLK() {
        RawSLK slk = new RawSLK();
        for (Obj obj : this.getObjs().values()) {
            Object id = obj.getId();
            Object slkObj = slk.addObj(id);
            ((SLK.Obj)slkObj).merge(obj, true);
        }
        return slk;
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        RawSLK slk = new RawSLK();
        slk.read(file);
        this.read(slk);
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        RawSLK slk = this.toRawSLK();
        slk.write(file);
    }

    public UberSplatSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values()) {
            this.addField(state);
        }
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(UberSplatId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull UberSplatSLK other, boolean overwrite) {
    }

    public static class Obj
    extends SLK.Obj<UberSplatId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();
        Color _colorStart;

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public Path getTex() {
            return Paths.get(this.get(State.ART_TEX_DIR).toString(), this.get(State.ART_TEX_FILE).toString());
        }

        public void setTex(Path val) {
            this.set(State.ART_TEX_DIR, War3String.valueOf(val.getParent().toString()));
            this.set(State.ART_TEX_FILE, War3String.valueOf(val.getFileName().toString()));
        }

        public BlendMode getBlendMode() {
            return this.get(State.ART_BLEND_MODE);
        }

        public void setBlendMode(BlendMode val) {
            this.set(State.ART_BLEND_MODE, val);
        }

        public War3Real getScale() {
            return this.get(State.ART_SCALE);
        }

        public void setScale(War3Real val) {
            this.set(State.ART_SCALE, val);
        }

        public War3Real getBirthTime() {
            return this.get(State.ART_BIRTH_TIME);
        }

        public void setBirthTime(War3Real val) {
            this.set(State.ART_BIRTH_TIME, val);
        }

        public War3Real getPauseTime() {
            return this.get(State.ART_PAUSE_TIME);
        }

        public void setPauseTime(War3Real val) {
            this.set(State.ART_PAUSE_TIME, val);
        }

        public Color getColorStart() {
            return Color.fromBGRA255(this.get(State.ART_COLOR_BLUE_START).toInt(), this.get(State.ART_COLOR_GREEN_START).toInt(), this.get(State.ART_COLOR_RED_START).toInt(), this.get(State.ART_COLOR_ALPHA_START).toInt());
        }

        public void setColorStart(Color val) {
            this.set(State.ART_COLOR_ALPHA_START, War3Int.valueOf(val.getAlpha255()));
            this.set(State.ART_COLOR_BLUE_START, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_COLOR_GREEN_START, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_COLOR_RED_START, War3Int.valueOf(val.getRed255()));
        }

        public Color getColorMid() {
            return Color.fromBGRA255(this.get(State.ART_COLOR_BLUE_MID).toInt(), this.get(State.ART_COLOR_GREEN_MID).toInt(), this.get(State.ART_COLOR_RED_MID).toInt(), this.get(State.ART_COLOR_ALPHA_MID).toInt());
        }

        public void setColorMid(Color val) {
            this.set(State.ART_COLOR_ALPHA_MID, War3Int.valueOf(val.getAlpha255()));
            this.set(State.ART_COLOR_BLUE_MID, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_COLOR_GREEN_MID, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_COLOR_RED_MID, War3Int.valueOf(val.getRed255()));
        }

        public Color getColorEnd() {
            return Color.fromBGRA255(this.get(State.ART_COLOR_BLUE_END).toInt(), this.get(State.ART_COLOR_GREEN_END).toInt(), this.get(State.ART_COLOR_RED_END).toInt(), this.get(State.ART_COLOR_ALPHA_END).toInt());
        }

        public void setColorEnd(Color val) {
            this.set(State.ART_COLOR_ALPHA_END, War3Int.valueOf(val.getAlpha255()));
            this.set(State.ART_COLOR_BLUE_END, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_COLOR_GREEN_END, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_COLOR_RED_END, War3Int.valueOf(val.getRed255()));
        }

        public War3Bool getDecay() {
            return this.get(State.ART_DECAY);
        }

        public void setDecay(War3Bool val) {
            this.set(State.ART_DECAY, val);
        }

        public SoundLabel getSound() {
            return this.get(State.SOUND_LABEL);
        }

        public void setSound(SoundLabel val) {
            this.set(State.SOUND_LABEL, val);
        }

        public <T extends DataType> T get(State<T> state) {
            return (T)super.get(state);
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void remove(State<T> state) {
            super.set(state, null);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(UberSplatId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(UberSplatId id) {
            super(id);
            for (State state : State.values()) {
                this.set(state, state.getDefVal());
            }
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<UberSplatId> OBJ_ID = new State<UberSplatId>("Name", UberSplatId.class);
        public static final State<War3Real> ART_BIRTH_TIME = new State<War3Real>("BirthTime", War3Real.class);
        public static final State<BlendMode> ART_BLEND_MODE = new State<BlendMode>("BlendMode", BlendMode.class);
        public static final State<War3Int> ART_COLOR_ALPHA_END = new State<War3Int>("EndA", War3Int.class);
        public static final State<War3Int> ART_COLOR_ALPHA_MID = new State<War3Int>("MiddleA", War3Int.class);
        public static final State<War3Int> ART_COLOR_ALPHA_START = new State<War3Int>("StartA", War3Int.class);
        public static final State<War3Int> ART_COLOR_BLUE_END = new State<War3Int>("EndB", War3Int.class);
        public static final State<War3Int> ART_COLOR_BLUE_MID = new State<War3Int>("MiddleB", War3Int.class);
        public static final State<War3Int> ART_COLOR_BLUE_START = new State<War3Int>("StartB", War3Int.class);
        public static final State<War3Int> ART_COLOR_GREEN_END = new State<War3Int>("EndG", War3Int.class);
        public static final State<War3Int> ART_COLOR_GREEN_MID = new State<War3Int>("MiddleG", War3Int.class);
        public static final State<War3Int> ART_COLOR_GREEN_START = new State<War3Int>("StartG", War3Int.class);
        public static final State<War3Int> ART_COLOR_RED_END = new State<War3Int>("EndR", War3Int.class);
        public static final State<War3Int> ART_COLOR_RED_MID = new State<War3Int>("MiddleR", War3Int.class);
        public static final State<War3Int> ART_COLOR_RED_START = new State<War3Int>("StartR", War3Int.class);
        public static final State<War3Bool> ART_DECAY = new State<War3Bool>("Decay", War3Bool.class);
        public static final State<War3Real> ART_PAUSE_TIME = new State<War3Real>("PauseTime", War3Real.class);
        public static final State<War3Real> ART_SCALE = new State<War3Real>("Scale", War3Real.class);
        public static final State<War3String> ART_TEX_DIR = new State<War3String>("Dir", War3String.class);
        public static final State<War3String> ART_TEX_FILE = new State<War3String>("file", War3String.class);
        public static final State<War3String> EDITOR_COMMENT = new State<War3String>("comment", War3String.class);
        public static final State<SoundLabel> SOUND_LABEL = new State<SoundLabel>("Sound", SoundLabel.class);

        public static Collection<State> values() {
            return State.values(State.class);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

