/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.dataTypes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.misc.TypeInfo;

public class DataTypeInfo
extends TypeInfo<DataType> {
    @Override
    @Nonnull
    public Class<? extends DataType> getType() {
        return super.getType();
    }

    @Nullable
    public DataTypeInfo[] getGenerics() {
        TypeInfo<boundType>[] superGenerics = super.getGenerics();
        if (superGenerics == null) {
            return null;
        }
        DataTypeInfo[] ret = new DataTypeInfo[superGenerics.length];
        for (int i = 0; i < superGenerics.length; ++i) {
            ret[i] = (DataTypeInfo)superGenerics[i];
        }
        return ret;
    }

    @Nullable
    public DataType getDefVal() {
        try {
            Method method = this.getType().getDeclaredMethod("getDefVal", new Class[0]);
            return (DataType)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    @Nullable
    public String getTranslatorSection() {
        try {
            Method method = this.getType().getDeclaredMethod("getTranslatorSection", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    @Nullable
    public DataType tryCastVal(@Nullable DataType val) throws CastException {
        if (val == null) {
            return null;
        }
        Class<? extends DataType> type = this.getType();
        try {
            if (type == DataList.class) {
                return new DataList(this.getGenerics()[0]).decode(val);
            }
            Method c = type.getDeclaredMethod("decodeStatic", Object.class);
            assert (c != null) : "decodeStatic not declared on " + type;
            return (DataType)c.invoke(null, val);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new CastException(e);
        }
    }

    public DataTypeInfo(@Nonnull Class<? extends DataType> type, Class<? extends DataType> generics) {
        super(type, new DataTypeInfo(generics));
    }

    public DataTypeInfo(@Nonnull Class<? extends DataType> type, DataTypeInfo[] generics) {
        super(type, generics);
    }

    public DataTypeInfo(@Nonnull Class<? extends DataType> type, @Nonnull DataTypeInfo generics) {
        this(type, generics.getType());
    }

    public DataTypeInfo(@Nonnull Class<? extends DataType> type) {
        super(type);
    }

    public static class CastException
    extends Exception {
        public CastException(@Nonnull Exception enclosedException) {
            super(enclosedException);
        }
    }
}

