/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.attributes.AttrConstantValue;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.Nullable;

public class WurstTypeArray
extends WurstType {
    private Expr arSize;
    private final WurstType baseType;
    private int[] sizes;

    public WurstTypeArray(WurstType baseType, Expr arSize) {
        if (baseType instanceof WurstTypeArray) {
            throw new Error("cannot have array of arrays...");
        }
        this.baseType = baseType;
        this.arSize = arSize;
    }

    public WurstTypeArray(WurstType baseType) {
        if (baseType instanceof WurstTypeArray) {
            throw new Error("cannot have array of arrays...");
        }
        this.baseType = baseType;
        this.sizes = new int[]{-1};
    }

    public WurstTypeArray(WurstType baseType, int size) {
        if (baseType instanceof WurstTypeArray) {
            throw new Error("cannot have array of arrays...");
        }
        this.baseType = baseType;
        this.sizes = new int[]{size};
    }

    private void initSizes() {
        if (this.sizes != null) {
            return;
        }
        int[] sizes = new int[]{};
        try {
            ILconst i = this.arSize.attrConstantValue();
            if (i instanceof ILconstInt) {
                int val = ((ILconstInt)i).getVal();
                sizes = new int[]{val};
                if (val < 0) {
                    this.arSize.addError("Array size must be at least 0");
                }
            } else {
                this.arSize.addError("Array sizes should be integer...");
            }
        }
        catch (AttrConstantValue.ConstantValueCalculationException e) {
            this.arSize.addError("Array size is not a constant expression.");
        }
        this.sizes = sizes;
    }

    public WurstType getBaseType() {
        return this.baseType;
    }

    public int getDimensions() {
        this.initSizes();
        return this.sizes.length;
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType other, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if (other instanceof WurstTypeArray) {
            WurstTypeArray otherArray = (WurstTypeArray)other;
            if ((mapping = this.baseType.matchTypes(otherArray.baseType, location, mapping, VariablePosition.RIGHT)) == null) {
                return null;
            }
            if (this.getDimensions() != otherArray.getDimensions()) {
                return null;
            }
            return mapping;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.baseType.getName() + " array(dimensions = " + this.getDimensions() + ")";
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    public int getSize(int i) {
        this.initSizes();
        return this.sizes[i];
    }

    @Override
    public ImType imTranslateType(ImTranslator tr) {
        this.initSizes();
        ImType bt = this.baseType.imTranslateType(tr);
        if (this.sizes.length > 0) {
            if (this.sizes[0] < 0) {
                return JassIm.ImArrayType(bt);
            }
            ArrayList nsizes = Lists.newArrayList();
            for (int size : this.sizes) {
                nsizes.add(size);
            }
            return JassIm.ImArrayTypeMulti(bt, nsizes);
        }
        return JassIm.ImArrayType(bt);
    }

    @Override
    public ImExprOpt getDefaultValue(ImTranslator tr) {
        throw new Error();
    }

    @Override
    protected boolean isNullable() {
        return false;
    }
}

