/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imoptimizer;

import com.google.common.collect.Lists;
import de.peeeq.wurstio.TimeTaker;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.intermediatelang.optimizer.BranchMerger;
import de.peeeq.wurstscript.intermediatelang.optimizer.ConstantAndCopyPropagation;
import de.peeeq.wurstscript.intermediatelang.optimizer.LocalMerger;
import de.peeeq.wurstscript.intermediatelang.optimizer.SimpleRewrites;
import de.peeeq.wurstscript.intermediatelang.optimizer.TempMerger;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imoptimizer.GlobalsInliner;
import de.peeeq.wurstscript.translation.imoptimizer.ImCompressor;
import de.peeeq.wurstscript.translation.imoptimizer.ImInliner;
import de.peeeq.wurstscript.translation.imoptimizer.NullSetter;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imoptimizer.Replacer;
import de.peeeq.wurstscript.translation.imoptimizer.UselessFunctionCallsRemover;
import de.peeeq.wurstscript.translation.imtranslation.AssertProperty;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.utils.Pair;
import de.peeeq.wurstscript.validation.TRVEHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ImOptimizer {
    private int totalFunctionsRemoved = 0;
    private int totalGlobalsRemoved = 0;
    private static final ArrayList<OptimizerPass> localPasses = new ArrayList();
    private static final HashMap<String, Integer> totalCount = new HashMap();
    private final TimeTaker timeTaker;
    ImTranslator trans;
    private int optCount = 1;

    public ImOptimizer(TimeTaker timeTaker, ImTranslator trans) {
        this.timeTaker = timeTaker;
        this.trans = trans;
    }

    public void optimize() {
        this.removeGarbage();
        ImCompressor compressor = new ImCompressor(this.trans);
        compressor.compressNames();
    }

    public void doInlining() {
        this.removeGarbage();
        GlobalsInliner globalsInliner = new GlobalsInliner();
        globalsInliner.optimize(this.trans);
        ImInliner inliner = new ImInliner(this.trans);
        inliner.doInlining();
        this.trans.assertProperties(new AssertProperty[0]);
        this.removeGarbage();
    }

    public void localOptimizations() {
        totalCount.clear();
        this.removeGarbage();
        int finalItr = 0;
        for (int i = 1; i <= 10 && this.optCount > 0; ++i) {
            this.optCount = 0;
            localPasses.forEach(pass -> {
                int count = this.timeTaker.measure(pass.getName(), () -> pass.optimize(this.trans));
                this.optCount += count;
                totalCount.put(pass.getName(), totalCount.getOrDefault(pass.getName(), 0) + count);
            });
            this.trans.getImProg().flatten(this.trans);
            this.removeGarbage();
            finalItr = i;
            WLogger.info("=== Optimization pass: " + i + " opts: " + this.optCount + " ===");
        }
        WLogger.info("=== Local optimizations done! Ran " + finalItr + " passes. ===");
        totalCount.forEach((k, v) -> WLogger.info("== " + k + ":   " + v));
    }

    public void doNullsetting() {
        NullSetter ns = new NullSetter(this.trans);
        ns.optimize();
        this.trans.assertProperties(new AssertProperty[0]);
    }

    public void removeGarbage() {
        boolean changes = true;
        int iterations = 0;
        while (changes && iterations++ < 10) {
            ImProg prog = this.trans.imProg();
            this.trans.calculateCallRelationsAndUsedVariables();
            int globalsBefore = prog.getGlobals().size();
            changes = prog.getGlobals().retainAll(this.trans.getReadVariables());
            int globalsAfter = prog.getGlobals().size();
            int globalsRemoved = globalsBefore - globalsAfter;
            this.totalGlobalsRemoved += globalsRemoved;
            int functionsBefore = prog.getFunctions().size();
            changes |= prog.getFunctions().retainAll(this.trans.getUsedFunctions());
            int functionsAfter = prog.getFunctions().size();
            int functionsRemoved = functionsBefore - functionsAfter;
            this.totalFunctionsRemoved += functionsRemoved;
            HashSet<ImFunction> allFunctions = new HashSet<ImFunction>(prog.getFunctions());
            for (ImClass c : prog.getClasses()) {
                int classFunctionsBefore = c.getFunctions().size();
                changes |= c.getFunctions().retainAll(this.trans.getUsedFunctions());
                int classFunctionsAfter = c.getFunctions().size();
                this.totalFunctionsRemoved += classFunctionsBefore - classFunctionsAfter;
                allFunctions.addAll(c.getFunctions());
                int classFieldsBefore = c.getFields().size();
                changes |= c.getFields().retainAll(this.trans.getReadVariables());
                int classFieldsAfter = c.getFields().size();
                this.totalGlobalsRemoved += classFieldsBefore - classFieldsAfter;
            }
            for (ImFunction f : allFunctions) {
                final ArrayList replacements = Lists.newArrayList();
                f.accept(new Element.DefaultVisitor(){

                    @Override
                    public void visit(ImSet e) {
                        super.visit(e);
                        if (e.getLeft() instanceof ImVarAccess) {
                            ImVarAccess va = (ImVarAccess)e.getLeft();
                            if (!ImOptimizer.this.trans.getReadVariables().contains(va.getVar()) && !TRVEHelper.protectedVariables.contains(va.getVar().getName())) {
                                replacements.add(Pair.create(e, Collections.singletonList(e.getRight())));
                            }
                        } else if (e.getLeft() instanceof ImVarArrayAccess) {
                            ImVarArrayAccess va = (ImVarArrayAccess)e.getLeft();
                            if (!ImOptimizer.this.trans.getReadVariables().contains(va.getVar()) && !TRVEHelper.protectedVariables.contains(va.getVar().getName())) {
                                List exprs = va.getIndexes().removeAll();
                                exprs.add(e.getRight());
                                replacements.add(Pair.create(e, exprs));
                            }
                        } else if (e.getLeft() instanceof ImTupleSelection) {
                            ImVar var = TypesHelper.getTupleVar((ImTupleSelection)e.getLeft());
                            if (!ImOptimizer.this.trans.getReadVariables().contains(var) && !TRVEHelper.protectedVariables.contains(var.getName())) {
                                replacements.add(Pair.create(e, Collections.singletonList(e.getRight())));
                            }
                        } else if (e.getLeft() instanceof ImMemberAccess) {
                            ImMemberAccess va = (ImMemberAccess)e.getLeft();
                            if (!ImOptimizer.this.trans.getReadVariables().contains(va.getVar()) && !TRVEHelper.protectedVariables.contains(va.getVar().getName())) {
                                replacements.add(Pair.create(e, Collections.singletonList(e.getRight())));
                            }
                        }
                    }
                });
                Replacer replacer = new Replacer();
                for (Pair pair : replacements) {
                    ImExpr r;
                    changes = true;
                    if (((List)pair.getB()).size() == 1) {
                        r = (ImExpr)((List)pair.getB()).get(0);
                        r.setParent(null);
                    } else {
                        List<ImStmt> exprs = Collections.unmodifiableList((List)pair.getB());
                        for (ImStmt expr : exprs) {
                            expr.setParent(null);
                        }
                        r = ImHelper.statementExprVoid(JassIm.ImStmts(exprs));
                    }
                    replacer.replace((Element)pair.getA(), r);
                }
                changes |= f.getLocals().retainAll(this.trans.getReadVariables());
            }
        }
    }

    static {
        localPasses.add(new SimpleRewrites());
        localPasses.add(new ConstantAndCopyPropagation());
        localPasses.add(new UselessFunctionCallsRemover());
        localPasses.add(new GlobalsInliner());
        localPasses.add(new BranchMerger());
        localPasses.add(new SimpleRewrites());
        localPasses.add(new TempMerger());
        localPasses.add(new LocalMerger());
    }
}

