/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.prettyPrint;

import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.ArrayInitializer;
import de.peeeq.wurstscript.ast.ArraySizes;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassDefs;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.ConstructorDefs;
import de.peeeq.wurstscript.ast.Documentable;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EndFunctionStatement;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.EnumMembers;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprBoolVal;
import de.peeeq.wurstscript.ast.ExprCast;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprIfElse;
import de.peeeq.wurstscript.ast.ExprIncomplete;
import de.peeeq.wurstscript.ast.ExprInstanceOf;
import de.peeeq.wurstscript.ast.ExprIntVal;
import de.peeeq.wurstscript.ast.ExprList;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDot;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDotDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDotDot;
import de.peeeq.wurstscript.ast.ExprMemberVarDot;
import de.peeeq.wurstscript.ast.ExprMemberVarDotDot;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprNull;
import de.peeeq.wurstscript.ast.ExprRealVal;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.ExprStringVal;
import de.peeeq.wurstscript.ast.ExprSuper;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.ExprTypeId;
import de.peeeq.wurstscript.ast.ExprUnary;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.ExprVarArrayAccess;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FuncDefs;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.GlobalVarDefs;
import de.peeeq.wurstscript.ast.Identifier;
import de.peeeq.wurstscript.ast.IdentifierWithTypeArgs;
import de.peeeq.wurstscript.ast.IdentifierWithTypeParamDefs;
import de.peeeq.wurstscript.ast.Indexes;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.JassGlobalBlock;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.JassToplevelDeclarations;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.LoopStatementWithVarDef;
import de.peeeq.wurstscript.ast.ModAbstract;
import de.peeeq.wurstscript.ast.ModConstant;
import de.peeeq.wurstscript.ast.ModOverride;
import de.peeeq.wurstscript.ast.ModStatic;
import de.peeeq.wurstscript.ast.ModVararg;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.ModuleInstanciations;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.ModuleUses;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.NoDefaultCase;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.NoSuperConstructorCall;
import de.peeeq.wurstscript.ast.NoTypeExpr;
import de.peeeq.wurstscript.ast.NoTypeParamConstraints;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.SomeSuperConstructorCall;
import de.peeeq.wurstscript.ast.StartFunctionStatement;
import de.peeeq.wurstscript.ast.StmtCall;
import de.peeeq.wurstscript.ast.StmtErr;
import de.peeeq.wurstscript.ast.StmtExitwhen;
import de.peeeq.wurstscript.ast.StmtForFrom;
import de.peeeq.wurstscript.ast.StmtForIn;
import de.peeeq.wurstscript.ast.StmtForRange;
import de.peeeq.wurstscript.ast.StmtForRangeDown;
import de.peeeq.wurstscript.ast.StmtForRangeUp;
import de.peeeq.wurstscript.ast.StmtIf;
import de.peeeq.wurstscript.ast.StmtLoop;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.StmtSkip;
import de.peeeq.wurstscript.ast.StmtWhile;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchCases;
import de.peeeq.wurstscript.ast.SwitchDefaultCaseStatements;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.TopLevelDeclarations;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeExprArray;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeExprResolved;
import de.peeeq.wurstscript.ast.TypeExprSimple;
import de.peeeq.wurstscript.ast.TypeExprThis;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.VisibilityDefault;
import de.peeeq.wurstscript.ast.VisibilityPrivate;
import de.peeeq.wurstscript.ast.VisibilityProtected;
import de.peeeq.wurstscript.ast.VisibilityPublic;
import de.peeeq.wurstscript.ast.VisibilityPublicread;
import de.peeeq.wurstscript.ast.WBlock;
import de.peeeq.wurstscript.ast.WEntities;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WPackages;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.ast.WShortParameters;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.ast.WurstDoc;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.prettyPrint.Spacer;
import de.peeeq.wurstscript.jassAst.JassExprUnary;
import de.peeeq.wurstscript.jassAst.JassOpAnd;
import de.peeeq.wurstscript.jassAst.JassOpBinary;
import de.peeeq.wurstscript.jassAst.JassOpMult;
import de.peeeq.wurstscript.jassAst.JassOpOr;
import de.peeeq.wurstscript.jassAst.JassOpPlus;
import de.peeeq.wurstscript.jassprinter.JassPrinter;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.parser.WPosWithComments;
import de.peeeq.wurstscript.utils.Utils;
import org.apache.commons.lang.StringUtils;

public class PrettyPrinter {
    private static void commaSeparatedList(Element e, Spacer spacer, StringBuilder sb, int indent) {
        for (int i = 0; i < e.size(); ++i) {
            if (i > 0) {
                sb.append(",");
                spacer.addSpace(sb);
            }
            e.get(i).prettyPrint(spacer, sb, indent);
        }
    }

    private static void printClassOrModuleDeclaration(ClassOrModule e, Spacer spacer, StringBuilder sb, int indent) {
        e.getModuleUses().prettyPrint(spacer, sb, indent);
        e.getVars().prettyPrint(spacer, sb, indent);
        e.getConstructors().prettyPrint(spacer, sb, indent);
        e.getMethods().prettyPrint(spacer, sb, indent);
        e.getOnDestroy().prettyPrint(spacer, sb, indent);
        e.getInnerClasses().prettyPrint(spacer, sb, indent);
    }

    private static void printFirstNewline(Element e, StringBuilder sb, int indent) {
        if (e.getParent().get(0).equals(e)) {
            return;
        }
        if (sb.charAt(sb.length() - 1) == '\n' && sb.charAt(sb.length() - 2) == '\n') {
            return;
        }
        sb.append("\n");
    }

    private static void printNewline(Element e, StringBuilder sb, int indent) {
        if (!(e.getParent() instanceof WStatements)) {
            return;
        }
        sb.append("\n");
    }

    private static void printStuff(Documentable e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printCommentsBefore(sb, e, indent);
        PrettyPrinter.printHotDoc(e.getModifiers(), spacer, sb, indent);
        PrettyPrinter.printIndent(sb, indent);
        e.getModifiers().prettyPrint(spacer, sb, indent);
    }

    private static void printHotDoc(Modifiers e, Spacer spacer, StringBuilder sb, int indent) {
        for (Modifier modifier : e) {
            if (!(modifier instanceof WurstDoc)) continue;
            modifier.prettyPrint(spacer, sb, indent);
        }
    }

    private static void printCommentsBefore(StringBuilder sb, Element d, int indent) {
        if (!(d instanceof AstElementWithSource)) {
            return;
        }
        WPos source1 = ((AstElementWithSource)d).getSource();
        if (source1 instanceof WPosWithComments) {
            WPosWithComments source = (WPosWithComments)source1;
            for (WPosWithComments.Comment comment : source.getCommentsBefore()) {
                PrettyPrinter.printIndent(sb, indent);
                sb.append(comment.getContent());
                if (!comment.isSingleLine()) continue;
                sb.append("\n");
            }
        }
    }

    private static void printCommentsAfter(StringBuilder sb, Element d, int indent) {
        if (!(d instanceof AstElementWithSource)) {
            return;
        }
        WPos source1 = ((AstElementWithSource)d).getSource();
        if (source1 instanceof WPosWithComments) {
            WPosWithComments source = (WPosWithComments)source1;
            for (WPosWithComments.Comment comment : source.getCommentsAfter()) {
                PrettyPrinter.printIndent(sb, indent);
                sb.append(comment.getContent());
                if (!comment.isSingleLine()) continue;
                sb.append("\n");
            }
        }
    }

    private static void printIndent(StringBuilder sb, int indent) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
            for (int i = 0; i < indent; ++i) {
                sb.append("    ");
            }
        }
    }

    private static String calculateIndent(int indent) {
        Object s = "";
        for (int i = 0; i < indent; ++i) {
            s = (String)s + "\t";
        }
        return s;
    }

    public static void prettyPrint(JassToplevelDeclarations e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(JassGlobalBlock e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(Annotation e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(e.getAnnotationType());
        if (e.getAnnotationMessage() != null && e.getAnnotationMessage().length() >= 1) {
            sb.append("(");
            sb.append(e.getAnnotationMessage());
            sb.append(")");
        }
    }

    public static void prettyPrint(Arguments e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.commaSeparatedList(e, spacer, sb, indent);
    }

    public static void prettyPrint(ExprList e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.commaSeparatedList(e, spacer, sb, indent);
    }

    public static void prettyPrint(ArraySizes e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.commaSeparatedList(e, spacer, sb, indent);
    }

    public static void prettyPrint(ClassDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("class");
        spacer.addSpace(sb);
        sb.append(e.getName());
        e.getTypeParameters().prettyPrint(spacer, sb, indent);
        if (e.getExtendedClass() instanceof TypeExpr) {
            TypeExpr te = (TypeExpr)e.getExtendedClass();
            spacer.addSpace(sb);
            sb.append("extends");
            spacer.addSpace(sb);
            te.prettyPrint(spacer, sb, indent);
        }
        if (!e.getImplementsList().isEmpty()) {
            spacer.addSpace(sb);
            sb.append("implements");
            spacer.addSpace(sb);
            PrettyPrinter.commaSeparatedList(e.getImplementsList(), spacer, sb, indent);
        }
        sb.append("\n");
        PrettyPrinter.printClassOrModuleDeclaration(e, spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(CompilationUnit e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.prettyPrint(e.getPackages(), spacer, sb, indent);
        PrettyPrinter.jassPrettyPrint(e.getJassDecls(), spacer, sb, indent);
    }

    public static void prettyPrint(ConstructorDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("construct");
        e.getParameters().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        e.getSuperConstructorCall().prettyPrint(spacer, sb, indent);
        e.getBody().prettyPrint(spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(ConstructorDefs e, Spacer spacer, StringBuilder sb, int indent) {
        for (ConstructorDef constructorDef : e) {
            constructorDef.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(EndFunctionStatement e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(EnumDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("enum");
        spacer.addSpace(sb);
        sb.append(e.getName());
        sb.append("\n");
        e.getMembers().prettyPrint(spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(EnumMember e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append(e.getName());
        sb.append("\n");
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(EnumMembers e, Spacer spacer, StringBuilder sb, int indent) {
        for (EnumMember enumMember : e) {
            enumMember.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(ExprBinary e, Spacer spacer, StringBuilder sb, int indent) {
        boolean useParanthesesLeft = false;
        boolean useParanthesesRight = false;
        if (e.getLeft() instanceof ExprBinary) {
            ExprBinary left = (ExprBinary)e.getLeft();
            if (JassPrinter.precedence(left.getOp().jassTranslateBinary()) < JassPrinter.precedence(e.getOp().jassTranslateBinary())) {
                useParanthesesLeft = true;
            }
        } else if (e.getLeft() instanceof ExprUnary) {
            useParanthesesLeft = true;
        }
        if (e.getRight() instanceof ExprBinary) {
            ExprBinary right = (ExprBinary)e.getRight();
            JassOpBinary op = right.getOp().jassTranslateBinary();
            JassOpBinary op2 = e.getOp().jassTranslateBinary();
            if (JassPrinter.precedence(op) < JassPrinter.precedence(op2)) {
                useParanthesesRight = true;
            } else if (!(JassPrinter.precedence(op) != JassPrinter.precedence(op2) || op instanceof JassOpPlus && op2 instanceof JassOpPlus || op instanceof JassOpMult && op2 instanceof JassOpMult || op instanceof JassOpOr && op2 instanceof JassOpOr || op instanceof JassOpAnd && op2 instanceof JassOpAnd)) {
                useParanthesesRight = true;
            }
        } else if (e.getRight() instanceof JassExprUnary) {
            useParanthesesRight = true;
        }
        sb.append(useParanthesesLeft ? "(" : "");
        e.getLeft().prettyPrint(spacer, sb, indent);
        sb.append(useParanthesesLeft ? ")" : "");
        spacer.addSpace(sb);
        sb.append(e.getOp().toString());
        spacer.addSpace(sb);
        sb.append(useParanthesesRight ? "(" : "");
        e.getRight().prettyPrint(spacer, sb, indent);
        sb.append(useParanthesesRight ? ")" : "");
    }

    public static void prettyPrint(ExprBoolVal e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(e.getValB());
    }

    public static void prettyPrint(ExprCast e, Spacer spacer, StringBuilder sb, int indent) {
        e.getExpr().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("castTo");
        spacer.addSpace(sb);
        e.getTyp().prettyPrint(spacer, sb, indent);
    }

    public static void prettyPrint(ExprClosure e, Spacer spacer, StringBuilder sb, int indent) {
        e.getShortParameters().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("->");
        spacer.addSpace(sb);
        e.getImplementation().prettyPrint(spacer, sb, indent);
    }

    public static void prettyPrint(ExprDestroy e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printIndent(sb, indent);
        sb.append("destroy");
        spacer.addSpace(sb);
        e.getDestroyedObj().prettyPrint(spacer, sb, indent);
        sb.append("\n");
    }

    public static void prettyPrint(ExprEmpty e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(ExprFuncRef e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("function");
        spacer.addSpace(sb);
        if (!StringUtils.isBlank((String)e.getScopeName())) {
            sb.append(e.getScopeName());
            sb.append(".");
        }
        sb.append(e.getFuncName());
    }

    public static void prettyPrint(ExprFunctionCall e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append(e.getFuncName());
        sb.append("(");
        e.getArgs().prettyPrint(spacer, sb, indent);
        sb.append(")");
        PrettyPrinter.printNewline(e, sb, indent);
    }

    public static void prettyPrint(ExprIncomplete e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(ExprInstanceOf e, Spacer spacer, StringBuilder sb, int indent) {
        e.getExpr().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("instanceof");
        spacer.addSpace(sb);
        e.getTyp().prettyPrint(spacer, sb, indent);
    }

    public static void prettyPrint(ExprIntVal e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(e.getValIraw());
    }

    public static void prettyPrint(ExprMemberArrayVarDot e, Spacer spacer, StringBuilder sb, int indent) {
        e.getLeft().prettyPrint(spacer, sb, indent);
        sb.append(".");
        sb.append(e.getVarName());
        sb.append("[");
        e.getIndexes().prettyPrint(spacer, sb, indent);
        sb.append("]");
    }

    public static void prettyPrint(ExprMemberArrayVarDotDot e, Spacer spacer, StringBuilder sb, int indent) {
        e.getLeft().prettyPrint(spacer, sb, indent);
        sb.append("..");
        sb.append(e.getVarName());
        sb.append("[");
        e.getIndexes().prettyPrint(spacer, sb, indent);
        sb.append("]");
    }

    public static void prettyPrint(ExprMemberMethodDot e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        if (e.getLeft() instanceof ExprBinary) {
            sb.append("(");
            e.getLeft().prettyPrint(spacer, sb, indent);
            sb.append(")");
        } else {
            e.getLeft().prettyPrint(spacer, sb, indent);
        }
        sb.append(".");
        sb.append(e.getFuncName());
        sb.append("(");
        e.getArgs().prettyPrint(spacer, sb, indent);
        sb.append(")");
        PrettyPrinter.printNewline(e, sb, indent);
    }

    public static void prettyPrint(ExprMemberMethodDotDot e, Spacer spacer, StringBuilder sb, int indent) {
        if (e.getLeft() instanceof ExprBinary) {
            sb.append("(");
            e.getLeft().prettyPrint(spacer, sb, indent);
            sb.append(")");
        } else {
            e.getLeft().prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
        PrettyPrinter.printIndent(sb, indent + 1);
        sb.append("..");
        sb.append(e.getFuncName());
        sb.append("(");
        e.getArgs().prettyPrint(spacer, sb, indent);
        sb.append(")");
        PrettyPrinter.printNewline(e, sb, indent);
    }

    public static void prettyPrint(ExprMemberVarDot e, Spacer spacer, StringBuilder sb, int indent) {
        e.getLeft().prettyPrint(spacer, sb, indent);
        sb.append(".");
        sb.append(e.getVarName());
    }

    public static void prettyPrint(ExprMemberVarDotDot e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        e.getLeft().prettyPrint(spacer, sb, indent);
        sb.append("..");
        sb.append(e.getVarName());
    }

    public static void prettyPrint(ExprNewObject e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("new");
        spacer.addSpace(sb);
        sb.append(e.getTypeName());
        e.getTypeArgs().prettyPrint(spacer, sb, indent);
        if (e.getArgs().size() > 0) {
            sb.append("(");
            e.getArgs().prettyPrint(spacer, sb, indent);
            sb.append(")");
        }
        PrettyPrinter.printNewline(e, sb, indent);
    }

    public static void prettyPrint(ExprNull e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("null");
    }

    public static void prettyPrint(ExprRealVal e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(e.getValR());
    }

    public static void prettyPrint(ExprStatementsBlock e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("begin");
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
        PrettyPrinter.printIndent(sb, indent);
        sb.append("end");
    }

    public static void prettyPrint(ExprStringVal e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(Utils.escapeString(e.getValS()));
    }

    public static void prettyPrint(ExprSuper e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("super");
    }

    public static void prettyPrint(ExprThis e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("this");
    }

    public static void prettyPrint(ExprTypeId e, Spacer spacer, StringBuilder sb, int indent) {
        e.getLeft().prettyPrint(spacer, sb, indent);
        sb.append(".typeId");
    }

    public static void prettyPrint(ExprUnary e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(e.getOpU().toString());
        if (e.getOpU().toString() == "not") {
            spacer.addSpace(sb);
        }
        e.getRight().prettyPrint(spacer, sb, indent);
    }

    public static void prettyPrint(ExprVarAccess e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append(e.getVarName());
    }

    public static void prettyPrint(ExprVarArrayAccess e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append(e.getVarName());
        sb.append("[");
        e.getIndexes().prettyPrint(spacer, sb, indent);
        sb.append("]");
    }

    public static void prettyPrint(ExtensionFuncDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("function");
        spacer.addSpace(sb);
        e.getExtendedType().prettyPrint(spacer, sb, indent);
        sb.append(".");
        PrettyPrinter.printFunctionSignature(e, spacer, sb, indent);
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    private static void printFunctionSignature(FunctionImplementation e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(e.getName());
        e.getTypeParameters().prettyPrint(spacer, sb, indent);
        e.getParameters().prettyPrint(spacer, sb, indent);
        if (!(e.getReturnTyp() instanceof NoTypeExpr)) {
            spacer.addSpace(sb);
            sb.append("returns");
            spacer.addSpace(sb);
            e.getReturnTyp().prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(FuncDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("function");
        spacer.addSpace(sb);
        PrettyPrinter.printFunctionSignature(e, spacer, sb, indent);
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(FuncDefs e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        for (FuncDef funcDef : e) {
            funcDef.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(GlobalVarDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        if (e.getOptTyp() instanceof NoTypeExpr) {
            if (!e.attrIsConstant()) {
                sb.append("var");
            }
        } else {
            e.getOptTyp().prettyPrint(spacer, sb, indent);
        }
        spacer.addSpace(sb);
        sb.append(e.getName());
        if (!(e.getInitialExpr() instanceof NoExpr)) {
            spacer.addSpace(sb);
            sb.append("=");
            spacer.addSpace(sb);
            e.getInitialExpr().prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(GlobalVarDefs e, Spacer spacer, StringBuilder sb, int indent) {
        if (e.size() <= 0) {
            return;
        }
        for (GlobalVarDef varDef : e) {
            varDef.prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
    }

    public static void prettyPrint(IdentifierWithTypeArgs e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(IdentifierWithTypeParamDefs e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(Indexes e, Spacer spacer, StringBuilder sb, int indent) {
        for (Expr expr : e) {
            expr.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(InitBlock e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printIndent(sb, indent);
        sb.append("init");
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
    }

    public static void prettyPrint(InterfaceDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("interface");
        spacer.addSpace(sb);
        sb.append(e.getName());
        e.getTypeParameters().prettyPrint(spacer, sb, indent);
        if (e.getExtendsList().size() >= 1) {
            spacer.addSpace(sb);
            sb.append("extends");
            spacer.addSpace(sb);
            e.getExtendsList().prettyPrint(spacer, sb, indent);
        }
        e.getModuleUses().prettyPrint(spacer, sb, indent + 1);
        e.getVars().prettyPrint(spacer, sb, indent + 1);
        e.getConstructors().prettyPrint(spacer, sb, indent + 1);
        e.getMethods().prettyPrint(spacer, sb, indent + 1);
        e.getOnDestroy().prettyPrint(spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void jassPrettyPrint(GlobalVarDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        PrettyPrinter.jassPrettyPrint(e.getOptTyp(), spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append(e.getName());
        if (!(e.getInitialExpr() instanceof NoExpr)) {
            spacer.addSpace(sb);
            sb.append("=");
            spacer.addSpace(sb);
            e.getInitialExpr().prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void jassPrettyPrint(OptTypeExpr e, Spacer spacer, StringBuilder sb, int indent) {
        if (e instanceof NoTypeExpr) {
            sb.append("nothing");
        } else if (e instanceof TypeExpr) {
            PrettyPrinter.jassPrettyPrint((TypeExpr)e, spacer, sb, indent);
        }
    }

    public static void jassPrettyPrint(TypeExpr e, Spacer spacer, StringBuilder sb, int indent) {
        if (e instanceof NoTypeExpr) {
            sb.append("nothing");
        } else if (e instanceof TypeExprSimple) {
            sb.append(((TypeExprSimple)e).getTypeName());
        } else if (e instanceof TypeExprArray) {
            PrettyPrinter.jassPrettyPrint(((TypeExprArray)e).getBase(), spacer, sb, indent);
            spacer.addSpace(sb);
            sb.append("array");
        }
    }

    public static void jassPrettyPrint(JassToplevelDeclarations e, Spacer spacer, StringBuilder sb, int indent) {
        for (int i = 0; i < e.size(); ++i) {
            PrettyPrinter.jassPrettyPrint((JassToplevelDeclaration)e.get(i), spacer, sb, indent);
        }
    }

    private static void jassPrettyPrint(JassToplevelDeclaration e, Spacer spacer, StringBuilder sb, int indent) {
        if (e instanceof JassGlobalBlock) {
            PrettyPrinter.jassPrettyPrint((JassGlobalBlock)e, spacer, sb, indent);
        } else if (e instanceof NativeFunc) {
            PrettyPrinter.jassPrettyPrint((NativeFunc)e, spacer, sb, indent);
        } else if (e instanceof FuncDef) {
            PrettyPrinter.jassPrettyPrint((FuncDef)e, spacer, sb, indent);
        }
    }

    public static void jassPrettyPrint(FuncDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("function");
        spacer.addSpace(sb);
        sb.append(e.getName());
        spacer.addSpace(sb);
        sb.append("takes");
        spacer.addSpace(sb);
        PrettyPrinter.jassPrettyPrint(e.getParameters(), spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("returns");
        spacer.addSpace(sb);
        if (e.getReturnTyp() instanceof NoTypeExpr) {
            sb.append("nothing");
        } else {
            e.getReturnTyp().prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
        PrettyPrinter.jassPrettyPrint(e.getBody(), spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
        sb.append("endfunction\n");
    }

    public static void jassPrettyPrint(WStatements e, Spacer spacer, StringBuilder sb, int indent) {
        for (int i = 0; i < e.size(); ++i) {
            PrettyPrinter.jassPrettyPrint((WStatement)e.get(i), spacer, sb, indent);
        }
    }

    public static void jassPrettyPrint(WStatement e, Spacer spacer, StringBuilder sb, int indent) {
        if (e instanceof LocalVarDef) {
            PrettyPrinter.jassPrettyPrint((LocalVarDef)e, spacer, sb, indent);
        } else if (e instanceof StmtSet) {
            PrettyPrinter.jassPrettyPrint((StmtSet)e, spacer, sb, indent);
        } else if (e instanceof StmtCall) {
            PrettyPrinter.jassPrettyPrint((StmtCall)e, spacer, sb, indent);
        } else if (e instanceof StmtIf) {
            PrettyPrinter.jassPrettyPrint((StmtIf)e, spacer, sb, indent);
        } else if (e instanceof StmtReturn) {
            PrettyPrinter.jassPrettyPrint((StmtReturn)e, spacer, sb, indent);
        } else if (e instanceof StmtLoop) {
            PrettyPrinter.jassPrettyPrint((StmtLoop)e, spacer, sb, indent);
        } else if (e instanceof StmtExitwhen) {
            PrettyPrinter.jassPrettyPrint((StmtExitwhen)e, spacer, sb, indent);
        }
    }

    public static void jassPrettyPrint(StmtExitwhen e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("exitwhen");
        spacer.addSpace(sb);
        e.getCond().prettyPrint(spacer, sb, indent);
        sb.append("\n");
    }

    public static void jassPrettyPrint(StmtLoop e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("loop\n");
        PrettyPrinter.jassPrettyPrint(e.getBody(), spacer, sb, indent + 1);
        PrettyPrinter.printIndent(sb, indent);
        sb.append("endloop\n");
    }

    public static void jassPrettyPrint(StmtReturn e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("return");
        spacer.addSpace(sb);
        e.getReturnedObj().prettyPrint(spacer, sb, indent);
        sb.append("\n");
    }

    public static void jassPrettyPrint(StmtIf e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("if");
        spacer.addSpace(sb);
        e.getCond().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("then\n");
        PrettyPrinter.jassPrettyPrint(e.getThenBlock(), spacer, sb, indent + 1);
        if (e.getElseBlock().size() > 0) {
            PrettyPrinter.printIndent(sb, indent);
            sb.append("else");
            if (e.getElseBlock().size() == 1 && e.getElseBlock().get(0) instanceof StmtIf) {
                PrettyPrinter.jassPrettyPrint((WStatement)e.getElseBlock().get(0), spacer, sb, indent);
            } else {
                sb.append("\n");
                PrettyPrinter.jassPrettyPrint(e.getElseBlock(), spacer, sb, indent + 1);
                PrettyPrinter.printIndent(sb, indent);
                sb.append("endif\n");
            }
        } else {
            PrettyPrinter.printIndent(sb, indent);
            sb.append("endif\n");
        }
    }

    public static void jassPrettyPrint(StmtCall e, Spacer spacer, StringBuilder sb, int indent) {
        if (e instanceof FunctionCall) {
            PrettyPrinter.jassPrettyPrint((FunctionCall)e, spacer, sb, indent);
        }
    }

    public static void jassPrettyPrint(FunctionCall e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("call");
        spacer.addSpace(sb);
        sb.append(e.getFuncName());
        sb.append("(");
        PrettyPrinter.jassPrettyPrint(e.getArgs(), spacer, sb, indent);
        sb.append(")");
        sb.append("\n");
    }

    public static void jassPrettyPrint(Arguments e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.commaSeparatedList(e, spacer, sb, indent);
    }

    public static void jassPrettyPrint(StmtSet e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("set");
        spacer.addSpace(sb);
        e.getUpdatedExpr().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("=");
        spacer.addSpace(sb);
        e.getRight().prettyPrint(spacer, sb, indent);
        sb.append("\n");
    }

    public static void jassPrettyPrint(LocalVarDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printCommentsBefore(sb, e, indent);
        PrettyPrinter.printIndent(sb, indent);
        sb.append("local");
        spacer.addSpace(sb);
        e.getOptTyp().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append(e.getName());
        if (!(e.getInitialExpr() instanceof NoExpr)) {
            spacer.addSpace(sb);
            sb.append("=");
            spacer.addSpace(sb);
            e.getInitialExpr().prettyPrint(spacer, sb, indent);
        }
        PrettyPrinter.printNewline(e, sb, indent);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void jassPrettyPrint(JassGlobalBlock e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("globals\n");
        for (int i = 0; i < e.size(); ++i) {
            PrettyPrinter.jassPrettyPrint((GlobalVarDef)e.get(i), spacer, sb, indent + 1);
        }
        sb.append("endglobals\n");
    }

    public static void jassPrettyPrint(WParameters wParameters, Spacer spacer, StringBuilder sb, int indent) {
        if (wParameters.size() == 0) {
            sb.append("nothing");
            return;
        }
        String prefix = "";
        for (WParameter wParameter : wParameters) {
            sb.append(prefix);
            prefix = ",";
            spacer.addSpace(sb);
            wParameter.prettyPrint(spacer, sb, indent);
        }
    }

    public static void jassPrettyPrint(NativeFunc e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("native");
        spacer.addSpace(sb);
        e.getNameId().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("takes");
        spacer.addSpace(sb);
        PrettyPrinter.jassPrettyPrint(e.getParameters(), spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("returns");
        spacer.addSpace(sb);
        e.getReturnTyp().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(LocalVarDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printCommentsBefore(sb, e, indent);
        PrettyPrinter.printIndent(sb, indent);
        if (e.getOptTyp() instanceof NoTypeExpr) {
            if (e.attrIsConstant()) {
                sb.append("let");
            } else if (!(e.getParent() instanceof StmtForRange)) {
                sb.append("var");
            }
        } else {
            e.getOptTyp().prettyPrint(spacer, sb, indent);
        }
        spacer.addSpace(sb);
        sb.append(e.getName());
        if (!(e.getInitialExpr() instanceof NoExpr)) {
            spacer.addSpace(sb);
            sb.append("=");
            spacer.addSpace(sb);
            e.getInitialExpr().prettyPrint(spacer, sb, indent);
        }
        PrettyPrinter.printNewline(e, sb, indent);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(ModAbstract e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("abstract");
    }

    public static void prettyPrint(ModConstant e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("constant");
    }

    public static void prettyPrint(ModVararg e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("vararg");
    }

    public static void prettyPrint(Modifiers e, Spacer spacer, StringBuilder sb, int indent) {
        for (Modifier modifier : e) {
            if (modifier instanceof WurstDoc) continue;
            modifier.prettyPrint(spacer, sb, indent);
            spacer.addSpace(sb);
        }
    }

    public static void prettyPrint(ModOverride e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("override");
    }

    public static void prettyPrint(ModStatic e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("static");
    }

    public static void prettyPrint(ModuleDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("module");
        spacer.addSpace(sb);
        e.getNameId().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        PrettyPrinter.printClassOrModuleDeclaration(e, spacer, sb, indent + 1);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(ModuleInstanciation e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printCommentsBefore(sb, e, indent);
    }

    public static void prettyPrint(ModuleInstanciations e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(ModuleUse e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("use");
        spacer.addSpace(sb);
        sb.append(e.getModuleName());
        sb.append("\n");
    }

    public static void prettyPrint(ModuleUses e, Spacer spacer, StringBuilder sb, int indent) {
        for (ModuleUse moduleUse : e) {
            moduleUse.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(NativeFunc e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("native");
        spacer.addSpace(sb);
        e.getNameId().prettyPrint(spacer, sb, indent);
        e.getParameters().prettyPrint(spacer, sb, indent);
        if (!(e.getReturnTyp() instanceof NoTypeExpr)) {
            spacer.addSpace(sb);
            sb.append("returns");
            spacer.addSpace(sb);
            e.getReturnTyp().prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(NativeType e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        sb.append("nativetype");
        spacer.addSpace(sb);
        e.getNameId().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(NoDefaultCase e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(NoExpr e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(NoTypeExpr e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(OnDestroyDef e, Spacer spacer, StringBuilder sb, int indent) {
        if (e.getBody().size() <= 0) {
            return;
        }
        PrettyPrinter.printFirstNewline(e, sb, indent);
        PrettyPrinter.printIndent(sb, indent);
        sb.append("ondestroy");
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
    }

    public static void prettyPrint(StartFunctionStatement e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(StmtErr e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(StmtExitwhen e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("break");
        sb.append("\n");
    }

    public static void prettyPrint(StmtForFrom e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.forIteratorLoop("from", e, e.getIn(), spacer, sb, indent);
    }

    public static void prettyPrint(StmtForIn e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.forIteratorLoop("in", e, e.getIn(), spacer, sb, indent);
    }

    private static void forIteratorLoop(String method, LoopStatementWithVarDef e, Expr target, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("for");
        spacer.addSpace(sb);
        e.getLoopVar().getNameId().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append(method);
        spacer.addSpace(sb);
        target.prettyPrint(spacer, sb, indent);
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
    }

    private static void forRangeLoop(String direction, StmtForRange e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("for");
        spacer.addSpace(sb);
        e.getLoopVar().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append(direction);
        spacer.addSpace(sb);
        e.getTo().prettyPrint(spacer, sb, indent);
        if (e.getStep() instanceof ExprIntVal && ((ExprIntVal)e.getStep()).getValI() != 1) {
            spacer.addSpace(sb);
            sb.append("step");
            spacer.addSpace(sb);
            e.getStep().prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
    }

    public static void prettyPrint(StmtForRangeDown e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.forRangeLoop("downto", e, spacer, sb, indent);
    }

    public static void prettyPrint(StmtForRangeUp e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.forRangeLoop("to", e, spacer, sb, indent);
    }

    public static void prettyPrint(StmtIf e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("if");
        spacer.addSpace(sb);
        e.getCond().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        e.getThenBlock().prettyPrint(spacer, sb, indent + 1);
        if (e.getElseBlock().size() > 0) {
            PrettyPrinter.printIndent(sb, indent);
            sb.append("else");
            if (e.getElseBlock().size() > 0 && e.getElseBlock().get(0) instanceof StmtIf) {
                spacer.addSpace(sb);
                ((WStatement)e.getElseBlock().get(0)).prettyPrint(spacer, sb, indent);
            } else {
                sb.append("\n");
                e.getElseBlock().prettyPrint(spacer, sb, indent + 1);
            }
        }
    }

    public static void prettyPrint(StmtLoop e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(StmtReturn e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("return");
        spacer.addSpace(sb);
        e.getReturnedObj().prettyPrint(spacer, sb, indent);
        sb.append("\n");
    }

    private static boolean printAssignmentShorthands(Expr left, Expr right, Spacer spacer, StringBuilder sb, int indent) {
        if (!(right instanceof ExprBinary)) {
            return false;
        }
        if (!left.toString().equals(((ExprBinary)right).getLeft().toString())) {
            return false;
        }
        String operator = ((ExprBinary)right).getOp().toString();
        Expr val = ((ExprBinary)right).getRight();
        if (val instanceof ExprIntVal && ((ExprIntVal)val).getValI() == 1 && (operator.equals("+") || operator.equals("-"))) {
            sb.append(operator);
            sb.append(operator);
            return true;
        }
        spacer.addSpace(sb);
        sb.append(operator);
        sb.append("=");
        spacer.addSpace(sb);
        val.prettyPrint(spacer, sb, indent);
        return true;
    }

    public static void prettyPrint(StmtSet e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        e.getUpdatedExpr().prettyPrint(spacer, sb, indent);
        boolean shortened = PrettyPrinter.printAssignmentShorthands(e.getUpdatedExpr(), e.getRight(), spacer, sb, indent);
        if (!shortened) {
            spacer.addSpace(sb);
            sb.append("=");
            spacer.addSpace(sb);
            e.getRight().prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
    }

    public static void prettyPrint(StmtSkip e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("skip");
        sb.append("\n");
    }

    public static void prettyPrint(StmtWhile e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("while");
        spacer.addSpace(sb);
        e.getCond().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        e.getBody().prettyPrint(spacer, sb, indent + 1);
    }

    public static void prettyPrint(SwitchCase e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("case");
        spacer.addSpace(sb);
        e.getExpressions().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        e.getStmts().prettyPrint(spacer, sb, indent + 1);
    }

    public static void prettyPrint(SwitchCases sw, Spacer spacer, StringBuilder sb, int indent) {
        for (SwitchCase c : sw) {
            c.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(SwitchDefaultCaseStatements e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("default");
        sb.append("\n");
        e.getStmts().prettyPrint(spacer, sb, indent + 1);
    }

    public static void prettyPrint(SwitchStmt sw, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append("switch");
        spacer.addSpace(sb);
        sw.getExpr().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        sw.getCases().prettyPrint(spacer, sb, indent + 1);
        sw.getSwitchDefault().prettyPrint(spacer, sb, indent + 1);
    }

    public static void prettyPrint(TopLevelDeclarations e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(TupleDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printStuff(e, spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("tuple");
        spacer.addSpace(sb);
        e.getNameId().prettyPrint(spacer, sb, indent);
        e.getParameters().prettyPrint(spacer, sb, indent);
        sb.append("\n");
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(TypeExprArray e, Spacer spacer, StringBuilder sb, int indent) {
        e.getBase().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("array");
    }

    public static void prettyPrint(TypeExprList typeExprList, Spacer spacer, StringBuilder sb, int indent) {
        if (typeExprList.size() == 0) {
            return;
        }
        sb.append("<");
        PrettyPrinter.commaSeparatedList(typeExprList, spacer, sb, indent);
        sb.append(">");
    }

    public static void prettyPrint(TypeExprResolved e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(TypeExprSimple e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(e.getTypeName());
        e.getTypeArgs().prettyPrint(spacer, sb, indent);
    }

    public static void prettyPrint(TypeExprThis e, Spacer spacer, StringBuilder sb, int indent) {
        if (!(e.getScopeType() instanceof NoTypeExpr)) {
            e.getScopeType().prettyPrint(spacer, sb, indent);
            sb.append(".");
        }
        sb.append("thistype");
    }

    public static void prettyPrint(TypeParamDef e, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printCommentsBefore(sb, e, indent);
        e.getNameId().prettyPrint(spacer, sb, indent);
        PrettyPrinter.printCommentsAfter(sb, e, indent);
    }

    public static void prettyPrint(TypeParamDefs e, Spacer spacer, StringBuilder sb, int indent) {
        if (e.size() >= 1) {
            sb.append("<");
            PrettyPrinter.commaSeparatedList(e, spacer, sb, indent);
            sb.append(">");
        }
    }

    public static void prettyPrint(VisibilityDefault e, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(VisibilityPrivate e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("private");
    }

    public static void prettyPrint(VisibilityProtected e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("protected");
    }

    public static void prettyPrint(VisibilityPublic e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("public");
    }

    public static void prettyPrint(VisibilityPublicread e, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("publicread");
    }

    public static void prettyPrint(WBlock wBlock, Spacer spacer, StringBuilder sb, int indent) {
        throw new Error("not implemented");
    }

    public static void prettyPrint(WEntities wEntities, Spacer spacer, StringBuilder sb, int indent) {
        for (WEntity entity : wEntities) {
            entity.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(WImport wImport, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("import");
        spacer.addSpace(sb);
        sb.append(wImport.getIsInitLater() ? "initlater" : "");
        spacer.addSpace(sb);
        sb.append(wImport.getIsPublic() ? "public" : "");
        spacer.addSpace(sb);
        sb.append(wImport.getPackagename());
        sb.append("\n");
    }

    public static void prettyPrint(WurstModel wurstModel, Spacer spacer, StringBuilder sb, int indent) {
        for (CompilationUnit compilationUnit : wurstModel) {
            compilationUnit.prettyPrint(spacer, sb, indent);
        }
    }

    private static String spaces(int indentation) {
        return " {" + indentation + "}";
    }

    public static void prettyPrint(WurstDoc wurstDoc, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent);
        sb.append(wurstDoc.getRawComment());
        sb.append("\n");
    }

    public static void prettyPrint(WStatements wStatements, Spacer spacer, StringBuilder sb, int indent) {
        for (WStatement wStatement : wStatements) {
            wStatement.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(WParameters wParameters, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("(");
        String prefix = "";
        for (WParameter wParameter : wParameters) {
            sb.append(prefix);
            prefix = ",";
            spacer.addSpace(sb);
            wParameter.prettyPrint(spacer, sb, indent);
        }
        sb.append(")");
    }

    public static void prettyPrint(WShortParameters wParameters, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("(");
        String prefix = "";
        for (WShortParameter wParameter : wParameters) {
            sb.append(prefix);
            prefix = ",";
            spacer.addSpace(sb);
            wParameter.prettyPrint(spacer, sb, indent);
        }
        sb.append(")");
    }

    public static void prettyPrint(WParameter wParameter, Spacer spacer, StringBuilder sb, int indent) {
        wParameter.getTyp().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append(wParameter.getName());
    }

    public static void prettyPrint(WShortParameter wParameter, Spacer spacer, StringBuilder sb, int indent) {
        OptTypeExpr t = wParameter.getTypOpt();
        if (t instanceof TypeExpr) {
            t.prettyPrint(spacer, sb, indent);
            spacer.addSpace(sb);
        }
        sb.append(wParameter.getName());
    }

    public static void prettyPrint(WPackages wPackages, Spacer spacer, StringBuilder sb, int indent) {
        for (WPackage wPackage : wPackages) {
            wPackage.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(WPackage wPackage, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printCommentsBefore(sb, wPackage, indent);
        sb.append("package");
        spacer.addSpace(sb);
        sb.append(wPackage.getName());
        sb.append("\n\n");
        wPackage.getImports().prettyPrint(spacer, sb, indent);
        wPackage.getElements().prettyPrint(spacer, sb, indent);
        PrettyPrinter.printCommentsAfter(sb, wPackage, indent);
    }

    public static void prettyPrint(WImports wImports, Spacer spacer, StringBuilder sb, int indent) {
        if (wImports.size() <= 0) {
            return;
        }
        for (WImport wImport : wImports) {
            if (wImport.getPackagename().equals("Wurst")) continue;
            wImport.prettyPrint(spacer, sb, indent);
        }
        sb.append("\n");
    }

    public static void prettyPrint(ClassDefs classDefs, Spacer spacer, StringBuilder sb, int indent) {
        for (ClassDef classDef : classDefs) {
            classDef.prettyPrint(spacer, sb, indent);
        }
    }

    public static void prettyPrint(Identifier identifier, Spacer spacer, StringBuilder sb, int indent) {
        sb.append(identifier.getName());
    }

    public static void prettyPrint(ExprIfElse e, Spacer spacer, StringBuilder sb, int indent) {
        boolean shouldBracket = e.getParent() instanceof ExprBinary;
        if (shouldBracket) {
            sb.append("(");
        }
        e.getCond().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append("?");
        spacer.addSpace(sb);
        e.getIfTrue().prettyPrint(spacer, sb, indent);
        spacer.addSpace(sb);
        sb.append(":");
        spacer.addSpace(sb);
        e.getIfFalse().prettyPrint(spacer, sb, indent);
        if (shouldBracket) {
            sb.append(")");
        }
    }

    public static void prettyPrint(ArrayInitializer arrayInitializer, Spacer spacer, StringBuilder sb, int indent) {
        sb.append("[");
        arrayInitializer.getValues().prettyPrint(spacer, sb, indent);
        sb.append("]");
    }

    public static void prettyPrint(NoSuperConstructorCall noSuperConstructorCall, Spacer spacer, StringBuilder sb, int indent) {
    }

    public static void prettyPrint(SomeSuperConstructorCall c, Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.printIndent(sb, indent + 1);
        sb.append("super(");
        c.getSuperArgs().prettyPrint(spacer, sb, indent);
        sb.append(")\n");
    }

    public static void prettyPrint(NoTypeParamConstraints noTypeParamConstraints, Spacer spacer, StringBuilder sb, int indent) {
    }
}

