/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.ast;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.AstElementWithBody;
import de.peeeq.wurstscript.ast.AstElementWithParameters;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.ClassSlot;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Documentable;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.FunctionLike;
import de.peeeq.wurstscript.ast.HasFunctionSignature;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.HasReadVariables;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.SuperConstructorCall;
import de.peeeq.wurstscript.ast.TranslatedToImFunction;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.AttrImportedPackage;
import de.peeeq.wurstscript.attributes.AttrNameDef;
import de.peeeq.wurstscript.attributes.AttrNearest;
import de.peeeq.wurstscript.attributes.AttrPos;
import de.peeeq.wurstscript.attributes.AttrVarDefType;
import de.peeeq.wurstscript.attributes.AttrWurstDoc;
import de.peeeq.wurstscript.attributes.Description;
import de.peeeq.wurstscript.attributes.DescriptionHtml;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.attributes.ErrorHandling;
import de.peeeq.wurstscript.attributes.IsDynamicContext;
import de.peeeq.wurstscript.attributes.ModifiersHelper;
import de.peeeq.wurstscript.attributes.PathDescription;
import de.peeeq.wurstscript.attributes.ReadVariables;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.attributes.SubClasses;
import de.peeeq.wurstscript.attributes.UsedPackages;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.NameLinks;
import de.peeeq.wurstscript.attributes.names.NameResolution;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.names.TypeLink;
import de.peeeq.wurstscript.attributes.names.TypeNameLinks;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyPrinter;
import de.peeeq.wurstscript.attributes.prettyPrint.Spacer;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imtranslation.FuncSkeleton;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.WurstType;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

class ConstructorDefImpl
implements ConstructorDef {
    private Element parent;
    private WPos source;
    private Modifiers modifiers;
    private WParameters parameters;
    private SuperConstructorCall superConstructorCall;
    private WStatements body;
    private int zzattr_attrReadVariables_state = 0;
    private ImmutableList<NameDef> zzattr_attrReadVariables_cache;
    private int zzattr_attrReturnType_state = 0;
    private WurstType zzattr_attrReturnType_cache;
    private int zzattr_attrNextScope_state = 0;
    private @Nullable WScope zzattr_attrNextScope_cache;
    private int zzattr_attrSuperConstructor_state = 0;
    private ConstructorDef zzattr_attrSuperConstructor_cache;
    private int zzattr_attrNameLinks_state = 0;
    private ImmutableMultimap<String, DefLink> zzattr_attrNameLinks_cache;
    private int zzattr_attrTypeNameLinks_state = 0;
    private ImmutableMultimap<String, TypeLink> zzattr_attrTypeNameLinks_cache;

    ConstructorDefImpl(WPos source, Modifiers modifiers, WParameters parameters, SuperConstructorCall superConstructorCall, WStatements body) {
        if (source == null) {
            throw new IllegalArgumentException("Element source must not be null.");
        }
        if (modifiers == null) {
            throw new IllegalArgumentException("Element modifiers must not be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Element parameters must not be null.");
        }
        if (superConstructorCall == null) {
            throw new IllegalArgumentException("Element superConstructorCall must not be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Element body must not be null.");
        }
        this.source = source;
        this.modifiers = modifiers;
        this.parameters = parameters;
        this.superConstructorCall = superConstructorCall;
        this.body = body;
        modifiers.setParent(this);
        parameters.setParent(this);
        superConstructorCall.setParent(this);
        body.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setSource(WPos source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
    }

    @Override
    public WPos getSource() {
        return this.source;
    }

    @Override
    public void setModifiers(Modifiers modifiers) {
        if (modifiers == null) {
            throw new IllegalArgumentException();
        }
        this.modifiers.setParent(null);
        modifiers.setParent(this);
        this.modifiers = modifiers;
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public void setParameters(WParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        this.parameters.setParent(null);
        parameters.setParent(this);
        this.parameters = parameters;
    }

    @Override
    public WParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setSuperConstructorCall(SuperConstructorCall superConstructorCall) {
        if (superConstructorCall == null) {
            throw new IllegalArgumentException();
        }
        this.superConstructorCall.setParent(null);
        superConstructorCall.setParent(this);
        this.superConstructorCall = superConstructorCall;
    }

    @Override
    public SuperConstructorCall getSuperConstructorCall() {
        return this.superConstructorCall;
    }

    @Override
    public void setBody(WStatements body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this.body.setParent(null);
        body.setParent(this);
        this.body = body;
    }

    @Override
    public WStatements getBody() {
        return this.body;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.parameters;
            }
            case 2: {
                return this.superConstructorCall;
            }
            case 3: {
                return this.body;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                Modifiers oldElem = this.modifiers;
                this.setModifiers((Modifiers)newElem);
                return oldElem;
            }
            case 1: {
                WParameters oldElem = this.parameters;
                this.setParameters((WParameters)newElem);
                return oldElem;
            }
            case 2: {
                SuperConstructorCall oldElem = this.superConstructorCall;
                this.setSuperConstructorCall((SuperConstructorCall)newElem);
                return oldElem;
            }
            case 3: {
                WStatements oldElem = this.body;
                this.setBody((WStatements)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.modifiers);
        action.accept(this.parameters);
        action.accept(this.superConstructorCall);
        action.accept(this.body);
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public ConstructorDef copy() {
        ConstructorDefImpl result = new ConstructorDefImpl(this.source, this.modifiers.copy(), this.parameters.copy(), this.superConstructorCall.copy(), this.body.copy());
        return result;
    }

    @Override
    public ConstructorDef copyWithRefs() {
        ConstructorDef res = this.copy();
        return res;
    }

    @Override
    public void clearAttributes() {
        this.modifiers.clearAttributes();
        this.parameters.clearAttributes();
        this.superConstructorCall.clearAttributes();
        this.body.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
        this.zzattr_attrReadVariables_state = 0;
        this.zzattr_attrReturnType_state = 0;
        this.zzattr_attrNextScope_state = 0;
        this.zzattr_attrSuperConstructor_state = 0;
        this.zzattr_attrNameLinks_state = 0;
        this.zzattr_attrTypeNameLinks_state = 0;
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(AstElementWithParameters.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(AstElementWithParameters.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(ClassSlot.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(ClassSlot.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(TranslatedToImFunction.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(TranslatedToImFunction.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(HasModifier.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(HasModifier.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(HasReadVariables.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(HasReadVariables.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(Documentable.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(Documentable.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(WScope.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(WScope.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(FunctionLike.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(FunctionLike.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(AstElementWithBody.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(AstElementWithBody.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(AstElementWithSource.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(AstElementWithSource.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    @Override
    public <T> T match(HasFunctionSignature.Matcher<T> matcher) {
        return matcher.case_ConstructorDef(this);
    }

    @Override
    public void match(HasFunctionSignature.MatcherVoid matcher) {
        matcher.case_ConstructorDef(this);
    }

    public String toString() {
        return "ConstructorDef(" + this.source + ", " + this.modifiers + ", " + this.parameters + ", " + this.superConstructorCall + ", " + this.body + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof ConstructorDef) {
            ConstructorDef o = (ConstructorDef)e;
            return this.modifiers.structuralEquals(o.getModifiers()) && this.parameters.structuralEquals(o.getParameters()) && this.superConstructorCall.structuralEquals(o.getSuperConstructorCall()) && this.body.structuralEquals(o.getBody());
        }
        return false;
    }

    @Override
    public ImmutableList<NameDef> attrReadVariables() {
        if (this.zzattr_attrReadVariables_state == 0) {
            try {
                this.zzattr_attrReadVariables_state = 1;
                this.zzattr_attrReadVariables_cache = ReadVariables.calculate(this);
            }
            finally {
                this.zzattr_attrReadVariables_state = 0;
            }
            this.zzattr_attrReadVariables_state = 2;
        } else if (this.zzattr_attrReadVariables_state == 1) {
            throw new CyclicDependencyError(this, "attrReadVariables");
        }
        return this.zzattr_attrReadVariables_cache;
    }

    @Override
    public WurstType attrReturnType() {
        if (this.zzattr_attrReturnType_state == 0) {
            try {
                this.zzattr_attrReturnType_state = 1;
                this.zzattr_attrReturnType_cache = AttrVarDefType.calculate(this);
            }
            finally {
                this.zzattr_attrReturnType_state = 0;
            }
            this.zzattr_attrReturnType_state = 2;
        } else if (this.zzattr_attrReturnType_state == 1) {
            throw new CyclicDependencyError(this, "attrReturnType");
        }
        return this.zzattr_attrReturnType_cache;
    }

    @Override
    public boolean attrIsDynamicContext() {
        return IsDynamicContext.calculate(this);
    }

    @Override
    public @Nullable PackageOrGlobal attrNearestPackage() {
        return AttrNearest.nearestPackage(this);
    }

    @Override
    public @Nullable NamedScope attrNearestNamedScope() {
        return AttrNearest.nearestNamedScope(this);
    }

    @Override
    public @Nullable WScope attrNearestScope() {
        return AttrNearest.nearestScope(this);
    }

    @Override
    public @Nullable WScope attrNextScope() {
        if (this.zzattr_attrNextScope_state == 0) {
            try {
                this.zzattr_attrNextScope_state = 1;
                this.zzattr_attrNextScope_cache = AttrNearest.nextScope(this);
            }
            finally {
                this.zzattr_attrNextScope_state = 0;
            }
            this.zzattr_attrNextScope_state = 2;
        } else if (this.zzattr_attrNextScope_state == 1) {
            throw new CyclicDependencyError(this, "attrNextScope");
        }
        return this.zzattr_attrNextScope_cache;
    }

    @Override
    public String attrPathDescription() {
        return PathDescription.get(this);
    }

    @Override
    public CompilationUnit attrCompilationUnit() {
        return AttrNearest.nearestCompilationUnit(this);
    }

    @Override
    public @Nullable ClassDef attrNearestClassDef() {
        return AttrNearest.nearestClassDef(this);
    }

    @Override
    public @Nullable ClassOrInterface attrNearestClassOrInterface() {
        return AttrNearest.nearestClassOrInterface(this);
    }

    @Override
    public @Nullable ClassOrModule attrNearestClassOrModule() {
        return AttrNearest.nearestClassOrModule(this);
    }

    @Override
    public @Nullable StructureDef attrNearestStructureDef() {
        return AttrNearest.nearestStructureDef(this);
    }

    @Override
    public @Nullable FunctionImplementation attrNearestFuncDef() {
        return AttrNearest.nearestFuncDef(this);
    }

    @Override
    public @Nullable ExprClosure attrNearestExprClosure() {
        return AttrNearest.nearestExprClosure(this);
    }

    @Override
    public @Nullable ExprStatementsBlock attrNearestExprStatementsBlock() {
        return AttrNearest.nearestExprStatementsBlock(this);
    }

    @Override
    public @Nullable NameDef tryGetNameDef() {
        return AttrNameDef.tryGetNameDef(this);
    }

    @Override
    public boolean attrIsCompiletime() {
        return ModifiersHelper.isCompiletime(this);
    }

    @Override
    public boolean attrHasAnnotation(String name) {
        return ModifiersHelper.hasAnnotation(this, name);
    }

    @Override
    public Annotation attrGetAnnotation(String name) {
        return ModifiersHelper.getAnnotation(this, name);
    }

    @Override
    public boolean attrIsPublic() {
        return ModifiersHelper.isPublic(this);
    }

    @Override
    public boolean attrIsPublicRead() {
        return ModifiersHelper.isPublicRead(this);
    }

    @Override
    public boolean attrIsPrivate() {
        return ModifiersHelper.isPrivate(this);
    }

    @Override
    public boolean attrIsProtected() {
        return ModifiersHelper.isProtected(this);
    }

    @Override
    public boolean attrIsStatic() {
        return ModifiersHelper.isStatic(this);
    }

    @Override
    public boolean attrIsOverride() {
        return ModifiersHelper.isOverride(this);
    }

    @Override
    public boolean attrIsAbstract() {
        return ModifiersHelper.isAbstract(this);
    }

    @Override
    public boolean attrIsConstant() {
        return ModifiersHelper.isConstant(this);
    }

    @Override
    public boolean attrIsVararg() {
        return ModifiersHelper.isVararg(this);
    }

    @Override
    public WPos attrSource() {
        return AttrPos.getPos(this);
    }

    @Override
    public WPos attrErrorPos() {
        return AttrPos.getErrorPos(this);
    }

    @Override
    public ConstructorDef attrSuperConstructor() {
        if (this.zzattr_attrSuperConstructor_state == 0) {
            try {
                this.zzattr_attrSuperConstructor_state = 1;
                this.zzattr_attrSuperConstructor_cache = SubClasses.getSuperConstructor(this);
            }
            finally {
                this.zzattr_attrSuperConstructor_state = 0;
            }
            this.zzattr_attrSuperConstructor_state = 2;
        } else if (this.zzattr_attrSuperConstructor_state == 1) {
            throw new CyclicDependencyError(this, "attrSuperConstructor");
        }
        return this.zzattr_attrSuperConstructor_cache;
    }

    @Override
    public WurstModel getModel() {
        return AttrImportedPackage.getModel(this);
    }

    @Override
    public void imCreateFuncSkeleton(ImTranslator translator, ImFunction f) {
        FuncSkeleton.create(this, translator, f);
    }

    @Override
    public void addError(String msg) {
        ErrorHandling.addError(this, msg);
    }

    @Override
    public void addWarning(String msg) {
        ErrorHandling.addWarning(this, msg);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return ErrorHandling.getErrorHandler(this);
    }

    @Override
    public boolean attrHasEmptyBody() {
        return SmallHelpers.hasEmptyBody(this);
    }

    @Override
    public ImmutableMultimap<String, DefLink> attrNameLinks() {
        if (this.zzattr_attrNameLinks_state == 0) {
            try {
                this.zzattr_attrNameLinks_state = 1;
                this.zzattr_attrNameLinks_cache = NameLinks.calculate(this);
            }
            finally {
                this.zzattr_attrNameLinks_state = 0;
            }
            this.zzattr_attrNameLinks_state = 2;
        } else if (this.zzattr_attrNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrNameLinks");
        }
        return this.zzattr_attrNameLinks_cache;
    }

    @Override
    public ImmutableMultimap<String, TypeLink> attrTypeNameLinks() {
        if (this.zzattr_attrTypeNameLinks_state == 0) {
            try {
                this.zzattr_attrTypeNameLinks_state = 1;
                this.zzattr_attrTypeNameLinks_cache = TypeNameLinks.calculate(this);
            }
            finally {
                this.zzattr_attrTypeNameLinks_state = 0;
            }
            this.zzattr_attrTypeNameLinks_state = 2;
        } else if (this.zzattr_attrTypeNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrTypeNameLinks");
        }
        return this.zzattr_attrTypeNameLinks_cache;
    }

    @Override
    public @Nullable TypeDef lookupType(String name, boolean showErrors) {
        return NameResolution.lookupType(this, name, showErrors);
    }

    @Override
    public PackageLink lookupPackage(String name, boolean showErrors) {
        return NameResolution.lookupPackage(this, name, showErrors);
    }

    @Override
    public NameLink lookupVar(String name, boolean showErrors) {
        return NameResolution.lookupVar(this, name, showErrors);
    }

    @Override
    public NameLink lookupVarNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupVarNoConfig(this, name, showErrors);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberVar(this, receiverType, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name, boolean showErrors) {
        return NameResolution.lookupFuncs(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncsNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupFuncsNoConfig(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberFuncs(this, receiverType, name, showErrors);
    }

    @Override
    public @Nullable TypeDef lookupType(String name) {
        return NameResolution.lookupTypeShort(this, name);
    }

    @Override
    public PackageLink lookupPackage(String name) {
        return NameResolution.lookupPackageShort(this, name);
    }

    @Override
    public NameLink lookupVar(String name) {
        return NameResolution.lookupVarShort(this, name);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name) {
        return NameResolution.lookupMemberVarShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name) {
        return NameResolution.lookupFuncsShort(this, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name) {
        return NameResolution.lookupMemberFuncsShort(this, receiverType, name);
    }

    @Override
    public String attrComment() {
        return AttrWurstDoc.getComment(this);
    }

    @Override
    public ImmutableCollection<WPackage> attrUsedPackages() {
        return UsedPackages.usedPackages(this);
    }

    @Override
    public String description() {
        return Description.description(this);
    }

    @Override
    public String descriptionHtml() {
        return DescriptionHtml.description(this);
    }

    @Override
    public boolean isSubtreeOf(Element other) {
        return SmallHelpers.isSubtreeOf(this, other);
    }

    @Override
    public void prettyPrint(Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.prettyPrint(this, spacer, sb, indent);
    }
}

