/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import dorkbox.bytes.OptimizeUtilsByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0006J\"\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nJ\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nJ*\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nJ*\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00102\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldorkbox/bytes/OptimizeUtilsByteArray;", "", "()V", "version", "", "canReadInt", "", "buffer", "", "position", "", "canReadLong", "intLength", "value", "optimizePositive", "longLength", "", "readInt", "readLong", "writeInt", "writeLong", "ByteUtilities"})
public final class OptimizeUtilsByteArray {
    @NotNull
    public static final OptimizeUtilsByteArray INSTANCE = new OptimizeUtilsByteArray();
    @NotNull
    public static final String version = "2.0";

    private OptimizeUtilsByteArray() {
    }

    public final int intLength(int value, boolean optimizePositive) {
        return OptimizeUtilsByteBuf.INSTANCE.intLength(value, optimizePositive);
    }

    public final boolean canReadInt(@NotNull byte[] buffer, int position) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position2 = position;
        int length = buffer.length;
        if (length >= 5) {
            return true;
        }
        if (position2 + 1 > length) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == length) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == length) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == length) {
            return false;
        }
        return (buffer[position2++] & 0x80) == 0 ? true : position2 != length;
    }

    public static /* synthetic */ boolean canReadInt$default(OptimizeUtilsByteArray optimizeUtilsByteArray, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return optimizeUtilsByteArray.canReadInt(byArray, n);
    }

    public final int readInt(@NotNull byte[] buffer, int position) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.readInt(buffer, false, position);
    }

    public final int readInt(@NotNull byte[] buffer, boolean optimizePositive, int position) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position2 = position;
        byte b = buffer[position2++];
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer[position2++];
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer[position2++];
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer[position2++];
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer[position2++];
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public static /* synthetic */ int readInt$default(OptimizeUtilsByteArray optimizeUtilsByteArray, byte[] byArray, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return optimizeUtilsByteArray.readInt(byArray, bl, n);
    }

    public final int writeInt(@NotNull byte[] buffer, int value, boolean optimizePositive, int position) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int value2 = value;
        int position2 = position;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        if (value2 >>> 7 == 0) {
            buffer[position2++] = (byte)value2;
            return 1;
        }
        if (value2 >>> 14 == 0) {
            buffer[position2++] = (byte)(value2 & 0x7F | 0x80);
            buffer[position2++] = (byte)(value2 >>> 7);
            return 2;
        }
        if (value2 >>> 21 == 0) {
            buffer[position2++] = (byte)(value2 & 0x7F | 0x80);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80);
            buffer[position2++] = (byte)(value2 >>> 14);
            return 3;
        }
        if (value2 >>> 28 == 0) {
            buffer[position2++] = (byte)(value2 & 0x7F | 0x80);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80);
            buffer[position2++] = (byte)(value2 >>> 14 | 0x80);
            buffer[position2++] = (byte)(value2 >>> 21);
            return 4;
        }
        buffer[position2++] = (byte)(value2 & 0x7F | 0x80);
        buffer[position2++] = (byte)(value2 >>> 7 | 0x80);
        buffer[position2++] = (byte)(value2 >>> 14 | 0x80);
        buffer[position2++] = (byte)(value2 >>> 21 | 0x80);
        buffer[position2++] = (byte)(value2 >>> 28);
        return 5;
    }

    public static /* synthetic */ int writeInt$default(OptimizeUtilsByteArray optimizeUtilsByteArray, byte[] byArray, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return optimizeUtilsByteArray.writeInt(byArray, n, bl, n2);
    }

    public final int longLength(long value, boolean optimizePositive) {
        return OptimizeUtilsByteBuf.longLength(value, optimizePositive);
    }

    public final long readLong(@NotNull byte[] buffer, boolean optimizePositive, int position) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position2 = position;
        byte b = buffer[position2++];
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer[position2++];
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer[position2++];
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer[position2++];
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer[position2++];
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer[position2++];
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer[position2++];
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer[position2++];
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer[position2++];
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result = result >>> 1 ^ -(result & 1L);
        }
        return result;
    }

    public static /* synthetic */ long readLong$default(OptimizeUtilsByteArray optimizeUtilsByteArray, byte[] byArray, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return optimizeUtilsByteArray.readLong(byArray, bl, n);
    }

    public final int writeLong(@NotNull byte[] buffer, long value, boolean optimizePositive, int position) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long value2 = value;
        int position2 = position;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 63;
        }
        if (value2 >>> 7 == 0L) {
            buffer[position2++] = (byte)value2;
            return 1;
        }
        if (value2 >>> 14 == 0L) {
            buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 7);
            return 2;
        }
        if (value2 >>> 21 == 0L) {
            buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 14);
            return 3;
        }
        if (value2 >>> 28 == 0L) {
            buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 14 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 21);
            return 4;
        }
        if (value2 >>> 35 == 0L) {
            buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 14 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 21 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 28);
            return 5;
        }
        if (value2 >>> 42 == 0L) {
            buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 14 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 21 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 28 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 35);
            return 6;
        }
        if (value2 >>> 49 == 0L) {
            buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 14 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 21 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 28 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 35 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 42);
            return 7;
        }
        if (value2 >>> 56 == 0L) {
            buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 7 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 14 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 21 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 28 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 35 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 42 | 0x80L);
            buffer[position2++] = (byte)(value2 >>> 49);
            return 8;
        }
        buffer[position2++] = (byte)(value2 & 0x7FL | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 7 | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 14 | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 21 | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 28 | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 35 | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 42 | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 49 | 0x80L);
        buffer[position2++] = (byte)(value2 >>> 56);
        return 9;
    }

    public static /* synthetic */ int writeLong$default(OptimizeUtilsByteArray optimizeUtilsByteArray, byte[] byArray, long l, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return optimizeUtilsByteArray.writeLong(byArray, l, bl, n);
    }

    public final boolean canReadLong(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position = 0;
        return this.canReadLong(buffer, position);
    }

    private final boolean canReadLong(byte[] buffer, int position) {
        int position2 = position;
        int limit = buffer.length;
        if (limit >= 9) {
            return true;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == limit) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == limit) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == limit) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == limit) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == limit) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == limit) {
            return false;
        }
        if ((buffer[position2++] & 0x80) == 0) {
            return true;
        }
        if (position2 == limit) {
            return false;
        }
        return (buffer[position2++] & 0x80) == 0 ? true : position2 != limit;
    }
}

