/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.ast;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.AstElementWithNameId;
import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Documentable;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.HasReadVariables;
import de.peeeq.wurstscript.ast.Identifier;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TopLevelDeclaration;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.WEntities;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.AttrImportedPackage;
import de.peeeq.wurstscript.attributes.AttrNameDef;
import de.peeeq.wurstscript.attributes.AttrNearest;
import de.peeeq.wurstscript.attributes.AttrPos;
import de.peeeq.wurstscript.attributes.AttrVarDefType;
import de.peeeq.wurstscript.attributes.AttrWurstDoc;
import de.peeeq.wurstscript.attributes.CofigActualDef;
import de.peeeq.wurstscript.attributes.Description;
import de.peeeq.wurstscript.attributes.DescriptionHtml;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.attributes.ErrorHandling;
import de.peeeq.wurstscript.attributes.HasAnnotation;
import de.peeeq.wurstscript.attributes.InitOrder;
import de.peeeq.wurstscript.attributes.IsDynamicContext;
import de.peeeq.wurstscript.attributes.ModifiersHelper;
import de.peeeq.wurstscript.attributes.PathDescription;
import de.peeeq.wurstscript.attributes.ReadVariables;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.attributes.UsedPackages;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.Exports;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.NameLinks;
import de.peeeq.wurstscript.attributes.names.NameResolution;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.names.TypeLink;
import de.peeeq.wurstscript.attributes.names.TypeNameLinks;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyPrinter;
import de.peeeq.wurstscript.attributes.prettyPrint.Spacer;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.TLDTranslation;
import de.peeeq.wurstscript.types.WurstType;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

class WPackageImpl
implements WPackage {
    private Element parent;
    private WPos source;
    private Modifiers modifiers;
    private Identifier nameId;
    private WImports imports;
    private WEntities elements;
    private int zzattr_attrReadVariables_state = 0;
    private ImmutableList<NameDef> zzattr_attrReadVariables_cache;
    private int zzattr_attrTyp_state = 0;
    private WurstType zzattr_attrTyp_cache;
    private int zzattr_attrNextScope_state = 0;
    private @Nullable WScope zzattr_attrNextScope_cache;
    private int zzattr_attrConfigActualNameDef_state = 0;
    private NameDef zzattr_attrConfigActualNameDef_cache;
    private int zzattr_attrNameLinks_state = 0;
    private ImmutableMultimap<String, DefLink> zzattr_attrNameLinks_cache;
    private int zzattr_attrTypeNameLinks_state = 0;
    private ImmutableMultimap<String, TypeLink> zzattr_attrTypeNameLinks_cache;
    private int zzattr_attrExportedNameLinks_state = 0;
    private ImmutableMultimap<String, DefLink> zzattr_attrExportedNameLinks_cache;
    private int zzattr_attrExportedTypeNameLinks_state = 0;
    private ImmutableMultimap<String, TypeLink> zzattr_attrExportedTypeNameLinks_cache;
    private int zzattr_attrImportedPackagesTransitive_state = 0;
    private ImmutableCollection<WPackage> zzattr_attrImportedPackagesTransitive_cache;
    private int zzattr_attrInitDependencies_state = 0;
    private com.google.common.collect.ImmutableList<WPackage> zzattr_attrInitDependencies_cache;
    private int zzattr_attrInitDependenciesTransitive_state = 0;
    private com.google.common.collect.ImmutableList<WPackage> zzattr_attrInitDependenciesTransitive_cache;

    WPackageImpl(WPos source, Modifiers modifiers, Identifier nameId, WImports imports, WEntities elements) {
        if (source == null) {
            throw new IllegalArgumentException("Element source must not be null.");
        }
        if (modifiers == null) {
            throw new IllegalArgumentException("Element modifiers must not be null.");
        }
        if (nameId == null) {
            throw new IllegalArgumentException("Element nameId must not be null.");
        }
        if (imports == null) {
            throw new IllegalArgumentException("Element imports must not be null.");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Element elements must not be null.");
        }
        this.source = source;
        this.modifiers = modifiers;
        this.nameId = nameId;
        this.imports = imports;
        this.elements = elements;
        modifiers.setParent(this);
        nameId.setParent(this);
        imports.setParent(this);
        elements.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setSource(WPos source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
    }

    @Override
    public WPos getSource() {
        return this.source;
    }

    @Override
    public void setModifiers(Modifiers modifiers) {
        if (modifiers == null) {
            throw new IllegalArgumentException();
        }
        this.modifiers.setParent(null);
        modifiers.setParent(this);
        this.modifiers = modifiers;
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public void setNameId(Identifier nameId) {
        if (nameId == null) {
            throw new IllegalArgumentException();
        }
        this.nameId.setParent(null);
        nameId.setParent(this);
        this.nameId = nameId;
    }

    @Override
    public Identifier getNameId() {
        return this.nameId;
    }

    @Override
    public void setImports(WImports imports) {
        if (imports == null) {
            throw new IllegalArgumentException();
        }
        this.imports.setParent(null);
        imports.setParent(this);
        this.imports = imports;
    }

    @Override
    public WImports getImports() {
        return this.imports;
    }

    @Override
    public void setElements(WEntities elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        this.elements.setParent(null);
        elements.setParent(this);
        this.elements = elements;
    }

    @Override
    public WEntities getElements() {
        return this.elements;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.nameId;
            }
            case 2: {
                return this.imports;
            }
            case 3: {
                return this.elements;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                Modifiers oldElem = this.modifiers;
                this.setModifiers((Modifiers)newElem);
                return oldElem;
            }
            case 1: {
                Identifier oldElem = this.nameId;
                this.setNameId((Identifier)newElem);
                return oldElem;
            }
            case 2: {
                WImports oldElem = this.imports;
                this.setImports((WImports)newElem);
                return oldElem;
            }
            case 3: {
                WEntities oldElem = this.elements;
                this.setElements((WEntities)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.modifiers);
        action.accept(this.nameId);
        action.accept(this.imports);
        action.accept(this.elements);
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public WPackage copy() {
        WPackageImpl result = new WPackageImpl(this.source, this.modifiers.copy(), this.nameId.copy(), this.imports.copy(), this.elements.copy());
        return result;
    }

    @Override
    public WPackage copyWithRefs() {
        WPackage res = this.copy();
        return res;
    }

    @Override
    public void clearAttributes() {
        this.modifiers.clearAttributes();
        this.nameId.clearAttributes();
        this.imports.clearAttributes();
        this.elements.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
        this.zzattr_attrReadVariables_state = 0;
        this.zzattr_attrTyp_state = 0;
        this.zzattr_attrNextScope_state = 0;
        this.zzattr_attrConfigActualNameDef_state = 0;
        this.zzattr_attrNameLinks_state = 0;
        this.zzattr_attrTypeNameLinks_state = 0;
        this.zzattr_attrExportedNameLinks_state = 0;
        this.zzattr_attrExportedTypeNameLinks_state = 0;
        this.zzattr_attrImportedPackagesTransitive_state = 0;
        this.zzattr_attrInitDependencies_state = 0;
        this.zzattr_attrInitDependenciesTransitive_state = 0;
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(HasModifier.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(HasModifier.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(HasReadVariables.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(HasReadVariables.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(Documentable.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(Documentable.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(NamedScope.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(NamedScope.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(WScope.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(WScope.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(PackageOrGlobal.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(PackageOrGlobal.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(TopLevelDeclaration.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(TopLevelDeclaration.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(NameDef.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(NameDef.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(AstElementWithSource.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(AstElementWithSource.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    @Override
    public <T> T match(AstElementWithNameId.Matcher<T> matcher) {
        return matcher.case_WPackage(this);
    }

    @Override
    public void match(AstElementWithNameId.MatcherVoid matcher) {
        matcher.case_WPackage(this);
    }

    public String toString() {
        return "WPackage(" + this.source + ", " + this.modifiers + ", " + this.nameId + ", " + this.imports + ", " + this.elements + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof WPackage) {
            WPackage o = (WPackage)e;
            return this.modifiers.structuralEquals(o.getModifiers()) && this.nameId.structuralEquals(o.getNameId()) && this.imports.structuralEquals(o.getImports()) && this.elements.structuralEquals(o.getElements());
        }
        return false;
    }

    @Override
    public ImmutableList<NameDef> attrReadVariables() {
        if (this.zzattr_attrReadVariables_state == 0) {
            try {
                this.zzattr_attrReadVariables_state = 1;
                this.zzattr_attrReadVariables_cache = ReadVariables.calculate(this);
            }
            finally {
                this.zzattr_attrReadVariables_state = 0;
            }
            this.zzattr_attrReadVariables_state = 2;
        } else if (this.zzattr_attrReadVariables_state == 1) {
            throw new CyclicDependencyError(this, "attrReadVariables");
        }
        return this.zzattr_attrReadVariables_cache;
    }

    @Override
    public WurstType attrTyp() {
        if (this.zzattr_attrTyp_state == 0) {
            try {
                this.zzattr_attrTyp_state = 1;
                this.zzattr_attrTyp_cache = AttrVarDefType.calculate(this);
            }
            finally {
                this.zzattr_attrTyp_state = 0;
            }
            this.zzattr_attrTyp_state = 2;
        } else if (this.zzattr_attrTyp_state == 1) {
            throw new CyclicDependencyError(this, "attrTyp");
        }
        return this.zzattr_attrTyp_cache;
    }

    @Override
    public boolean attrIsDynamicContext() {
        return IsDynamicContext.calculate(this);
    }

    @Override
    public @Nullable PackageOrGlobal attrNearestPackage() {
        return AttrNearest.nearestPackage(this);
    }

    @Override
    public @Nullable NamedScope attrNearestNamedScope() {
        return AttrNearest.nearestNamedScope(this);
    }

    @Override
    public @Nullable WScope attrNearestScope() {
        return AttrNearest.nearestScope(this);
    }

    @Override
    public @Nullable WScope attrNextScope() {
        if (this.zzattr_attrNextScope_state == 0) {
            try {
                this.zzattr_attrNextScope_state = 1;
                this.zzattr_attrNextScope_cache = AttrNearest.nextScope(this);
            }
            finally {
                this.zzattr_attrNextScope_state = 0;
            }
            this.zzattr_attrNextScope_state = 2;
        } else if (this.zzattr_attrNextScope_state == 1) {
            throw new CyclicDependencyError(this, "attrNextScope");
        }
        return this.zzattr_attrNextScope_cache;
    }

    @Override
    public String attrPathDescription() {
        return PathDescription.get(this);
    }

    @Override
    public CompilationUnit attrCompilationUnit() {
        return AttrNearest.nearestCompilationUnit(this);
    }

    @Override
    public @Nullable ClassDef attrNearestClassDef() {
        return AttrNearest.nearestClassDef(this);
    }

    @Override
    public @Nullable ClassOrInterface attrNearestClassOrInterface() {
        return AttrNearest.nearestClassOrInterface(this);
    }

    @Override
    public @Nullable ClassOrModule attrNearestClassOrModule() {
        return AttrNearest.nearestClassOrModule(this);
    }

    @Override
    public @Nullable StructureDef attrNearestStructureDef() {
        return AttrNearest.nearestStructureDef(this);
    }

    @Override
    public @Nullable FunctionImplementation attrNearestFuncDef() {
        return AttrNearest.nearestFuncDef(this);
    }

    @Override
    public @Nullable ExprClosure attrNearestExprClosure() {
        return AttrNearest.nearestExprClosure(this);
    }

    @Override
    public @Nullable ExprStatementsBlock attrNearestExprStatementsBlock() {
        return AttrNearest.nearestExprStatementsBlock(this);
    }

    @Override
    public @Nullable NameDef tryGetNameDef() {
        return AttrNameDef.tryGetNameDef(this);
    }

    @Override
    public boolean attrIsCompiletime() {
        return ModifiersHelper.isCompiletime(this);
    }

    @Override
    public boolean attrHasAnnotation(String name) {
        return ModifiersHelper.hasAnnotation(this, name);
    }

    @Override
    public Annotation attrGetAnnotation(String name) {
        return ModifiersHelper.getAnnotation(this, name);
    }

    @Override
    public boolean attrIsPublic() {
        return ModifiersHelper.isPublic(this);
    }

    @Override
    public boolean attrIsPublicRead() {
        return ModifiersHelper.isPublicRead(this);
    }

    @Override
    public boolean attrIsPrivate() {
        return ModifiersHelper.isPrivate(this);
    }

    @Override
    public boolean attrIsProtected() {
        return ModifiersHelper.isProtected(this);
    }

    @Override
    public boolean attrIsStatic() {
        return ModifiersHelper.isStatic(this);
    }

    @Override
    public boolean attrIsOverride() {
        return ModifiersHelper.isOverride(this);
    }

    @Override
    public boolean attrIsAbstract() {
        return ModifiersHelper.isAbstract(this);
    }

    @Override
    public boolean attrIsConstant() {
        return ModifiersHelper.isConstant(this);
    }

    @Override
    public boolean attrIsVararg() {
        return ModifiersHelper.isVararg(this);
    }

    @Override
    public WPos attrSource() {
        return AttrPos.getPos(this);
    }

    @Override
    public WPos attrErrorPos() {
        return AttrPos.getErrorPos(this);
    }

    @Override
    public WurstModel getModel() {
        return AttrImportedPackage.getModel(this);
    }

    @Override
    public NameDef attrConfigActualNameDef() {
        if (this.zzattr_attrConfigActualNameDef_state == 0) {
            try {
                this.zzattr_attrConfigActualNameDef_state = 1;
                this.zzattr_attrConfigActualNameDef_cache = CofigActualDef.calculate(this);
            }
            finally {
                this.zzattr_attrConfigActualNameDef_state = 0;
            }
            this.zzattr_attrConfigActualNameDef_state = 2;
        } else if (this.zzattr_attrConfigActualNameDef_state == 1) {
            throw new CyclicDependencyError(this, "attrConfigActualNameDef");
        }
        return this.zzattr_attrConfigActualNameDef_cache;
    }

    @Override
    public boolean hasAnnotation(String annotation) {
        return HasAnnotation.hasAnnotation(this, annotation);
    }

    @Override
    public Annotation getAnnotation(String annotation) {
        return HasAnnotation.getAnnotation(this, annotation);
    }

    @Override
    public void imTranslateTLD(ImTranslator translator) {
        TLDTranslation.translate(this, translator);
    }

    @Override
    public void addError(String msg) {
        ErrorHandling.addError(this, msg);
    }

    @Override
    public void addWarning(String msg) {
        ErrorHandling.addWarning(this, msg);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return ErrorHandling.getErrorHandler(this);
    }

    @Override
    public ImmutableMultimap<String, DefLink> attrNameLinks() {
        if (this.zzattr_attrNameLinks_state == 0) {
            try {
                this.zzattr_attrNameLinks_state = 1;
                this.zzattr_attrNameLinks_cache = NameLinks.calculate(this);
            }
            finally {
                this.zzattr_attrNameLinks_state = 0;
            }
            this.zzattr_attrNameLinks_state = 2;
        } else if (this.zzattr_attrNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrNameLinks");
        }
        return this.zzattr_attrNameLinks_cache;
    }

    @Override
    public ImmutableMultimap<String, TypeLink> attrTypeNameLinks() {
        if (this.zzattr_attrTypeNameLinks_state == 0) {
            try {
                this.zzattr_attrTypeNameLinks_state = 1;
                this.zzattr_attrTypeNameLinks_cache = TypeNameLinks.calculate(this);
            }
            finally {
                this.zzattr_attrTypeNameLinks_state = 0;
            }
            this.zzattr_attrTypeNameLinks_state = 2;
        } else if (this.zzattr_attrTypeNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrTypeNameLinks");
        }
        return this.zzattr_attrTypeNameLinks_cache;
    }

    @Override
    public ImmutableMultimap<String, DefLink> attrExportedNameLinks() {
        if (this.zzattr_attrExportedNameLinks_state == 0) {
            try {
                this.zzattr_attrExportedNameLinks_state = 1;
                this.zzattr_attrExportedNameLinks_cache = Exports.exportedNameLinks(this);
            }
            finally {
                this.zzattr_attrExportedNameLinks_state = 0;
            }
            this.zzattr_attrExportedNameLinks_state = 2;
        } else if (this.zzattr_attrExportedNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrExportedNameLinks");
        }
        return this.zzattr_attrExportedNameLinks_cache;
    }

    @Override
    public ImmutableMultimap<String, TypeLink> attrExportedTypeNameLinks() {
        if (this.zzattr_attrExportedTypeNameLinks_state == 0) {
            try {
                this.zzattr_attrExportedTypeNameLinks_state = 1;
                this.zzattr_attrExportedTypeNameLinks_cache = Exports.exportedTypeNameLinks(this);
            }
            finally {
                this.zzattr_attrExportedTypeNameLinks_state = 0;
            }
            this.zzattr_attrExportedTypeNameLinks_state = 2;
        } else if (this.zzattr_attrExportedTypeNameLinks_state == 1) {
            throw new CyclicDependencyError(this, "attrExportedTypeNameLinks");
        }
        return this.zzattr_attrExportedTypeNameLinks_cache;
    }

    @Override
    public @Nullable TypeDef lookupType(String name, boolean showErrors) {
        return NameResolution.lookupType(this, name, showErrors);
    }

    @Override
    public PackageLink lookupPackage(String name, boolean showErrors) {
        return NameResolution.lookupPackage(this, name, showErrors);
    }

    @Override
    public NameLink lookupVar(String name, boolean showErrors) {
        return NameResolution.lookupVar(this, name, showErrors);
    }

    @Override
    public NameLink lookupVarNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupVarNoConfig(this, name, showErrors);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberVar(this, receiverType, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name, boolean showErrors) {
        return NameResolution.lookupFuncs(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncsNoConfig(String name, boolean showErrors) {
        return NameResolution.lookupFuncsNoConfig(this, name, showErrors);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name, boolean showErrors) {
        return NameResolution.lookupMemberFuncs(this, receiverType, name, showErrors);
    }

    @Override
    public @Nullable TypeDef lookupType(String name) {
        return NameResolution.lookupTypeShort(this, name);
    }

    @Override
    public PackageLink lookupPackage(String name) {
        return NameResolution.lookupPackageShort(this, name);
    }

    @Override
    public NameLink lookupVar(String name) {
        return NameResolution.lookupVarShort(this, name);
    }

    @Override
    public NameLink lookupMemberVar(WurstType receiverType, String name) {
        return NameResolution.lookupMemberVarShort(this, receiverType, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupFuncs(String name) {
        return NameResolution.lookupFuncsShort(this, name);
    }

    @Override
    public ImmutableCollection<FuncLink> lookupMemberFuncs(WurstType receiverType, String name) {
        return NameResolution.lookupMemberFuncsShort(this, receiverType, name);
    }

    @Override
    public String attrComment() {
        return AttrWurstDoc.getComment(this);
    }

    @Override
    public ImmutableCollection<WPackage> attrUsedPackages() {
        return UsedPackages.usedPackages(this);
    }

    @Override
    public ImmutableCollection<WPackage> attrImportedPackagesTransitive() {
        if (this.zzattr_attrImportedPackagesTransitive_state == 0) {
            try {
                this.zzattr_attrImportedPackagesTransitive_state = 1;
                this.zzattr_attrImportedPackagesTransitive_cache = InitOrder.importedPackagesTrans(this);
            }
            finally {
                this.zzattr_attrImportedPackagesTransitive_state = 0;
            }
            this.zzattr_attrImportedPackagesTransitive_state = 2;
        } else if (this.zzattr_attrImportedPackagesTransitive_state == 1) {
            throw new CyclicDependencyError(this, "attrImportedPackagesTransitive");
        }
        return this.zzattr_attrImportedPackagesTransitive_cache;
    }

    @Override
    public com.google.common.collect.ImmutableList<WPackage> attrInitDependencies() {
        if (this.zzattr_attrInitDependencies_state == 0) {
            try {
                this.zzattr_attrInitDependencies_state = 1;
                this.zzattr_attrInitDependencies_cache = InitOrder.initDependencies(this);
            }
            finally {
                this.zzattr_attrInitDependencies_state = 0;
            }
            this.zzattr_attrInitDependencies_state = 2;
        } else if (this.zzattr_attrInitDependencies_state == 1) {
            throw new CyclicDependencyError(this, "attrInitDependencies");
        }
        return this.zzattr_attrInitDependencies_cache;
    }

    @Override
    public com.google.common.collect.ImmutableList<WPackage> attrInitDependenciesTransitive() {
        if (this.zzattr_attrInitDependenciesTransitive_state == 0) {
            try {
                this.zzattr_attrInitDependenciesTransitive_state = 1;
                this.zzattr_attrInitDependenciesTransitive_cache = InitOrder.initDependenciesTransitive(this);
            }
            finally {
                this.zzattr_attrInitDependenciesTransitive_state = 0;
            }
            this.zzattr_attrInitDependenciesTransitive_state = 2;
        } else if (this.zzattr_attrInitDependenciesTransitive_state == 1) {
            throw new CyclicDependencyError(this, "attrInitDependenciesTransitive");
        }
        return this.zzattr_attrInitDependenciesTransitive_cache;
    }

    @Override
    public String description() {
        return Description.description(this);
    }

    @Override
    public String descriptionHtml() {
        return DescriptionHtml.description(this);
    }

    @Override
    public boolean isSubtreeOf(Element other) {
        return SmallHelpers.isSubtreeOf(this, other);
    }

    @Override
    public void prettyPrint(Spacer spacer, StringBuilder sb, int indent) {
        PrettyPrinter.prettyPrint(this, spacer, sb, indent);
    }

    @Override
    public String getName() {
        return SmallHelpers.getName(this);
    }
}

