/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.Convert;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.StmtForFrom;
import de.peeeq.wurstscript.ast.StmtForIn;
import de.peeeq.wurstscript.ast.StmtForRangeDown;
import de.peeeq.wurstscript.ast.StmtForRangeUp;
import de.peeeq.wurstscript.ast.StmtIf;
import de.peeeq.wurstscript.ast.StmtLoop;
import de.peeeq.wurstscript.ast.StmtWhile;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.parser.WPos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class FoldingRangeRequest
extends UserRequest<List<FoldingRange>> {
    private final TextDocumentIdentifier textDocument;

    public FoldingRangeRequest(FoldingRangeRequestParams params) {
        this.textDocument = params.getTextDocument();
    }

    @Override
    public List<FoldingRange> execute(ModelManager modelManager) {
        CompilationUnit cu = modelManager.getCompilationUnit(WFile.create(this.textDocument));
        if (cu == null) {
            return Collections.emptyList();
        }
        return FoldingRangeRequest.calculateFoldingRanges(cu);
    }

    @NotNull
    public static List<FoldingRange> calculateFoldingRanges(CompilationUnit cu) {
        final ArrayList<FoldingRange> result = new ArrayList<FoldingRange>();
        cu.accept(new Element.DefaultVisitor(){

            private void addFoldingRange(Element element) {
                this.addFoldingRange(element, 0, 0);
            }

            private void addFoldingRange(Element element, int startOffset, int endOffset) {
                this.addFoldingRange(element, startOffset, endOffset, "");
            }

            private void addFoldingRange(Element element, int startOffset, int endOffset, String kind) {
                WPos pos = element.attrSource();
                if (pos.isArtificial()) {
                    return;
                }
                Range range = Convert.posToRange(pos);
                range.getStart().setLine(range.getStart().getLine() + startOffset);
                if (range.getEnd().getCharacter() == 0) {
                    range.getEnd().setLine(range.getEnd().getLine() - 1);
                } else {
                    range.getEnd().setLine(range.getEnd().getLine() + endOffset);
                }
                if (range.getStart().getLine() < range.getEnd().getLine()) {
                    FoldingRange foldingRange = new FoldingRange(range.getStart().getLine(), range.getEnd().getLine());
                    foldingRange.setKind(kind);
                    result.add(foldingRange);
                }
            }

            @Override
            public void visit(WImports imports) {
                this.addFoldingRange(imports, 0, -1, "imports");
            }

            @Override
            public void visit(ClassDef classDef) {
                this.addFoldingRange(classDef, StringUtils.isEmpty((String)classDef.attrComment()) ? 0 : 1, 0);
                super.visit(classDef);
            }

            @Override
            public void visit(FuncDef funcDef) {
                this.addFoldingRange(funcDef.getBody(), -1, 0);
                super.visit(funcDef);
            }

            @Override
            public void visit(ExtensionFuncDef extensionFuncDef) {
                this.addFoldingRange(extensionFuncDef.getBody(), -1, 0);
                super.visit(extensionFuncDef);
            }

            @Override
            public void visit(StmtIf ifStmt) {
                this.addFoldingRange(ifStmt, 0, -1);
                super.visit(ifStmt);
            }

            @Override
            public void visit(InterfaceDef interfaceDef) {
                this.addFoldingRange(interfaceDef, StringUtils.isEmpty((String)interfaceDef.attrComment()) ? 0 : 1, 0);
                super.visit(interfaceDef);
            }

            @Override
            public void visit(StmtLoop stmtLoop) {
                this.addFoldingRange(stmtLoop, 0, -1);
                super.visit(stmtLoop);
            }

            @Override
            public void visit(StmtWhile stmtWhile) {
                this.addFoldingRange(stmtWhile);
                super.visit(stmtWhile);
            }

            @Override
            public void visit(StmtForIn stmtForIn) {
                this.addFoldingRange(stmtForIn);
                super.visit(stmtForIn);
            }

            @Override
            public void visit(StmtForFrom stmtForFrom) {
                this.addFoldingRange(stmtForFrom);
                super.visit(stmtForFrom);
            }

            @Override
            public void visit(StmtForRangeDown stmtForRangeDown) {
                this.addFoldingRange(stmtForRangeDown);
                super.visit(stmtForRangeDown);
            }

            @Override
            public void visit(StmtForRangeUp stmtForRangeUp) {
                this.addFoldingRange(stmtForRangeUp);
                super.visit(stmtForRangeUp);
            }

            @Override
            public void visit(InitBlock initBlock) {
                this.addFoldingRange(initBlock);
                super.visit(initBlock);
            }

            @Override
            public void visit(EnumDef enumDef) {
                this.addFoldingRange(enumDef);
                super.visit(enumDef);
            }

            @Override
            public void visit(SwitchStmt switchStmt) {
                this.addFoldingRange(switchStmt);
                super.visit(switchStmt);
            }

            @Override
            public void visit(SwitchCase switchCase) {
                this.addFoldingRange(switchCase);
                super.visit(switchCase);
            }

            @Override
            public void visit(OnDestroyDef onDestroyDef) {
                this.addFoldingRange(onDestroyDef);
                super.visit(onDestroyDef);
            }

            @Override
            public void visit(ConstructorDef constructorDef) {
                this.addFoldingRange(constructorDef);
                super.visit(constructorDef);
            }
        });
        return result;
    }
}

