/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.misc.Raster;
import net.moonlightflower.wc3libs.misc.Size;
import net.moonlightflower.wc3libs.misc.UnsupportedFormatException;
import net.moonlightflower.wc3libs.misc.image.BLP;
import net.moonlightflower.wc3libs.misc.image.FxImg;
import net.moonlightflower.wc3libs.misc.image.JPG;
import net.moonlightflower.wc3libs.misc.image.TGA;
import net.moonlightflower.wc3libs.misc.image.Wc3Img;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;

public class Wc3RasterImg
extends Wc3Img {
    private BufferedImage _bufImg = new BufferedImage(1, 1, 2);

    @Nonnull
    public BufferedImage getBufImg() {
        return this._bufImg;
    }

    public int getWidth() {
        return this._bufImg.getWidth();
    }

    public int getHeight() {
        return this._bufImg.getHeight();
    }

    public void setRGB(int x, int y, @Nonnull Color color) {
        this._bufImg.setRGB(x, y, color.getRGB());
    }

    @Override
    @Nonnull
    public FxImg getFXImg() {
        return new FxImg(this._bufImg);
    }

    public void setBufImg(@Nonnull BufferedImage bufImg) {
        this._bufImg = bufImg;
    }

    public void setFXImg(@Nonnull FxImg fxImg) {
        this.setBufImg(fxImg.toBufImg());
    }

    public Raster<Color> toRaster() {
        return new Rastered();
    }

    public <valType> Wc3RasterImg(Raster<valType> pathMap, RasterConverter<valType> converter) {
        this(pathMap.getSize());
        for (int x = 0; x < pathMap.getWidth(); ++x) {
            for (int y = 0; y < pathMap.getHeight(); ++y) {
                this.setRGB(x, y, converter.getColor(pathMap.get(pathMap.getIndexByXY(x, y))));
            }
        }
    }

    public void addHSV(double hue, double sat, double val) {
        for (int y = 0; y < this._bufImg.getHeight(); ++y) {
            for (int x = 0; x < this._bufImg.getWidth(); ++x) {
                Color oldColor = new Color(this._bufImg.getRGB(x, y), true);
                float[] hsv = Color.RGBtoHSB(oldColor.getRed(), oldColor.getGreen(), oldColor.getBlue(), null);
                hsv[0] = (float)((double)hsv[0] + hue);
                hsv[1] = Math.max(Math.min((float)((double)hsv[1] + sat), 1.0f), 0.0f);
                hsv[2] = Math.max(Math.min((float)((double)hsv[2] + val), 1.0f), 0.0f);
                Color newColor = new Color(Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]));
                newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), oldColor.getAlpha());
                this._bufImg.setRGB(x, y, newColor.getRGB());
            }
        }
        this.setBufImg(this._bufImg);
    }

    public void enlarge(@Nonnull Size size, @Nonnull Color color) {
        BufferedImage bufImg = new BufferedImage(Math.max(size.getWidth(), this.getWidth()), Math.max(size.getHeight(), this.getHeight()), 2);
        for (int y = 0; y < bufImg.getHeight(); ++y) {
            for (int x = 0; x < bufImg.getWidth(); ++x) {
                bufImg.setRGB(x, y, new Color(color.getRed(), color.getGreen(), color.getBlue(), 255).getRGB());
            }
        }
        FxImg fxImg = new FxImg(bufImg);
        Wc3RasterImg other = new Wc3RasterImg(fxImg);
        int xOff = ((int)fxImg.getWidth() - this.getWidth()) / 2;
        int yOff = ((int)fxImg.getHeight() - this.getHeight()) / 2;
        other.merge(this, new Coords2DI(xOff, yOff), false);
        this.setBufImg(other.getBufImg());
    }

    public void merge(@Nonnull Wc3RasterImg other, @Nonnull Coords2DI otherOffset, boolean retainBounds) {
        int width = this.getWidth();
        int height = this.getHeight();
        int minX = 0;
        int minY = 0;
        int maxX = width - 1;
        int maxY = height - 1;
        int otherMinX = otherOffset.getX();
        int otherMinY = otherOffset.getY();
        int otherMaxX = otherOffset.getX() + other.getWidth() - 1;
        int otherMaxY = otherOffset.getY() + other.getHeight() - 1;
        int newMinX = minX;
        int newMinY = minY;
        int newMaxX = maxX;
        int newMaxY = maxY;
        if (!retainBounds) {
            newMinX = Math.min(otherOffset.getX(), minX);
            newMinY = Math.min(otherOffset.getY(), minY);
            newMaxX = Math.max(maxX, otherOffset.getX() + other.getWidth() - 1);
            newMaxY = Math.max(maxY, otherOffset.getY() + other.getHeight() - 1);
        }
        int newWidth = maxX - minX + 1;
        int newHeight = maxY - minY + 1;
        Size newSize = new Size(newWidth, newHeight);
        Wc3RasterImg newImg = new Wc3RasterImg(newSize);
        BufferedImage bufImg = this.getBufImg();
        BufferedImage otherBufImg = other.getBufImg();
        BufferedImage newBufImg = newImg.getBufImg();
        for (int y = newMinY; y <= newMaxY; ++y) {
            for (int x = newMinX; x <= newMaxX; ++x) {
                if (x >= minX && y >= minY && x <= maxX && y <= maxY) {
                    newBufImg.setRGB(x - newMinX, y - minY, bufImg.getRGB(x, y));
                }
                if (x < otherMinX || y < otherMinY || x > otherMaxX || y > otherMaxY) continue;
                Color otherColor = new Color(otherBufImg.getRGB(x - otherMinX, y - otherMinY), true);
                Color curColor = new Color(newBufImg.getRGB(x - newMinX, y - newMinY), true);
                double alphaFactor = (double)otherColor.getAlpha() / 255.0;
                double oldAlphaFactor = (double)curColor.getAlpha() / 255.0;
                int newRed = (int)((double)curColor.getRed() * (1.0 - alphaFactor) + (double)otherColor.getRed() * alphaFactor);
                int newGreen = (int)((double)curColor.getGreen() * (1.0 - alphaFactor) + (double)otherColor.getGreen() * alphaFactor);
                int newBlue = (int)((double)curColor.getBlue() * (1.0 - alphaFactor) + (double)otherColor.getBlue() * alphaFactor);
                int newAlpha = (int)((oldAlphaFactor + (1.0 - oldAlphaFactor) * alphaFactor) * 255.0);
                Color newColor = new Color(newRed, newGreen, newBlue, newAlpha);
                newBufImg.setRGB(x - newMinX, y - newMinY, newColor.getRGB());
            }
        }
        this.setBufImg(newBufImg);
    }

    public void ignoreAlpha() {
        BufferedImage oldImg;
        BufferedImage newImg = oldImg = this.getBufImg();
        for (int y = 0; y < newImg.getHeight(); ++y) {
            for (int x = 0; x < newImg.getWidth(); ++x) {
                newImg.setRGB(x, y, new Color(oldImg.getRGB(x, y), false).getRGB());
            }
        }
        this.setBufImg(newImg);
    }

    public void ignoreAlpha2() {
        BufferedImage oldImg = this.getBufImg();
        BufferedImage newImg = new BufferedImage(oldImg.getWidth(), oldImg.getHeight(), 2);
        for (int y = 0; y < newImg.getHeight(); ++y) {
            for (int x = 0; x < newImg.getWidth(); ++x) {
                Color oldColor = new Color(oldImg.getRGB(x, y));
                Color newColor = new Color(oldColor.getRed(), oldColor.getGreen(), oldColor.getBlue(), oldColor.getAlpha());
                newImg.setRGB(x, y, newColor.getRGB());
            }
        }
        this.setFXImg(new FxImg(newImg));
    }

    public Wc3RasterImg copy() {
        BufferedImage bufImg = this.getFXImg().toBufImg();
        return new Wc3RasterImg(bufImg);
    }

    public Wc3RasterImg() {
    }

    public Wc3RasterImg(@Nonnull Size size) {
        this();
        BufferedImage bufImg = new BufferedImage(size.getWidth(), size.getHeight(), 2);
        int blankColor = new Color(0, 0, 0, 0).getRGB();
        for (int y = 0; y < size.getHeight(); ++y) {
            for (int x = 0; x < size.getWidth(); ++x) {
                bufImg.setRGB(x, y, blankColor);
            }
        }
        this.setFXImg(new FxImg(bufImg));
    }

    public Wc3RasterImg(@Nonnull BufferedImage bufImg) {
        this();
        this._bufImg = bufImg;
    }

    public Wc3RasterImg(@Nonnull FxImg fxImg) {
        this(fxImg.toBufImg());
    }

    @Nonnull
    public static Wc3RasterImg ofInputStream(@Nonnull InputStream inStream, @Nonnull String ext) throws UnsupportedFormatException, IOException {
        switch (ext.toLowerCase()) {
            case "jpeg": 
            case "jpg": {
                return new JPG(inStream);
            }
            case "blp": {
                return new BLP(inStream);
            }
            case "tga": {
                return new TGA(inStream);
            }
        }
        throw new UnsupportedFormatException(String.format("extension %s not supported", ext.toLowerCase()));
    }

    @Nonnull
    public static Wc3RasterImg ofFile(@Nonnull File file) throws UnsupportedFormatException, IOException {
        Orient.checkFileExists(file);
        String ext = Orient.getFileExt(file);
        if (ext == null) {
            throw new IllegalArgumentException(String.format("file %s has no extension", file));
        }
        switch (ext.toLowerCase()) {
            case "jpeg": 
            case "jpg": {
                return new JPG(file);
            }
            case "blp": {
                return new BLP(file);
            }
            case "tga": {
                return new TGA(file);
            }
        }
        throw new UnsupportedFormatException(String.format("extension %s of file %s not supported", ext.toLowerCase(), file));
    }

    @Nonnull
    protected static MpqPort getMpqPort() {
        return Context.getService(MpqPort.class);
    }

    @Nonnull
    public static Wc3RasterImg ofGameFile(@Nonnull File inFile) throws IOException, UnsupportedFormatException, NotFoundException {
        MpqPort.Out.Result portResult = Wc3RasterImg.getMpqPort().getGameFiles(inFile);
        Wc3RasterImg img = Wc3RasterImg.ofFile(portResult.getFile(inFile));
        return img;
    }

    public static interface RasterConverter<valType> {
        public Color getColor(valType var1);
    }

    private static class Rastered
    extends Raster<Color> {
        @Override
        public void setSize(int cellsCount) {
            this._cells = new Color[cellsCount];
        }

        @Override
        public Color mergeCellVal(@Nonnull Color oldVal, @Nonnull Color other) {
            return other;
        }

        @Override
        public Raster<Color> clone() {
            Rastered other = new Rastered();
            other.mergeCells(this);
            return other;
        }

        @Override
        public int getCellSize() {
            return 1;
        }

        private Rastered() {
            super(new Bounds(0, 0, 0, 0));
        }
    }
}

