/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import systems.crigges.jmpq3.BlockTable;
import systems.crigges.jmpq3.DebugHelper;
import systems.crigges.jmpq3.JMpqException;
import systems.crigges.jmpq3.compression.CompressionUtil;
import systems.crigges.jmpq3.compression.RecompressOptions;
import systems.crigges.jmpq3.security.MPQEncryption;
import systems.crigges.jmpq3.security.MPQHashGenerator;

public class MpqFile {
    public static final int COMPRESSED = 512;
    public static final int ENCRYPTED = 65536;
    public static final int SINGLE_UNIT = 0x1000000;
    public static final int ADJUSTED_ENCRYPTED = 131072;
    public static final int EXISTS = Integer.MIN_VALUE;
    public static final int DELETED = 0x2000000;
    public static final int IMPLODED = 256;
    private final ByteBuffer buf;
    private final BlockTable.Block block;
    private final String name;
    private boolean isEncrypted = false;
    private final int sectorSize;
    private final int compressedSize;
    private final int normalSize;
    private final int flags;
    private final int sectorCount;
    private int baseKey;

    public MpqFile(ByteBuffer buf, BlockTable.Block b, int sectorSize, String name) throws IOException {
        this.buf = buf;
        this.block = b;
        this.sectorSize = sectorSize;
        this.name = name;
        this.compressedSize = b.getCompressedSize();
        this.normalSize = b.getNormalSize();
        this.flags = b.getFlags();
        this.sectorCount = (int)(Math.ceil((double)this.normalSize / (double)sectorSize) + 1.0);
        this.baseKey = 0;
        int sepIndex = name.lastIndexOf(92);
        String pathlessName = name.substring(sepIndex + 1);
        if (b.hasFlag(65536)) {
            this.isEncrypted = true;
            MPQHashGenerator keyGen = MPQHashGenerator.getFileKeyGenerator();
            keyGen.process(pathlessName);
            this.baseKey = keyGen.getHash();
            if (b.hasFlag(131072)) {
                this.baseKey = this.baseKey + b.getFilePos() ^ b.getNormalSize();
            }
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public void extractToFile(File f) throws IOException {
        if (this.sectorCount == 1) {
            f.createNewFile();
        }
        this.extractToOutputStream(Files.newOutputStream(f.toPath(), new OpenOption[0]));
    }

    public byte[] extractToBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.extractToOutputStream(byteArrayOutputStream);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return bytes;
    }

    public void extractToOutputStream(OutputStream writer) throws IOException {
        if (this.sectorCount == 1) {
            writer.close();
            return;
        }
        if (this.extractImplodedBlock(writer)) {
            return;
        }
        if (this.extractSingleUnitBlock(writer)) {
            return;
        }
        if (this.block.hasFlag(512)) {
            this.extractCompressedBlock(writer);
        } else {
            this.check(writer);
        }
    }

    private void extractCompressedBlock(OutputStream writer) throws IOException {
        this.buf.position(0);
        byte[] sot = new byte[this.sectorCount * 4];
        this.buf.get(sot);
        if (this.isEncrypted) {
            new MPQEncryption(this.baseKey - 1, true).processSingle(ByteBuffer.wrap(sot));
        }
        ByteBuffer sotBuffer = ByteBuffer.wrap(sot).order(ByteOrder.LITTLE_ENDIAN);
        int start = sotBuffer.getInt();
        int end = sotBuffer.getInt();
        int finalSize = 0;
        for (int i = 0; i < this.sectorCount - 1; ++i) {
            this.buf.position(start);
            byte[] arr = this.getSectorAsByteArray(this.buf, end - start);
            if (this.isEncrypted) {
                new MPQEncryption(this.baseKey + i, true).processSingle(ByteBuffer.wrap(arr));
            }
            arr = this.block.getNormalSize() - finalSize <= this.sectorSize ? this.decompressSector(arr, end - start, this.block.getNormalSize() - finalSize) : this.decompressSector(arr, end - start, this.sectorSize);
            writer.write(arr);
            finalSize += this.sectorSize;
            start = end;
            try {
                end = sotBuffer.getInt();
                continue;
            }
            catch (BufferUnderflowException e) {
                break;
            }
        }
        writer.flush();
        writer.close();
    }

    private boolean extractSingleUnitBlock(OutputStream writer) throws IOException {
        if (this.block.hasFlag(0x1000000)) {
            if (this.block.hasFlag(512)) {
                this.buf.position(0);
                byte[] arr = this.getSectorAsByteArray(this.buf, this.compressedSize);
                if (this.isEncrypted) {
                    new MPQEncryption(this.baseKey, true).processSingle(ByteBuffer.wrap(arr));
                }
                arr = this.decompressSector(arr, this.block.getCompressedSize(), this.block.getNormalSize());
                writer.write(arr);
                writer.flush();
                writer.close();
            } else {
                this.check(writer);
            }
            return true;
        }
        return false;
    }

    private boolean extractImplodedBlock(OutputStream writer) throws IOException {
        if (this.block.hasFlag(256)) {
            this.buf.position(0);
            byte[] sot = new byte[this.sectorCount * 4];
            this.buf.get(sot);
            if (this.isEncrypted) {
                new MPQEncryption(this.baseKey - 1, true).processSingle(ByteBuffer.wrap(sot));
            }
            ByteBuffer sotBuffer = ByteBuffer.wrap(sot).order(ByteOrder.LITTLE_ENDIAN);
            int start = sotBuffer.getInt();
            int end = sotBuffer.getInt();
            int finalSize = 0;
            for (int i = 0; i < this.sectorCount - 1; ++i) {
                this.buf.position(start);
                byte[] arr = this.getSectorAsByteArray(this.buf, end - start);
                if (this.isEncrypted) {
                    new MPQEncryption(this.baseKey + i, true).processSingle(ByteBuffer.wrap(arr));
                }
                arr = this.block.getNormalSize() - finalSize <= this.sectorSize ? this.decompressImplodedSector(arr, end - start, this.block.getNormalSize() - finalSize) : this.decompressImplodedSector(arr, end - start, this.sectorSize);
                writer.write(arr);
                finalSize += this.sectorSize;
                start = end;
                try {
                    end = sotBuffer.getInt();
                    continue;
                }
                catch (BufferUnderflowException e) {
                    break;
                }
            }
            writer.flush();
            writer.close();
            return true;
        }
        return false;
    }

    private void check(OutputStream writer) throws IOException {
        this.buf.position(0);
        byte[] arr = this.getSectorAsByteArray(this.buf, this.compressedSize);
        if (this.isEncrypted) {
            new MPQEncryption(this.baseKey, true).processSingle(ByteBuffer.wrap(arr));
        }
        writer.write(arr);
        writer.flush();
        writer.close();
    }

    public void writeFileAndBlock(BlockTable.Block newBlock, MappedByteBuffer writeBuffer) throws JMpqException {
        newBlock.setNormalSize(this.normalSize);
        newBlock.setCompressedSize(this.compressedSize);
        if (this.normalSize == 0) {
            newBlock.setFlags(this.block.getFlags());
            return;
        }
        if (this.block.hasFlag(0x1000000) || !this.block.hasFlag(512)) {
            this.buf.position(0);
            byte[] arr = this.getSectorAsByteArray(this.buf, this.block.hasFlag(512) ? this.compressedSize : this.normalSize);
            if (this.block.hasFlag(65536)) {
                new MPQEncryption(this.baseKey, true).processSingle(ByteBuffer.wrap(arr));
            }
            writeBuffer.put(arr);
            if (this.block.hasFlag(0x1000000)) {
                if ((this.block.getFlags() & 0x200) == 512) {
                    newBlock.setFlags(-2130705920);
                } else {
                    newBlock.setFlags(-2130706432);
                }
            } else if ((this.block.getFlags() & 0x200) == 512) {
                newBlock.setFlags(-2147483136);
            } else {
                newBlock.setFlags(Integer.MIN_VALUE);
            }
        } else {
            this.buf.position(0);
            byte[] sot = new byte[this.sectorCount * 4];
            this.buf.get(sot);
            if (this.isEncrypted) {
                new MPQEncryption(this.baseKey - 1, true).processSingle(ByteBuffer.wrap(sot));
            }
            writeBuffer.put(sot);
            ByteBuffer sotBuffer = ByteBuffer.wrap(sot).order(ByteOrder.LITTLE_ENDIAN);
            int start = sotBuffer.getInt();
            int end = sotBuffer.getInt();
            for (int i = 0; i < this.sectorCount - 1; ++i) {
                this.buf.position(start);
                byte[] arr = this.getSectorAsByteArray(this.buf, end - start);
                if (this.isEncrypted) {
                    new MPQEncryption(this.baseKey + i, true).processSingle(ByteBuffer.wrap(arr));
                }
                writeBuffer.put(arr);
                start = end;
                try {
                    end = sotBuffer.getInt();
                    continue;
                }
                catch (BufferUnderflowException e) {
                    break;
                }
            }
            if ((this.block.getFlags() & 0x200) == 512) {
                newBlock.setFlags(-2147483136);
            } else {
                newBlock.setFlags(Integer.MIN_VALUE);
            }
        }
    }

    public static void writeFileAndBlock(byte[] file, BlockTable.Block b, MappedByteBuffer buf, int sectorSize, RecompressOptions recompress) {
        MpqFile.writeFileAndBlock(file, b, buf, sectorSize, "", recompress);
    }

    public static void writeFileAndBlock(byte[] fileArr, BlockTable.Block b, MappedByteBuffer buf, int sectorSize, String pathlessName, RecompressOptions recompress) {
        ByteBuffer fileBuf = ByteBuffer.wrap(fileArr);
        fileBuf.position(0);
        b.setNormalSize(fileArr.length);
        if (b.getFlags() == 0) {
            if (fileArr.length > 0) {
                b.setFlags(-2147483136);
            } else {
                b.setFlags(Integer.MIN_VALUE);
                return;
            }
        }
        int sectorCount = (int)(Math.ceil((double)fileArr.length / (double)sectorSize) + 1.0);
        ByteBuffer sot = ByteBuffer.allocate(sectorCount * 4);
        sot.order(ByteOrder.LITTLE_ENDIAN);
        sot.position(0);
        sot.putInt(sectorCount * 4);
        buf.position(sectorCount * 4);
        int sotPos = sectorCount * 4;
        byte[] temp = new byte[sectorSize];
        for (int i = 0; i < sectorCount - 1; ++i) {
            int bKey;
            MPQHashGenerator keyGen;
            if (fileBuf.position() + sectorSize > fileArr.length) {
                temp = new byte[fileArr.length - fileBuf.position()];
            }
            fileBuf.get(temp);
            byte[] compSector = null;
            try {
                compSector = CompressionUtil.compress(temp, recompress);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (compSector != null && compSector.length + 1 < temp.length) {
                if (b.hasFlag(65536)) {
                    keyGen = MPQHashGenerator.getFileKeyGenerator();
                    keyGen.process(pathlessName);
                    bKey = keyGen.getHash();
                    if (b.hasFlag(131072)) {
                        bKey = bKey + b.getFilePos() ^ b.getNormalSize();
                    }
                    if (new MPQEncryption(bKey + i, false).processFinal(ByteBuffer.wrap(DebugHelper.appendData((byte)2, compSector), 0, compSector.length + 1), buf)) {
                        throw new BufferOverflowException();
                    }
                } else {
                    buf.put((byte)2);
                    buf.put(compSector);
                }
                sotPos += compSector.length + 1;
            } else {
                if (b.hasFlag(65536)) {
                    keyGen = MPQHashGenerator.getFileKeyGenerator();
                    keyGen.process(pathlessName);
                    bKey = keyGen.getHash();
                    if (b.hasFlag(131072)) {
                        bKey = bKey + b.getFilePos() ^ b.getNormalSize();
                    }
                    if (new MPQEncryption(bKey + i, false).processFinal(ByteBuffer.wrap(temp), buf)) {
                        throw new BufferOverflowException();
                    }
                } else {
                    buf.put(temp);
                }
                sotPos += temp.length;
            }
            sot.putInt(sotPos);
        }
        b.setCompressedSize(sotPos);
        buf.position(0);
        sot.position(0);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        if (b.hasFlag(65536)) {
            MPQHashGenerator keyGen = MPQHashGenerator.getFileKeyGenerator();
            keyGen.process(pathlessName);
            int bKey = keyGen.getHash();
            if (b.hasFlag(131072)) {
                bKey = bKey + b.getFilePos() ^ b.getNormalSize();
            }
            if (new MPQEncryption(bKey - 1, false).processFinal(sot, buf)) {
                throw new BufferOverflowException();
            }
        } else {
            buf.put(sot);
        }
    }

    private byte[] getSectorAsByteArray(ByteBuffer buf, int sectorSize) {
        byte[] arr = new byte[sectorSize];
        buf.get(arr);
        return arr;
    }

    private byte[] decompressSector(byte[] sector, int normalSize, int uncompressedSize) throws JMpqException {
        return CompressionUtil.decompress(sector, normalSize, uncompressedSize);
    }

    private byte[] decompressImplodedSector(byte[] sector, int normalSize, int uncompressedSize) throws JMpqException {
        return CompressionUtil.explode(sector, normalSize, uncompressedSize);
    }

    public String toString() {
        return "MpqFile [sectorSize=" + this.sectorSize + ", compressedSize=" + this.compressedSize + ", normalSize=" + this.normalSize + ", flags=" + this.flags + ", name=" + this.name + "]";
    }
}

