/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.misc.Raster;
import net.moonlightflower.wc3libs.misc.image.FxImg;
import net.moonlightflower.wc3libs.misc.image.Wc3RasterImg;

public class ShadowMap
extends Raster<Boolean> {
    public static final int CELL_SIZE = 32;

    @Override
    public int getCellSize() {
        return 32;
    }

    @Override
    public void setSize(int cellsCount) {
        this._cells = new Boolean[cellsCount];
    }

    @Override
    public Boolean mergeCellVal(Boolean oldVal, Boolean other) {
        return oldVal != false || other != false;
    }

    @Override
    public ShadowMap clone() {
        ShadowMap other = this.getShadowMap(this.getBounds());
        other.mergeCells(this);
        return other;
    }

    protected ShadowMap getShadowMap(@Nonnull Bounds bounds) {
        return new ShadowMap(bounds);
    }

    @Nonnull
    public Wc3RasterImg toImg() {
        BufferedImage bufImg = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                bufImg.setRGB(x, y, ((Boolean)this.get(new Coords2DI(x, this.getHeight() - 1 - y)) != false ? Color.WHITE : Color.BLACK).getRGB());
            }
        }
        return new Wc3RasterImg(new FxImg(bufImg));
    }

    public ShadowMap(@Nonnull Bounds bounds) {
        super(bounds);
        this.setBounds(bounds, false, false);
    }
}

