/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.utils;

public class LineOffsets {
    int[] offsets = new int[128];
    int maxLine = 0;
    public static final LineOffsets dummy = new LineOffsets();

    public void set(int line, int offset) {
        this.maxLine = Math.max(line, this.maxLine);
        if (line >= this.offsets.length) {
            int newLen;
            for (newLen = this.offsets.length; line >= newLen; newLen *= 2) {
            }
            int[] offsets2 = new int[newLen];
            System.arraycopy(this.offsets, 0, offsets2, 0, this.offsets.length);
            this.offsets = offsets2;
        }
        this.offsets[line] = offset;
    }

    public int get(int line) {
        if (line >= this.offsets.length) {
            line = this.offsets.length - 1;
        } else if (line <= 0) {
            return -1;
        }
        while (line >= 0 && this.offsets[line] == 0) {
            --line;
        }
        if (line >= 0) {
            return this.offsets[line];
        }
        return 0;
    }

    public int getLine(int offset) {
        int min = 0;
        int max = this.maxLine + 1;
        while (min < max) {
            int test = (min + max) / 2;
            int v = this.get(test);
            if (v < offset) {
                if (min == test) {
                    ++min;
                    continue;
                }
                min = test;
                continue;
            }
            max = test;
        }
        return min;
    }

    public int getColumn(int offset) {
        int line = this.getLine(offset);
        return offset - this.get(line - 1);
    }
}

