/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.peParser.types;

import dorkbox.hex.HexExtensionsKt;
import dorkbox.os.OS;
import dorkbox.peParser.ByteArray;
import dorkbox.peParser.misc.ResourceTypes;
import dorkbox.peParser.types.ByteDefinition;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B(\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Ldorkbox/peParser/types/ResourceDirName;", "Ldorkbox/peParser/types/ByteDefinition;", "", "intValue", "Lkotlin/UInt;", "descriptiveName", "bytes", "Ldorkbox/peParser/ByteArray;", "level", "", "(ILjava/lang/String;Ldorkbox/peParser/ByteArray;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "value", "format", "", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "get", "Companion", "PeParser"})
@SourceDebugExtension(value={"SMAP\nResourceDirName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDirName.kt\ndorkbox/peParser/types/ResourceDirName\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,106:1\n107#2:107\n79#2,22:108\n*S KotlinDebug\n*F\n+ 1 ResourceDirName.kt\ndorkbox/peParser/types/ResourceDirName\n*L\n67#1:107\n67#1:108,22\n*E\n"})
public final class ResourceDirName
extends ByteDefinition<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int level;
    @Nullable
    private String value;
    private static final int NAME_IS_STRING_MASK = Integer.MIN_VALUE;
    private static final int NAME_OFFSET_MASK = Integer.MAX_VALUE;

    /*
     * WARNING - void declaration
     */
    private ResourceDirName(int intValue, String descriptiveName, ByteArray bytes, int level) {
        boolean isString;
        Intrinsics.checkNotNullParameter((Object)descriptiveName, (String)"descriptiveName");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        super(descriptiveName);
        this.level = level;
        long valueInt = (long)intValue & 0xFFFFFFFFL;
        boolean bl = isString = 0L != (valueInt & Integer.MIN_VALUE);
        if (isString) {
            void $this$trim$iv;
            int savedPosition = bytes.position();
            long offset = valueInt & Integer.MAX_VALUE;
            if (offset > Integer.MAX_VALUE) {
                throw new RuntimeException("Unable to set offset to more than 2gb!");
            }
            bytes.seek(bytes.marked() + (int)offset);
            int length = bytes.readUShort-BwKQO78(2) & 0xFFFF;
            byte[] buff = new byte[length * 2];
            int n = buff.length;
            for (int i = 0; i < n; ++i) {
                buff[i] = bytes.readUByte-w2LRezQ();
            }
            bytes.seek(savedPosition);
            Charset charset = StandardCharsets.UTF_16LE;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_16LE");
            Object i = charset;
            i = new String(buff, (Charset)i);
            ResourceDirName resourceDirName = this;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            resourceDirName.value = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        } else {
            switch (this.level) {
                case 1: {
                    ResourceTypes resourceTypes = ResourceTypes.Companion.get-WZ4Q5Ns(intValue);
                    this.value = resourceTypes != null ? resourceTypes.getDetailedInfo() : null;
                    break;
                }
                case 2: {
                    this.value = HexExtensionsKt.toHexString-OzbTU-A$default((int)intValue, (boolean)false, (boolean)false, (int)3, null);
                    break;
                }
                case 3: {
                    this.value = HexExtensionsKt.toHexString-OzbTU-A$default((int)intValue, (boolean)false, (boolean)false, (int)3, null);
                    break;
                }
                default: {
                    this.value = HexExtensionsKt.toHexString-OzbTU-A$default((int)intValue, (boolean)false, (boolean)false, (int)3, null);
                }
            }
        }
    }

    @Override
    @NotNull
    public String get() {
        String string = this.value;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public void format(@NotNull StringBuilder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        b.append(this.getDescriptiveName()).append(": ");
        switch (this.level) {
            case 1: {
                break;
            }
            case 2: {
                b.append("name: ");
                break;
            }
            case 3: {
                b.append("Language: ");
                break;
            }
            default: {
                b.append("??: ");
            }
        }
        b.append(this.value).append(OS.INSTANCE.getLINE_SEPARATOR());
    }

    public /* synthetic */ ResourceDirName(int intValue, String descriptiveName, ByteArray bytes, int level, DefaultConstructorMarker $constructor_marker) {
        this(intValue, descriptiveName, bytes, level);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/peParser/types/ResourceDirName$Companion;", "", "()V", "NAME_IS_STRING_MASK", "", "NAME_OFFSET_MASK", "PeParser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

