/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.dataTypes.app;

import java.lang.reflect.InvocationTargetException;
import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlagsInt
extends DataType {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());
    private BitSet _val;

    public static Class<Enum> getEnum(Class<?> c) {
        try {
            return (Class)c.getMethod("getEnumStatic", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int toInt() {
        if (this._val.toLongArray().length == 0) {
            return 0;
        }
        return (int)this._val.toLongArray()[0];
    }

    @Nonnull
    public Set<Integer> getPoses() {
        return this._val.stream().boxed().collect(Collectors.toSet());
    }

    public void setVal(int val) {
        this._val = BitSet.valueOf(new long[]{val});
    }

    public boolean containsFlag(@Nonnull Flag flag) {
        return this._val.get(flag.getPos());
    }

    public void setPos(int pos, boolean val) {
        this._val.set(pos, val);
    }

    public void setPoses(@Nonnull Collection<Integer> poses, boolean val) {
        BitSet posesBitSet = new BitSet();
        for (Integer pos : poses) {
            posesBitSet.set(pos);
        }
        if (val) {
            this._val.or(posesBitSet);
        } else {
            this._val.andNot(posesBitSet);
        }
    }

    public void setFlag(@Nonnull Flag flag, boolean val) {
        this._val.set(flag.getPos(), val);
    }

    protected FlagsInt() {
    }

    protected FlagsInt(int val) {
        this._val = BitSet.valueOf(new long[]{val});
    }

    protected FlagsInt(@Nonnull BitSet val) {
        this._val = val;
    }

    public static class Flag
    extends net.moonlightflower.wc3libs.misc.Flag {
        public Flag(@Nonnull String label, int pos) {
            super(label, pos);
        }
    }

    public static interface IsFlag {
        public int getVal();
    }
}

