/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.lua.translation;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImBoolVal;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImGetStackTrace;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImIntVal;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImRealVal;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStringVal;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVarDispatch;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.luaAst.LuaAst;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprBoolVal;
import de.peeeq.wurstscript.luaAst.LuaExprlist;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaOpBinary;
import de.peeeq.wurstscript.luaAst.LuaOpFloorDiv;
import de.peeeq.wurstscript.luaAst.LuaOpMod;
import de.peeeq.wurstscript.luaAst.LuaOpUnary;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaStatements;
import de.peeeq.wurstscript.luaAst.LuaTableConstructor;
import de.peeeq.wurstscript.luaAst.LuaTableField;
import de.peeeq.wurstscript.luaAst.LuaTableFields;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.translation.LuaTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import java.util.Optional;

public class ExprTranslation {
    public static final String TYPE_ID = "__typeId__";
    public static final String WURST_SUPERTYPES = "__wurst_supertypes";

    public static LuaExpr translate(ImAlloc e, LuaTranslator tr) {
        ImClass c = e.getClazz().getClassDef();
        LuaMethod m = tr.luaClassInitMethod.getFor(c);
        LuaVariable classVar = tr.luaClassVar.getFor(c);
        return LuaAst.LuaExprMethodCall(LuaAst.LuaExprVarAccess(classVar), m, LuaAst.LuaExprlist(new LuaExpr[0]));
    }

    public static LuaExpr translate(ImBoolVal e, LuaTranslator tr) {
        return LuaAst.LuaExprBoolVal(e.getValB());
    }

    public static LuaExpr translate(ImDealloc e, LuaTranslator tr) {
        return LuaAst.LuaExprNull();
    }

    public static LuaExpr translate(ImFuncRef e, LuaTranslator tr) {
        LuaVariable dots = LuaAst.LuaVariable("...", LuaAst.LuaNoExpr());
        LuaVariable tempDots = LuaAst.LuaVariable("temp", LuaAst.LuaExprVarAccess(dots));
        LuaVariable tempRes = LuaAst.LuaVariable("tempRes", LuaAst.LuaExprNull());
        return LuaAst.LuaExprFunctionAbstraction(LuaAst.LuaParams(dots), LuaAst.LuaStatements(tempDots, tempRes, LuaAst.LuaExprFunctionCallByName("xpcall", LuaAst.LuaExprlist(LuaAst.LuaExprFunctionAbstraction(LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(LuaAst.LuaAssignment(LuaAst.LuaExprVarAccess(tempRes), LuaAst.LuaExprFunctionCall(tr.luaFunc.getFor(e.getFunc()), LuaAst.LuaExprlist(LuaAst.LuaExprVarAccess(tempDots)))))), LuaAst.LuaLiteral("function(err) xpcall(function() " + ExprTranslation.callErrorFunc(tr, "tostring(err)") + " end, function(err2) BJDebugMsg(\"error reporting error: \" .. tostring(err2)) BJDebugMsg(\"while reporting: \" .. tostring(err))  end) end"))), LuaAst.LuaReturn(LuaAst.LuaExprVarAccess(tempRes))));
    }

    private static String callErrorFunc(LuaTranslator tr, String msg) {
        LuaFunction ef = tr.getErrorFunc();
        if (ef != null) {
            if (ef.getParams().size() == 2) {
                return ef.getName() + "(" + msg + ", \"<lua error>\")";
            }
            return ef.getName() + "(" + msg + ")";
        }
        return "BJDebugMsg(" + msg + ")";
    }

    public static LuaExpr translate(ImFunctionCall e, LuaTranslator tr) {
        LuaFunction f = tr.luaFunc.getFor(e.getFunc());
        if (f.getName().equals("$debugPrint")) {
            f.setName("BJDebugMsg");
        } else if (f.getName().equals("I2S")) {
            f.setName("tostring");
        }
        return LuaAst.LuaExprFunctionCall(f, tr.translateExprList(e.getArguments()));
    }

    public static LuaExpr translate(ImInstanceof e, LuaTranslator tr) {
        return LuaAst.LuaExprFunctionCall(tr.instanceOfFunction, LuaAst.LuaExprlist(e.getObj().translateToLua(tr), LuaAst.LuaExprVarAccess(tr.luaClassVar.getFor(e.getClazz().getClassDef()))));
    }

    public static LuaExpr translate(ImIntVal e, LuaTranslator tr) {
        return LuaAst.LuaExprIntVal("" + e.getValI());
    }

    public static LuaExpr translate(ImMemberAccess e, LuaTranslator tr) {
        LuaExpr res = LuaAst.LuaExprFieldAccess(e.getReceiver().translateToLua(tr), e.getVar().getName());
        if (!e.getIndexes().isEmpty()) {
            LuaExprlist indexes = LuaAst.LuaExprlist(new LuaExpr[0]);
            for (ImExpr index : e.getIndexes()) {
                indexes.add(index.translateToLua(tr));
            }
            res = LuaAst.LuaExprArrayAccess(res, indexes);
        }
        return res;
    }

    public static LuaExpr translate(ImMethodCall e, LuaTranslator tr) {
        return LuaAst.LuaExprMethodCall(e.getReceiver().translateToLua(tr), tr.luaMethod.getFor(e.getMethod()), tr.translateExprList(e.getArguments()));
    }

    public static LuaExpr translate(ImNull e, LuaTranslator tr) {
        return LuaAst.LuaExprNull();
    }

    public static LuaExpr translate(ImOperatorCall e, LuaTranslator tr) {
        if (e.getArguments().size() == 2) {
            ImExpr left = (ImExpr)e.getArguments().get(0);
            ImExpr right = (ImExpr)e.getArguments().get(1);
            if (e.getOp() == WurstOperator.EQ) {
                return ExprTranslation.translateEquals(left, right, tr);
            }
            if (e.getOp() == WurstOperator.NOTEQ) {
                return LuaAst.LuaExprUnary(LuaAst.LuaOpNot(), ExprTranslation.translateEquals(left, right, tr));
            }
            LuaExpr leftExpr = left.translateToLua(tr);
            LuaExpr rightExpr = right.translateToLua(tr);
            if (e.getOp() == WurstOperator.MOD_INT) {
                LuaOpMod op = LuaAst.LuaOpMod();
                return LuaAst.LuaExprFunctionCallE(LuaAst.LuaLiteral("math.floor"), LuaAst.LuaExprlist(LuaAst.LuaExprBinary(leftExpr, op, rightExpr)));
            }
            if (e.getOp() == WurstOperator.DIV_INT) {
                LuaOpFloorDiv op = LuaAst.LuaOpFloorDiv();
                return LuaAst.LuaExprBinary(leftExpr, op, rightExpr);
            }
            LuaOpBinary op = e.getOp().luaTranslateBinary();
            return LuaAst.LuaExprBinary(leftExpr, op, rightExpr);
        }
        if (e.getArguments().size() == 1) {
            LuaOpUnary op;
            ImExpr arg = (ImExpr)e.getArguments().get(0);
            LuaExpr argT = arg.translateToLua(tr);
            switch (e.getOp()) {
                case NOT: {
                    op = LuaAst.LuaOpNot();
                    break;
                }
                case UNARY_MINUS: {
                    op = LuaAst.LuaOpMinus();
                    break;
                }
                default: {
                    throw new Error("not implemented: unary operator " + e.getOp());
                }
            }
            return LuaAst.LuaExprUnary(op, argT);
        }
        throw new Error("not implemented: " + e);
    }

    private static LuaFunction getTupleEqualsFunc(ImTupleType t, LuaTranslator tr) {
        TupleFunc tf;
        Optional<TupleFunc> tfo = tr.tupleEqualsFuncs.stream().filter(f -> f.tupleType.equalsType(t)).findFirst();
        if (tfo.isPresent()) {
            tf = tfo.get();
        } else {
            LuaVariable t1 = LuaAst.LuaVariable("t1", LuaAst.LuaNoExpr());
            LuaVariable t2 = LuaAst.LuaVariable("t2", LuaAst.LuaNoExpr());
            LuaStatements body = LuaAst.LuaStatements(new LuaStatement[0]);
            LuaFunction func = LuaAst.LuaFunction(tr.uniqueName("tupleEquals"), LuaAst.LuaParams(t1, t2), body);
            LuaExpr result = LuaAst.LuaExprBoolVal(true);
            for (int i = 0; i < t.getNames().size(); ++i) {
                result = ExprTranslation.conjunction(result, ExprTranslation.translateEquals(LuaAst.LuaExprArrayAccess(LuaAst.LuaExprVarAccess(t1), LuaAst.LuaExprlist(LuaAst.LuaExprIntVal("" + i))), LuaAst.LuaExprArrayAccess(LuaAst.LuaExprVarAccess(t2), LuaAst.LuaExprlist(LuaAst.LuaExprIntVal("" + i))), t.getTypes().get(i), tr));
            }
            body.add(LuaAst.LuaReturn(result));
            tr.luaModel.add(func);
            tf = new TupleFunc(t, func);
            tr.tupleEqualsFuncs.add(tf);
        }
        return tf.func;
    }

    public static LuaFunction getTupleCopyFunc(ImTupleType t, LuaTranslator tr) {
        TupleFunc tf;
        Optional<TupleFunc> tfo = tr.tupleCopyFuncs.stream().filter(f -> f.tupleType.equalsType(t)).findFirst();
        if (tfo.isPresent()) {
            tf = tfo.get();
        } else {
            LuaVariable t1 = LuaAst.LuaVariable("t", LuaAst.LuaNoExpr());
            LuaStatements body = LuaAst.LuaStatements(new LuaStatement[0]);
            LuaFunction func = LuaAst.LuaFunction(tr.uniqueName("tupleCopy"), LuaAst.LuaParams(t1), body);
            LuaTableFields fields = LuaAst.LuaTableFields(new LuaTableField[0]);
            LuaTableConstructor result = LuaAst.LuaTableConstructor(fields);
            int i = 0;
            for (ImType type : t.getTypes()) {
                LuaExpr v = LuaAst.LuaExprArrayAccess(LuaAst.LuaExprVarAccess(t1), LuaAst.LuaExprlist(LuaAst.LuaExprIntVal("" + ++i)));
                if (type instanceof ImTupleType) {
                    ImTupleType tt = (ImTupleType)type;
                    v = LuaAst.LuaExprFunctionCall(ExprTranslation.getTupleCopyFunc(tt, tr), LuaAst.LuaExprlist(v));
                }
                fields.add(LuaAst.LuaTableSingleField(v));
            }
            body.add(LuaAst.LuaReturn(result));
            tr.luaModel.add(func);
            tf = new TupleFunc(t, func);
            tr.tupleCopyFuncs.add(tf);
        }
        return tf.func;
    }

    private static LuaExpr conjunction(LuaExpr left, LuaExpr right) {
        if (left instanceof LuaExprBoolVal && ((LuaExprBoolVal)left).getValB()) {
            return right;
        }
        if (right instanceof LuaExprBoolVal && ((LuaExprBoolVal)right).getValB()) {
            return left;
        }
        return LuaAst.LuaExprBinary(left, LuaAst.LuaOpAnd(), right);
    }

    private static LuaExpr translateEquals(ImExpr left, ImExpr right, LuaTranslator tr) {
        LuaExpr leftExpr = left.translateToLua(tr);
        LuaExpr rightExpr = right.translateToLua(tr);
        ImType t = left.attrTyp();
        return ExprTranslation.translateEquals(leftExpr, rightExpr, t, tr);
    }

    private static LuaExpr translateEquals(LuaExpr leftExpr, LuaExpr rightExpr, ImType t, LuaTranslator tr) {
        if (t instanceof ImTupleType) {
            ImTupleType tt = (ImTupleType)t;
            LuaFunction ef = ExprTranslation.getTupleEqualsFunc(tt, tr);
            return LuaAst.LuaExprFunctionCall(ef, LuaAst.LuaExprlist(leftExpr, rightExpr));
        }
        return LuaAst.LuaExprBinary(leftExpr, LuaAst.LuaOpEquals(), rightExpr);
    }

    public static LuaExpr translate(ImRealVal e, LuaTranslator tr) {
        return LuaAst.LuaExprRealVal(e.getValR());
    }

    public static LuaExpr translate(ImStatementExpr e, LuaTranslator tr) {
        LuaStatements body = tr.translateStatements(e.getStatements());
        body.add(LuaAst.LuaReturn(e.getExpr().translateToLua(tr)));
        return LuaAst.LuaExprFunctionCallE(LuaAst.LuaExprFunctionAbstraction(LuaAst.LuaParams(new LuaVariable[0]), body), LuaAst.LuaExprlist(new LuaExpr[0]));
    }

    public static LuaExpr translate(ImStringVal e, LuaTranslator tr) {
        return LuaAst.LuaExprStringVal(e.getValS());
    }

    public static LuaExpr translate(ImTupleExpr e, LuaTranslator tr) {
        LuaTableFields tableFields = LuaAst.LuaTableFields(new LuaTableField[0]);
        for (ImExpr te : e.getExprs()) {
            tableFields.add(LuaAst.LuaTableSingleField(te.translateToLua(tr)));
        }
        return LuaAst.LuaTableConstructor(tableFields);
    }

    public static LuaExpr translate(ImTupleSelection e, LuaTranslator tr) {
        return LuaAst.LuaExprArrayAccess(e.getTupleExpr().translateToLua(tr), LuaAst.LuaExprlist(LuaAst.LuaExprIntVal("" + (1 + e.getTupleIndex()))));
    }

    public static LuaExpr translate(ImTypeIdOfClass e, LuaTranslator tr) {
        int i = tr.getTypeId(e.getClazz().getClassDef());
        return LuaAst.LuaExprIntVal("" + i);
    }

    public static LuaExpr translate(ImTypeIdOfObj e, LuaTranslator tr) {
        return LuaAst.LuaExprFieldAccess(e.getObj().translateToLua(tr), TYPE_ID);
    }

    public static LuaExpr translate(ImVarAccess e, LuaTranslator tr) {
        return LuaAst.LuaExprVarAccess(tr.luaVar.getFor(e.getVar()));
    }

    public static LuaExpr translate(ImVarArrayAccess e, LuaTranslator tr) {
        LuaExprlist indexes = LuaAst.LuaExprlist(new LuaExpr[0]);
        for (ImExpr ie : e.getIndexes()) {
            indexes.add(ie.translateToLua(tr));
        }
        return LuaAst.LuaExprArrayAccess(LuaAst.LuaExprVarAccess(tr.luaVar.getFor(e.getVar())), indexes);
    }

    public static LuaExpr translate(ImGetStackTrace e, LuaTranslator tr) {
        return LuaAst.LuaLiteral("\"$Stacktrace$\"");
    }

    public static LuaExpr translate(ImCompiletimeExpr imCompiletimeExpr, LuaTranslator tr) {
        throw new Error("not implemented");
    }

    public static LuaExpr translate(ImTypeVarDispatch imTypeVarDispatch, LuaTranslator tr) {
        throw new Error("not implemented");
    }

    public static LuaExpr translate(ImCast imCast, LuaTranslator tr) {
        LuaExpr translated = imCast.getExpr().translateToLua(tr);
        if (TypesHelper.isIntType(imCast.getToType())) {
            return LuaAst.LuaExprFunctionCall(tr.toIndexFunction, LuaAst.LuaExprlist(translated));
        }
        if (imCast.getToType() instanceof ImClassType || imCast.getToType() instanceof ImAnyType) {
            return LuaAst.LuaExprFunctionCall(tr.fromIndexFunction, LuaAst.LuaExprlist(translated));
        }
        return translated;
    }

    static class TupleFunc {
        final ImTupleType tupleType;
        final LuaFunction func;

        public TupleFunc(ImTupleType tupleType, LuaFunction func) {
            this.tupleType = tupleType;
            this.func = func;
        }
    }
}

