/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImBoolVal;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImGetStackTrace;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImIntVal;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImNoExpr;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImPrintable;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImRealVal;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImStringVal;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.ImTypeClassFunc;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImTypeVarDispatch;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImTypeVars;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlag;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class ImPrinter {
    public static void print(ImProg p, Appendable sb, int indent) {
        for (ImVar g : p.getGlobals()) {
            g.print(sb, indent);
            ImPrinter.append(sb, "\n");
        }
        ImPrinter.append(sb, "\n\n");
        p.getGlobalInits().forEach((v, es) -> {
            v.print(sb, indent);
            ImPrinter.append(sb, " = ");
            boolean first = true;
            for (ImSet e : es) {
                if (!first) {
                    ImPrinter.append(sb, ", ");
                }
                e.getRight().print(sb, indent);
                first = false;
            }
            ImPrinter.append(sb, "\n");
        });
        ImPrinter.append(sb, "\n\n");
        for (ImFunction f : p.getFunctions()) {
            f.print(sb, indent);
            ImPrinter.append(sb, "\n");
        }
        for (ImMethod m : p.getMethods()) {
            ImPrinter.printMethod(sb, m, indent);
        }
        ImPrinter.append(sb, "\n\n");
        for (ImClass c : p.getClasses()) {
            ImPrinter.print(c, sb, indent);
        }
    }

    public static void print(ImClass c, Appendable sb, int indent) {
        ImPrinter.append(sb, "class ");
        ImPrinter.append(sb, c.getName());
        ImPrinter.append(sb, ImPrinter.smallHash(c));
        ImPrinter.printTypeVariables(c.getTypeVariables(), sb, indent);
        ImPrinter.append(sb, " extends ");
        for (ImClassType sc : c.getSuperClasses()) {
            sc.print(sb, indent);
            ImPrinter.append(sb, " ");
        }
        ImPrinter.append(sb, "{\n");
        for (ImVar f : c.getFields()) {
            ImPrinter.indent(sb, indent + 1);
            f.print(sb, indent + 1);
            ImPrinter.append(sb, "\n");
        }
        ImPrinter.append(sb, "\n\n");
        for (ImMethod m : c.getMethods()) {
            ImPrinter.indent(sb, indent + 1);
            ImPrinter.printMethod(sb, m, indent + 1);
        }
        for (ImFunction func : c.getFunctions()) {
            func.print(sb, indent + 1);
        }
        ImPrinter.append(sb, "}\n\n");
    }

    private static void printMethod(Appendable sb, ImMethod m, int indent) {
        if (m.getIsAbstract()) {
            ImPrinter.append(sb, "abstract ");
        }
        ImPrinter.append(sb, "method ");
        m.getMethodClass().print(sb, indent);
        ImPrinter.append(sb, ".");
        ImPrinter.append(sb, m.getName());
        ImPrinter.append(sb, ImPrinter.smallHash(m));
        ImPrinter.append(sb, " implemented by ");
        ImPrinter.append(sb, m.getImplementation().getName());
        ImPrinter.append(sb, ImPrinter.smallHash(m.getImplementation()));
        ImPrinter.append(sb, "\n");
        for (ImMethod sm : m.getSubMethods()) {
            ImPrinter.append(sb, "        sub: ");
            sm.getMethodClass().print(sb, indent);
            ImPrinter.append(sb, ".");
            ImPrinter.append(sb, sm.getName());
            ImPrinter.append(sb, ImPrinter.smallHash(sm));
            ImPrinter.append(sb, "\n");
        }
        ImPrinter.append(sb, "\n");
    }

    private static void append(Appendable sb, Object s) {
        ImPrinter.append(sb, s.toString());
    }

    private static void append(Appendable sb, String s) {
        try {
            sb.append(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void print(ImSimpleType p, Appendable sb, int indent) {
        ImPrinter.append(sb, p.getTypename());
    }

    public static void print(ImArrayType t, Appendable sb, int indent) {
        ImPrinter.append(sb, "array<");
        t.getEntryType().print(sb, indent);
        ImPrinter.append(sb, ">");
    }

    public static void print(ImTupleType p, Appendable sb, int indent) {
        ImPrinter.append(sb, "\u2985");
        boolean first = true;
        for (ImType t : p.getTypes()) {
            if (!first) {
                ImPrinter.append(sb, ", ");
            }
            t.print(sb, indent);
            first = false;
        }
        ImPrinter.append(sb, "\u2986");
    }

    public static void print(ImVoid p, Appendable sb, int indent) {
        ImPrinter.append(sb, "void");
    }

    public static void print(ImFunction p, Appendable sb, int indent) {
        ImPrinter.indent(sb, indent);
        for (FunctionFlag flag : p.getFlags()) {
            ImPrinter.append(sb, flag);
            ImPrinter.append(sb, " ");
        }
        ImPrinter.append(sb, "function ");
        ImPrinter.append(sb, p.getName());
        ImPrinter.append(sb, ImPrinter.smallHash(p));
        ImPrinter.printTypeVariables(p.getTypeVariables(), sb, indent);
        ImPrinter.append(sb, "(");
        boolean first = true;
        for (ImVar p1 : p.getParameters()) {
            if (!first) {
                ImPrinter.append(sb, ", ");
            }
            p1.print(sb, indent);
            first = false;
        }
        ImPrinter.append(sb, ")");
        if (!(p.getReturnType() instanceof ImVoid)) {
            ImPrinter.append(sb, " returns ");
            p.getReturnType().print(sb, indent);
        }
        ImPrinter.append(sb, " { \n");
        for (ImVar v : p.getLocals()) {
            ImPrinter.indent(sb, indent + 1);
            ImPrinter.append(sb, "local ");
            v.print(sb, indent + 1);
            ImPrinter.append(sb, "\n");
        }
        p.getBody().print(sb, indent + 1);
        ImPrinter.indent(sb, indent);
        ImPrinter.append(sb, "}\n\n");
    }

    private static void printTypeVariables(ImTypeVars tvs, Appendable sb, int indent) {
        if (tvs.isEmpty()) {
            return;
        }
        ImPrinter.append(sb, "<");
        for (int i = 0; i < tvs.size(); ++i) {
            if (i > 0) {
                ImPrinter.append(sb, ", ");
            }
            ((ImTypeVar)tvs.get(i)).print(sb, indent);
        }
        ImPrinter.append(sb, ">");
    }

    public static void print(ImIf p, Appendable sb, int indent) {
        ImPrinter.append(sb, "if ");
        p.getCondition().print(sb, indent);
        ImPrinter.append(sb, " {\n");
        p.getThenBlock().print(sb, indent + 1);
        ImPrinter.indent(sb, indent);
        ImPrinter.append(sb, "} else {\n");
        p.getElseBlock().print(sb, indent + 1);
        ImPrinter.indent(sb, indent);
        ImPrinter.append(sb, "}");
    }

    private static void indent(Appendable sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            ImPrinter.append(sb, "    ");
        }
    }

    public static void print(ImLoop p, Appendable sb, int indent) {
        ImPrinter.append(sb, "loop {\n");
        p.getBody().print(sb, indent + 1);
        ImPrinter.indent(sb, indent);
        ImPrinter.append(sb, "}");
    }

    public static void print(ImExitwhen p, Appendable sb, int indent) {
        ImPrinter.append(sb, "exitwhen ");
        p.getCondition().print(sb, indent);
    }

    public static void print(ImReturn p, Appendable sb, int indent) {
        ImPrinter.append(sb, "return ");
        p.getReturnValue().print(sb, indent);
    }

    public static void print(ImSet p, Appendable sb, int indent) {
        p.getLeft().print(sb, indent);
        ImPrinter.append(sb, " = ");
        p.getRight().print(sb, indent);
    }

    public static void print(ImNoExpr p, Appendable sb, int indent) {
        ImPrinter.append(sb, "%nothing%");
    }

    public static void print(ImStatementExpr p, Appendable sb, int indent) {
        ImPrinter.append(sb, "{\n");
        p.getStatements().print(sb, indent + 1);
        ImPrinter.indent(sb, indent + 1);
        ImPrinter.append(sb, ">>>  ");
        p.getExpr().print(sb, indent + 1);
        ImPrinter.append(sb, "}");
    }

    public static void print(ImFunctionCall p, Appendable sb, int indent) {
        if (p.getCallType() == CallType.EXECUTE) {
            ImPrinter.append(sb, "EXECUTE ");
        }
        ImPrinter.append(sb, p.getFunc().getName());
        ImPrinter.append(sb, ImPrinter.smallHash(p.getFunc()));
        ImPrinter.printTypeArguments(p.getTypeArguments(), indent, sb);
        ImPrinter.printArgumentList(sb, indent, p.getArguments());
    }

    public static void printArgumentList(Appendable sb, int indent, List<ImExpr> args) {
        ImPrinter.append(sb, "(");
        boolean first = true;
        for (ImExpr a : args) {
            if (!first) {
                ImPrinter.append(sb, ", ");
            }
            a.print(sb, indent);
            first = false;
        }
        ImPrinter.append(sb, ")");
    }

    public static void print(ImVarAccess p, Appendable sb, int indent) {
        ImPrinter.append(sb, p.getVar().getName());
        ImPrinter.append(sb, "_");
        ImPrinter.append(sb, ImPrinter.smallHash(p.getVar()));
    }

    public static String smallHash(Object g) {
        String c = "" + g.hashCode();
        return c.substring(0, Math.min(3, c.length() - 1));
    }

    public static void print(ImVarArrayAccess p, Appendable sb, int indent) {
        ImPrinter.append(sb, p.getVar().getName());
        ImPrinter.append(sb, "_");
        ImPrinter.append(sb, ImPrinter.smallHash(p.getVar()));
        for (ImExpr ie : p.getIndexes()) {
            ImPrinter.append(sb, "[");
            ie.print(sb, indent + 1);
            ImPrinter.append(sb, "]");
        }
    }

    public static void print(ImTupleExpr p, Appendable sb, int indent) {
        ImPrinter.append(sb, "<");
        boolean first = true;
        for (ImExpr e : p.getExprs()) {
            if (!first) {
                ImPrinter.append(sb, ", ");
            }
            e.print(sb, indent);
            first = false;
        }
        ImPrinter.append(sb, ">");
    }

    public static void print(ImTupleSelection p, Appendable sb, int indent) {
        p.getTupleExpr().print(sb, indent);
        ImPrinter.append(sb, "#");
        ImPrinter.append(sb, p.getTupleIndex());
    }

    public static void print(ImIntVal p, Appendable sb, int indent) {
        ImPrinter.append(sb, p.getValI());
    }

    public static void print(ImRealVal p, Appendable sb, int indent) {
        ImPrinter.append(sb, p.getValR());
    }

    public static void print(ImStringVal p, Appendable sb, int indent) {
        ImPrinter.append(sb, Character.valueOf('\"'));
        ImPrinter.append(sb, p.getValS());
        ImPrinter.append(sb, Character.valueOf('\"'));
    }

    public static void print(ImBoolVal p, Appendable sb, int indent) {
        ImPrinter.append(sb, p.getValB() ? "true" : "false");
    }

    public static void print(ImFuncRef p, Appendable sb, int indent) {
        ImPrinter.append(sb, "function ");
        ImPrinter.append(sb, p.getFunc().getName());
    }

    public static void print(ImNull p, Appendable sb, int indent) {
        ImPrinter.append(sb, "null");
        if (!(p.getType() instanceof ImVoid)) {
            ImPrinter.append(sb, "<");
            p.getType().print(sb, indent);
            ImPrinter.append(sb, ">");
        }
    }

    public static void print(ImStmts ss, Appendable sb, int indent) {
        for (ImStmt s : ss) {
            ImPrinter.indent(sb, indent);
            s.print(sb, indent);
            ImPrinter.append(sb, ";\n");
        }
    }

    public static void print(ImVar v, Appendable sb, int indent) {
        v.getType().print(sb, indent);
        ImPrinter.append(sb, " ");
        ImPrinter.append(sb, v.getName());
        ImPrinter.append(sb, ImPrinter.smallHash(v));
    }

    public static void print(ImOperatorCall e, Appendable sb, int indent) {
        ImPrinter.append(sb, "(");
        if (e.getArguments().size() == 2) {
            ((ImExpr)e.getArguments().get(0)).print(sb, indent);
            ImPrinter.append(sb, " ");
            ImPrinter.append(sb, (Object)e.getOp());
            ImPrinter.append(sb, " ");
            ((ImExpr)e.getArguments().get(1)).print(sb, indent);
        } else {
            ImPrinter.append(sb, (Object)e.getOp());
            for (ImExpr a : e.getArguments()) {
                ImPrinter.append(sb, " ");
                a.print(sb, indent);
            }
        }
        ImPrinter.append(sb, ")");
    }

    public static String printToString(ImPrintable p) {
        return ImPrinter.asString(p);
    }

    public static String asString(ImPrintable p) {
        StringBuilder sb = new StringBuilder();
        try {
            p.print(sb, 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            ImPrinter.append((Appendable)sb, "## error {");
            ImPrinter.append((Appendable)sb, t);
            ImPrinter.append((Appendable)sb, "}");
        }
        return ((Object)sb).toString();
    }

    public static void print(ImMethodCall mc, Appendable sb, int indent) {
        mc.getReceiver().print(sb, 0);
        ImPrinter.append(sb, ".");
        ImPrinter.append(sb, mc.getMethod().getName());
        ImPrinter.append(sb, ImPrinter.smallHash(mc.getMethod()));
        ImPrinter.printTypeArguments(mc.getTypeArguments(), indent, sb);
        ImPrinter.printArgumentList(sb, 0, mc.getArguments());
    }

    public static String asString(ImFunction f) {
        return f.getName() + ImPrinter.smallHash(f);
    }

    public static void print(ImMemberAccess e, Appendable sb, int indent) {
        e.getReceiver().print(sb, 0);
        ImPrinter.append(sb, ".");
        ImPrinter.append(sb, e.getVar().getName());
        ImPrinter.append(sb, ImPrinter.smallHash(e.getVar()));
        for (ImExpr index : e.getIndexes()) {
            ImPrinter.append(sb, "[");
            index.print(sb, indent);
            ImPrinter.append(sb, "]");
        }
        ImPrinter.printTypeArguments(e.getTypeArguments(), indent, sb);
    }

    public static void print(ImAlloc e, Appendable sb, int indent) {
        ImPrinter.append(sb, "#alloc(");
        e.getClazz().print(sb, indent);
        ImPrinter.append(sb, ")");
    }

    public static void print(ImDealloc e, Appendable sb, int indent) {
        ImPrinter.append(sb, "#dealloc(");
        e.getClazz().print(sb, indent);
        ImPrinter.append(sb, ", ");
        e.getObj().print(sb, 0);
        ImPrinter.append(sb, ")");
    }

    public static void print(ImInstanceof e, Appendable sb, int indent) {
        e.getObj().print(sb, 0);
        ImPrinter.append(sb, " instanceof ");
        e.getClazz().print(sb, indent);
    }

    public static void print(ImTypeIdOfClass e, Appendable sb, int indent) {
        ImPrinter.append(sb, e.getClass().getName());
        ImPrinter.append(sb, ".typeId");
    }

    public static void print(ImTypeIdOfObj e, Appendable sb, int indent) {
        e.getObj().print(sb, 0);
        ImPrinter.append(sb, ".typeId");
    }

    public static void print(ImArrayTypeMulti imArrayTypeMulti, Appendable sb, int indent) {
        ImPrinter.append(sb, "array<");
        imArrayTypeMulti.getEntryType().print(sb, indent);
        ImPrinter.append(sb, " size: ");
        ImPrinter.append(sb, imArrayTypeMulti.getArraySize());
        ImPrinter.append(sb, ">");
    }

    public static void print(ImGetStackTrace e, Appendable sb, int indent) {
        ImPrinter.append(sb, "#getStackTrace()");
    }

    public static void print(ImCompiletimeExpr e, Appendable sb, int indent) {
        ImPrinter.append(sb, "compiletime<<");
        e.getExpr().print(sb, indent);
        ImPrinter.append(sb, ">>");
    }

    public static void print(ImVarargLoop e, Appendable sb, int indent) {
        ImPrinter.append(sb, "foreach vararg ");
        e.getLoopVar().print(sb, indent);
        ImPrinter.append(sb, " {\n");
        e.getBody().print(sb, indent + 1);
        ImPrinter.indent(sb, indent);
        ImPrinter.append(sb, "}");
    }

    public static void print(ImTypeVarDispatch e, Appendable sb, int indent) {
        ImPrinter.append(sb, "<");
        ImPrinter.append(sb, e.getTypeVariable().getName());
        ImPrinter.append(sb, ">.");
        ImPrinter.append(sb, e.getTypeClassFunc().getName());
        ImPrinter.printArgumentList(sb, indent, e.getArguments());
    }

    public static void print(ImTypeVarRef e, Appendable sb, int indent) {
        ImPrinter.append(sb, e.getTypeVariable().getName());
        ImPrinter.append(sb, ImPrinter.smallHash(e.getTypeVariable()));
    }

    public static void print(ImClassType ct, Appendable sb, int indent) {
        ImPrinter.append(sb, ct.getClassDef().getName());
        ImTypeArguments typeArguments = ct.getTypeArguments();
        ImPrinter.printTypeArguments(typeArguments, indent, sb);
    }

    private static void printTypeArguments(ImTypeArguments typeArguments, int indent, Appendable sb) {
        if (!typeArguments.isEmpty()) {
            ImPrinter.append(sb, "<");
            boolean first = true;
            for (ImTypeArgument ta : typeArguments) {
                if (!first) {
                    ImPrinter.append(sb, ", ");
                }
                ta.getType().print(sb, indent);
                first = false;
            }
            ImPrinter.append(sb, ">");
        }
    }

    public static void print(ImTypeVar tv, Appendable sb, int indent) {
        ImPrinter.append(sb, tv.getName());
        ImPrinter.append(sb, ImPrinter.smallHash(tv));
    }

    public static String asString(ImStmts s) {
        return ImPrinter.asString((ImPrintable)s);
    }

    public static String asString(List<?> s) {
        return "[" + s.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    public static String asString(ImTypeClassFunc s) {
        return s.getName() + ImPrinter.smallHash(s);
    }

    public static String asString(ImClass s) {
        return s.getName() + ImPrinter.smallHash(s);
    }

    public static String asString(ImMethod s) {
        return s.getName() + ImPrinter.smallHash(s);
    }

    public static String asString(ImTypeArgument s) {
        return "" + s.getType() + s.getTypeClassBinding();
    }

    public static void print(ImCast e, Appendable sb, int indent) {
        ImPrinter.append(sb, "(");
        e.getExpr().print(sb, indent);
        ImPrinter.append(sb, " castTo ");
        e.getToType().print(sb, indent);
        ImPrinter.append(sb, ")");
    }

    public static void print(ImAnyType at, Appendable sb, int indent) {
        ImPrinter.append(sb, "any");
    }
}

