/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import de.peeeq.wurstio.languageserver.ConfigProvider;
import de.peeeq.wurstio.languageserver.LanguageWorker;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.WurstCommands;
import de.peeeq.wurstio.languageserver.WurstTextDocumentService;
import de.peeeq.wurstio.languageserver.WurstWorkspaceService;
import de.peeeq.wurstscript.WLogger;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class WurstLanguageServer
implements LanguageServer,
LanguageClientAware {
    private WFile rootUri;
    private final LanguageWorker languageWorker = new LanguageWorker();
    private LanguageClient languageClient;
    private RemoteEndpoint remoteEndpoint;

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        System.err.println("Loading Wurst version 1.8.1.0-jenkins-Wurst-1367");
        this.setupLogger();
        System.setErr(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.err), true, StandardCharsets.UTF_8));
        if (params.getRootUri() == null) {
            System.err.println("Workspace null. Make sure to open a valid project root using File->Open Folder, before opening code files.");
            return CompletableFuture.completedFuture(null);
        }
        WLogger.info("initialize " + params.getRootUri());
        this.rootUri = WFile.create(params.getRootUri());
        this.languageWorker.setRootPath(this.rootUri);
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setCompletionProvider(new CompletionOptions(Boolean.valueOf(false), Collections.singletonList(".")));
        capabilities.setHoverProvider(Boolean.valueOf(true));
        capabilities.setDefinitionProvider(Boolean.valueOf(true));
        capabilities.setSignatureHelpProvider(new SignatureHelpOptions(Arrays.asList("(", ".")));
        capabilities.setDocumentHighlightProvider(Boolean.valueOf(true));
        capabilities.setReferencesProvider(Boolean.valueOf(true));
        capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(WurstCommands.providedCommands()));
        capabilities.setRenameProvider(Boolean.valueOf(true));
        capabilities.setTextDocumentSync(Either.forLeft((Object)TextDocumentSyncKind.Full));
        capabilities.setCodeActionProvider(Boolean.valueOf(true));
        capabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
        capabilities.setWorkspaceSymbolProvider(Boolean.valueOf(true));
        capabilities.setDocumentFormattingProvider(Boolean.valueOf(true));
        capabilities.setColorProvider(Boolean.valueOf(true));
        capabilities.setCodeLensProvider(new CodeLensOptions(Boolean.valueOf(true)));
        capabilities.setFoldingRangeProvider(Boolean.valueOf(true));
        InitializeResult res = new InitializeResult(capabilities);
        WLogger.info("initialization done: " + params.getRootUri());
        return CompletableFuture.completedFuture(res);
    }

    private void setupLogger() {
        WLogger.setLogger("languageServer");
    }

    public CompletableFuture<Object> shutdown() {
        WLogger.info("shutdown");
        this.languageWorker.stop();
        return CompletableFuture.completedFuture("ok");
    }

    public void exit() {
        System.exit(0);
    }

    public TextDocumentService getTextDocumentService() {
        WLogger.info("getTextDocumentService");
        return new WurstTextDocumentService(this.languageWorker);
    }

    public WorkspaceService getWorkspaceService() {
        WLogger.info("getWorkspaceService");
        return new WurstWorkspaceService(this);
    }

    public void connect(LanguageClient client) {
        WLogger.info("connect to LanguageClient");
        this.languageClient = client;
        this.languageWorker.setLanguageClient(client);
    }

    public LanguageWorker worker() {
        return this.languageWorker;
    }

    public WFile getRootUri() {
        return this.rootUri;
    }

    public LanguageClient getLanguageClient() {
        return this.languageClient;
    }

    public ConfigProvider getConfigProvider() {
        return new ConfigProvider(this.languageClient);
    }

    public void setRemoteEndpoint(RemoteEndpoint remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public RemoteEndpoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }
}

