/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImClassRelatedExprWithClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeClassFunc;
import de.peeeq.wurstscript.jassIm.ImTypeVarDispatch;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.types.TypesHelper;

public interface AssertProperty {
    public static final AssertProperty FLAT = e -> {
        if (e instanceof ImStatementExpr) {
            throw new Error("contains statementExpr " + e);
        }
    };
    public static final AssertProperty NOTUPLES = e -> {
        ImVar v;
        if (e instanceof ImTupleExpr || e instanceof ImTupleSelection) {
            throw new Error("contains tuple exprs " + e);
        }
        if (e instanceof ImVar && TypesHelper.typeContainsTuples((v = (ImVar)e).getType())) {
            throw new Error("contains tuple var: " + v + " in\n" + v.getParent().getParent());
        }
    };

    public static AssertProperty rooted(final Element root) {
        return new AssertProperty(){
            ImFunction currentFunction;

            @Override
            public void check(Element e) {
                if (e instanceof ImVar) {
                    this.checkType(e, ((ImVar)e).getType());
                } else if (e instanceof ImFunction) {
                    ImFunction f;
                    this.currentFunction = f = (ImFunction)e;
                    this.checkType(e, f.getReturnType());
                } else if (e instanceof ImTypeClassFunc) {
                    this.checkType(e, ((ImTypeClassFunc)e).getReturnType());
                } else if (e instanceof ImMethod) {
                    this.checkType(e, ((ImMethod)e).getMethodClass());
                    this.checkRooted(e, ((ImMethod)e).getImplementation());
                } else if (e instanceof ImVarargLoop) {
                    this.checkRooted(e, ((ImVarargLoop)e).getLoopVar());
                } else if (e instanceof ImTypeVarDispatch) {
                    this.checkRooted(e, ((ImTypeVarDispatch)e).getTypeClassFunc());
                    this.checkRooted(e, ((ImTypeVarDispatch)e).getTypeVariable());
                } else if (e instanceof ImVarAccess) {
                    this.checkRooted(e, ((ImVarAccess)e).getVar());
                } else if (e instanceof ImVarArrayAccess) {
                    this.checkRooted(e, ((ImVarArrayAccess)e).getVar());
                } else if (e instanceof ImMethodCall) {
                    this.checkRooted(e, ((ImMethodCall)e).getMethod());
                } else if (e instanceof ImMemberAccess) {
                    this.checkRooted(e, ((ImMemberAccess)e).getVar());
                } else if (e instanceof ImClassRelatedExprWithClass) {
                    this.checkType(e, ((ImClassRelatedExprWithClass)e).getClazz());
                } else if (e instanceof ImFunctionCall) {
                    this.checkRooted(e, ((ImFunctionCall)e).getFunc());
                } else if (e instanceof ImFuncRef) {
                    this.checkRooted(e, ((ImFuncRef)e).getFunc());
                } else if (e instanceof ImTypeArgument) {
                    this.checkType(e, ((ImTypeArgument)e).getType());
                }
            }

            private void checkType(Element e, ImType type) {
                if (type instanceof ImArrayType) {
                    this.checkType(e, ((ImArrayType)type).getEntryType());
                } else if (type instanceof ImArrayTypeMulti) {
                    this.checkType(e, ((ImArrayTypeMulti)type).getEntryType());
                } else if (type instanceof ImClassType) {
                    this.checkRooted(e, ((ImClassType)type).getClassDef());
                    for (ImTypeArgument ta : ((ImClassType)type).getTypeArguments()) {
                        this.checkType(e, ta.getType());
                    }
                } else if (type instanceof ImTypeVarRef) {
                    this.checkRooted(e, ((ImTypeVarRef)type).getTypeVariable());
                }
            }

            public void checkRooted(Element location, Element el) {
                try {
                    Element e = el;
                    while (e != null) {
                        if (e == root) {
                            return;
                        }
                        Element parent = e.getParent();
                        if (parent != null) {
                            this.checkContains(location, parent, e);
                            if (parent instanceof ImFunction && parent != this.currentFunction) {
                                throw new CompileError(location, "Element " + el + " is rooted in function " + parent + " but should be in function " + this.currentFunction);
                            }
                            e = parent;
                            continue;
                        }
                        break;
                    }
                }
                catch (CompileError e) {
                    throw new CompileError(location, "Element " + el + " not rooted. In ...\n" + location + "\n\n" + e.getMessage());
                }
                throw new CompileError(location, "Element " + el + " not rooted. In ...\n" + location);
            }

            private void checkContains(Element location, Element parent, Element e) {
                for (int i = 0; i < parent.size(); ++i) {
                    if (parent.get(i) != e) continue;
                    return;
                }
                throw new CompileError(location, "Element " + e + " does not appear in parent " + parent.getClass().getSimpleName() + ".\nIn ...\n" + location);
            }
        };
    }

    public void check(Element var1);
}

