/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Coords3DF;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObjId;

public class DOO_UNITS {
    public static final File GAME_PATH = new File("war3mapUnits.doo");
    private List<Obj> _objs = new ArrayList<Obj>();

    @Nonnull
    public List<Obj> getObjs() {
        return new ArrayList<Obj>(this._objs);
    }

    private void addObj(@Nullable Obj val) {
        this._objs.add(val);
    }

    @Nonnull
    public Obj addObj() {
        Obj obj = new Obj();
        this.addObj(obj);
        return obj;
    }

    private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
        stream.writeId(Id.valueOf("W3do"));
        stream.writeInt32(EncodingFormat.DOO_0x8.getVersion());
        stream.writeInt32(11);
        stream.writeInt32(this._objs.size());
        for (Obj obj : this._objs) {
            obj.write(stream, EncodingFormat.DOO_0x8);
        }
    }

    private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.DOO_0x8.getVersion(), version);
        int subVersion = stream.readInt32("subVersion");
        int objsCount = stream.readInt32("objsCount");
        for (int i = 0; i < objsCount; ++i) {
            this.addObj(new Obj(stream, EncodingFormat.DOO_0x8));
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.rewind();
        this.read(stream, stream.getFormat(EncodingFormat.class, version));
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case DOO_0x8: {
                this.read_0x8(stream);
            }
        }
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case DOO_0x8: 
            case AUTO: {
                this.write_0x8(stream);
            }
        }
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO);
    }

    private void read(@Nonnull File file) throws IOException {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream, EncodingFormat.AUTO);
        inStream.close();
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public DOO_UNITS(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this.read(stream);
    }

    public DOO_UNITS() {
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat DOO_0x8 = new EncodingFormat(Enum.DOO_0x8, 8);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            DOO_0x8;

        }
    }

    public static class Obj {
        private ObjId _typeId;
        private int _variation = 0;
        private Coords3DF _pos = new Coords3DF(0.0f, 0.0f, 0.0f);
        private float _angle = 0.0f;
        private Coords3DF _scale = new Coords3DF(0.0f, 0.0f, 0.0f);
        private int _flags = 0;
        private int _ownerIndex = 0;
        private int _unknownA = 0;
        private int _unknownB = 0;
        private int _lifePerc = 100;
        private int _manaPerc = 100;
        private int _itemTablePtr = 0;
        private List<LootSet> _lootSets = new ArrayList<LootSet>();
        private int _resourcesAmount = 0;
        private float _targetAcquisition = 0.0f;
        private int _heroLevel = 1;
        private int _heroStr = 0;
        private int _heroAgi = 0;
        private int _heroInt = 0;
        private List<InvItem> _invItems = new ArrayList<InvItem>();
        private List<AbilMod> _abilMods = new ArrayList<AbilMod>();
        private int _randFlag = 0;
        final int randFlag_ANY = 0;
        final int randFlag_RAND_GROUP = 1;
        final int randFlag_RAND_CUSTOM = 2;
        private int _randLevel = 0;
        int _randClass = 0;
        final int randClass_ANY_OR_SPECIFIC = 0;
        final int randClass_PERM = 1;
        private int _randGroupIndex = 0;
        private int _randGroupPos = 0;
        private List<RandObj> _randObjs = new ArrayList<RandObj>();
        private int _customColor = 0;
        private int _waygateTargetRectIndex = 0;
        private int _editorId = 0;

        public ObjId getTypeId() {
            return this._typeId;
        }

        public void setTypeId(ObjId val) {
            this._typeId = val;
        }

        public int getVariation() {
            return this._variation;
        }

        public void setVariation(int val) {
            this._variation = val;
        }

        public Coords3DF getPos() {
            return this._pos;
        }

        public void setPos(Coords3DF val) {
            this._pos = val;
        }

        public float getAngle() {
            return this._angle;
        }

        public void setAngle(float val) {
            this._angle = val;
        }

        public Coords3DF getScale() {
            return this._scale;
        }

        public void setScale(Coords3DF val) {
            this._scale = val;
        }

        public int getFlags() {
            return this._flags;
        }

        public void setFlags(int val) {
            this._flags = val;
        }

        public int getOwnerIndex() {
            return this._ownerIndex;
        }

        public void setOwnerIndex(int val) {
            this._ownerIndex = val;
        }

        public int getUnknownA() {
            return this._unknownA;
        }

        public void setUnknownA(int val) {
            this._unknownA = val;
        }

        public int getUnknownB() {
            return this._unknownB;
        }

        public void setUnknownB(int val) {
            this._unknownB = val;
        }

        public int getLifePerc() {
            return this._lifePerc;
        }

        public void setLifePerc(int val) {
            this._lifePerc = val;
        }

        public int getManaPerc() {
            return this._manaPerc;
        }

        public void setManaPerc(int val) {
            this._manaPerc = val;
        }

        public int getItemTablePtr() {
            return this._itemTablePtr;
        }

        public void setItemTablePtr(int val) {
            this._itemTablePtr = val;
        }

        private void addLootSet(@Nonnull LootSet val) {
            this._lootSets.add(val);
        }

        @Nonnull
        public LootSet addLootSet() {
            LootSet set = new LootSet();
            this.addLootSet(set);
            return set;
        }

        public int getResourcesAmount() {
            return this._resourcesAmount;
        }

        public void setResourcesAmount(int val) {
            this._resourcesAmount = val;
        }

        public float targetAcquisition_NORMAL() {
            return -1.0f;
        }

        public float targetAcquisition_CAMP() {
            return -2.0f;
        }

        public float getTargetAcquisition() {
            return this._targetAcquisition;
        }

        public void setTargetAcquisition(float val) {
            this._targetAcquisition = val;
        }

        public int getHeroLevel() {
            return this._heroLevel;
        }

        public void setHeroLevel(int val) {
            this._heroLevel = val;
        }

        public int getHeroStr() {
            return this._heroStr;
        }

        public int getHeroAgi() {
            return this._heroAgi;
        }

        public int getHeroInt() {
            return this._heroInt;
        }

        public void setHeroAttributes(int strVal, int agiVal, int intVal) {
            this._heroStr = strVal;
            this._heroAgi = agiVal;
            this._heroInt = intVal;
        }

        private void addInvItem(@Nonnull InvItem val) {
            this._invItems.add(val);
        }

        @Nonnull
        public InvItem addInvItem() {
            InvItem item = new InvItem();
            this.addInvItem(item);
            return item;
        }

        private void addAbilMod(@Nonnull AbilMod val) {
            this._abilMods.add(val);
        }

        @Nonnull
        public AbilMod addAbilMod() {
            AbilMod abil = new AbilMod();
            this.addAbilMod(abil);
            return abil;
        }

        public int getRandFlag() {
            return this._randFlag;
        }

        public void setRandFlag(int val) {
            this._randFlag = val;
        }

        public int getRandLevel() {
            return this._randLevel;
        }

        public void setRandLevel(int val) {
            this._randLevel = val;
        }

        public int getRandClass() {
            return this._randClass;
        }

        public void setRandClass(int val) {
            this._randClass = val;
        }

        public int getRandGroupIndex() {
            return this._randGroupIndex;
        }

        public void setRandGroupIndex(int val) {
            this._randGroupIndex = val;
        }

        public int getRandGroupPos() {
            return this._randGroupPos;
        }

        public void setRandGroupPos(int val) {
            this._randGroupPos = val;
        }

        private void addRandObj(RandObj val) {
            this._randObjs.add(val);
        }

        public RandObj addRandObj() {
            RandObj obj = new RandObj();
            this.addRandObj(obj);
            return obj;
        }

        public int getCustomColor() {
            return this._customColor;
        }

        public void setCustomColor(int val) {
            this._customColor = val;
        }

        public int getWaygateTargetRectIndex() {
            return this._waygateTargetRectIndex;
        }

        public void setWaygateTargetRectIndex(int val) {
            this._waygateTargetRectIndex = val;
        }

        public int getEditorId() {
            return this._editorId;
        }

        public void setEditorId(int val) {
            this._editorId = val;
        }

        private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setTypeId(ObjId.valueOf(stream.readId("typeId")));
            this.setVariation(stream.readInt32("variation"));
            this.setPos(new Coords3DF(stream.readFloat32("posX").floatValue(), stream.readFloat32("posY").floatValue(), stream.readFloat32("posZ").floatValue()));
            this.setAngle(stream.readFloat32("angle").floatValue());
            this.setScale(new Coords3DF(stream.readFloat32("scaleX").floatValue(), stream.readFloat32("scaleY").floatValue(), stream.readFloat32("scaleZ").floatValue()));
            this.setFlags(stream.readByte("flags").byteValue());
            this.setOwnerIndex(stream.readInt32("ownerIndex"));
            this.setUnknownA(stream.readByte("unknownA").byteValue());
            this.setUnknownB(stream.readByte("unknownB").byteValue());
            this.setLifePerc(stream.readInt32("lifePerc"));
            this.setManaPerc(stream.readInt32("manaPerc"));
            this.setItemTablePtr(stream.readInt32("itemTablePtr"));
            int lootsCount = stream.readInt32("lootsCount");
            for (int i = 0; i < lootsCount; ++i) {
                this.addLootSet(new LootSet(stream, EncodingFormat.DOO_0x8));
            }
            this.setResourcesAmount(stream.readInt32("resourcesAmount"));
            this.setTargetAcquisition(stream.readFloat32("targetAcquisition").floatValue());
            this.setHeroLevel(stream.readInt32("heroLevel"));
            this.setHeroAttributes(stream.readInt32("heroStr"), stream.readInt32("heroAgi"), stream.readInt32("heroInt"));
            int invItemsCount = stream.readInt32("invItemsCount");
            for (int i = 0; i < invItemsCount; ++i) {
                this.addInvItem(new InvItem(stream, EncodingFormat.DOO_0x8));
            }
            int abilModsCount = stream.readInt32("abilModsCount");
            for (int i = 0; i < abilModsCount; ++i) {
                this.addAbilMod(new AbilMod(stream, EncodingFormat.DOO_0x8));
            }
            int randFlag = stream.readInt32("randFlag");
            this.setRandFlag(randFlag);
            switch (randFlag) {
                case 0: {
                    int rand1 = stream.readByte() & 0xFF;
                    int rand2 = stream.readByte() & 0xFF;
                    int rand3 = stream.readByte() & 0xFF;
                    int randLevel = rand3 * 256 * 256 + rand2 * 256 + rand1;
                    this.setRandLevel(randLevel);
                    this.setRandClass(stream.readByte());
                    break;
                }
                case 1: {
                    this.setRandGroupIndex(stream.readInt32());
                    this.setRandGroupPos(stream.readInt32());
                    break;
                }
                case 2: {
                    int randUnitsCount = stream.readInt32();
                    for (int i = 0; i < randUnitsCount; ++i) {
                        this.addRandObj(new RandObj(stream, EncodingFormat.DOO_0x8));
                    }
                    break;
                }
            }
            this.setCustomColor(stream.readInt32("customColor"));
            this.setWaygateTargetRectIndex(stream.readInt32("waygateTargetRectIndex"));
            this.setEditorId(stream.readInt32("editorId"));
        }

        private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
            stream.writeId(this.getTypeId());
            stream.writeInt32(this.getVariation());
            Coords3DF pos = this.getPos();
            stream.writeFloat32(pos.getX());
            stream.writeFloat32(pos.getY());
            stream.writeFloat32(pos.getZ());
            stream.writeFloat32(this.getAngle());
            Coords3DF scale = this.getScale();
            stream.writeFloat32(scale.getX());
            stream.writeFloat32(scale.getY());
            stream.writeFloat32(scale.getZ());
            stream.writeUByte(this.getFlags());
            stream.writeInt32(this.getOwnerIndex());
            stream.writeUByte(this.getUnknownA());
            stream.writeUByte(this.getUnknownB());
            stream.writeInt32(this.getLifePerc());
            stream.writeInt32(this.getManaPerc());
            stream.writeInt32(this.getItemTablePtr());
            stream.writeInt32(this._lootSets.size());
            for (LootSet set : this._lootSets) {
                set.write(stream, EncodingFormat.DOO_0x8);
            }
            stream.writeInt32(this.getResourcesAmount());
            stream.writeFloat32(this.getTargetAcquisition());
            stream.writeInt32(this.getHeroLevel());
            stream.writeInt32(this.getHeroStr());
            stream.writeInt32(this.getHeroAgi());
            stream.writeInt32(this.getHeroInt());
            stream.writeInt32(this._invItems.size());
            for (InvItem item : this._invItems) {
                item.write(stream, EncodingFormat.DOO_0x8);
            }
            stream.writeInt32(this._abilMods.size());
            for (AbilMod abilMod : this._abilMods) {
                abilMod.write(stream, EncodingFormat.DOO_0x8);
            }
            int randFlag = this.getRandFlag();
            stream.writeInt32(randFlag);
            switch (randFlag) {
                case 0: {
                    int randLevel = this.getRandLevel();
                    byte rand1 = (byte)(randLevel % 256);
                    byte rand2 = (byte)(randLevel / 256 % 256);
                    byte rand3 = (byte)(randLevel / 65536 % 256);
                    stream.writeByte(rand1);
                    stream.writeByte(rand2);
                    stream.writeByte(rand3);
                    stream.writeUByte(this.getRandClass());
                    break;
                }
                case 1: {
                    stream.writeInt32(this.getRandGroupIndex());
                    stream.writeInt32(this.getRandGroupPos());
                    break;
                }
                case 2: {
                    stream.writeInt32(this._randObjs.size());
                    for (RandObj randObj : this._randObjs) {
                        randObj.write(stream, EncodingFormat.DOO_0x8);
                    }
                    break;
                }
            }
            stream.writeInt32(this.getCustomColor());
            stream.writeInt32(this.getWaygateTargetRectIndex());
            stream.writeInt32(this.getEditorId());
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case DOO_0x8: {
                    this.read_0x8(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case DOO_0x8: 
                case AUTO: {
                    this.write_0x8(stream);
                }
            }
        }

        public Obj(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Obj() {
        }

        public static class RandObj {
            private ObjId _typeId;
            private int _chance;

            public ObjId getTypeId() {
                return this._typeId;
            }

            public void setTypeId(ObjId val) {
                this._typeId = val;
            }

            public int getChance() {
                return this._chance;
            }

            public void setChance(int val) {
                this._chance = val;
            }

            private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                this.setTypeId(ObjId.valueOf(stream.readId("typeId")));
                this.setChance(stream.readInt32("chance"));
            }

            private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
                stream.writeId(this.getTypeId());
                stream.writeInt32(this.getChance());
            }

            private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: {
                        this.read_0x8(stream);
                    }
                }
            }

            private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: 
                    case AUTO: {
                        this.write_0x8(stream);
                    }
                }
            }

            public RandObj(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                this.read(stream, format);
            }

            public RandObj() {
            }
        }

        public static class AbilMod {
            private ObjId _typeId;
            private int _autoCast = 0;
            private final int autoCast_OFF = 0;
            private final int autoCast_ON = 1;
            private int _level = 1;

            public ObjId getTypeId() {
                return this._typeId;
            }

            public void setTypeId(ObjId val) {
                this._typeId = val;
            }

            public int getAutoCast() {
                return this._autoCast;
            }

            public void setAutoCast(int val) {
                this._autoCast = val;
            }

            public int getLevel() {
                return this._level;
            }

            public void setLevel(int val) {
                this._level = val;
            }

            private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                this.setTypeId(ObjId.valueOf(stream.readId("typeId")));
                this.setAutoCast(stream.readInt32("autoCast"));
                this.setLevel(stream.readInt32("level"));
            }

            private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
                stream.writeId(this.getTypeId());
                stream.writeInt32(this.getAutoCast());
                stream.writeInt32(this.getLevel());
            }

            private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: {
                        this.read_0x8(stream);
                    }
                }
            }

            private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: 
                    case AUTO: {
                        this.write_0x8(stream);
                    }
                }
            }

            public AbilMod(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                this.read(stream, format);
            }

            public AbilMod() {
            }
        }

        public static class InvItem {
            private int _slot = 0;
            private ObjId _typeId;

            public int getSlot() {
                return this._slot;
            }

            public void setSlot(int val) {
                this._slot = val;
            }

            public ObjId getTypeId() {
                return this._typeId;
            }

            public void setTypeId(ObjId val) {
                this._typeId = val;
            }

            private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                this.setSlot(stream.readInt32("slot"));
                this.setTypeId(ObjId.valueOf(stream.readId("typeId")));
            }

            private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
                stream.writeInt32(this.getSlot());
                stream.writeId(this.getTypeId());
            }

            private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: {
                        this.read_0x8(stream);
                    }
                }
            }

            private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: 
                    case AUTO: {
                        this.write_0x8(stream);
                    }
                }
            }

            public InvItem(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                this.read(stream, format);
            }

            public InvItem() {
            }
        }

        public static class LootSet {
            private List<Item> _items = new ArrayList<Item>();

            private void addItem(@Nonnull Item val) {
                this._items.add(val);
            }

            @Nonnull
            public Item addItem() {
                Item item = new Item();
                this.addItem(item);
                return item;
            }

            private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                int itemsCount = stream.readInt32("itemsCount");
                for (int i = 1; i <= itemsCount; ++i) {
                    this.addItem(new Item(stream, EncodingFormat.DOO_0x8));
                }
            }

            private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
                stream.writeInt32(this._items.size());
                for (Item item : this._items) {
                    item.write(stream, EncodingFormat.DOO_0x8);
                }
            }

            private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: {
                        this.read_0x8(stream);
                    }
                }
            }

            private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: 
                    case AUTO: {
                        this.write_0x8(stream);
                    }
                }
            }

            public LootSet(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                this.read(stream, format);
            }

            public LootSet() {
            }

            public static class Item {
                private ObjId _typeId;
                private int _chance = 100;

                public ObjId getTypeId() {
                    return this._typeId;
                }

                public void setTypeId(ObjId val) {
                    this._typeId = val;
                }

                public int getChance() {
                    return this._chance;
                }

                public void setChance(int val) {
                    this._chance = val;
                }

                private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                    this.setTypeId(ObjId.valueOf(stream.readId("typeId")));
                    this.setChance(stream.readInt32("chance"));
                }

                private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
                    stream.writeId(this.getTypeId());
                    stream.writeInt32(this.getChance());
                }

                private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                    switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                        case DOO_0x8: {
                            this.read_0x8(stream);
                        }
                    }
                }

                private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                    switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                        case DOO_0x8: 
                        case AUTO: {
                            this.write_0x8(stream);
                        }
                    }
                }

                public Item(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                    this.read(stream, format);
                }

                public Item() {
                }
            }
        }
    }
}

