/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import java.util.Optional;

public class CheckHelper {
    public static Optional<String> checkIfIsRefinement(VariableBinding typeParamMapping, FunctionDefinition f, FunctionDefinition of, String errorMessage) {
        int of_count;
        WurstType of_type;
        String funcName = f.getName();
        if (f.attrIsStatic() && !of.attrIsStatic()) {
            return Optional.of("Function " + funcName + " must not be static.");
        }
        if (!f.attrIsStatic() && of.attrIsStatic()) {
            return Optional.of("Function " + funcName + " must be static.");
        }
        WurstType f_type = CheckHelper.getRealType(f, typeParamMapping, f.attrReturnTyp());
        if (!f_type.isSubtypeOf(of_type = CheckHelper.getRealType(f, typeParamMapping, of.attrReturnTyp()), f)) {
            return Optional.of(errorMessage + funcName + ": The return type is " + f_type + " but it should be " + of_type + ".");
        }
        int f_count = f.getParameters().size();
        if (f_count != (of_count = of.getParameters().size())) {
            return Optional.of(errorMessage + funcName + ": The number of parameters of function " + funcName + " must be equal to " + of_count + ", as defined by the overriden function.");
        }
        int i = 0;
        for (WParameter f_p : f.getParameters()) {
            WurstType of_p_type;
            WParameter of_p = (WParameter)of.getParameters().get(i);
            WurstType f_p_type = CheckHelper.getRealType(f, typeParamMapping, f_p.attrTyp());
            if (!f_p_type.isSupertypeOf(of_p_type = CheckHelper.getRealType(f, typeParamMapping, of_p.attrTyp()), f)) {
                return Optional.of(errorMessage + funcName + ": The type of parameter " + f_p.getName() + " is " + f_p_type + " but it should be " + of_p_type);
            }
            ++i;
        }
        return Optional.empty();
    }

    private static WurstType getRealType(Element context, VariableBinding typeParamMapping, WurstType t) {
        return t.setTypeArgs(typeParamMapping);
    }

    public static boolean isRefinement(VariableBinding typeParamMapping, FunctionDefinition f, FunctionDefinition of) {
        return !CheckHelper.checkIfIsRefinement(typeParamMapping, f, of, "").isPresent();
    }
}

