/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.utils;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstscript.parser.WPos;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class FileUtils {
    public static void write(CharSequence data, File outFile) throws IOException {
        com.google.common.io.Files.asCharSink((File)outFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write(data);
    }

    public static boolean sameFile(File f1, File f2) {
        try {
            return Files.isSameFile(f1.toPath(), f2.toPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isInDirectoryTrans(WFile file, WFile directory) {
        try {
            return file.getPath().startsWith(directory.getPath());
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static void deleteRecursively(File f) throws IOException {
        boolean ok;
        if (!f.exists()) {
            return;
        }
        File[] files = f.listFiles();
        if (files != null) {
            for (File child : files) {
                FileUtils.deleteRecursively(child);
            }
        }
        if (!(ok = f.delete())) {
            throw new IOException("Could not delete file " + f);
        }
    }

    public static String getWPosParent(WPos pos) {
        String parentName = "";
        try {
            parentName = WFile.create(pos.getFile()).getPath().getParent().getFileName().toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return parentName;
    }
}

