/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.Sound;

public class SoundChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("SNDS");
    private final LinkedHashSet<Sound> _sounds = new ObservableLinkedHashSet<Sound>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public LinkedHashSet<Sound> getSounds() {
        return this._sounds;
    }

    private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Chunk.Header header = new Chunk.Header(this, stream);
        long endPos = stream.getPos() + header.getSize();
        while (stream.getPos() < endPos) {
            this._sounds.add(new Sound(stream));
        }
    }

    private void write_0x0(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        Chunk.Header header = new Chunk.Header(this);
        header.write(stream);
        for (Sound sound : this.getSounds()) {
            sound.write(stream);
        }
        header.rewrite();
    }

    public void read(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: 
            case AUTO: {
                this.write_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public SoundChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        this();
        this.read(stream, format);
    }

    public SoundChunk() {
    }
}

