/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt.app.jass.expr.num;

import java.io.StringWriter;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.antlr.JassParser;
import net.moonlightflower.wc3libs.misc.Math;
import net.moonlightflower.wc3libs.txt.app.jass.expr.num.IntExpr;
import net.moonlightflower.wc3libs.txt.app.jass.expr.num.NumLiteral;

public class IntLiteral
implements NumLiteral,
IntExpr {
    private int _val;
    private Type _type;

    public IntLiteral(int val, @Nonnull Type type) {
        this._val = val;
        this._type = type;
    }

    public static IntLiteral create(@Nonnull JassParser.Int_literalContext int_literalContext) {
        if (int_literalContext.OCT_INT_LITERAL() != null) {
            return new IntLiteral(Math.decode(int_literalContext.OCT_INT_LITERAL().getText(), "01234567"), Type.OCT);
        }
        if (int_literalContext.DEC_INT_LITERAL() != null) {
            return new IntLiteral(Math.decode(int_literalContext.DEC_INT_LITERAL().getText(), "0123456789"), Type.DEC);
        }
        if (int_literalContext.HEX_INT_LITERAL() != null) {
            return new IntLiteral(Math.decode(int_literalContext.HEX_INT_LITERAL().getText(), "0123456789ABCDEF"), Type.HEX);
        }
        if (int_literalContext.ID_INT_LITERAL() != null) {
            return new IntLiteral(Math.decode(int_literalContext.ID_INT_LITERAL().getText(), Math.CODE_ASCII), Type.ID);
        }
        throw new AssertionError((Object)("no option for " + int_literalContext.getText()));
    }

    @Override
    public void write(@Nonnull StringWriter sw) {
        switch (this._type) {
            case OCT: {
                sw.write(Math.encode(this._val, "01234567"));
                break;
            }
            case DEC: {
                sw.write(Math.encode(this._val, "0123456789"));
                break;
            }
            case HEX: {
                sw.write(Math.encode(this._val, "0123456789ABCDEF"));
                break;
            }
            case ID: {
                sw.write(Math.encode(this._val, Math.CODE_ASCII));
                break;
            }
            default: {
                throw new AssertionError((Object)("no option for " + this._type));
            }
        }
    }

    public static enum Type {
        OCT,
        DEC,
        HEX,
        ID;

    }
}

