/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.io.PrintStream;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Printer {
    private final PrintStream _stream;
    private final Stack<Object> _groups = new Stack();

    public Printer(@Nonnull PrintStream stream) {
        this._stream = stream;
    }

    public void beginGroup(@Nonnull Object name) {
        this.println("begin " + name + ":");
        this._groups.push(name);
    }

    public void endGroup() {
        if (this._groups.isEmpty()) {
            return;
        }
        this.println("end " + this._groups.pop());
    }

    public void print(@Nullable Object s) {
        this._stream.print(new String(new char[this._groups.size()]).replace("\u0000", "\t") + s);
    }

    public void println(@Nullable Object s) {
        this._stream.println(new String(new char[this._groups.size()]).replace("\u0000", "\t") + s);
    }
}

