/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BinStream {
    protected long _pos = 0L;
    protected ByteList _bytes = new ByteList();
    protected List<String> _logLines = new ArrayList<String>();
    private long _logStartPos = 0L;
    private Stack<String> _curGroupStack = new Stack();

    public long getPos() {
        return this._pos;
    }

    public byte get(long index) {
        return this._bytes.get(index);
    }

    public long size() {
        return this._bytes.size();
    }

    public boolean eof() {
        return this._pos >= this._bytes.size();
    }

    public void setPos(long pos) {
        this._pos = pos;
    }

    @Nonnull
    public List<String> getLogLines() {
        return this._logLines;
    }

    public void log(@Nullable String s) {
        this._logLines.add(s);
    }

    public void log(@Nonnull String type, @Nullable String label, Object val, String valFormat) {
        long startPos = this._logStartPos;
        long endPos = this._pos;
        long len = endPos - startPos;
        if (label == null) {
            label = "?";
        }
        StringBuilder bytesPart = new StringBuilder("");
        for (long i = startPos; i < startPos + len; ++i) {
            if (bytesPart.length() > 0) {
                bytesPart.append(" ");
            }
            if (i < this._bytes.size()) {
                bytesPart.append(String.format("%02X", this._bytes.get(i)));
                continue;
            }
            bytesPart.append("?");
        }
        String line = String.format("%s [%s]: %s [%s]", label, type, String.format(valFormat, val), bytesPart);
        StringBuilder sb = new StringBuilder();
        for (String group : this._curGroupStack) {
            sb.append(group);
            sb.append("_");
        }
        sb.append(line);
        this._logLines.add(sb.toString());
    }

    public void logBegin() {
        this._logStartPos = this._pos;
    }

    public void log(@Nonnull String type, @Nullable String label, Object val) {
        this.log(type, label, val, "%s");
    }

    public void beginGroup(@Nonnull String label) {
        this._curGroupStack.push(label);
    }

    public void endGroup() {
        this._curGroupStack.pop();
    }

    public void printLog(@Nonnull OutputStream outStream) throws IOException {
        for (String line : this.getLogLines()) {
            outStream.write(line.getBytes(StandardCharsets.UTF_8));
            outStream.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
        }
    }

    protected static class ByteList {
        protected List<Byte> _bytes = new ArrayList<Byte>();

        public long size() {
            return this._bytes.size();
        }

        public Byte get(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("index out of bounds " + index);
            }
            return this._bytes.get((int)index);
        }

        public void set(long index, Byte val) {
            if (index > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("index out of bounds " + index);
            }
            this._bytes.set((int)index, val);
        }

        public void add(Byte val) {
            this._bytes.add(val);
        }
    }

    public static class StreamException
    extends IOException {
        private BinStream _stream;

        @Nonnull
        public BinStream getStream() {
            return this._stream;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            for (String s : this._stream.getLogLines()) {
                sb.append(System.lineSeparator());
                sb.append(s);
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            return this.getMessage();
        }

        public StreamException(@Nonnull BinStream stream, @Nonnull String msg) {
            this(stream);
            this._stream.log(msg);
        }

        public StreamException(@Nonnull BinStream stream) {
            this._stream = stream;
        }
    }
}

