/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.Predicate;
import dorkbox.collections.Select;
import dorkbox.collections.StateException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableIterable;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 u*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003stuB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB%\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bB\u0015\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000eB\u0015\b\u0016\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010B-\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0004\u0012\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J\u001b\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J#\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u00002\u0006\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010-J+\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u00002\u0006\u0010,\u001a\u00028\u00002\u0006\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u00020&2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000J&\u00100\u001a\u00020&2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J)\u00100\u001a\u00020&2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u00101J\u001f\u00100\u001a\u00020&2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000f\"\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u00102\u001a\u00020&J\u001d\u00103\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u00104\u001a\u00020\u0007\u00a2\u0006\u0002\u00105J\u001e\u00106\u001a\u00020\u00072\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\u0007J\u001e\u00108\u001a\u00020\u00072\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\u0007J\u001b\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f2\u0006\u0010:\u001a\u00020\u0004\u00a2\u0006\u0002\u0010;J\u0013\u0010<\u001a\u00020\u00072\b\u0010=\u001a\u0004\u0018\u00010>H\u0096\u0002J\u000e\u0010?\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>J\r\u0010@\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010AJ\u0016\u0010B\u001a\u00028\u00002\u0006\u0010C\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020\u0004H\u0016J\u001d\u0010F\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u00104\u001a\u00020\u0007\u00a2\u0006\u0002\u0010GJ\u001b\u0010H\u001a\u00020&2\u0006\u0010C\u001a\u00020\u00042\u0006\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010IJ\u0016\u0010J\u001a\u00020&2\u0006\u0010C\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010K\u001a\u00020\u0007J\u000f\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000MH\u0096\u0002J\u001d\u0010N\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u00104\u001a\u00020\u0007\u00a2\u0006\u0002\u0010GJ\u0006\u0010O\u001a\u00020\u0007J\r\u0010P\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010AJ\r\u0010Q\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010AJ\r\u0010R\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010AJ\u001e\u0010S\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\u0007J\u0015\u0010T\u001a\u0004\u0018\u00018\u00002\u0006\u0010C\u001a\u00020\u0004\u00a2\u0006\u0002\u0010DJ\u0016\u0010U\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010V\u001a\u00020\u0004J\u001d\u0010W\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u00104\u001a\u00020\u0007\u00a2\u0006\u0002\u00105J\u001d\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f2\u0006\u0010Y\u001a\u00020\u0004H\u0004\u00a2\u0006\u0002\u0010;J\u0006\u0010Z\u001a\u00020&J\u001c\u0010[\u001a\b\u0012\u0004\u0012\u00028\u00000\\2\u000e\u0010]\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010^J%\u0010_\u001a\u0004\u0018\u00018\u00002\u000e\u0010`\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000a2\u0006\u0010b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010cJ\u001e\u0010d\u001a\u00020\u00042\u000e\u0010`\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000a2\u0006\u0010b\u001a\u00020\u0004J\u001e\u0010e\u001a\u00020&2\u0006\u0010C\u001a\u00020\u00042\u0006\u0010'\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010IJ\u001b\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f2\u0006\u0010Y\u001a\u00020\u0004\u00a2\u0006\u0002\u0010;J\u0013\u0010f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000f\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010g\u001a\u00020&J\u0006\u0010h\u001a\u00020&J\u0018\u0010h\u001a\u00020&2\u0010\u0010`\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000aJ\u0016\u0010i\u001a\u00020&2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010j\u001a\u00020\u0004J\u0011\u0010k\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0016J'\u0010k\u001a\b\u0012\u0004\u0012\u0002Hl0\u000f\"\u0004\b\u0001\u0010l2\u000e\u0010m\u001a\n\u0012\u0004\u0012\u0002Hl\u0018\u00010\n\u00a2\u0006\u0002\u0010nJ\b\u0010o\u001a\u00020pH\u0016J\u000e\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020pJ\u000e\u0010r\u001a\u00020&2\u0006\u0010Y\u001a\u00020\u0004R$\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0010R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0005\u00a8\u0006v"}, d2={"Ldorkbox/collections/ExpandingArray;", "T", "", "capacity", "", "(I)V", "ordered", "", "(ZI)V", "arrayType", "Ljava/lang/Class;", "(ZILjava/lang/Class;)V", "(Ljava/lang/Class;)V", "array", "(Ldorkbox/collections/ExpandingArray;)V", "", "([Ljava/lang/Object;)V", "start", "count", "(Z[Ljava/lang/Object;II)V", "items", "getItems", "()[Ljava/lang/Object;", "setItems", "[Ljava/lang/Object;", "iterable", "Ldorkbox/collections/ExpandingArray$ArrayIterable;", "getOrdered", "()Z", "setOrdered", "(Z)V", "predicateIterable", "Ldorkbox/collections/Predicate$PredicateIterable;", "size", "getSize", "()I", "setSize", "add", "", "value", "(Ljava/lang/Object;)V", "value1", "value2", "(Ljava/lang/Object;Ljava/lang/Object;)V", "value3", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "value4", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "addAll", "([Ljava/lang/Object;II)V", "clear", "contains", "identity", "(Ljava/lang/Object;Z)Z", "containsAll", "values", "containsAny", "ensureCapacity", "additionalCapacity", "(I)[Ljava/lang/Object;", "equals", "other", "", "equalsIdentity", "first", "()Ljava/lang/Object;", "get", "index", "(I)Ljava/lang/Object;", "hashCode", "indexOf", "(Ljava/lang/Object;Z)I", "insert", "(ILjava/lang/Object;)V", "insertRange", "isEmpty", "iterator", "Ldorkbox/collections/ExpandingArray$ArrayIterator;", "lastIndexOf", "notEmpty", "peek", "pop", "random", "removeAll", "removeIndex", "removeRange", "end", "removeValue", "resize", "newSize", "reverse", "select", "", "predicate", "Ldorkbox/collections/Predicate;", "selectRanked", "comparator", "Ljava/util/Comparator;", "kthLowest", "(Ljava/util/Comparator;I)Ljava/lang/Object;", "selectRankedIndex", "set", "shrink", "shuffle", "sort", "swap", "second", "toArray", "V", "type", "(Ljava/lang/Class;)[Ljava/lang/Object;", "toString", "", "separator", "truncate", "ArrayIterable", "ArrayIterator", "Companion", "Collections"})
@SourceDebugExtension(value={"SMAP\nExpandingArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpandingArray.kt\ndorkbox/collections/ExpandingArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,865:1\n1#2:866\n*E\n"})
public final class ExpandingArray<T>
implements Iterable<T>,
KMutableIterable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private T[] items;
    private int size;
    private boolean ordered;
    @Nullable
    private ArrayIterable<T> iterable;
    @Nullable
    private Predicate.PredicateIterable<T> predicateIterable;
    @NotNull
    public static final String version = "2.4";

    @NotNull
    public final T[] getItems() {
        return this.items;
    }

    public final void setItems(@NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"<set-?>");
        this.items = TArray;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final boolean getOrdered() {
        return this.ordered;
    }

    public final void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public ExpandingArray(int capacity) {
        this(true, capacity);
    }

    public ExpandingArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new Object[capacity];
    }

    public /* synthetic */ ExpandingArray(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if ((n2 & 2) != 0) {
            n = 16;
        }
        this(bl, n);
    }

    public ExpandingArray(boolean ordered, int capacity, @NotNull Class<T> arrayType) {
        Intrinsics.checkNotNullParameter(arrayType, (String)"arrayType");
        this.ordered = ordered;
        Object object = Array.newInstance(arrayType, capacity);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of dorkbox.collections.ExpandingArray?>");
        this.items = (Object[])object;
    }

    public ExpandingArray(@NotNull Class<T> arrayType) {
        Intrinsics.checkNotNullParameter(arrayType, (String)"arrayType");
        this(true, 16, arrayType);
    }

    public ExpandingArray(@NotNull ExpandingArray<? extends T> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        boolean bl = array.ordered;
        int n = array.size;
        Class<?> clazz = array.items.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of dorkbox.collections.ExpandingArray>");
        this(bl, n, clazz);
        this.size = array.size;
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public ExpandingArray(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this(true, array, 0, array.length);
    }

    public ExpandingArray(boolean ordered, @NotNull T[] array, int start, int count) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        Class<?> clazz = array.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of dorkbox.collections.ExpandingArray>");
        this(ordered, count, clazz);
        this.size = count;
        System.arraycopy(array, start, this.items, 0, this.size);
    }

    public final void add(T value) {
        T[] items = this.items;
        if (this.size == items.length) {
            items = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        int n = this.size;
        this.size = n + 1;
        items[n] = value;
    }

    public final void add(T value1, T value2) {
        T[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public final void add(T value1, T value2, T value3) {
        T[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public final void add(T value1, T value2, T value3, T value4) {
        T[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.8f))));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public final void addAll(@NotNull ExpandingArray<? extends T> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.addAll(array.items, 0, array.size);
    }

    public final void addAll(@NotNull ExpandingArray<? extends T> array, int start, int count) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        if (start + count > array.size) {
            throw new StateException("start + count must be <= size: " + start + " + " + count + " <= " + array.size);
        }
        this.addAll(array.items, start, count);
    }

    public final void addAll(T ... array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.addAll(array, 0, array.length);
    }

    public final void addAll(@NotNull T[] array, int start, int count) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        T[] items = this.items;
        int sizeNeeded = this.size + count;
        if (sizeNeeded > items.length) {
            items = this.resize((int)Math.max(Math.max(8.0, (double)sizeNeeded), (double)((int)((float)this.size * 1.75f))));
        }
        System.arraycopy(array, start, items, this.size, count);
        this.size = sizeNeeded;
    }

    public final T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T t = this.items[index];
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final void set(int index, T value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public final void insert(int index, T value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        T[] items = this.items;
        if (this.size == items.length) {
            items = this.resize((int)Math.max(8.0, (double)((int)((float)this.size * 1.75f))));
        }
        if (this.ordered) {
            System.arraycopy(items, index, items, index + 1, this.size - index);
        } else {
            items[this.size] = items[index];
        }
        int n = this.size;
        this.size = n + 1;
        items[index] = value;
    }

    public final void insertRange(int index, int count) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize((int)Math.max(Math.max(8.0, (double)sizeNeeded), (double)((int)((float)this.size * 1.75f))));
        }
        System.arraycopy(this.items, index, this.items, index + count, this.size - index);
        this.size = sizeNeeded;
    }

    public final void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        T[] items = this.items;
        T firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    public final boolean contains(@Nullable T value, boolean identity) {
        T[] items = this.items;
        int i = this.size - 1;
        if (identity || value == null) {
            while (i >= 0) {
                if (items[i--] != value) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!Intrinsics.areEqual(value, items[i--])) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean containsAll(@NotNull ExpandingArray<? extends T> values, boolean identity) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        T[] items = values.items;
        int n = values.size;
        for (int i = 0; i < n; ++i) {
            if (this.contains(items[i], identity)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAny(@NotNull ExpandingArray<? extends T> values, boolean identity) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        T[] items = values.items;
        int n = values.size;
        for (int i = 0; i < n; ++i) {
            if (!this.contains(items[i], identity)) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(@Nullable T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items[i] != value) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(value, items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final int lastIndexOf(@Nullable T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            for (int i = this.size - 1; -1 < i; --i) {
                if (items[i] != value) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; -1 < i; --i) {
                if (!Intrinsics.areEqual(value, items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final boolean removeValue(@Nullable T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items[i] != value) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(value, items[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public final T removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T[] items = this.items;
        T value = items[index];
        int n = this.size;
        this.size = n + -1;
        if (this.ordered) {
            System.arraycopy(items, index + 1, items, index, this.size - index);
        } else {
            items[index] = items[this.size];
        }
        items[this.size] = null;
        return value;
    }

    public final void removeRange(int start, int end) {
        int i;
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        T[] items = this.items;
        int count = end - start + 1;
        int lastIndex = n - count;
        if (this.ordered) {
            System.arraycopy(items, start + count, items, start, n - (start + count));
        } else {
            i = (int)Math.max((double)lastIndex, (double)(end + 1));
            System.arraycopy(items, i, items, start, n - i);
        }
        for (i = lastIndex; i < n; ++i) {
            items[i] = null;
        }
        this.size = n - count;
    }

    public final boolean removeAll(@NotNull ExpandingArray<? extends T> array, boolean identity) {
        int size;
        Intrinsics.checkNotNullParameter(array, (String)"array");
        int startSize = size = this.size;
        T[] items = this.items;
        if (identity) {
            int n = array.size;
            block0: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                int n2 = size;
                for (int ii = 0; ii < n2; ++ii) {
                    if (item != items[ii]) continue;
                    this.removeIndex(ii);
                    --size;
                    continue block0;
                }
            }
        } else {
            int n = array.size;
            block2: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                int n3 = size;
                for (int ii = 0; ii < n3; ++ii) {
                    if (!Intrinsics.areEqual(item, items[ii])) continue;
                    this.removeIndex(ii);
                    --size;
                    continue block2;
                }
            }
        }
        return size != startSize;
    }

    @Nullable
    public final T pop() {
        if (!(this.size != 0)) {
            boolean bl = false;
            String string = "Array is empty.";
            throw new IllegalStateException(string.toString());
        }
        this.size += -1;
        T item = this.items[this.size];
        this.items[this.size] = null;
        return item;
    }

    @Nullable
    public final T peek() {
        if (!(this.size != 0)) {
            boolean bl = false;
            String string = "Array is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.items[this.size - 1];
    }

    @Nullable
    public final T first() {
        if (!(this.size != 0)) {
            boolean bl = false;
            String string = "Array is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.items[0];
    }

    public final boolean notEmpty() {
        return this.size > 0;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        Arrays.fill(this.items, 0, this.size, null);
        this.size = 0;
    }

    @NotNull
    public final T[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    @NotNull
    public final T[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new StateException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize((int)Math.max(Math.max(8.0, (double)sizeNeeded), (double)((int)((float)this.size * 1.75f))));
        }
        return this.items;
    }

    @NotNull
    public final T[] setSize(int newSize) {
        this.truncate(newSize);
        if (newSize > this.items.length) {
            this.resize((int)Math.max(8.0, (double)newSize));
        }
        this.size = newSize;
        return this.items;
    }

    @NotNull
    protected final T[] resize(int newSize) {
        T[] items = this.items;
        Object object = Array.newInstance(items.getClass().getComponentType(), newSize);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of dorkbox.collections.ExpandingArray?>");
        Object[] newItems = (Object[])object;
        System.arraycopy(items, 0, newItems, 0, (int)Math.min((double)this.size, (double)newItems.length));
        this.items = newItems;
        return newItems;
    }

    public final void sort() {
        ArraysKt.sort((Object[])this.items, (int)0, (int)this.size);
    }

    public final void sort(@NotNull Comparator<? super T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        ArraysKt.sortWith((Object[])this.items, comparator, (int)0, (int)this.size);
    }

    @Nullable
    public final T selectRanked(@NotNull Comparator<T> comparator, int kthLowest) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        if (kthLowest < 1) {
            throw new RuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.Companion.instance().select(this.items, comparator, kthLowest, this.size);
    }

    public final int selectRankedIndex(@NotNull Comparator<T> comparator, int kthLowest) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        if (kthLowest < 1) {
            throw new RuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.Companion.instance().selectIndex(this.items, comparator, kthLowest, this.size);
    }

    public final void reverse() {
        T[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            T temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public final void shuffle() {
        T[] items = this.items;
        for (int i = this.size - 1; -1 < i; --i) {
            int ii = Collections.INSTANCE.random(i);
            T temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    @Override
    @NotNull
    public ArrayIterator<T> iterator() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new ArrayIterator(this, true);
        }
        if (this.iterable == null) {
            this.iterable = new ArrayIterable(this, false, 2, null);
        }
        ArrayIterable<T> arrayIterable = this.iterable;
        Intrinsics.checkNotNull(arrayIterable);
        return arrayIterable.iterator();
    }

    @NotNull
    public final Iterable<T> select(@Nullable Predicate<T> predicate) {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Predicate.PredicateIterable<T>(this, predicate);
        }
        if (this.predicateIterable == null) {
            this.predicateIterable = new Predicate.PredicateIterable<T>(this, predicate);
        } else {
            Predicate.PredicateIterable<T> predicateIterable = this.predicateIterable;
            Intrinsics.checkNotNull(predicateIterable);
            predicateIterable.set(this, predicate);
        }
        Predicate.PredicateIterable<T> predicateIterable = this.predicateIterable;
        Intrinsics.checkNotNull(predicateIterable);
        return predicateIterable;
    }

    public final void truncate(int newSize) {
        if (newSize < 0) {
            throw new StateException("newSize must be >= 0: " + newSize);
        }
        if (this.size <= newSize) {
            return;
        }
        int n = this.size;
        for (int i = newSize; i < n; ++i) {
            this.items[i] = null;
        }
        this.size = newSize;
    }

    @Nullable
    public final T random() {
        return this.size == 0 ? null : (T)this.items[Collections.INSTANCE.random(0, this.size - 1)];
    }

    @NotNull
    public final T[] toArray() {
        return this.toArray(this.items.getClass().getComponentType());
    }

    @NotNull
    public final <V> V[] toArray(@Nullable Class<V> type) {
        Object object = Array.newInstance(type, this.size);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<V of dorkbox.collections.ExpandingArray.toArray>");
        Object[] result = (Object[])object;
        System.arraycopy(this.items, 0, result, 0, this.size);
        return result;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h *= 31;
            T item = items[i];
            if (item == null) continue;
            h += item.hashCode();
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(other instanceof ExpandingArray)) {
            return false;
        }
        ExpandingArray cfr_ignored_0 = (ExpandingArray)other;
        if (!((ExpandingArray)other).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((ExpandingArray)other).size) {
            return false;
        }
        T[] items1 = this.items;
        T[] items2 = ((ExpandingArray)other).items;
        for (int i = 0; i < n; ++i) {
            T o1 = items1[i];
            T o2 = items2[i];
            T t = o1;
            if (t == null ? o2 == null : Intrinsics.areEqual(t, o2)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIdentity(@NotNull Object other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(other instanceof ExpandingArray)) {
            return false;
        }
        ExpandingArray cfr_ignored_0 = (ExpandingArray)other;
        if (!((ExpandingArray)other).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((ExpandingArray)other).size) {
            return false;
        }
        T[] items1 = this.items;
        T[] items2 = ((ExpandingArray)other).items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        int n = this.size;
        for (int i = 1; i < n; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append(']');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (this.size == 0) {
            return "";
        }
        T[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        int n = this.size;
        for (int i = 1; i < n; ++i) {
            buffer.append(separator);
            buffer.append(items[i]);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\tH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldorkbox/collections/ExpandingArray$ArrayIterable;", "T", "", "array", "Ldorkbox/collections/ExpandingArray;", "allowRemove", "", "(Ldorkbox/collections/ExpandingArray;Z)V", "iterator1", "Ldorkbox/collections/ExpandingArray$ArrayIterator;", "iterator2", "iterator", "Collections"})
    public static final class ArrayIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        @NotNull
        private final ExpandingArray<T> array;
        private final boolean allowRemove;
        @Nullable
        private ArrayIterator<T> iterator1;
        @Nullable
        private ArrayIterator<T> iterator2;

        public ArrayIterable(@NotNull ExpandingArray<T> array, boolean allowRemove) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            this.array = array;
            this.allowRemove = allowRemove;
        }

        public /* synthetic */ ArrayIterable(ExpandingArray expandingArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(expandingArray, bl);
        }

        @Override
        @NotNull
        public ArrayIterator<T> iterator() {
            if (Collections.INSTANCE.getAllocateIterators()) {
                return new ArrayIterator<T>(this.array, this.allowRemove);
            }
            if (this.iterator1 == null) {
                this.iterator1 = new ArrayIterator<T>(this.array, this.allowRemove);
                this.iterator2 = new ArrayIterator<T>(this.array, this.allowRemove);
            }
            ArrayIterator<T> arrayIterator = this.iterator1;
            Intrinsics.checkNotNull(arrayIterator);
            if (!arrayIterator.getValid()) {
                ArrayIterator<T> arrayIterator2 = this.iterator1;
                Intrinsics.checkNotNull(arrayIterator2);
                arrayIterator2.setIndex(0);
                ArrayIterator<T> arrayIterator3 = this.iterator1;
                Intrinsics.checkNotNull(arrayIterator3);
                arrayIterator3.setValid(true);
                ArrayIterator<T> arrayIterator4 = this.iterator2;
                Intrinsics.checkNotNull(arrayIterator4);
                arrayIterator4.setValid(false);
                ArrayIterator<T> arrayIterator5 = this.iterator1;
                Intrinsics.checkNotNull(arrayIterator5);
                return arrayIterator5;
            }
            ArrayIterator<T> arrayIterator6 = this.iterator2;
            Intrinsics.checkNotNull(arrayIterator6);
            arrayIterator6.setIndex(0);
            ArrayIterator<T> arrayIterator7 = this.iterator2;
            Intrinsics.checkNotNull(arrayIterator7);
            arrayIterator7.setValid(true);
            ArrayIterator<T> arrayIterator8 = this.iterator1;
            Intrinsics.checkNotNull(arrayIterator8);
            arrayIterator8.setValid(false);
            ArrayIterator<T> arrayIterator9 = this.iterator2;
            Intrinsics.checkNotNull(arrayIterator9);
            return arrayIterator9;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0007H\u0096\u0002J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000e\u0010\u0016\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Ldorkbox/collections/ExpandingArray$ArrayIterator;", "T", "", "", "array", "Ldorkbox/collections/ExpandingArray;", "allowRemove", "", "(Ldorkbox/collections/ExpandingArray;Z)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "valid", "getValid", "()Z", "setValid", "(Z)V", "hasNext", "iterator", "next", "()Ljava/lang/Object;", "remove", "", "reset", "Collections"})
    public static final class ArrayIterator<T>
    implements Iterator<T>,
    Iterable<T>,
    KMutableIterator,
    KMappedMarker {
        @NotNull
        private final ExpandingArray<T> array;
        private final boolean allowRemove;
        private int index;
        private boolean valid;

        public ArrayIterator(@NotNull ExpandingArray<T> array, boolean allowRemove) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            this.array = array;
            this.allowRemove = allowRemove;
            this.valid = true;
        }

        public /* synthetic */ ArrayIterator(ExpandingArray expandingArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(expandingArray, bl);
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.array.getSize();
        }

        @Override
        public T next() {
            if (this.index >= this.array.getSize()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.index;
            this.index = n + 1;
            T t = this.array.getItems()[n];
            Intrinsics.checkNotNull(t);
            return t;
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new RuntimeException("Remove not allowed.");
            }
            int n = this.index;
            this.index = n + -1;
            this.array.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        @Override
        @NotNull
        public ArrayIterator<T> iterator() {
            return this;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ0\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u0010\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldorkbox/collections/ExpandingArray$Companion;", "", "()V", "version", "", "of", "Ldorkbox/collections/ExpandingArray;", "T", "arrayType", "Ljava/lang/Class;", "ordered", "", "capacity", "", "with", "array", "", "([Ljava/lang/Object;)Ldorkbox/collections/ExpandingArray;", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> ExpandingArray<T> of(@NotNull Class<T> arrayType) {
            Intrinsics.checkNotNullParameter(arrayType, (String)"arrayType");
            return new ExpandingArray<T>(arrayType);
        }

        @NotNull
        public final <T> ExpandingArray<T> of(boolean ordered, int capacity, @NotNull Class<T> arrayType) {
            Intrinsics.checkNotNullParameter(arrayType, (String)"arrayType");
            return new ExpandingArray<T>(ordered, capacity, arrayType);
        }

        @NotNull
        public final <T> ExpandingArray<T> with(T ... array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return new ExpandingArray<T>(array);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

