/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaTableExprField;
import de.peeeq.wurstscript.luaAst.LuaTableField;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaTableExprFieldImpl
implements LuaTableExprField {
    private Element parent;
    private LuaExpr fieldKey;
    private LuaExpr val;

    LuaTableExprFieldImpl(LuaExpr fieldKey, LuaExpr val) {
        if (fieldKey == null) {
            throw new IllegalArgumentException("Element fieldKey must not be null.");
        }
        if (val == null) {
            throw new IllegalArgumentException("Element val must not be null.");
        }
        this.fieldKey = fieldKey;
        this.val = val;
        fieldKey.setParent(this);
        val.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setFieldKey(LuaExpr fieldKey) {
        if (fieldKey == null) {
            throw new IllegalArgumentException();
        }
        this.fieldKey.setParent(null);
        fieldKey.setParent(this);
        this.fieldKey = fieldKey;
    }

    @Override
    public LuaExpr getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public void setVal(LuaExpr val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        this.val.setParent(null);
        val.setParent(this);
        this.val = val;
    }

    @Override
    public LuaExpr getVal() {
        return this.val;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.fieldKey;
            }
            case 1: {
                return this.val;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaExpr oldElem = this.fieldKey;
                this.setFieldKey((LuaExpr)newElem);
                return oldElem;
            }
            case 1: {
                LuaExpr oldElem = this.val;
                this.setVal((LuaExpr)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.fieldKey);
        action.accept(this.val);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public LuaTableExprField copy() {
        LuaTableExprFieldImpl result = new LuaTableExprFieldImpl(this.fieldKey.copy(), this.val.copy());
        return result;
    }

    @Override
    public LuaTableExprField copyWithRefs() {
        final LuaTableExprField res = this.copy();
        final LuaTableExprFieldImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.fieldKey.clearAttributes();
        this.val.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaTableExprField(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaTableExprField(this);
    }

    @Override
    public <T> T match(LuaTableField.Matcher<T> matcher) {
        return matcher.case_LuaTableExprField(this);
    }

    @Override
    public void match(LuaTableField.MatcherVoid matcher) {
        matcher.case_LuaTableExprField(this);
    }

    public String toString() {
        return "LuaTableExprField(" + this.fieldKey + ", " + this.val + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaTableExprField) {
            LuaTableExprField o = (LuaTableExprField)e;
            return this.fieldKey.structuralEquals(o.getFieldKey()) && this.val.structuralEquals(o.getVal());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

